# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProvisionedModelThroughputArgs', 'ProvisionedModelThroughput']

@pulumi.input_type
class ProvisionedModelThroughputArgs:
    def __init__(__self__, *,
                 model_arn: pulumi.Input[str],
                 model_units: pulumi.Input[int],
                 provisioned_model_name: pulumi.Input[str],
                 commitment_duration: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['ProvisionedModelThroughputTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ProvisionedModelThroughput resource.
        :param pulumi.Input[str] model_arn: ARN of the model to associate with this Provisioned Throughput.
        :param pulumi.Input[int] model_units: Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
        :param pulumi.Input[str] provisioned_model_name: Unique name for this Provisioned Throughput.
        :param pulumi.Input[str] commitment_duration: Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "model_arn", model_arn)
        pulumi.set(__self__, "model_units", model_units)
        pulumi.set(__self__, "provisioned_model_name", provisioned_model_name)
        if commitment_duration is not None:
            pulumi.set(__self__, "commitment_duration", commitment_duration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="modelArn")
    def model_arn(self) -> pulumi.Input[str]:
        """
        ARN of the model to associate with this Provisioned Throughput.
        """
        return pulumi.get(self, "model_arn")

    @model_arn.setter
    def model_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_arn", value)

    @property
    @pulumi.getter(name="modelUnits")
    def model_units(self) -> pulumi.Input[int]:
        """
        Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
        """
        return pulumi.get(self, "model_units")

    @model_units.setter
    def model_units(self, value: pulumi.Input[int]):
        pulumi.set(self, "model_units", value)

    @property
    @pulumi.getter(name="provisionedModelName")
    def provisioned_model_name(self) -> pulumi.Input[str]:
        """
        Unique name for this Provisioned Throughput.
        """
        return pulumi.get(self, "provisioned_model_name")

    @provisioned_model_name.setter
    def provisioned_model_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "provisioned_model_name", value)

    @property
    @pulumi.getter(name="commitmentDuration")
    def commitment_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
        """
        return pulumi.get(self, "commitment_duration")

    @commitment_duration.setter
    def commitment_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commitment_duration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ProvisionedModelThroughputTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ProvisionedModelThroughputTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ProvisionedModelThroughputState:
    def __init__(__self__, *,
                 commitment_duration: Optional[pulumi.Input[str]] = None,
                 model_arn: Optional[pulumi.Input[str]] = None,
                 model_units: Optional[pulumi.Input[int]] = None,
                 provisioned_model_arn: Optional[pulumi.Input[str]] = None,
                 provisioned_model_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['ProvisionedModelThroughputTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ProvisionedModelThroughput resources.
        :param pulumi.Input[str] commitment_duration: Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
        :param pulumi.Input[str] model_arn: ARN of the model to associate with this Provisioned Throughput.
        :param pulumi.Input[int] model_units: Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
        :param pulumi.Input[str] provisioned_model_arn: The ARN of the Provisioned Throughput.
        :param pulumi.Input[str] provisioned_model_name: Unique name for this Provisioned Throughput.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if commitment_duration is not None:
            pulumi.set(__self__, "commitment_duration", commitment_duration)
        if model_arn is not None:
            pulumi.set(__self__, "model_arn", model_arn)
        if model_units is not None:
            pulumi.set(__self__, "model_units", model_units)
        if provisioned_model_arn is not None:
            pulumi.set(__self__, "provisioned_model_arn", provisioned_model_arn)
        if provisioned_model_name is not None:
            pulumi.set(__self__, "provisioned_model_name", provisioned_model_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="commitmentDuration")
    def commitment_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
        """
        return pulumi.get(self, "commitment_duration")

    @commitment_duration.setter
    def commitment_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commitment_duration", value)

    @property
    @pulumi.getter(name="modelArn")
    def model_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the model to associate with this Provisioned Throughput.
        """
        return pulumi.get(self, "model_arn")

    @model_arn.setter
    def model_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_arn", value)

    @property
    @pulumi.getter(name="modelUnits")
    def model_units(self) -> Optional[pulumi.Input[int]]:
        """
        Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
        """
        return pulumi.get(self, "model_units")

    @model_units.setter
    def model_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "model_units", value)

    @property
    @pulumi.getter(name="provisionedModelArn")
    def provisioned_model_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Provisioned Throughput.
        """
        return pulumi.get(self, "provisioned_model_arn")

    @provisioned_model_arn.setter
    def provisioned_model_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioned_model_arn", value)

    @property
    @pulumi.getter(name="provisionedModelName")
    def provisioned_model_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name for this Provisioned Throughput.
        """
        return pulumi.get(self, "provisioned_model_name")

    @provisioned_model_name.setter
    def provisioned_model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioned_model_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ProvisionedModelThroughputTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ProvisionedModelThroughputTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class ProvisionedModelThroughput(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commitment_duration: Optional[pulumi.Input[str]] = None,
                 model_arn: Optional[pulumi.Input[str]] = None,
                 model_units: Optional[pulumi.Input[int]] = None,
                 provisioned_model_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ProvisionedModelThroughputTimeoutsArgs', 'ProvisionedModelThroughputTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) for an Amazon Bedrock model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.ProvisionedModelThroughput("example",
            provisioned_model_name="example-model",
            model_arn="arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
            commitment_duration="SixMonths",
            model_units=1)
        ```

        ## Import

        Using `pulumi import`, import Provisioned Throughput using the `provisioned_model_arn`. For example:

        ```sh
        $ pulumi import aws:bedrock/provisionedModelThroughput:ProvisionedModelThroughput example arn:aws:bedrock:us-west-2:123456789012:provisioned-model/1y5n57gh5y2e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] commitment_duration: Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
        :param pulumi.Input[str] model_arn: ARN of the model to associate with this Provisioned Throughput.
        :param pulumi.Input[int] model_units: Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
        :param pulumi.Input[str] provisioned_model_name: Unique name for this Provisioned Throughput.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProvisionedModelThroughputArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages [Provisioned Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html) for an Amazon Bedrock model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.ProvisionedModelThroughput("example",
            provisioned_model_name="example-model",
            model_arn="arn:aws:bedrock:us-east-1::foundation-model/anthropic.claude-v2",
            commitment_duration="SixMonths",
            model_units=1)
        ```

        ## Import

        Using `pulumi import`, import Provisioned Throughput using the `provisioned_model_arn`. For example:

        ```sh
        $ pulumi import aws:bedrock/provisionedModelThroughput:ProvisionedModelThroughput example arn:aws:bedrock:us-west-2:123456789012:provisioned-model/1y5n57gh5y2e
        ```

        :param str resource_name: The name of the resource.
        :param ProvisionedModelThroughputArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProvisionedModelThroughputArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commitment_duration: Optional[pulumi.Input[str]] = None,
                 model_arn: Optional[pulumi.Input[str]] = None,
                 model_units: Optional[pulumi.Input[int]] = None,
                 provisioned_model_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ProvisionedModelThroughputTimeoutsArgs', 'ProvisionedModelThroughputTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProvisionedModelThroughputArgs.__new__(ProvisionedModelThroughputArgs)

            __props__.__dict__["commitment_duration"] = commitment_duration
            if model_arn is None and not opts.urn:
                raise TypeError("Missing required property 'model_arn'")
            __props__.__dict__["model_arn"] = model_arn
            if model_units is None and not opts.urn:
                raise TypeError("Missing required property 'model_units'")
            __props__.__dict__["model_units"] = model_units
            if provisioned_model_name is None and not opts.urn:
                raise TypeError("Missing required property 'provisioned_model_name'")
            __props__.__dict__["provisioned_model_name"] = provisioned_model_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["provisioned_model_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ProvisionedModelThroughput, __self__).__init__(
            'aws:bedrock/provisionedModelThroughput:ProvisionedModelThroughput',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commitment_duration: Optional[pulumi.Input[str]] = None,
            model_arn: Optional[pulumi.Input[str]] = None,
            model_units: Optional[pulumi.Input[int]] = None,
            provisioned_model_arn: Optional[pulumi.Input[str]] = None,
            provisioned_model_name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ProvisionedModelThroughputTimeoutsArgs', 'ProvisionedModelThroughputTimeoutsArgsDict']]] = None) -> 'ProvisionedModelThroughput':
        """
        Get an existing ProvisionedModelThroughput resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] commitment_duration: Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
        :param pulumi.Input[str] model_arn: ARN of the model to associate with this Provisioned Throughput.
        :param pulumi.Input[int] model_units: Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
        :param pulumi.Input[str] provisioned_model_arn: The ARN of the Provisioned Throughput.
        :param pulumi.Input[str] provisioned_model_name: Unique name for this Provisioned Throughput.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProvisionedModelThroughputState.__new__(_ProvisionedModelThroughputState)

        __props__.__dict__["commitment_duration"] = commitment_duration
        __props__.__dict__["model_arn"] = model_arn
        __props__.__dict__["model_units"] = model_units
        __props__.__dict__["provisioned_model_arn"] = provisioned_model_arn
        __props__.__dict__["provisioned_model_name"] = provisioned_model_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return ProvisionedModelThroughput(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="commitmentDuration")
    def commitment_duration(self) -> pulumi.Output[Optional[str]]:
        """
        Commitment duration requested for the Provisioned Throughput. For custom models, you can purchase on-demand Provisioned Throughput by omitting this argument. Valid values: `OneMonth`, `SixMonths`.
        """
        return pulumi.get(self, "commitment_duration")

    @property
    @pulumi.getter(name="modelArn")
    def model_arn(self) -> pulumi.Output[str]:
        """
        ARN of the model to associate with this Provisioned Throughput.
        """
        return pulumi.get(self, "model_arn")

    @property
    @pulumi.getter(name="modelUnits")
    def model_units(self) -> pulumi.Output[int]:
        """
        Number of model units to allocate. A model unit delivers a specific throughput level for the specified model.
        """
        return pulumi.get(self, "model_units")

    @property
    @pulumi.getter(name="provisionedModelArn")
    def provisioned_model_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Provisioned Throughput.
        """
        return pulumi.get(self, "provisioned_model_arn")

    @property
    @pulumi.getter(name="provisionedModelName")
    def provisioned_model_name(self) -> pulumi.Output[str]:
        """
        Unique name for this Provisioned Throughput.
        """
        return pulumi.get(self, "provisioned_model_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ProvisionedModelThroughputTimeouts']]:
        return pulumi.get(self, "timeouts")

