# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TeamsChannelConfigurationArgs', 'TeamsChannelConfiguration']

@pulumi.input_type
class TeamsChannelConfigurationArgs:
    def __init__(__self__, *,
                 channel_id: pulumi.Input[str],
                 configuration_name: pulumi.Input[str],
                 iam_role_arn: pulumi.Input[str],
                 team_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str],
                 channel_name: Optional[pulumi.Input[str]] = None,
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_level: Optional[pulumi.Input[str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 team_name: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['TeamsChannelConfigurationTimeoutsArgs']] = None,
                 user_authorization_required: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a TeamsChannelConfiguration resource.
        :param pulumi.Input[str] channel_id: ID of the Microsoft Teams channel.
        :param pulumi.Input[str] configuration_name: Name of the Microsoft Teams channel configuration.
        :param pulumi.Input[str] iam_role_arn: ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
        :param pulumi.Input[str] team_id: ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
        :param pulumi.Input[str] tenant_id: ID of the Microsoft Teams tenant.
               
               The following arguments are optional:
        :param pulumi.Input[str] channel_name: Name of the Microsoft Teams channel.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[str] team_name: Name of the Microsoft Teams team.
        :param pulumi.Input[bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        pulumi.set(__self__, "channel_id", channel_id)
        pulumi.set(__self__, "configuration_name", configuration_name)
        pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        pulumi.set(__self__, "team_id", team_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if guardrail_policy_arns is not None:
            pulumi.set(__self__, "guardrail_policy_arns", guardrail_policy_arns)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if sns_topic_arns is not None:
            pulumi.set(__self__, "sns_topic_arns", sns_topic_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_authorization_required is not None:
            pulumi.set(__self__, "user_authorization_required", user_authorization_required)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Input[str]:
        """
        ID of the Microsoft Teams channel.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> pulumi.Input[str]:
        """
        Name of the Microsoft Teams channel configuration.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "configuration_name", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Input[str]:
        """
        ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Input[str]:
        """
        ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        ID of the Microsoft Teams tenant.

        The following arguments are optional:
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Microsoft Teams channel.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter(name="guardrailPolicyArns")
    def guardrail_policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        """
        return pulumi.get(self, "guardrail_policy_arns")

    @guardrail_policy_arns.setter
    def guardrail_policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "guardrail_policy_arns", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[str]]:
        """
        Logging levels include `ERROR`, `INFO`, or `NONE`.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="snsTopicArns")
    def sns_topic_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        """
        return pulumi.get(self, "sns_topic_arns")

    @sns_topic_arns.setter
    def sns_topic_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sns_topic_arns", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Microsoft Teams team.
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_name", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['TeamsChannelConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['TeamsChannelConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="userAuthorizationRequired")
    def user_authorization_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables use of a user role requirement in your chat configuration.
        """
        return pulumi.get(self, "user_authorization_required")

    @user_authorization_required.setter
    def user_authorization_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_authorization_required", value)


@pulumi.input_type
class _TeamsChannelConfigurationState:
    def __init__(__self__, *,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 chat_configuration_arn: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 logging_level: Optional[pulumi.Input[str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 team_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['TeamsChannelConfigurationTimeoutsArgs']] = None,
                 user_authorization_required: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering TeamsChannelConfiguration resources.
        :param pulumi.Input[str] channel_id: ID of the Microsoft Teams channel.
        :param pulumi.Input[str] channel_name: Name of the Microsoft Teams channel.
        :param pulumi.Input[str] chat_configuration_arn: ARN of the Microsoft Teams channel configuration.
        :param pulumi.Input[str] configuration_name: Name of the Microsoft Teams channel configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[str] iam_role_arn: ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
        :param pulumi.Input[str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] team_id: ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
        :param pulumi.Input[str] team_name: Name of the Microsoft Teams team.
        :param pulumi.Input[str] tenant_id: ID of the Microsoft Teams tenant.
               
               The following arguments are optional:
        :param pulumi.Input[bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        if channel_id is not None:
            pulumi.set(__self__, "channel_id", channel_id)
        if channel_name is not None:
            pulumi.set(__self__, "channel_name", channel_name)
        if chat_configuration_arn is not None:
            pulumi.set(__self__, "chat_configuration_arn", chat_configuration_arn)
        if configuration_name is not None:
            pulumi.set(__self__, "configuration_name", configuration_name)
        if guardrail_policy_arns is not None:
            pulumi.set(__self__, "guardrail_policy_arns", guardrail_policy_arns)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if sns_topic_arns is not None:
            pulumi.set(__self__, "sns_topic_arns", sns_topic_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if team_name is not None:
            pulumi.set(__self__, "team_name", team_name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if user_authorization_required is not None:
            pulumi.set(__self__, "user_authorization_required", user_authorization_required)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Microsoft Teams channel.
        """
        return pulumi.get(self, "channel_id")

    @channel_id.setter
    def channel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_id", value)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Microsoft Teams channel.
        """
        return pulumi.get(self, "channel_name")

    @channel_name.setter
    def channel_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_name", value)

    @property
    @pulumi.getter(name="chatConfigurationArn")
    def chat_configuration_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Microsoft Teams channel configuration.
        """
        return pulumi.get(self, "chat_configuration_arn")

    @chat_configuration_arn.setter
    def chat_configuration_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chat_configuration_arn", value)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Microsoft Teams channel configuration.
        """
        return pulumi.get(self, "configuration_name")

    @configuration_name.setter
    def configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_name", value)

    @property
    @pulumi.getter(name="guardrailPolicyArns")
    def guardrail_policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        """
        return pulumi.get(self, "guardrail_policy_arns")

    @guardrail_policy_arns.setter
    def guardrail_policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "guardrail_policy_arns", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[str]]:
        """
        Logging levels include `ERROR`, `INFO`, or `NONE`.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="snsTopicArns")
    def sns_topic_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        """
        return pulumi.get(self, "sns_topic_arns")

    @sns_topic_arns.setter
    def sns_topic_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sns_topic_arns", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Microsoft Teams team.
        """
        return pulumi.get(self, "team_name")

    @team_name.setter
    def team_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Microsoft Teams tenant.

        The following arguments are optional:
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['TeamsChannelConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['TeamsChannelConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="userAuthorizationRequired")
    def user_authorization_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables use of a user role requirement in your chat configuration.
        """
        return pulumi.get(self, "user_authorization_required")

    @user_authorization_required.setter
    def user_authorization_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_authorization_required", value)


class TeamsChannelConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 logging_level: Optional[pulumi.Input[str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 team_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['TeamsChannelConfigurationTimeoutsArgs', 'TeamsChannelConfigurationTimeoutsArgsDict']]] = None,
                 user_authorization_required: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Chatbot Microsoft Teams Channel Configuration.

        > **NOTE:** We provide this resource on a best-effort basis. If you are able to test it and find it useful, we welcome your input at GitHub.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.chatbot.TeamsChannelConfiguration("test",
            channel_id="C07EZ1ABC23",
            configuration_name="mitt-lags-kanal",
            iam_role_arn=test_aws_iam_role["arn"],
            team_id="74361522-da01-538d-aa2e-ac7918c6bb92",
            tenant_id="1234",
            tags={
                "Name": "mitt-lags-kanal",
            })
        ```

        ## Import

        Using `pulumi import`, import Chatbot Microsoft Teams Channel Configuration using the `team_id`. For example:

        ```sh
        $ pulumi import aws:chatbot/teamsChannelConfiguration:TeamsChannelConfiguration example 5f4f15d2-b958-522a-8333-124aa8bf0925
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_id: ID of the Microsoft Teams channel.
        :param pulumi.Input[str] channel_name: Name of the Microsoft Teams channel.
        :param pulumi.Input[str] configuration_name: Name of the Microsoft Teams channel configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[str] iam_role_arn: ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
        :param pulumi.Input[str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[str] team_id: ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
        :param pulumi.Input[str] team_name: Name of the Microsoft Teams team.
        :param pulumi.Input[str] tenant_id: ID of the Microsoft Teams tenant.
               
               The following arguments are optional:
        :param pulumi.Input[bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamsChannelConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Chatbot Microsoft Teams Channel Configuration.

        > **NOTE:** We provide this resource on a best-effort basis. If you are able to test it and find it useful, we welcome your input at GitHub.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.chatbot.TeamsChannelConfiguration("test",
            channel_id="C07EZ1ABC23",
            configuration_name="mitt-lags-kanal",
            iam_role_arn=test_aws_iam_role["arn"],
            team_id="74361522-da01-538d-aa2e-ac7918c6bb92",
            tenant_id="1234",
            tags={
                "Name": "mitt-lags-kanal",
            })
        ```

        ## Import

        Using `pulumi import`, import Chatbot Microsoft Teams Channel Configuration using the `team_id`. For example:

        ```sh
        $ pulumi import aws:chatbot/teamsChannelConfiguration:TeamsChannelConfiguration example 5f4f15d2-b958-522a-8333-124aa8bf0925
        ```

        :param str resource_name: The name of the resource.
        :param TeamsChannelConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamsChannelConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_id: Optional[pulumi.Input[str]] = None,
                 channel_name: Optional[pulumi.Input[str]] = None,
                 configuration_name: Optional[pulumi.Input[str]] = None,
                 guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 iam_role_arn: Optional[pulumi.Input[str]] = None,
                 logging_level: Optional[pulumi.Input[str]] = None,
                 sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 team_name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input[Union['TeamsChannelConfigurationTimeoutsArgs', 'TeamsChannelConfigurationTimeoutsArgsDict']]] = None,
                 user_authorization_required: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamsChannelConfigurationArgs.__new__(TeamsChannelConfigurationArgs)

            if channel_id is None and not opts.urn:
                raise TypeError("Missing required property 'channel_id'")
            __props__.__dict__["channel_id"] = channel_id
            __props__.__dict__["channel_name"] = channel_name
            if configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_name'")
            __props__.__dict__["configuration_name"] = configuration_name
            __props__.__dict__["guardrail_policy_arns"] = guardrail_policy_arns
            if iam_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'iam_role_arn'")
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["logging_level"] = logging_level
            __props__.__dict__["sns_topic_arns"] = sns_topic_arns
            __props__.__dict__["tags"] = tags
            if team_id is None and not opts.urn:
                raise TypeError("Missing required property 'team_id'")
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["team_name"] = team_name
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["user_authorization_required"] = user_authorization_required
            __props__.__dict__["chat_configuration_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(TeamsChannelConfiguration, __self__).__init__(
            'aws:chatbot/teamsChannelConfiguration:TeamsChannelConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel_id: Optional[pulumi.Input[str]] = None,
            channel_name: Optional[pulumi.Input[str]] = None,
            chat_configuration_arn: Optional[pulumi.Input[str]] = None,
            configuration_name: Optional[pulumi.Input[str]] = None,
            guardrail_policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            iam_role_arn: Optional[pulumi.Input[str]] = None,
            logging_level: Optional[pulumi.Input[str]] = None,
            sns_topic_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            team_id: Optional[pulumi.Input[str]] = None,
            team_name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['TeamsChannelConfigurationTimeoutsArgs', 'TeamsChannelConfigurationTimeoutsArgsDict']]] = None,
            user_authorization_required: Optional[pulumi.Input[bool]] = None) -> 'TeamsChannelConfiguration':
        """
        Get an existing TeamsChannelConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_id: ID of the Microsoft Teams channel.
        :param pulumi.Input[str] channel_name: Name of the Microsoft Teams channel.
        :param pulumi.Input[str] chat_configuration_arn: ARN of the Microsoft Teams channel configuration.
        :param pulumi.Input[str] configuration_name: Name of the Microsoft Teams channel configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] guardrail_policy_arns: List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        :param pulumi.Input[str] iam_role_arn: ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
        :param pulumi.Input[str] logging_level: Logging levels include `ERROR`, `INFO`, or `NONE`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sns_topic_arns: ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags assigned to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] team_id: ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
        :param pulumi.Input[str] team_name: Name of the Microsoft Teams team.
        :param pulumi.Input[str] tenant_id: ID of the Microsoft Teams tenant.
               
               The following arguments are optional:
        :param pulumi.Input[bool] user_authorization_required: Enables use of a user role requirement in your chat configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamsChannelConfigurationState.__new__(_TeamsChannelConfigurationState)

        __props__.__dict__["channel_id"] = channel_id
        __props__.__dict__["channel_name"] = channel_name
        __props__.__dict__["chat_configuration_arn"] = chat_configuration_arn
        __props__.__dict__["configuration_name"] = configuration_name
        __props__.__dict__["guardrail_policy_arns"] = guardrail_policy_arns
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        __props__.__dict__["logging_level"] = logging_level
        __props__.__dict__["sns_topic_arns"] = sns_topic_arns
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["team_name"] = team_name
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["user_authorization_required"] = user_authorization_required
        return TeamsChannelConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> pulumi.Output[str]:
        """
        ID of the Microsoft Teams channel.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> pulumi.Output[str]:
        """
        Name of the Microsoft Teams channel.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="chatConfigurationArn")
    def chat_configuration_arn(self) -> pulumi.Output[str]:
        """
        ARN of the Microsoft Teams channel configuration.
        """
        return pulumi.get(self, "chat_configuration_arn")

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> pulumi.Output[str]:
        """
        Name of the Microsoft Teams channel configuration.
        """
        return pulumi.get(self, "configuration_name")

    @property
    @pulumi.getter(name="guardrailPolicyArns")
    def guardrail_policy_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        List of IAM policy ARNs that are applied as channel guardrails. The AWS managed `AdministratorAccess` policy is applied by default if this is not set.
        """
        return pulumi.get(self, "guardrail_policy_arns")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[str]:
        """
        ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS Chatbot will assume. This is not the service-linked role.
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> pulumi.Output[str]:
        """
        Logging levels include `ERROR`, `INFO`, or `NONE`.
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="snsTopicArns")
    def sns_topic_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        ARNs of the SNS topics that deliver notifications to AWS Chatbot.
        """
        return pulumi.get(self, "sns_topic_arns")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[str]:
        """
        ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from the console.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="teamName")
    def team_name(self) -> pulumi.Output[str]:
        """
        Name of the Microsoft Teams team.
        """
        return pulumi.get(self, "team_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        ID of the Microsoft Teams tenant.

        The following arguments are optional:
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.TeamsChannelConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="userAuthorizationRequired")
    def user_authorization_required(self) -> pulumi.Output[bool]:
        """
        Enables use of a user role requirement in your chat configuration.
        """
        return pulumi.get(self, "user_authorization_required")

