# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOriginAccessIdentityResult',
    'AwaitableGetOriginAccessIdentityResult',
    'get_origin_access_identity',
    'get_origin_access_identity_output',
]

@pulumi.output_type
class GetOriginAccessIdentityResult:
    """
    A collection of values returned by getOriginAccessIdentity.
    """
    def __init__(__self__, caller_reference=None, cloudfront_access_identity_path=None, comment=None, etag=None, iam_arn=None, id=None, s3_canonical_user_id=None):
        if caller_reference and not isinstance(caller_reference, str):
            raise TypeError("Expected argument 'caller_reference' to be a str")
        pulumi.set(__self__, "caller_reference", caller_reference)
        if cloudfront_access_identity_path and not isinstance(cloudfront_access_identity_path, str):
            raise TypeError("Expected argument 'cloudfront_access_identity_path' to be a str")
        pulumi.set(__self__, "cloudfront_access_identity_path", cloudfront_access_identity_path)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if iam_arn and not isinstance(iam_arn, str):
            raise TypeError("Expected argument 'iam_arn' to be a str")
        pulumi.set(__self__, "iam_arn", iam_arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if s3_canonical_user_id and not isinstance(s3_canonical_user_id, str):
            raise TypeError("Expected argument 's3_canonical_user_id' to be a str")
        pulumi.set(__self__, "s3_canonical_user_id", s3_canonical_user_id)

    @property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> str:
        """
        Internal value used by CloudFront to allow future
        updates to the origin access identity.
        """
        return pulumi.get(self, "caller_reference")

    @property
    @pulumi.getter(name="cloudfrontAccessIdentityPath")
    def cloudfront_access_identity_path(self) -> str:
        """
        A shortcut to the full path for the
        origin access identity to use in CloudFront, see below.
        """
        return pulumi.get(self, "cloudfront_access_identity_path")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        An optional comment for the origin access identity.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Current version of the origin access identity's information.
        For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="iamArn")
    def iam_arn(self) -> str:
        """
        Pre-generated ARN for use in S3 bucket policies (see below).
        Example: `arn:aws:iam::cloudfront:user/CloudFront Origin Access Identity
        E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "iam_arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="s3CanonicalUserId")
    def s3_canonical_user_id(self) -> str:
        """
        The Amazon S3 canonical user ID for the origin
        access identity, which you use when giving the origin access identity read
        permission to an object in Amazon S3.
        """
        return pulumi.get(self, "s3_canonical_user_id")


class AwaitableGetOriginAccessIdentityResult(GetOriginAccessIdentityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOriginAccessIdentityResult(
            caller_reference=self.caller_reference,
            cloudfront_access_identity_path=self.cloudfront_access_identity_path,
            comment=self.comment,
            etag=self.etag,
            iam_arn=self.iam_arn,
            id=self.id,
            s3_canonical_user_id=self.s3_canonical_user_id)


def get_origin_access_identity(id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOriginAccessIdentityResult:
    """
    Use this data source to retrieve information for an Amazon CloudFront origin access identity.

    ## Example Usage

    The following example below creates a CloudFront origin access identity.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudfront.get_origin_access_identity(id="E1ZAKK699EOLAL")
    ```


    :param str id: The identifier for the origin access identity. For example: `E1ZAKK699EOLAL`.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudfront/getOriginAccessIdentity:getOriginAccessIdentity', __args__, opts=opts, typ=GetOriginAccessIdentityResult).value

    return AwaitableGetOriginAccessIdentityResult(
        caller_reference=pulumi.get(__ret__, 'caller_reference'),
        cloudfront_access_identity_path=pulumi.get(__ret__, 'cloudfront_access_identity_path'),
        comment=pulumi.get(__ret__, 'comment'),
        etag=pulumi.get(__ret__, 'etag'),
        iam_arn=pulumi.get(__ret__, 'iam_arn'),
        id=pulumi.get(__ret__, 'id'),
        s3_canonical_user_id=pulumi.get(__ret__, 's3_canonical_user_id'))
def get_origin_access_identity_output(id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOriginAccessIdentityResult]:
    """
    Use this data source to retrieve information for an Amazon CloudFront origin access identity.

    ## Example Usage

    The following example below creates a CloudFront origin access identity.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudfront.get_origin_access_identity(id="E1ZAKK699EOLAL")
    ```


    :param str id: The identifier for the origin access identity. For example: `E1ZAKK699EOLAL`.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudfront/getOriginAccessIdentity:getOriginAccessIdentity', __args__, opts=opts, typ=GetOriginAccessIdentityResult)
    return __ret__.apply(lambda __response__: GetOriginAccessIdentityResult(
        caller_reference=pulumi.get(__response__, 'caller_reference'),
        cloudfront_access_identity_path=pulumi.get(__response__, 'cloudfront_access_identity_path'),
        comment=pulumi.get(__response__, 'comment'),
        etag=pulumi.get(__response__, 'etag'),
        iam_arn=pulumi.get(__response__, 'iam_arn'),
        id=pulumi.get(__response__, 'id'),
        s3_canonical_user_id=pulumi.get(__response__, 's3_canonical_user_id')))
