# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcOriginArgs', 'VpcOrigin']

@pulumi.input_type
class VpcOriginArgs:
    def __init__(__self__, *,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['VpcOriginTimeoutsArgs']] = None,
                 vpc_origin_endpoint_config: Optional[pulumi.Input['VpcOriginVpcOriginEndpointConfigArgs']] = None):
        """
        The set of arguments for constructing a VpcOrigin resource.
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_origin_endpoint_config is not None:
            pulumi.set(__self__, "vpc_origin_endpoint_config", vpc_origin_endpoint_config)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['VpcOriginTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['VpcOriginTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vpcOriginEndpointConfig")
    def vpc_origin_endpoint_config(self) -> Optional[pulumi.Input['VpcOriginVpcOriginEndpointConfigArgs']]:
        return pulumi.get(self, "vpc_origin_endpoint_config")

    @vpc_origin_endpoint_config.setter
    def vpc_origin_endpoint_config(self, value: Optional[pulumi.Input['VpcOriginVpcOriginEndpointConfigArgs']]):
        pulumi.set(self, "vpc_origin_endpoint_config", value)


@pulumi.input_type
class _VpcOriginState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['VpcOriginTimeoutsArgs']] = None,
                 vpc_origin_endpoint_config: Optional[pulumi.Input['VpcOriginVpcOriginEndpointConfigArgs']] = None):
        """
        Input properties used for looking up and filtering VpcOrigin resources.
        :param pulumi.Input[str] arn: The VPC origin ARN.
        :param pulumi.Input[str] etag: The current version of the origin.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if vpc_origin_endpoint_config is not None:
            pulumi.set(__self__, "vpc_origin_endpoint_config", vpc_origin_endpoint_config)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC origin ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The current version of the origin.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['VpcOriginTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['VpcOriginTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="vpcOriginEndpointConfig")
    def vpc_origin_endpoint_config(self) -> Optional[pulumi.Input['VpcOriginVpcOriginEndpointConfigArgs']]:
        return pulumi.get(self, "vpc_origin_endpoint_config")

    @vpc_origin_endpoint_config.setter
    def vpc_origin_endpoint_config(self, value: Optional[pulumi.Input['VpcOriginVpcOriginEndpointConfigArgs']]):
        pulumi.set(self, "vpc_origin_endpoint_config", value)


class VpcOrigin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['VpcOriginTimeoutsArgs', 'VpcOriginTimeoutsArgsDict']]] = None,
                 vpc_origin_endpoint_config: Optional[pulumi.Input[Union['VpcOriginVpcOriginEndpointConfigArgs', 'VpcOriginVpcOriginEndpointConfigArgsDict']]] = None,
                 __props__=None):
        """
        Creates an Amazon CloudFront VPC origin.

        For information about CloudFront VPC origins, see
        [Amazon CloudFront Developer Guide - Restrict access with VPC origins][1].

        ## Example Usage

        ### Application Load Balancer

        The following example below creates a CloudFront VPC origin for a Application Load Balancer.

        ```python
        import pulumi
        import pulumi_aws as aws

        alb = aws.cloudfront.VpcOrigin("alb", vpc_origin_endpoint_config={
            "name": "Example VPC Origin",
            "arn": this["arn"],
            "http_port": 8080,
            "https_port": 8443,
            "origin_protocol_policy": "https-only",
            "origin_ssl_protocols": {
                "items": ["TLSv1.2"],
                "quantity": 1,
            },
        })
        ```

        ## Import

        terraform

        import {

          to = aws_cloudfront_vpc_origin.origin

          id = vo_JQEa410sssUFoY6wMkx69j

        }

        Using `pulumi import`, import Cloudfront VPC origins using the `id`. For example:

        console

        % pulumi import aws_cloudfront_vpc_origin vo_JQEa410sssUFoY6wMkx69j

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcOriginArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Amazon CloudFront VPC origin.

        For information about CloudFront VPC origins, see
        [Amazon CloudFront Developer Guide - Restrict access with VPC origins][1].

        ## Example Usage

        ### Application Load Balancer

        The following example below creates a CloudFront VPC origin for a Application Load Balancer.

        ```python
        import pulumi
        import pulumi_aws as aws

        alb = aws.cloudfront.VpcOrigin("alb", vpc_origin_endpoint_config={
            "name": "Example VPC Origin",
            "arn": this["arn"],
            "http_port": 8080,
            "https_port": 8443,
            "origin_protocol_policy": "https-only",
            "origin_ssl_protocols": {
                "items": ["TLSv1.2"],
                "quantity": 1,
            },
        })
        ```

        ## Import

        terraform

        import {

          to = aws_cloudfront_vpc_origin.origin

          id = vo_JQEa410sssUFoY6wMkx69j

        }

        Using `pulumi import`, import Cloudfront VPC origins using the `id`. For example:

        console

        % pulumi import aws_cloudfront_vpc_origin vo_JQEa410sssUFoY6wMkx69j

        :param str resource_name: The name of the resource.
        :param VpcOriginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcOriginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['VpcOriginTimeoutsArgs', 'VpcOriginTimeoutsArgsDict']]] = None,
                 vpc_origin_endpoint_config: Optional[pulumi.Input[Union['VpcOriginVpcOriginEndpointConfigArgs', 'VpcOriginVpcOriginEndpointConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcOriginArgs.__new__(VpcOriginArgs)

            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["vpc_origin_endpoint_config"] = vpc_origin_endpoint_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["tags_all"] = None
        super(VpcOrigin, __self__).__init__(
            'aws:cloudfront/vpcOrigin:VpcOrigin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['VpcOriginTimeoutsArgs', 'VpcOriginTimeoutsArgsDict']]] = None,
            vpc_origin_endpoint_config: Optional[pulumi.Input[Union['VpcOriginVpcOriginEndpointConfigArgs', 'VpcOriginVpcOriginEndpointConfigArgsDict']]] = None) -> 'VpcOrigin':
        """
        Get an existing VpcOrigin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The VPC origin ARN.
        :param pulumi.Input[str] etag: The current version of the origin.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcOriginState.__new__(_VpcOriginState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["etag"] = etag
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["vpc_origin_endpoint_config"] = vpc_origin_endpoint_config
        return VpcOrigin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The VPC origin ARN.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The current version of the origin.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.VpcOriginTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="vpcOriginEndpointConfig")
    def vpc_origin_endpoint_config(self) -> pulumi.Output[Optional['outputs.VpcOriginVpcOriginEndpointConfig']]:
        return pulumi.get(self, "vpc_origin_endpoint_config")

