# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterClusterCertificateArgs',
    'ClusterClusterCertificateArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterClusterCertificateArgsDict(TypedDict):
        aws_hardware_certificate: NotRequired[pulumi.Input[str]]
        """
        The HSM hardware certificate issued (signed) by AWS CloudHSM.
        """
        cluster_certificate: NotRequired[pulumi.Input[str]]
        """
        The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
        """
        cluster_csr: NotRequired[pulumi.Input[str]]
        """
        The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
        """
        hsm_certificate: NotRequired[pulumi.Input[str]]
        """
        The HSM certificate issued (signed) by the HSM hardware.
        """
        manufacturer_hardware_certificate: NotRequired[pulumi.Input[str]]
        """
        The HSM hardware certificate issued (signed) by the hardware manufacturer.
        """
elif False:
    ClusterClusterCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterClusterCertificateArgs:
    def __init__(__self__, *,
                 aws_hardware_certificate: Optional[pulumi.Input[str]] = None,
                 cluster_certificate: Optional[pulumi.Input[str]] = None,
                 cluster_csr: Optional[pulumi.Input[str]] = None,
                 hsm_certificate: Optional[pulumi.Input[str]] = None,
                 manufacturer_hardware_certificate: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] aws_hardware_certificate: The HSM hardware certificate issued (signed) by AWS CloudHSM.
        :param pulumi.Input[str] cluster_certificate: The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
        :param pulumi.Input[str] cluster_csr: The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
        :param pulumi.Input[str] hsm_certificate: The HSM certificate issued (signed) by the HSM hardware.
        :param pulumi.Input[str] manufacturer_hardware_certificate: The HSM hardware certificate issued (signed) by the hardware manufacturer.
        """
        if aws_hardware_certificate is not None:
            pulumi.set(__self__, "aws_hardware_certificate", aws_hardware_certificate)
        if cluster_certificate is not None:
            pulumi.set(__self__, "cluster_certificate", cluster_certificate)
        if cluster_csr is not None:
            pulumi.set(__self__, "cluster_csr", cluster_csr)
        if hsm_certificate is not None:
            pulumi.set(__self__, "hsm_certificate", hsm_certificate)
        if manufacturer_hardware_certificate is not None:
            pulumi.set(__self__, "manufacturer_hardware_certificate", manufacturer_hardware_certificate)

    @property
    @pulumi.getter(name="awsHardwareCertificate")
    def aws_hardware_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The HSM hardware certificate issued (signed) by AWS CloudHSM.
        """
        return pulumi.get(self, "aws_hardware_certificate")

    @aws_hardware_certificate.setter
    def aws_hardware_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_hardware_certificate", value)

    @property
    @pulumi.getter(name="clusterCertificate")
    def cluster_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster certificate issued (signed) by the issuing certificate authority (CA) of the cluster's owner.
        """
        return pulumi.get(self, "cluster_certificate")

    @cluster_certificate.setter
    def cluster_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_certificate", value)

    @property
    @pulumi.getter(name="clusterCsr")
    def cluster_csr(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate signing request (CSR). Available only in `UNINITIALIZED` state after an HSM instance is added to the cluster.
        """
        return pulumi.get(self, "cluster_csr")

    @cluster_csr.setter
    def cluster_csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_csr", value)

    @property
    @pulumi.getter(name="hsmCertificate")
    def hsm_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The HSM certificate issued (signed) by the HSM hardware.
        """
        return pulumi.get(self, "hsm_certificate")

    @hsm_certificate.setter
    def hsm_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hsm_certificate", value)

    @property
    @pulumi.getter(name="manufacturerHardwareCertificate")
    def manufacturer_hardware_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The HSM hardware certificate issued (signed) by the hardware manufacturer.
        """
        return pulumi.get(self, "manufacturer_hardware_certificate")

    @manufacturer_hardware_certificate.setter
    def manufacturer_hardware_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manufacturer_hardware_certificate", value)


