# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogAnomalyDetectorArgs', 'LogAnomalyDetector']

@pulumi.input_type
class LogAnomalyDetectorArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 log_group_arn_lists: pulumi.Input[Sequence[pulumi.Input[str]]],
                 anomaly_visibility_time: Optional[pulumi.Input[int]] = None,
                 detector_name: Optional[pulumi.Input[str]] = None,
                 evaluation_frequency: Optional[pulumi.Input[str]] = None,
                 filter_pattern: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a LogAnomalyDetector resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_group_arn_lists: Array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.
               
               The following arguments are optional:
        :param pulumi.Input[int] anomaly_visibility_time: Number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomaly_visibility_time`, it will be considered normal going forward and will not be detected as an anomaly. Valid Range: Minimum value of 7. Maximum value of 90.
        :param pulumi.Input[str] detector_name: Name for this anomaly detector.
        :param pulumi.Input[str] evaluation_frequency: Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluation_frequency`. Valid Values: `ONE_MIN | FIVE_MIN | TEN_MIN | FIFTEEN_MIN | THIRTY_MIN | ONE_HOUR`.
        :param pulumi.Input[str] filter_pattern: You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        :param pulumi.Input[str] kms_key_id: Optionally assigns a AWS KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "log_group_arn_lists", log_group_arn_lists)
        if anomaly_visibility_time is not None:
            pulumi.set(__self__, "anomaly_visibility_time", anomaly_visibility_time)
        if detector_name is not None:
            pulumi.set(__self__, "detector_name", detector_name)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if filter_pattern is not None:
            pulumi.set(__self__, "filter_pattern", filter_pattern)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="logGroupArnLists")
    def log_group_arn_lists(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "log_group_arn_lists")

    @log_group_arn_lists.setter
    def log_group_arn_lists(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "log_group_arn_lists", value)

    @property
    @pulumi.getter(name="anomalyVisibilityTime")
    def anomaly_visibility_time(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomaly_visibility_time`, it will be considered normal going forward and will not be detected as an anomaly. Valid Range: Minimum value of 7. Maximum value of 90.
        """
        return pulumi.get(self, "anomaly_visibility_time")

    @anomaly_visibility_time.setter
    def anomaly_visibility_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "anomaly_visibility_time", value)

    @property
    @pulumi.getter(name="detectorName")
    def detector_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for this anomaly detector.
        """
        return pulumi.get(self, "detector_name")

    @detector_name.setter
    def detector_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detector_name", value)

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluation_frequency`. Valid Values: `ONE_MIN | FIVE_MIN | TEN_MIN | FIFTEEN_MIN | THIRTY_MIN | ONE_HOUR`.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_frequency", value)

    @property
    @pulumi.getter(name="filterPattern")
    def filter_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        """
        return pulumi.get(self, "filter_pattern")

    @filter_pattern.setter
    def filter_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_pattern", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optionally assigns a AWS KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LogAnomalyDetectorState:
    def __init__(__self__, *,
                 anomaly_visibility_time: Optional[pulumi.Input[int]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 detector_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[str]] = None,
                 filter_pattern: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_group_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering LogAnomalyDetector resources.
        :param pulumi.Input[int] anomaly_visibility_time: Number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomaly_visibility_time`, it will be considered normal going forward and will not be detected as an anomaly. Valid Range: Minimum value of 7. Maximum value of 90.
        :param pulumi.Input[str] arn: ARN of the log anomaly detector that you just created.
        :param pulumi.Input[str] detector_name: Name for this anomaly detector.
        :param pulumi.Input[str] evaluation_frequency: Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluation_frequency`. Valid Values: `ONE_MIN | FIVE_MIN | TEN_MIN | FIFTEEN_MIN | THIRTY_MIN | ONE_HOUR`.
        :param pulumi.Input[str] filter_pattern: You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        :param pulumi.Input[str] kms_key_id: Optionally assigns a AWS KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_group_arn_lists: Array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.
               
               The following arguments are optional:
        """
        if anomaly_visibility_time is not None:
            pulumi.set(__self__, "anomaly_visibility_time", anomaly_visibility_time)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if detector_name is not None:
            pulumi.set(__self__, "detector_name", detector_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if filter_pattern is not None:
            pulumi.set(__self__, "filter_pattern", filter_pattern)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_group_arn_lists is not None:
            pulumi.set(__self__, "log_group_arn_lists", log_group_arn_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="anomalyVisibilityTime")
    def anomaly_visibility_time(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomaly_visibility_time`, it will be considered normal going forward and will not be detected as an anomaly. Valid Range: Minimum value of 7. Maximum value of 90.
        """
        return pulumi.get(self, "anomaly_visibility_time")

    @anomaly_visibility_time.setter
    def anomaly_visibility_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "anomaly_visibility_time", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the log anomaly detector that you just created.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="detectorName")
    def detector_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for this anomaly detector.
        """
        return pulumi.get(self, "detector_name")

    @detector_name.setter
    def detector_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detector_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluation_frequency`. Valid Values: `ONE_MIN | FIVE_MIN | TEN_MIN | FIFTEEN_MIN | THIRTY_MIN | ONE_HOUR`.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_frequency", value)

    @property
    @pulumi.getter(name="filterPattern")
    def filter_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        """
        return pulumi.get(self, "filter_pattern")

    @filter_pattern.setter
    def filter_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter_pattern", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optionally assigns a AWS KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="logGroupArnLists")
    def log_group_arn_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "log_group_arn_lists")

    @log_group_arn_lists.setter
    def log_group_arn_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_group_arn_lists", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class LogAnomalyDetector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anomaly_visibility_time: Optional[pulumi.Input[int]] = None,
                 detector_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[str]] = None,
                 filter_pattern: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_group_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudWatch Logs Log Anomaly Detector.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = []
        for range in [{"value": i} for i in range(0, 2)]:
            test.append(aws.cloudwatch.LogGroup(f"test-{range['value']}", name=f"testing-{range['value']}"))
        test_log_anomaly_detector = aws.cloudwatch.LogAnomalyDetector("test",
            detector_name="testing",
            log_group_arn_lists=[test[0].arn],
            anomaly_visibility_time=7,
            evaluation_frequency="TEN_MIN",
            enabled=False)
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Log Anomaly Detector using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logAnomalyDetector:LogAnomalyDetector example log_anomaly_detector-arn-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] anomaly_visibility_time: Number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomaly_visibility_time`, it will be considered normal going forward and will not be detected as an anomaly. Valid Range: Minimum value of 7. Maximum value of 90.
        :param pulumi.Input[str] detector_name: Name for this anomaly detector.
        :param pulumi.Input[str] evaluation_frequency: Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluation_frequency`. Valid Values: `ONE_MIN | FIVE_MIN | TEN_MIN | FIFTEEN_MIN | THIRTY_MIN | ONE_HOUR`.
        :param pulumi.Input[str] filter_pattern: You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        :param pulumi.Input[str] kms_key_id: Optionally assigns a AWS KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_group_arn_lists: Array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogAnomalyDetectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudWatch Logs Log Anomaly Detector.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = []
        for range in [{"value": i} for i in range(0, 2)]:
            test.append(aws.cloudwatch.LogGroup(f"test-{range['value']}", name=f"testing-{range['value']}"))
        test_log_anomaly_detector = aws.cloudwatch.LogAnomalyDetector("test",
            detector_name="testing",
            log_group_arn_lists=[test[0].arn],
            anomaly_visibility_time=7,
            evaluation_frequency="TEN_MIN",
            enabled=False)
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Log Anomaly Detector using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/logAnomalyDetector:LogAnomalyDetector example log_anomaly_detector-arn-12345678
        ```

        :param str resource_name: The name of the resource.
        :param LogAnomalyDetectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogAnomalyDetectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anomaly_visibility_time: Optional[pulumi.Input[int]] = None,
                 detector_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[str]] = None,
                 filter_pattern: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_group_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogAnomalyDetectorArgs.__new__(LogAnomalyDetectorArgs)

            __props__.__dict__["anomaly_visibility_time"] = anomaly_visibility_time
            __props__.__dict__["detector_name"] = detector_name
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["evaluation_frequency"] = evaluation_frequency
            __props__.__dict__["filter_pattern"] = filter_pattern
            __props__.__dict__["kms_key_id"] = kms_key_id
            if log_group_arn_lists is None and not opts.urn:
                raise TypeError("Missing required property 'log_group_arn_lists'")
            __props__.__dict__["log_group_arn_lists"] = log_group_arn_lists
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(LogAnomalyDetector, __self__).__init__(
            'aws:cloudwatch/logAnomalyDetector:LogAnomalyDetector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anomaly_visibility_time: Optional[pulumi.Input[int]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            detector_name: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            evaluation_frequency: Optional[pulumi.Input[str]] = None,
            filter_pattern: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            log_group_arn_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'LogAnomalyDetector':
        """
        Get an existing LogAnomalyDetector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] anomaly_visibility_time: Number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomaly_visibility_time`, it will be considered normal going forward and will not be detected as an anomaly. Valid Range: Minimum value of 7. Maximum value of 90.
        :param pulumi.Input[str] arn: ARN of the log anomaly detector that you just created.
        :param pulumi.Input[str] detector_name: Name for this anomaly detector.
        :param pulumi.Input[str] evaluation_frequency: Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluation_frequency`. Valid Values: `ONE_MIN | FIVE_MIN | TEN_MIN | FIFTEEN_MIN | THIRTY_MIN | ONE_HOUR`.
        :param pulumi.Input[str] filter_pattern: You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        :param pulumi.Input[str] kms_key_id: Optionally assigns a AWS KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_group_arn_lists: Array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogAnomalyDetectorState.__new__(_LogAnomalyDetectorState)

        __props__.__dict__["anomaly_visibility_time"] = anomaly_visibility_time
        __props__.__dict__["arn"] = arn
        __props__.__dict__["detector_name"] = detector_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["evaluation_frequency"] = evaluation_frequency
        __props__.__dict__["filter_pattern"] = filter_pattern
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["log_group_arn_lists"] = log_group_arn_lists
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return LogAnomalyDetector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anomalyVisibilityTime")
    def anomaly_visibility_time(self) -> pulumi.Output[int]:
        """
        Number of days to have visibility on an anomaly. After this time period has elapsed for an anomaly, it will be automatically baselined and the anomaly detector will treat new occurrences of a similar anomaly as normal. Therefore, if you do not correct the cause of an anomaly during the time period specified in `anomaly_visibility_time`, it will be considered normal going forward and will not be detected as an anomaly. Valid Range: Minimum value of 7. Maximum value of 90.
        """
        return pulumi.get(self, "anomaly_visibility_time")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the log anomaly detector that you just created.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="detectorName")
    def detector_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name for this anomaly detector.
        """
        return pulumi.get(self, "detector_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies how often the anomaly detector is to run and look for anomalies. Set this value according to the frequency that the log group receives new logs. For example, if the log group receives new log events every 10 minutes, then 15 minutes might be a good setting for `evaluation_frequency`. Valid Values: `ONE_MIN | FIVE_MIN | TEN_MIN | FIFTEEN_MIN | THIRTY_MIN | ONE_HOUR`.
        """
        return pulumi.get(self, "evaluation_frequency")

    @property
    @pulumi.getter(name="filterPattern")
    def filter_pattern(self) -> pulumi.Output[Optional[str]]:
        """
        You can use this parameter to limit the anomaly detection model to examine only log events that match the pattern you specify here. For more information, see [Filter and Pattern Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
        """
        return pulumi.get(self, "filter_pattern")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optionally assigns a AWS KMS key to secure this anomaly detector and its findings. If a key is assigned, the anomalies found and the model used by this detector are encrypted at rest with the key. If a key is assigned to an anomaly detector, a user must have permissions for both this key and for the anomaly detector to retrieve information about the anomalies that it finds.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logGroupArnLists")
    def log_group_arn_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        Array containing the ARN of the log group that this anomaly detector will watch. You can specify only one log group ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "log_group_arn_lists")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

