# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FleetScalingConfiguration',
    'FleetScalingConfigurationTargetTrackingScalingConfig',
    'FleetStatus',
    'FleetVpcConfig',
    'ProjectArtifacts',
    'ProjectBuildBatchConfig',
    'ProjectBuildBatchConfigRestrictions',
    'ProjectCache',
    'ProjectEnvironment',
    'ProjectEnvironmentEnvironmentVariable',
    'ProjectEnvironmentFleet',
    'ProjectEnvironmentRegistryCredential',
    'ProjectFileSystemLocation',
    'ProjectLogsConfig',
    'ProjectLogsConfigCloudwatchLogs',
    'ProjectLogsConfigS3Logs',
    'ProjectSecondaryArtifact',
    'ProjectSecondarySource',
    'ProjectSecondarySourceBuildStatusConfig',
    'ProjectSecondarySourceGitSubmodulesConfig',
    'ProjectSecondarySourceVersion',
    'ProjectSource',
    'ProjectSourceBuildStatusConfig',
    'ProjectSourceGitSubmodulesConfig',
    'ProjectVpcConfig',
    'ReportGroupExportConfig',
    'ReportGroupExportConfigS3Destination',
    'WebhookFilterGroup',
    'WebhookFilterGroupFilter',
    'WebhookScopeConfiguration',
    'GetFleetScalingConfigurationResult',
    'GetFleetScalingConfigurationTargetTrackingScalingConfigResult',
    'GetFleetStatusResult',
    'GetFleetVpcConfigResult',
]

@pulumi.output_type
class FleetScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredCapacity":
            suggest = "desired_capacity"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "scalingType":
            suggest = "scaling_type"
        elif key == "targetTrackingScalingConfigs":
            suggest = "target_tracking_scaling_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_capacity: Optional[int] = None,
                 max_capacity: Optional[int] = None,
                 scaling_type: Optional[str] = None,
                 target_tracking_scaling_configs: Optional[Sequence['outputs.FleetScalingConfigurationTargetTrackingScalingConfig']] = None):
        """
        :param int max_capacity: Maximum number of instances in the ﬂeet when auto-scaling.
        :param str scaling_type: Scaling type for a compute fleet. Valid value: `TARGET_TRACKING_SCALING`.
        :param Sequence['FleetScalingConfigurationTargetTrackingScalingConfigArgs'] target_tracking_scaling_configs: Configuration block. Detailed below.
        """
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if scaling_type is not None:
            pulumi.set(__self__, "scaling_type", scaling_type)
        if target_tracking_scaling_configs is not None:
            pulumi.set(__self__, "target_tracking_scaling_configs", target_tracking_scaling_configs)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[int]:
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[int]:
        """
        Maximum number of instances in the ﬂeet when auto-scaling.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="scalingType")
    def scaling_type(self) -> Optional[str]:
        """
        Scaling type for a compute fleet. Valid value: `TARGET_TRACKING_SCALING`.
        """
        return pulumi.get(self, "scaling_type")

    @property
    @pulumi.getter(name="targetTrackingScalingConfigs")
    def target_tracking_scaling_configs(self) -> Optional[Sequence['outputs.FleetScalingConfigurationTargetTrackingScalingConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "target_tracking_scaling_configs")


@pulumi.output_type
class FleetScalingConfigurationTargetTrackingScalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricType":
            suggest = "metric_type"
        elif key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetScalingConfigurationTargetTrackingScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetScalingConfigurationTargetTrackingScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetScalingConfigurationTargetTrackingScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_type: Optional[str] = None,
                 target_value: Optional[float] = None):
        """
        :param str metric_type: Metric type to determine auto-scaling. Valid value: `FLEET_UTILIZATION_RATE`.
        :param float target_value: Value of metricType when to start scaling.
        """
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if target_value is not None:
            pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[str]:
        """
        Metric type to determine auto-scaling. Valid value: `FLEET_UTILIZATION_RATE`.
        """
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> Optional[float]:
        """
        Value of metricType when to start scaling.
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class FleetStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: Optional[str] = None,
                 message: Optional[str] = None,
                 status_code: Optional[str] = None):
        """
        :param str context: Additional information about a compute fleet.
        :param str message: Message associated with the status of a compute fleet.
        :param str status_code: Status code of the compute fleet.
        """
        if context is not None:
            pulumi.set(__self__, "context", context)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Additional information about a compute fleet.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message associated with the status of a compute fleet.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        """
        Status code of the compute fleet.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class FleetVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str],
                 vpc_id: str):
        """
        :param Sequence[str] security_group_ids: A list of one or more security groups IDs in your Amazon VPC.
        :param Sequence[str] subnets: A list of one or more subnet IDs in your Amazon VPC.
        :param str vpc_id: The ID of the Amazon VPC.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        A list of one or more security groups IDs in your Amazon VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        A list of one or more subnet IDs in your Amazon VPC.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the Amazon VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class ProjectArtifacts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactIdentifier":
            suggest = "artifact_identifier"
        elif key == "bucketOwnerAccess":
            suggest = "bucket_owner_access"
        elif key == "encryptionDisabled":
            suggest = "encryption_disabled"
        elif key == "namespaceType":
            suggest = "namespace_type"
        elif key == "overrideArtifactName":
            suggest = "override_artifact_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectArtifacts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectArtifacts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectArtifacts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 artifact_identifier: Optional[str] = None,
                 bucket_owner_access: Optional[str] = None,
                 encryption_disabled: Optional[bool] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 namespace_type: Optional[str] = None,
                 override_artifact_name: Optional[bool] = None,
                 packaging: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str type: Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
        :param str artifact_identifier: Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        :param str bucket_owner_access: Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
        :param bool encryption_disabled: Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        :param str location: Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored. If `type` is set to `S3`, this is the name of the output bucket.
        :param str name: Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        :param str namespace_type: Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID`, `NONE`.
        :param bool override_artifact_name: Whether a name specified in the build specification overrides the artifact name.
        :param str packaging: Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
        :param str path: If `type` is set to `S3`, this is the path to the output artifact.
        """
        pulumi.set(__self__, "type", type)
        if artifact_identifier is not None:
            pulumi.set(__self__, "artifact_identifier", artifact_identifier)
        if bucket_owner_access is not None:
            pulumi.set(__self__, "bucket_owner_access", bucket_owner_access)
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_type is not None:
            pulumi.set(__self__, "namespace_type", namespace_type)
        if override_artifact_name is not None:
            pulumi.set(__self__, "override_artifact_name", override_artifact_name)
        if packaging is not None:
            pulumi.set(__self__, "packaging", packaging)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Build output artifact's type. Valid values: `CODEPIPELINE`, `NO_ARTIFACTS`, `S3`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="artifactIdentifier")
    def artifact_identifier(self) -> Optional[str]:
        """
        Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        """
        return pulumi.get(self, "artifact_identifier")

    @property
    @pulumi.getter(name="bucketOwnerAccess")
    def bucket_owner_access(self) -> Optional[str]:
        """
        Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
        """
        return pulumi.get(self, "bucket_owner_access")

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[bool]:
        """
        Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        """
        return pulumi.get(self, "encryption_disabled")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored. If `type` is set to `S3`, this is the name of the output bucket.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the project. If `type` is set to `S3`, this is the name of the output artifact object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceType")
    def namespace_type(self) -> Optional[str]:
        """
        Namespace to use in storing build artifacts. If `type` is set to `S3`, then valid values are `BUILD_ID`, `NONE`.
        """
        return pulumi.get(self, "namespace_type")

    @property
    @pulumi.getter(name="overrideArtifactName")
    def override_artifact_name(self) -> Optional[bool]:
        """
        Whether a name specified in the build specification overrides the artifact name.
        """
        return pulumi.get(self, "override_artifact_name")

    @property
    @pulumi.getter
    def packaging(self) -> Optional[str]:
        """
        Type of build output artifact to create. If `type` is set to `S3`, valid values are `NONE`, `ZIP`
        """
        return pulumi.get(self, "packaging")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        If `type` is set to `S3`, this is the path to the output artifact.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ProjectBuildBatchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceRole":
            suggest = "service_role"
        elif key == "combineArtifacts":
            suggest = "combine_artifacts"
        elif key == "timeoutInMins":
            suggest = "timeout_in_mins"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectBuildBatchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectBuildBatchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectBuildBatchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_role: str,
                 combine_artifacts: Optional[bool] = None,
                 restrictions: Optional['outputs.ProjectBuildBatchConfigRestrictions'] = None,
                 timeout_in_mins: Optional[int] = None):
        """
        :param str service_role: Specifies the service role ARN for the batch build project.
        :param bool combine_artifacts: Specifies if the build artifacts for the batch build should be combined into a single artifact location.
        :param 'ProjectBuildBatchConfigRestrictionsArgs' restrictions: Configuration block specifying the restrictions for the batch build. Detailed below.
        :param int timeout_in_mins: Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
        """
        pulumi.set(__self__, "service_role", service_role)
        if combine_artifacts is not None:
            pulumi.set(__self__, "combine_artifacts", combine_artifacts)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if timeout_in_mins is not None:
            pulumi.set(__self__, "timeout_in_mins", timeout_in_mins)

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> str:
        """
        Specifies the service role ARN for the batch build project.
        """
        return pulumi.get(self, "service_role")

    @property
    @pulumi.getter(name="combineArtifacts")
    def combine_artifacts(self) -> Optional[bool]:
        """
        Specifies if the build artifacts for the batch build should be combined into a single artifact location.
        """
        return pulumi.get(self, "combine_artifacts")

    @property
    @pulumi.getter
    def restrictions(self) -> Optional['outputs.ProjectBuildBatchConfigRestrictions']:
        """
        Configuration block specifying the restrictions for the batch build. Detailed below.
        """
        return pulumi.get(self, "restrictions")

    @property
    @pulumi.getter(name="timeoutInMins")
    def timeout_in_mins(self) -> Optional[int]:
        """
        Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
        """
        return pulumi.get(self, "timeout_in_mins")


@pulumi.output_type
class ProjectBuildBatchConfigRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeTypesAlloweds":
            suggest = "compute_types_alloweds"
        elif key == "maximumBuildsAllowed":
            suggest = "maximum_builds_allowed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectBuildBatchConfigRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectBuildBatchConfigRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectBuildBatchConfigRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_types_alloweds: Optional[Sequence[str]] = None,
                 maximum_builds_allowed: Optional[int] = None):
        """
        :param Sequence[str] compute_types_alloweds: An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
        :param int maximum_builds_allowed: Specifies the maximum number of builds allowed.
        """
        if compute_types_alloweds is not None:
            pulumi.set(__self__, "compute_types_alloweds", compute_types_alloweds)
        if maximum_builds_allowed is not None:
            pulumi.set(__self__, "maximum_builds_allowed", maximum_builds_allowed)

    @property
    @pulumi.getter(name="computeTypesAlloweds")
    def compute_types_alloweds(self) -> Optional[Sequence[str]]:
        """
        An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
        """
        return pulumi.get(self, "compute_types_alloweds")

    @property
    @pulumi.getter(name="maximumBuildsAllowed")
    def maximum_builds_allowed(self) -> Optional[int]:
        """
        Specifies the maximum number of builds allowed.
        """
        return pulumi.get(self, "maximum_builds_allowed")


@pulumi.output_type
class ProjectCache(dict):
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 modes: Optional[Sequence[str]] = None,
                 type: Optional[str] = None):
        """
        :param str location: Location where the AWS CodeBuild project stores cached resources. For type `S3`, the value must be a valid S3 bucket name/prefix.
        :param Sequence[str] modes: Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
        :param str type: Type of storage that will be used for the AWS CodeBuild project cache. Valid values: `NO_CACHE`, `LOCAL`, `S3`. Defaults to `NO_CACHE`.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if modes is not None:
            pulumi.set(__self__, "modes", modes)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location where the AWS CodeBuild project stores cached resources. For type `S3`, the value must be a valid S3 bucket name/prefix.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def modes(self) -> Optional[Sequence[str]]:
        """
        Specifies settings that AWS CodeBuild uses to store and reuse build dependencies. Valid values:  `LOCAL_SOURCE_CACHE`, `LOCAL_DOCKER_LAYER_CACHE`, `LOCAL_CUSTOM_CACHE`.
        """
        return pulumi.get(self, "modes")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of storage that will be used for the AWS CodeBuild project cache. Valid values: `NO_CACHE`, `LOCAL`, `S3`. Defaults to `NO_CACHE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ProjectEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "imagePullCredentialsType":
            suggest = "image_pull_credentials_type"
        elif key == "privilegedMode":
            suggest = "privileged_mode"
        elif key == "registryCredential":
            suggest = "registry_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 image: str,
                 type: str,
                 certificate: Optional[str] = None,
                 environment_variables: Optional[Sequence['outputs.ProjectEnvironmentEnvironmentVariable']] = None,
                 fleet: Optional['outputs.ProjectEnvironmentFleet'] = None,
                 image_pull_credentials_type: Optional[str] = None,
                 privileged_mode: Optional[bool] = None,
                 registry_credential: Optional['outputs.ProjectEnvironmentRegistryCredential'] = None):
        """
        :param str compute_type: Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`, `BUILD_LAMBDA_1GB`, `BUILD_LAMBDA_2GB`, `BUILD_LAMBDA_4GB`, `BUILD_LAMBDA_8GB`, `BUILD_LAMBDA_10GB`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`. When `type` is set to `LINUX_LAMBDA_CONTAINER` or `ARM_LAMBDA_CONTAINER`, `compute_type` must be `BUILD_LAMBDA_XGB`.`
        :param str image: Docker image to use for this build project. Valid values include [Docker images provided by CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html) (e.g `aws/codebuild/amazonlinux2-x86_64-standard:4.0`), [Docker Hub images](https://hub.docker.com/) (e.g., `pulumi/pulumi:latest`), and full Docker repository URIs such as those for ECR (e.g., `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
        :param str type: Type of build environment to use for related builds. Valid values: `LINUX_CONTAINER`, `LINUX_GPU_CONTAINER`, `WINDOWS_CONTAINER` (deprecated), `WINDOWS_SERVER_2019_CONTAINER`, `ARM_CONTAINER`, `LINUX_LAMBDA_CONTAINER`, `ARM_LAMBDA_CONTAINER`. For additional information, see the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html).
        :param str certificate: ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
        :param Sequence['ProjectEnvironmentEnvironmentVariableArgs'] environment_variables: Configuration block. Detailed below.
        :param 'ProjectEnvironmentFleetArgs' fleet: Configuration block. Detailed below.
        :param str image_pull_credentials_type: Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
        :param bool privileged_mode: Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
        :param 'ProjectEnvironmentRegistryCredentialArgs' registry_credential: Configuration block. Detailed below.
        """
        pulumi.set(__self__, "compute_type", compute_type)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "type", type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if fleet is not None:
            pulumi.set(__self__, "fleet", fleet)
        if image_pull_credentials_type is not None:
            pulumi.set(__self__, "image_pull_credentials_type", image_pull_credentials_type)
        if privileged_mode is not None:
            pulumi.set(__self__, "privileged_mode", privileged_mode)
        if registry_credential is not None:
            pulumi.set(__self__, "registry_credential", registry_credential)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`, `BUILD_LAMBDA_1GB`, `BUILD_LAMBDA_2GB`, `BUILD_LAMBDA_4GB`, `BUILD_LAMBDA_8GB`, `BUILD_LAMBDA_10GB`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`. When `type` is set to `LINUX_LAMBDA_CONTAINER` or `ARM_LAMBDA_CONTAINER`, `compute_type` must be `BUILD_LAMBDA_XGB`.`
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Docker image to use for this build project. Valid values include [Docker images provided by CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html) (e.g `aws/codebuild/amazonlinux2-x86_64-standard:4.0`), [Docker Hub images](https://hub.docker.com/) (e.g., `pulumi/pulumi:latest`), and full Docker repository URIs such as those for ECR (e.g., `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of build environment to use for related builds. Valid values: `LINUX_CONTAINER`, `LINUX_GPU_CONTAINER`, `WINDOWS_CONTAINER` (deprecated), `WINDOWS_SERVER_2019_CONTAINER`, `ARM_CONTAINER`, `LINUX_LAMBDA_CONTAINER`, `ARM_LAMBDA_CONTAINER`. For additional information, see the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        """
        ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Sequence['outputs.ProjectEnvironmentEnvironmentVariable']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def fleet(self) -> Optional['outputs.ProjectEnvironmentFleet']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "fleet")

    @property
    @pulumi.getter(name="imagePullCredentialsType")
    def image_pull_credentials_type(self) -> Optional[str]:
        """
        Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
        """
        return pulumi.get(self, "image_pull_credentials_type")

    @property
    @pulumi.getter(name="privilegedMode")
    def privileged_mode(self) -> Optional[bool]:
        """
        Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
        """
        return pulumi.get(self, "privileged_mode")

    @property
    @pulumi.getter(name="registryCredential")
    def registry_credential(self) -> Optional['outputs.ProjectEnvironmentRegistryCredential']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "registry_credential")


@pulumi.output_type
class ProjectEnvironmentEnvironmentVariable(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 type: Optional[str] = None):
        """
        :param str name: Environment variable's name or key.
        :param str value: Environment variable's value.
        :param str type: Type of environment variable. Valid values: `PARAMETER_STORE`, `PLAINTEXT`, `SECRETS_MANAGER`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Environment variable's name or key.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Environment variable's value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of environment variable. Valid values: `PARAMETER_STORE`, `PLAINTEXT`, `SECRETS_MANAGER`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ProjectEnvironmentFleet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fleetArn":
            suggest = "fleet_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectEnvironmentFleet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectEnvironmentFleet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectEnvironmentFleet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fleet_arn: Optional[str] = None):
        """
        :param str fleet_arn: Compute fleet ARN for the build project.
        """
        if fleet_arn is not None:
            pulumi.set(__self__, "fleet_arn", fleet_arn)

    @property
    @pulumi.getter(name="fleetArn")
    def fleet_arn(self) -> Optional[str]:
        """
        Compute fleet ARN for the build project.
        """
        return pulumi.get(self, "fleet_arn")


@pulumi.output_type
class ProjectEnvironmentRegistryCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialProvider":
            suggest = "credential_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectEnvironmentRegistryCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectEnvironmentRegistryCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectEnvironmentRegistryCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential: str,
                 credential_provider: str):
        """
        :param str credential: ARN or name of credentials created using AWS Secrets Manager.
        :param str credential_provider: Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "credential_provider", credential_provider)

    @property
    @pulumi.getter
    def credential(self) -> str:
        """
        ARN or name of credentials created using AWS Secrets Manager.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter(name="credentialProvider")
    def credential_provider(self) -> str:
        """
        Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
        """
        return pulumi.get(self, "credential_provider")


@pulumi.output_type
class ProjectFileSystemLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"
        elif key == "mountPoint":
            suggest = "mount_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectFileSystemLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectFileSystemLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectFileSystemLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identifier: Optional[str] = None,
                 location: Optional[str] = None,
                 mount_options: Optional[str] = None,
                 mount_point: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str identifier: The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
        :param str location: A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
        :param str mount_options: The mount options for a file system created by AWS EFS.
        :param str mount_point: The location in the container where you mount the file system.
        :param str type: The type of the file system. The one supported type is `EFS`.
        """
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if mount_point is not None:
            pulumi.set(__self__, "mount_point", mount_point)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the identifier in all capital letters to CODEBUILD\\_. For example, if you specify my-efs for identifier, a new environment variable is create named CODEBUILD_MY-EFS.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[str]:
        """
        The mount options for a file system created by AWS EFS.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> Optional[str]:
        """
        The location in the container where you mount the file system.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the file system. The one supported type is `EFS`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ProjectLogsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogs":
            suggest = "cloudwatch_logs"
        elif key == "s3Logs":
            suggest = "s3_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectLogsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectLogsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectLogsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs: Optional['outputs.ProjectLogsConfigCloudwatchLogs'] = None,
                 s3_logs: Optional['outputs.ProjectLogsConfigS3Logs'] = None):
        """
        :param 'ProjectLogsConfigCloudwatchLogsArgs' cloudwatch_logs: Configuration block. Detailed below.
        :param 'ProjectLogsConfigS3LogsArgs' s3_logs: Configuration block. Detailed below.
        """
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional['outputs.ProjectLogsConfigCloudwatchLogs']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cloudwatch_logs")

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional['outputs.ProjectLogsConfigS3Logs']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class ProjectLogsConfigCloudwatchLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "streamName":
            suggest = "stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectLogsConfigCloudwatchLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectLogsConfigCloudwatchLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectLogsConfigCloudwatchLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: Optional[str] = None,
                 status: Optional[str] = None,
                 stream_name: Optional[str] = None):
        """
        :param str group_name: Group name of the logs in CloudWatch Logs.
        :param str status: Current status of logs in CloudWatch Logs for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `ENABLED`.
        :param str stream_name: Prefix of the log stream name of the logs in CloudWatch Logs.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[str]:
        """
        Group name of the logs in CloudWatch Logs.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Current status of logs in CloudWatch Logs for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `ENABLED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[str]:
        """
        Prefix of the log stream name of the logs in CloudWatch Logs.
        """
        return pulumi.get(self, "stream_name")


@pulumi.output_type
class ProjectLogsConfigS3Logs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketOwnerAccess":
            suggest = "bucket_owner_access"
        elif key == "encryptionDisabled":
            suggest = "encryption_disabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectLogsConfigS3Logs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectLogsConfigS3Logs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectLogsConfigS3Logs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_owner_access: Optional[str] = None,
                 encryption_disabled: Optional[bool] = None,
                 location: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str bucket_owner_access: Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
        :param bool encryption_disabled: Whether to disable encrypting S3 logs. Defaults to `false`.
        :param str location: Name of the S3 bucket and the path prefix for S3 logs. Must be set if status is `ENABLED`, otherwise it must be empty.
        :param str status: Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
        """
        if bucket_owner_access is not None:
            pulumi.set(__self__, "bucket_owner_access", bucket_owner_access)
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="bucketOwnerAccess")
    def bucket_owner_access(self) -> Optional[str]:
        """
        Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
        """
        return pulumi.get(self, "bucket_owner_access")

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[bool]:
        """
        Whether to disable encrypting S3 logs. Defaults to `false`.
        """
        return pulumi.get(self, "encryption_disabled")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Name of the S3 bucket and the path prefix for S3 logs. Must be set if status is `ENABLED`, otherwise it must be empty.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ProjectSecondaryArtifact(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactIdentifier":
            suggest = "artifact_identifier"
        elif key == "bucketOwnerAccess":
            suggest = "bucket_owner_access"
        elif key == "encryptionDisabled":
            suggest = "encryption_disabled"
        elif key == "namespaceType":
            suggest = "namespace_type"
        elif key == "overrideArtifactName":
            suggest = "override_artifact_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSecondaryArtifact. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSecondaryArtifact.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSecondaryArtifact.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_identifier: str,
                 type: str,
                 bucket_owner_access: Optional[str] = None,
                 encryption_disabled: Optional[bool] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 namespace_type: Optional[str] = None,
                 override_artifact_name: Optional[bool] = None,
                 packaging: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str artifact_identifier: Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        :param str type: Build output artifact's type. Valid values `CODEPIPELINE`, `NO_ARTIFACTS`, and `S3`.
        :param str bucket_owner_access: Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. The CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
        :param bool encryption_disabled: Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        :param str location: Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output bucket. If `path` is not specified, `location` can specify the path of the output artifact in the output bucket.
        :param str name: Name of the project. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output artifact object.
        :param str namespace_type: Namespace to use in storing build artifacts. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `BUILD_ID` or `NONE`.
        :param bool override_artifact_name: Whether a name specified in the build specification overrides the artifact name.
        :param str packaging: Type of build output artifact to create. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `NONE` or `ZIP`.
        :param str path: Along with `namespace_type` and `name`, the pattern that AWS CodeBuild uses to name and store the output artifact. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the path to the output artifact.
        """
        pulumi.set(__self__, "artifact_identifier", artifact_identifier)
        pulumi.set(__self__, "type", type)
        if bucket_owner_access is not None:
            pulumi.set(__self__, "bucket_owner_access", bucket_owner_access)
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_type is not None:
            pulumi.set(__self__, "namespace_type", namespace_type)
        if override_artifact_name is not None:
            pulumi.set(__self__, "override_artifact_name", override_artifact_name)
        if packaging is not None:
            pulumi.set(__self__, "packaging", packaging)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="artifactIdentifier")
    def artifact_identifier(self) -> str:
        """
        Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
        """
        return pulumi.get(self, "artifact_identifier")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Build output artifact's type. Valid values `CODEPIPELINE`, `NO_ARTIFACTS`, and `S3`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="bucketOwnerAccess")
    def bucket_owner_access(self) -> Optional[str]:
        """
        Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. The CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
        """
        return pulumi.get(self, "bucket_owner_access")

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[bool]:
        """
        Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
        """
        return pulumi.get(self, "encryption_disabled")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output bucket. If `path` is not specified, `location` can specify the path of the output artifact in the output bucket.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the project. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output artifact object.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceType")
    def namespace_type(self) -> Optional[str]:
        """
        Namespace to use in storing build artifacts. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `BUILD_ID` or `NONE`.
        """
        return pulumi.get(self, "namespace_type")

    @property
    @pulumi.getter(name="overrideArtifactName")
    def override_artifact_name(self) -> Optional[bool]:
        """
        Whether a name specified in the build specification overrides the artifact name.
        """
        return pulumi.get(self, "override_artifact_name")

    @property
    @pulumi.getter
    def packaging(self) -> Optional[str]:
        """
        Type of build output artifact to create. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `NONE` or `ZIP`.
        """
        return pulumi.get(self, "packaging")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Along with `namespace_type` and `name`, the pattern that AWS CodeBuild uses to name and store the output artifact. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the path to the output artifact.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ProjectSecondarySource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceIdentifier":
            suggest = "source_identifier"
        elif key == "buildStatusConfig":
            suggest = "build_status_config"
        elif key == "gitCloneDepth":
            suggest = "git_clone_depth"
        elif key == "gitSubmodulesConfig":
            suggest = "git_submodules_config"
        elif key == "insecureSsl":
            suggest = "insecure_ssl"
        elif key == "reportBuildStatus":
            suggest = "report_build_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSecondarySource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSecondarySource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSecondarySource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_identifier: str,
                 type: str,
                 build_status_config: Optional['outputs.ProjectSecondarySourceBuildStatusConfig'] = None,
                 buildspec: Optional[str] = None,
                 git_clone_depth: Optional[int] = None,
                 git_submodules_config: Optional['outputs.ProjectSecondarySourceGitSubmodulesConfig'] = None,
                 insecure_ssl: Optional[bool] = None,
                 location: Optional[str] = None,
                 report_build_status: Optional[bool] = None):
        """
        :param str source_identifier: An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
        :param str type: Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
        :param 'ProjectSecondarySourceBuildStatusConfigArgs' build_status_config: Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
        :param str buildspec: The build spec declaration to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
        :param int git_clone_depth: Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        :param 'ProjectSecondarySourceGitSubmodulesConfigArgs' git_submodules_config: Configuration block. Detailed below.
        :param bool insecure_ssl: Ignore SSL warnings when connecting to source control.
        :param str location: Location of the source code from git or s3.
        :param bool report_build_status: Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
        """
        pulumi.set(__self__, "source_identifier", source_identifier)
        pulumi.set(__self__, "type", type)
        if build_status_config is not None:
            pulumi.set(__self__, "build_status_config", build_status_config)
        if buildspec is not None:
            pulumi.set(__self__, "buildspec", buildspec)
        if git_clone_depth is not None:
            pulumi.set(__self__, "git_clone_depth", git_clone_depth)
        if git_submodules_config is not None:
            pulumi.set(__self__, "git_submodules_config", git_submodules_config)
        if insecure_ssl is not None:
            pulumi.set(__self__, "insecure_ssl", insecure_ssl)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if report_build_status is not None:
            pulumi.set(__self__, "report_build_status", report_build_status)

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> str:
        """
        An identifier for this project source. The identifier can only contain alphanumeric characters and underscores, and must be less than 128 characters in length.
        """
        return pulumi.get(self, "source_identifier")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="buildStatusConfig")
    def build_status_config(self) -> Optional['outputs.ProjectSecondarySourceBuildStatusConfig']:
        """
        Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
        """
        return pulumi.get(self, "build_status_config")

    @property
    @pulumi.getter
    def buildspec(self) -> Optional[str]:
        """
        The build spec declaration to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. It can either be a path to a file residing in the repository to be built or a local file path leveraging the `file()` built-in.
        """
        return pulumi.get(self, "buildspec")

    @property
    @pulumi.getter(name="gitCloneDepth")
    def git_clone_depth(self) -> Optional[int]:
        """
        Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        """
        return pulumi.get(self, "git_clone_depth")

    @property
    @pulumi.getter(name="gitSubmodulesConfig")
    def git_submodules_config(self) -> Optional['outputs.ProjectSecondarySourceGitSubmodulesConfig']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "git_submodules_config")

    @property
    @pulumi.getter(name="insecureSsl")
    def insecure_ssl(self) -> Optional[bool]:
        """
        Ignore SSL warnings when connecting to source control.
        """
        return pulumi.get(self, "insecure_ssl")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="reportBuildStatus")
    def report_build_status(self) -> Optional[bool]:
        """
        Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
        """
        return pulumi.get(self, "report_build_status")


@pulumi.output_type
class ProjectSecondarySourceBuildStatusConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUrl":
            suggest = "target_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSecondarySourceBuildStatusConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSecondarySourceBuildStatusConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSecondarySourceBuildStatusConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: Optional[str] = None,
                 target_url: Optional[str] = None):
        """
        :param str context: Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        :param str target_url: Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        if context is not None:
            pulumi.set(__self__, "context", context)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[str]:
        """
        Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "target_url")


@pulumi.output_type
class ProjectSecondarySourceGitSubmodulesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fetchSubmodules":
            suggest = "fetch_submodules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSecondarySourceGitSubmodulesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSecondarySourceGitSubmodulesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSecondarySourceGitSubmodulesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fetch_submodules: bool):
        """
        :param bool fetch_submodules: Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        pulumi.set(__self__, "fetch_submodules", fetch_submodules)

    @property
    @pulumi.getter(name="fetchSubmodules")
    def fetch_submodules(self) -> bool:
        """
        Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        return pulumi.get(self, "fetch_submodules")


@pulumi.output_type
class ProjectSecondarySourceVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceIdentifier":
            suggest = "source_identifier"
        elif key == "sourceVersion":
            suggest = "source_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSecondarySourceVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSecondarySourceVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSecondarySourceVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_identifier: str,
                 source_version: str):
        """
        :param str source_identifier: An identifier for a source in the build project.
        :param str source_version: The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        """
        pulumi.set(__self__, "source_identifier", source_identifier)
        pulumi.set(__self__, "source_version", source_version)

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> str:
        """
        An identifier for a source in the build project.
        """
        return pulumi.get(self, "source_identifier")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> str:
        """
        The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
        """
        return pulumi.get(self, "source_version")


@pulumi.output_type
class ProjectSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildStatusConfig":
            suggest = "build_status_config"
        elif key == "gitCloneDepth":
            suggest = "git_clone_depth"
        elif key == "gitSubmodulesConfig":
            suggest = "git_submodules_config"
        elif key == "insecureSsl":
            suggest = "insecure_ssl"
        elif key == "reportBuildStatus":
            suggest = "report_build_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 build_status_config: Optional['outputs.ProjectSourceBuildStatusConfig'] = None,
                 buildspec: Optional[str] = None,
                 git_clone_depth: Optional[int] = None,
                 git_submodules_config: Optional['outputs.ProjectSourceGitSubmodulesConfig'] = None,
                 insecure_ssl: Optional[bool] = None,
                 location: Optional[str] = None,
                 report_build_status: Optional[bool] = None):
        """
        :param str type: Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
        :param 'ProjectSourceBuildStatusConfigArgs' build_status_config: Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
        :param str buildspec: Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. Also, if a non-default buildspec file name or file path aside from the root is used, it must be specified.
        :param int git_clone_depth: Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        :param 'ProjectSourceGitSubmodulesConfigArgs' git_submodules_config: Configuration block. Detailed below.
        :param bool insecure_ssl: Ignore SSL warnings when connecting to source control.
        :param str location: Location of the source code from git or s3.
        :param bool report_build_status: Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
        """
        pulumi.set(__self__, "type", type)
        if build_status_config is not None:
            pulumi.set(__self__, "build_status_config", build_status_config)
        if buildspec is not None:
            pulumi.set(__self__, "buildspec", buildspec)
        if git_clone_depth is not None:
            pulumi.set(__self__, "git_clone_depth", git_clone_depth)
        if git_submodules_config is not None:
            pulumi.set(__self__, "git_submodules_config", git_submodules_config)
        if insecure_ssl is not None:
            pulumi.set(__self__, "insecure_ssl", insecure_ssl)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if report_build_status is not None:
            pulumi.set(__self__, "report_build_status", report_build_status)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of repository that contains the source code to be built. Valid values: `BITBUCKET`, `CODECOMMIT`, `CODEPIPELINE`, `GITHUB`, `GITHUB_ENTERPRISE`, `GITLAB`, `GITLAB_SELF_MANAGED`, `NO_SOURCE`, `S3`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="buildStatusConfig")
    def build_status_config(self) -> Optional['outputs.ProjectSourceBuildStatusConfig']:
        """
        Configuration block that contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket. `build_status_config` blocks are documented below.
        """
        return pulumi.get(self, "build_status_config")

    @property
    @pulumi.getter
    def buildspec(self) -> Optional[str]:
        """
        Build specification to use for this build project's related builds. This must be set when `type` is `NO_SOURCE`. Also, if a non-default buildspec file name or file path aside from the root is used, it must be specified.
        """
        return pulumi.get(self, "buildspec")

    @property
    @pulumi.getter(name="gitCloneDepth")
    def git_clone_depth(self) -> Optional[int]:
        """
        Truncate git history to this many commits. Use `0` for a `Full` checkout which you need to run commands like `git branch --show-current`. See [AWS CodePipeline User Guide: Tutorial: Use full clone with a GitHub pipeline source](https://docs.aws.amazon.com/codepipeline/latest/userguide/tutorials-github-gitclone.html) for details.
        """
        return pulumi.get(self, "git_clone_depth")

    @property
    @pulumi.getter(name="gitSubmodulesConfig")
    def git_submodules_config(self) -> Optional['outputs.ProjectSourceGitSubmodulesConfig']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "git_submodules_config")

    @property
    @pulumi.getter(name="insecureSsl")
    def insecure_ssl(self) -> Optional[bool]:
        """
        Ignore SSL warnings when connecting to source control.
        """
        return pulumi.get(self, "insecure_ssl")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location of the source code from git or s3.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="reportBuildStatus")
    def report_build_status(self) -> Optional[bool]:
        """
        Whether to report the status of a build's start and finish to your source provider. This option is valid only when your source provider is GitHub, GitHub Enterprise, GitLab, GitLab Self Managed, or Bitbucket.
        """
        return pulumi.get(self, "report_build_status")


@pulumi.output_type
class ProjectSourceBuildStatusConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUrl":
            suggest = "target_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSourceBuildStatusConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSourceBuildStatusConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSourceBuildStatusConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: Optional[str] = None,
                 target_url: Optional[str] = None):
        """
        :param str context: Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        :param str target_url: Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        if context is not None:
            pulumi.set(__self__, "context", context)
        if target_url is not None:
            pulumi.set(__self__, "target_url", target_url)

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Specifies the context of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="targetUrl")
    def target_url(self) -> Optional[str]:
        """
        Specifies the target url of the build status CodeBuild sends to the source provider. The usage of this parameter depends on the source provider.
        """
        return pulumi.get(self, "target_url")


@pulumi.output_type
class ProjectSourceGitSubmodulesConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fetchSubmodules":
            suggest = "fetch_submodules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSourceGitSubmodulesConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSourceGitSubmodulesConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSourceGitSubmodulesConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fetch_submodules: bool):
        """
        :param bool fetch_submodules: Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        pulumi.set(__self__, "fetch_submodules", fetch_submodules)

    @property
    @pulumi.getter(name="fetchSubmodules")
    def fetch_submodules(self) -> bool:
        """
        Whether to fetch Git submodules for the AWS CodeBuild build project.
        """
        return pulumi.get(self, "fetch_submodules")


@pulumi.output_type
class ProjectVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str],
                 vpc_id: str):
        """
        :param Sequence[str] security_group_ids: Security group IDs to assign to running builds.
        :param Sequence[str] subnets: Subnet IDs within which to run builds.
        :param str vpc_id: ID of the VPC within which to run builds.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        Security group IDs to assign to running builds.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        Subnet IDs within which to run builds.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC within which to run builds.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class ReportGroupExportConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Destination":
            suggest = "s3_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportGroupExportConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportGroupExportConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportGroupExportConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 s3_destination: Optional['outputs.ReportGroupExportConfigS3Destination'] = None):
        """
        :param str type: The export configuration type. Valid values are `S3` and `NO_EXPORT`.
        :param 'ReportGroupExportConfigS3DestinationArgs' s3_destination: contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
        """
        pulumi.set(__self__, "type", type)
        if s3_destination is not None:
            pulumi.set(__self__, "s3_destination", s3_destination)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The export configuration type. Valid values are `S3` and `NO_EXPORT`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="s3Destination")
    def s3_destination(self) -> Optional['outputs.ReportGroupExportConfigS3Destination']:
        """
        contains information about the S3 bucket where the run of a report is exported. see S3 Destination documented below.
        """
        return pulumi.get(self, "s3_destination")


@pulumi.output_type
class ReportGroupExportConfigS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "encryptionDisabled":
            suggest = "encryption_disabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReportGroupExportConfigS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReportGroupExportConfigS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReportGroupExportConfigS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 encryption_key: str,
                 encryption_disabled: Optional[bool] = None,
                 packaging: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str bucket: The name of the S3 bucket where the raw data of a report are exported.
        :param str encryption_key: The encryption key for the report's encrypted raw data. The KMS key ARN.
        :param bool encryption_disabled: A boolean value that specifies if the results of a report are encrypted.
               **Note: the API does not currently allow setting encryption as disabled**
        :param str packaging: The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
        :param str path: The path to the exported report's raw data results.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_disabled is not None:
            pulumi.set(__self__, "encryption_disabled", encryption_disabled)
        if packaging is not None:
            pulumi.set(__self__, "packaging", packaging)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the S3 bucket where the raw data of a report are exported.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> str:
        """
        The encryption key for the report's encrypted raw data. The KMS key ARN.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="encryptionDisabled")
    def encryption_disabled(self) -> Optional[bool]:
        """
        A boolean value that specifies if the results of a report are encrypted.
        **Note: the API does not currently allow setting encryption as disabled**
        """
        return pulumi.get(self, "encryption_disabled")

    @property
    @pulumi.getter
    def packaging(self) -> Optional[str]:
        """
        The type of build output artifact to create. Valid values are: `NONE` (default) and `ZIP`.
        """
        return pulumi.get(self, "packaging")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the exported report's raw data results.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WebhookFilterGroup(dict):
    def __init__(__self__, *,
                 filters: Optional[Sequence['outputs.WebhookFilterGroupFilter']] = None):
        """
        :param Sequence['WebhookFilterGroupFilterArgs'] filters: A webhook filter for the group. Filter blocks are documented below.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.WebhookFilterGroupFilter']]:
        """
        A webhook filter for the group. Filter blocks are documented below.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class WebhookFilterGroupFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeMatchedPattern":
            suggest = "exclude_matched_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookFilterGroupFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookFilterGroupFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookFilterGroupFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pattern: str,
                 type: str,
                 exclude_matched_pattern: Optional[bool] = None):
        """
        :param str pattern: For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED`, `WORKFLOW_JOB_QUEUED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
        :param str type: The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`, `WORKFLOW_NAME`, `TAG_NAME`, `RELEASE_NAME`. At least one filter group must specify `EVENT` as its type.
        :param bool exclude_matched_pattern: If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
        """
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "type", type)
        if exclude_matched_pattern is not None:
            pulumi.set(__self__, "exclude_matched_pattern", exclude_matched_pattern)

    @property
    @pulumi.getter
    def pattern(self) -> str:
        """
        For a filter that uses `EVENT` type, a comma-separated string that specifies one event: `PUSH`, `PULL_REQUEST_CREATED`, `PULL_REQUEST_UPDATED`, `PULL_REQUEST_REOPENED`. `PULL_REQUEST_MERGED`, `WORKFLOW_JOB_QUEUED` works with GitHub & GitHub Enterprise only. For a filter that uses any of the other filter types, a regular expression.
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The webhook filter group's type. Valid values for this parameter are: `EVENT`, `BASE_REF`, `HEAD_REF`, `ACTOR_ACCOUNT_ID`, `FILE_PATH`, `COMMIT_MESSAGE`, `WORKFLOW_NAME`, `TAG_NAME`, `RELEASE_NAME`. At least one filter group must specify `EVENT` as its type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="excludeMatchedPattern")
    def exclude_matched_pattern(self) -> Optional[bool]:
        """
        If set to `true`, the specified filter does *not* trigger a build. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_matched_pattern")


@pulumi.output_type
class WebhookScopeConfiguration(dict):
    def __init__(__self__, *,
                 name: str,
                 scope: str,
                 domain: Optional[str] = None):
        """
        :param str name: The name of either the enterprise or organization.
        :param str scope: The type of scope for a GitHub webhook. Valid values for this parameter are: `GITHUB_ORGANIZATION`, `GITHUB_GLOBAL`.
        :param str domain: The domain of the GitHub Enterprise organization. Required if your project's source type is GITHUB_ENTERPRISE.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scope", scope)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of either the enterprise or organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The type of scope for a GitHub webhook. Valid values for this parameter are: `GITHUB_ORGANIZATION`, `GITHUB_GLOBAL`.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the GitHub Enterprise organization. Required if your project's source type is GITHUB_ENTERPRISE.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetFleetScalingConfigurationResult(dict):
    def __init__(__self__, *,
                 desired_capacity: int,
                 max_capacity: int,
                 scaling_type: str,
                 target_tracking_scaling_configs: Sequence['outputs.GetFleetScalingConfigurationTargetTrackingScalingConfigResult']):
        """
        :param int desired_capacity: The desired number of instances in the ﬂeet when auto-scaling.
        :param int max_capacity: The maximum number of instances in the ﬂeet when auto-scaling.
        :param str scaling_type: The scaling type for a compute fleet.
        :param Sequence['GetFleetScalingConfigurationTargetTrackingScalingConfigArgs'] target_tracking_scaling_configs: Nested attribute containing information about thresholds when new instance is auto-scaled into the compute fleet.
        """
        pulumi.set(__self__, "desired_capacity", desired_capacity)
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "scaling_type", scaling_type)
        pulumi.set(__self__, "target_tracking_scaling_configs", target_tracking_scaling_configs)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> int:
        """
        The desired number of instances in the ﬂeet when auto-scaling.
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> int:
        """
        The maximum number of instances in the ﬂeet when auto-scaling.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="scalingType")
    def scaling_type(self) -> str:
        """
        The scaling type for a compute fleet.
        """
        return pulumi.get(self, "scaling_type")

    @property
    @pulumi.getter(name="targetTrackingScalingConfigs")
    def target_tracking_scaling_configs(self) -> Sequence['outputs.GetFleetScalingConfigurationTargetTrackingScalingConfigResult']:
        """
        Nested attribute containing information about thresholds when new instance is auto-scaled into the compute fleet.
        """
        return pulumi.get(self, "target_tracking_scaling_configs")


@pulumi.output_type
class GetFleetScalingConfigurationTargetTrackingScalingConfigResult(dict):
    def __init__(__self__, *,
                 metric_type: str,
                 target_value: float):
        """
        :param str metric_type: The metric type to determine auto-scaling.
        :param float target_value: The value of metric_type when to start scaling.
        """
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> str:
        """
        The metric type to determine auto-scaling.
        """
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        The value of metric_type when to start scaling.
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class GetFleetStatusResult(dict):
    def __init__(__self__, *,
                 context: str,
                 message: str,
                 status_code: str):
        """
        :param str context: Additional information about a compute fleet.
        :param str message: Message associated with the status of a compute fleet.
        :param str status_code: Status code of the compute fleet.
        """
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def context(self) -> str:
        """
        Additional information about a compute fleet.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Message associated with the status of a compute fleet.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> str:
        """
        Status code of the compute fleet.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetFleetVpcConfigResult(dict):
    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str],
                 vpc_id: str):
        """
        :param Sequence[str] security_group_ids: A list of one or more security groups IDs in your Amazon VPC.
        :param Sequence[str] subnets: A list of one or more subnet IDs in your Amazon VPC.
        :param str vpc_id: The ID of the Amazon VPC.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        A list of one or more security groups IDs in your Amazon VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        A list of one or more subnet IDs in your Amazon VPC.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the Amazon VPC.
        """
        return pulumi.get(self, "vpc_id")


