# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerArgs', 'Trigger']

@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 repository_name: pulumi.Input[str],
                 triggers: pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]]):
        """
        The set of arguments for constructing a Trigger resource.
        :param pulumi.Input[str] repository_name: The name for the repository. This needs to be less than 100 characters.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]] triggers: The name of the trigger.
        """
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Input[str]:
        """
        The name for the repository. This needs to be less than 100 characters.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class _TriggerState:
    def __init__(__self__, *,
                 configuration_id: Optional[pulumi.Input[str]] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]]] = None):
        """
        Input properties used for looking up and filtering Trigger resources.
        :param pulumi.Input[str] configuration_id: System-generated unique identifier.
        :param pulumi.Input[str] repository_name: The name for the repository. This needs to be less than 100 characters.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]] triggers: The name of the trigger.
        """
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        System-generated unique identifier.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_id", value)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the repository. This needs to be less than 100 characters.
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_name", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]]]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)


class Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerTriggerArgs', 'TriggerTriggerArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a CodeCommit Trigger Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codecommit.Repository("test", repository_name="test")
        test_trigger = aws.codecommit.Trigger("test",
            repository_name=test.repository_name,
            triggers=[{
                "name": "all",
                "events": ["all"],
                "destination_arn": test_aws_sns_topic["arn"],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] repository_name: The name for the repository. This needs to be less than 100 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerTriggerArgs', 'TriggerTriggerArgsDict']]]] triggers: The name of the trigger.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodeCommit Trigger Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codecommit.Repository("test", repository_name="test")
        test_trigger = aws.codecommit.Trigger("test",
            repository_name=test.repository_name,
            triggers=[{
                "name": "all",
                "events": ["all"],
                "destination_arn": test_aws_sns_topic["arn"],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 repository_name: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerTriggerArgs', 'TriggerTriggerArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerArgs.__new__(TriggerArgs)

            if repository_name is None and not opts.urn:
                raise TypeError("Missing required property 'repository_name'")
            __props__.__dict__["repository_name"] = repository_name
            if triggers is None and not opts.urn:
                raise TypeError("Missing required property 'triggers'")
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["configuration_id"] = None
        super(Trigger, __self__).__init__(
            'aws:codecommit/trigger:Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_id: Optional[pulumi.Input[str]] = None,
            repository_name: Optional[pulumi.Input[str]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerTriggerArgs', 'TriggerTriggerArgsDict']]]]] = None) -> 'Trigger':
        """
        Get an existing Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] configuration_id: System-generated unique identifier.
        :param pulumi.Input[str] repository_name: The name for the repository. This needs to be less than 100 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerTriggerArgs', 'TriggerTriggerArgsDict']]]] triggers: The name of the trigger.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerState.__new__(_TriggerState)

        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["repository_name"] = repository_name
        __props__.__dict__["triggers"] = triggers
        return Trigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[str]:
        """
        System-generated unique identifier.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Output[str]:
        """
        The name for the repository. This needs to be less than 100 characters.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Sequence['outputs.TriggerTrigger']]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "triggers")

