# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserPoolResult',
    'AwaitableGetUserPoolResult',
    'get_user_pool',
    'get_user_pool_output',
]

@pulumi.output_type
class GetUserPoolResult:
    """
    A collection of values returned by getUserPool.
    """
    def __init__(__self__, account_recovery_settings=None, admin_create_user_configs=None, arn=None, auto_verified_attributes=None, creation_date=None, custom_domain=None, deletion_protection=None, device_configurations=None, domain=None, email_configurations=None, estimated_number_of_users=None, id=None, lambda_configs=None, last_modified_date=None, mfa_configuration=None, name=None, schema_attributes=None, sms_authentication_message=None, sms_configuration_failure=None, sms_verification_message=None, tags=None, user_pool_id=None, user_pool_tags=None, username_attributes=None):
        if account_recovery_settings and not isinstance(account_recovery_settings, list):
            raise TypeError("Expected argument 'account_recovery_settings' to be a list")
        pulumi.set(__self__, "account_recovery_settings", account_recovery_settings)
        if admin_create_user_configs and not isinstance(admin_create_user_configs, list):
            raise TypeError("Expected argument 'admin_create_user_configs' to be a list")
        pulumi.set(__self__, "admin_create_user_configs", admin_create_user_configs)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_verified_attributes and not isinstance(auto_verified_attributes, list):
            raise TypeError("Expected argument 'auto_verified_attributes' to be a list")
        pulumi.set(__self__, "auto_verified_attributes", auto_verified_attributes)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if custom_domain and not isinstance(custom_domain, str):
            raise TypeError("Expected argument 'custom_domain' to be a str")
        pulumi.set(__self__, "custom_domain", custom_domain)
        if deletion_protection and not isinstance(deletion_protection, str):
            raise TypeError("Expected argument 'deletion_protection' to be a str")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if device_configurations and not isinstance(device_configurations, list):
            raise TypeError("Expected argument 'device_configurations' to be a list")
        pulumi.set(__self__, "device_configurations", device_configurations)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if email_configurations and not isinstance(email_configurations, list):
            raise TypeError("Expected argument 'email_configurations' to be a list")
        pulumi.set(__self__, "email_configurations", email_configurations)
        if estimated_number_of_users and not isinstance(estimated_number_of_users, int):
            raise TypeError("Expected argument 'estimated_number_of_users' to be a int")
        pulumi.set(__self__, "estimated_number_of_users", estimated_number_of_users)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lambda_configs and not isinstance(lambda_configs, list):
            raise TypeError("Expected argument 'lambda_configs' to be a list")
        pulumi.set(__self__, "lambda_configs", lambda_configs)
        if last_modified_date and not isinstance(last_modified_date, str):
            raise TypeError("Expected argument 'last_modified_date' to be a str")
        pulumi.set(__self__, "last_modified_date", last_modified_date)
        if mfa_configuration and not isinstance(mfa_configuration, str):
            raise TypeError("Expected argument 'mfa_configuration' to be a str")
        pulumi.set(__self__, "mfa_configuration", mfa_configuration)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schema_attributes and not isinstance(schema_attributes, list):
            raise TypeError("Expected argument 'schema_attributes' to be a list")
        pulumi.set(__self__, "schema_attributes", schema_attributes)
        if sms_authentication_message and not isinstance(sms_authentication_message, str):
            raise TypeError("Expected argument 'sms_authentication_message' to be a str")
        pulumi.set(__self__, "sms_authentication_message", sms_authentication_message)
        if sms_configuration_failure and not isinstance(sms_configuration_failure, str):
            raise TypeError("Expected argument 'sms_configuration_failure' to be a str")
        pulumi.set(__self__, "sms_configuration_failure", sms_configuration_failure)
        if sms_verification_message and not isinstance(sms_verification_message, str):
            raise TypeError("Expected argument 'sms_verification_message' to be a str")
        pulumi.set(__self__, "sms_verification_message", sms_verification_message)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_pool_id and not isinstance(user_pool_id, str):
            raise TypeError("Expected argument 'user_pool_id' to be a str")
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if user_pool_tags and not isinstance(user_pool_tags, dict):
            raise TypeError("Expected argument 'user_pool_tags' to be a dict")
        pulumi.set(__self__, "user_pool_tags", user_pool_tags)
        if username_attributes and not isinstance(username_attributes, list):
            raise TypeError("Expected argument 'username_attributes' to be a list")
        pulumi.set(__self__, "username_attributes", username_attributes)

    @property
    @pulumi.getter(name="accountRecoverySettings")
    def account_recovery_settings(self) -> Sequence['outputs.GetUserPoolAccountRecoverySettingResult']:
        return pulumi.get(self, "account_recovery_settings")

    @property
    @pulumi.getter(name="adminCreateUserConfigs")
    def admin_create_user_configs(self) -> Sequence['outputs.GetUserPoolAdminCreateUserConfigResult']:
        return pulumi.get(self, "admin_create_user_configs")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the User Pool.
        * account_recovery_setting - The available verified method a user can use to recover their password when they call ForgotPassword. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
        * admin_create_user_config - The configuration for AdminCreateUser requests.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoVerifiedAttributes")
    def auto_verified_attributes(self) -> Sequence[str]:
        """
        The attributes that are auto-verified in a user pool.
        """
        return pulumi.get(self, "auto_verified_attributes")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> str:
        """
        The date and time, in ISO 8601 format, when the item was created.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> str:
        """
        A custom domain name that you provide to Amazon Cognito. This parameter applies only if you use a custom domain to host the sign-up and sign-in pages for your application. An example of a custom domain name might be auth.example.com.
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> str:
        """
        When active, DeletionProtection prevents accidental deletion of your user pool. Before you can delete a user pool that you have protected against deletion, you must deactivate this feature.
        * device_configuration - The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="deviceConfigurations")
    def device_configurations(self) -> Sequence['outputs.GetUserPoolDeviceConfigurationResult']:
        return pulumi.get(self, "device_configurations")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain prefix, if the user pool has a domain associated with it.
        * email_configuration - The email configuration of your user pool. The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="emailConfigurations")
    def email_configurations(self) -> Sequence['outputs.GetUserPoolEmailConfigurationResult']:
        return pulumi.get(self, "email_configurations")

    @property
    @pulumi.getter(name="estimatedNumberOfUsers")
    def estimated_number_of_users(self) -> int:
        """
        A number estimating the size of the user pool.
        * lambda_config - The AWS Lambda triggers associated with the user pool.
        """
        return pulumi.get(self, "estimated_number_of_users")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lambdaConfigs")
    def lambda_configs(self) -> Sequence['outputs.GetUserPoolLambdaConfigResult']:
        return pulumi.get(self, "lambda_configs")

    @property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> str:
        """
        The date and time, in ISO 8601 format, when the item was modified.
        """
        return pulumi.get(self, "last_modified_date")

    @property
    @pulumi.getter(name="mfaConfiguration")
    def mfa_configuration(self) -> str:
        """
        Can be one of the following values: `OFF` | `ON` | `OPTIONAL`
        """
        return pulumi.get(self, "mfa_configuration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        - Name of the attribute.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="schemaAttributes")
    def schema_attributes(self) -> Sequence['outputs.GetUserPoolSchemaAttributeResult']:
        return pulumi.get(self, "schema_attributes")

    @property
    @pulumi.getter(name="smsAuthenticationMessage")
    def sms_authentication_message(self) -> str:
        """
        The contents of the SMS authentication message.
        """
        return pulumi.get(self, "sms_authentication_message")

    @property
    @pulumi.getter(name="smsConfigurationFailure")
    def sms_configuration_failure(self) -> str:
        """
        The reason why the SMS configuration can't send the messages to your users.
        """
        return pulumi.get(self, "sms_configuration_failure")

    @property
    @pulumi.getter(name="smsVerificationMessage")
    def sms_verification_message(self) -> str:
        """
        The contents of the SMS authentication message.
        """
        return pulumi.get(self, "sms_verification_message")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Map of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> str:
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="userPoolTags")
    @_utilities.deprecated("""Use the attribute \"tags\" instead""")
    def user_pool_tags(self) -> Mapping[str, str]:
        """
        (Deprecated) Map of tags assigned to the resource.
        """
        return pulumi.get(self, "user_pool_tags")

    @property
    @pulumi.getter(name="usernameAttributes")
    def username_attributes(self) -> Sequence[str]:
        """
        Specifies whether a user can use an email address or phone number as a username when they sign up.
        """
        return pulumi.get(self, "username_attributes")


class AwaitableGetUserPoolResult(GetUserPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserPoolResult(
            account_recovery_settings=self.account_recovery_settings,
            admin_create_user_configs=self.admin_create_user_configs,
            arn=self.arn,
            auto_verified_attributes=self.auto_verified_attributes,
            creation_date=self.creation_date,
            custom_domain=self.custom_domain,
            deletion_protection=self.deletion_protection,
            device_configurations=self.device_configurations,
            domain=self.domain,
            email_configurations=self.email_configurations,
            estimated_number_of_users=self.estimated_number_of_users,
            id=self.id,
            lambda_configs=self.lambda_configs,
            last_modified_date=self.last_modified_date,
            mfa_configuration=self.mfa_configuration,
            name=self.name,
            schema_attributes=self.schema_attributes,
            sms_authentication_message=self.sms_authentication_message,
            sms_configuration_failure=self.sms_configuration_failure,
            sms_verification_message=self.sms_verification_message,
            tags=self.tags,
            user_pool_id=self.user_pool_id,
            user_pool_tags=self.user_pool_tags,
            username_attributes=self.username_attributes)


def get_user_pool(user_pool_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserPoolResult:
    """
    Data source for managing an AWS Cognito User Pool.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cognito.get_user_pool(user_pool_id="us-west-2_aaaaaaaaa")
    ```


    :param str user_pool_id: The cognito pool ID
    """
    __args__ = dict()
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cognito/getUserPool:getUserPool', __args__, opts=opts, typ=GetUserPoolResult).value

    return AwaitableGetUserPoolResult(
        account_recovery_settings=pulumi.get(__ret__, 'account_recovery_settings'),
        admin_create_user_configs=pulumi.get(__ret__, 'admin_create_user_configs'),
        arn=pulumi.get(__ret__, 'arn'),
        auto_verified_attributes=pulumi.get(__ret__, 'auto_verified_attributes'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        custom_domain=pulumi.get(__ret__, 'custom_domain'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        device_configurations=pulumi.get(__ret__, 'device_configurations'),
        domain=pulumi.get(__ret__, 'domain'),
        email_configurations=pulumi.get(__ret__, 'email_configurations'),
        estimated_number_of_users=pulumi.get(__ret__, 'estimated_number_of_users'),
        id=pulumi.get(__ret__, 'id'),
        lambda_configs=pulumi.get(__ret__, 'lambda_configs'),
        last_modified_date=pulumi.get(__ret__, 'last_modified_date'),
        mfa_configuration=pulumi.get(__ret__, 'mfa_configuration'),
        name=pulumi.get(__ret__, 'name'),
        schema_attributes=pulumi.get(__ret__, 'schema_attributes'),
        sms_authentication_message=pulumi.get(__ret__, 'sms_authentication_message'),
        sms_configuration_failure=pulumi.get(__ret__, 'sms_configuration_failure'),
        sms_verification_message=pulumi.get(__ret__, 'sms_verification_message'),
        tags=pulumi.get(__ret__, 'tags'),
        user_pool_id=pulumi.get(__ret__, 'user_pool_id'),
        user_pool_tags=pulumi.get(__ret__, 'user_pool_tags'),
        username_attributes=pulumi.get(__ret__, 'username_attributes'))
def get_user_pool_output(user_pool_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserPoolResult]:
    """
    Data source for managing an AWS Cognito User Pool.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cognito.get_user_pool(user_pool_id="us-west-2_aaaaaaaaa")
    ```


    :param str user_pool_id: The cognito pool ID
    """
    __args__ = dict()
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cognito/getUserPool:getUserPool', __args__, opts=opts, typ=GetUserPoolResult)
    return __ret__.apply(lambda __response__: GetUserPoolResult(
        account_recovery_settings=pulumi.get(__response__, 'account_recovery_settings'),
        admin_create_user_configs=pulumi.get(__response__, 'admin_create_user_configs'),
        arn=pulumi.get(__response__, 'arn'),
        auto_verified_attributes=pulumi.get(__response__, 'auto_verified_attributes'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        custom_domain=pulumi.get(__response__, 'custom_domain'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        device_configurations=pulumi.get(__response__, 'device_configurations'),
        domain=pulumi.get(__response__, 'domain'),
        email_configurations=pulumi.get(__response__, 'email_configurations'),
        estimated_number_of_users=pulumi.get(__response__, 'estimated_number_of_users'),
        id=pulumi.get(__response__, 'id'),
        lambda_configs=pulumi.get(__response__, 'lambda_configs'),
        last_modified_date=pulumi.get(__response__, 'last_modified_date'),
        mfa_configuration=pulumi.get(__response__, 'mfa_configuration'),
        name=pulumi.get(__response__, 'name'),
        schema_attributes=pulumi.get(__response__, 'schema_attributes'),
        sms_authentication_message=pulumi.get(__response__, 'sms_authentication_message'),
        sms_configuration_failure=pulumi.get(__response__, 'sms_configuration_failure'),
        sms_verification_message=pulumi.get(__response__, 'sms_verification_message'),
        tags=pulumi.get(__response__, 'tags'),
        user_pool_id=pulumi.get(__response__, 'user_pool_id'),
        user_pool_tags=pulumi.get(__response__, 'user_pool_tags'),
        username_attributes=pulumi.get(__response__, 'username_attributes')))
