# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EntityRecognizerArgs', 'EntityRecognizer']

@pulumi.input_type
class EntityRecognizerArgs:
    def __init__(__self__, *,
                 data_access_role_arn: pulumi.Input[str],
                 input_data_config: pulumi.Input['EntityRecognizerInputDataConfigArgs'],
                 language_code: pulumi.Input[str],
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input['EntityRecognizerVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a EntityRecognizer resource.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input['EntityRecognizerInputDataConfigArgs'] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] model_kms_key_id: The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
        :param pulumi.Input[str] name: Name for the Entity Recognizer.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] version_name: Name for the version of the Entity Recognizer.
               Each version must have a unique name within the Entity Recognizer.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
        :param pulumi.Input['EntityRecognizerVpcConfigArgs'] vpc_config: Configuration parameters for VPC to contain Entity Recognizer resources.
               See the `vpc_config` Configuration Block section below.
        """
        pulumi.set(__self__, "data_access_role_arn", data_access_role_arn)
        pulumi.set(__self__, "input_data_config", input_data_config)
        pulumi.set(__self__, "language_code", language_code)
        if model_kms_key_id is not None:
            pulumi.set(__self__, "model_kms_key_id", model_kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)
        if version_name_prefix is not None:
            pulumi.set(__self__, "version_name_prefix", version_name_prefix)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @data_access_role_arn.setter
    def data_access_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_access_role_arn", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Input['EntityRecognizerInputDataConfigArgs']:
        """
        Configuration for the training and testing data.
        See the `input_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: pulumi.Input['EntityRecognizerInputDataConfigArgs']):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Input[str]:
        """
        Two-letter language code for the language.
        One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
        """
        return pulumi.get(self, "model_kms_key_id")

    @model_kms_key_id.setter
    def model_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Entity Recognizer.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the version of the Entity Recognizer.
        Each version must have a unique name within the Entity Recognizer.
        If omitted, the provider will assign a random, unique version name.
        If explicitly set to `""`, no version name will be set.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name_prefix`.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)

    @property
    @pulumi.getter(name="versionNamePrefix")
    def version_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique version name beginning with the specified prefix.
        Has a maximum length of 37 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name`.
        """
        return pulumi.get(self, "version_name_prefix")

    @version_name_prefix.setter
    def version_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name_prefix", value)

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @volume_kms_key_id.setter
    def volume_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_kms_key_id", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['EntityRecognizerVpcConfigArgs']]:
        """
        Configuration parameters for VPC to contain Entity Recognizer resources.
        See the `vpc_config` Configuration Block section below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['EntityRecognizerVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _EntityRecognizerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 data_access_role_arn: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input['EntityRecognizerInputDataConfigArgs']] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input['EntityRecognizerVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering EntityRecognizer resources.
        :param pulumi.Input[str] arn: ARN of the Entity Recognizer version.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input['EntityRecognizerInputDataConfigArgs'] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] model_kms_key_id: The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
        :param pulumi.Input[str] name: Name for the Entity Recognizer.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] version_name: Name for the version of the Entity Recognizer.
               Each version must have a unique name within the Entity Recognizer.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
        :param pulumi.Input['EntityRecognizerVpcConfigArgs'] vpc_config: Configuration parameters for VPC to contain Entity Recognizer resources.
               See the `vpc_config` Configuration Block section below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if data_access_role_arn is not None:
            pulumi.set(__self__, "data_access_role_arn", data_access_role_arn)
        if input_data_config is not None:
            pulumi.set(__self__, "input_data_config", input_data_config)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if model_kms_key_id is not None:
            pulumi.set(__self__, "model_kms_key_id", model_kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version_name is not None:
            pulumi.set(__self__, "version_name", version_name)
        if version_name_prefix is not None:
            pulumi.set(__self__, "version_name_prefix", version_name_prefix)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Entity Recognizer version.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @data_access_role_arn.setter
    def data_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_access_role_arn", value)

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> Optional[pulumi.Input['EntityRecognizerInputDataConfigArgs']]:
        """
        Configuration for the training and testing data.
        See the `input_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "input_data_config")

    @input_data_config.setter
    def input_data_config(self, value: Optional[pulumi.Input['EntityRecognizerInputDataConfigArgs']]):
        pulumi.set(self, "input_data_config", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        Two-letter language code for the language.
        One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
        """
        return pulumi.get(self, "model_kms_key_id")

    @model_kms_key_id.setter
    def model_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Entity Recognizer.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the version of the Entity Recognizer.
        Each version must have a unique name within the Entity Recognizer.
        If omitted, the provider will assign a random, unique version name.
        If explicitly set to `""`, no version name will be set.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name_prefix`.
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name", value)

    @property
    @pulumi.getter(name="versionNamePrefix")
    def version_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique version name beginning with the specified prefix.
        Has a maximum length of 37 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name`.
        """
        return pulumi.get(self, "version_name_prefix")

    @version_name_prefix.setter
    def version_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_name_prefix", value)

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @volume_kms_key_id.setter
    def volume_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_kms_key_id", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['EntityRecognizerVpcConfigArgs']]:
        """
        Configuration parameters for VPC to contain Entity Recognizer resources.
        See the `vpc_config` Configuration Block section below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['EntityRecognizerVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class EntityRecognizer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_role_arn: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input[Union['EntityRecognizerInputDataConfigArgs', 'EntityRecognizerInputDataConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input[Union['EntityRecognizerVpcConfigArgs', 'EntityRecognizerVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Comprehend Entity Recognizer.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        documents = aws.s3.BucketObjectv2("documents")
        entities = aws.s3.BucketObjectv2("entities")
        example = aws.comprehend.EntityRecognizer("example",
            name="example",
            data_access_role_arn=example_aws_iam_role["arn"],
            language_code="en",
            input_data_config={
                "entity_types": [
                    {
                        "type": "ENTITY_1",
                    },
                    {
                        "type": "ENTITY_2",
                    },
                ],
                "documents": {
                    "s3_uri": documents.id.apply(lambda id: f"s3://{documents_aws_s3_bucket['bucket']}/{id}"),
                },
                "entity_list": {
                    "s3_uri": entities.id.apply(lambda id: f"s3://{entities_aws_s3_bucket['bucket']}/{id}"),
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy]))
        ```

        ## Import

        Using `pulumi import`, import Comprehend Entity Recognizer using the ARN. For example:

        ```sh
        $ pulumi import aws:comprehend/entityRecognizer:EntityRecognizer example arn:aws:comprehend:us-west-2:123456789012:entity-recognizer/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input[Union['EntityRecognizerInputDataConfigArgs', 'EntityRecognizerInputDataConfigArgsDict']] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] model_kms_key_id: The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
        :param pulumi.Input[str] name: Name for the Entity Recognizer.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] version_name: Name for the version of the Entity Recognizer.
               Each version must have a unique name within the Entity Recognizer.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
        :param pulumi.Input[Union['EntityRecognizerVpcConfigArgs', 'EntityRecognizerVpcConfigArgsDict']] vpc_config: Configuration parameters for VPC to contain Entity Recognizer resources.
               See the `vpc_config` Configuration Block section below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EntityRecognizerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Comprehend Entity Recognizer.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        documents = aws.s3.BucketObjectv2("documents")
        entities = aws.s3.BucketObjectv2("entities")
        example = aws.comprehend.EntityRecognizer("example",
            name="example",
            data_access_role_arn=example_aws_iam_role["arn"],
            language_code="en",
            input_data_config={
                "entity_types": [
                    {
                        "type": "ENTITY_1",
                    },
                    {
                        "type": "ENTITY_2",
                    },
                ],
                "documents": {
                    "s3_uri": documents.id.apply(lambda id: f"s3://{documents_aws_s3_bucket['bucket']}/{id}"),
                },
                "entity_list": {
                    "s3_uri": entities.id.apply(lambda id: f"s3://{entities_aws_s3_bucket['bucket']}/{id}"),
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy]))
        ```

        ## Import

        Using `pulumi import`, import Comprehend Entity Recognizer using the ARN. For example:

        ```sh
        $ pulumi import aws:comprehend/entityRecognizer:EntityRecognizer example arn:aws:comprehend:us-west-2:123456789012:entity-recognizer/example
        ```

        :param str resource_name: The name of the resource.
        :param EntityRecognizerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntityRecognizerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_role_arn: Optional[pulumi.Input[str]] = None,
                 input_data_config: Optional[pulumi.Input[Union['EntityRecognizerInputDataConfigArgs', 'EntityRecognizerInputDataConfigArgsDict']]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version_name: Optional[pulumi.Input[str]] = None,
                 version_name_prefix: Optional[pulumi.Input[str]] = None,
                 volume_kms_key_id: Optional[pulumi.Input[str]] = None,
                 vpc_config: Optional[pulumi.Input[Union['EntityRecognizerVpcConfigArgs', 'EntityRecognizerVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntityRecognizerArgs.__new__(EntityRecognizerArgs)

            if data_access_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'data_access_role_arn'")
            __props__.__dict__["data_access_role_arn"] = data_access_role_arn
            if input_data_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_data_config'")
            __props__.__dict__["input_data_config"] = input_data_config
            if language_code is None and not opts.urn:
                raise TypeError("Missing required property 'language_code'")
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["model_kms_key_id"] = model_kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version_name"] = version_name
            __props__.__dict__["version_name_prefix"] = version_name_prefix
            __props__.__dict__["volume_kms_key_id"] = volume_kms_key_id
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(EntityRecognizer, __self__).__init__(
            'aws:comprehend/entityRecognizer:EntityRecognizer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            data_access_role_arn: Optional[pulumi.Input[str]] = None,
            input_data_config: Optional[pulumi.Input[Union['EntityRecognizerInputDataConfigArgs', 'EntityRecognizerInputDataConfigArgsDict']]] = None,
            language_code: Optional[pulumi.Input[str]] = None,
            model_kms_key_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            version_name: Optional[pulumi.Input[str]] = None,
            version_name_prefix: Optional[pulumi.Input[str]] = None,
            volume_kms_key_id: Optional[pulumi.Input[str]] = None,
            vpc_config: Optional[pulumi.Input[Union['EntityRecognizerVpcConfigArgs', 'EntityRecognizerVpcConfigArgsDict']]] = None) -> 'EntityRecognizer':
        """
        Get an existing EntityRecognizer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Entity Recognizer version.
        :param pulumi.Input[str] data_access_role_arn: The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        :param pulumi.Input[Union['EntityRecognizerInputDataConfigArgs', 'EntityRecognizerInputDataConfigArgsDict']] input_data_config: Configuration for the training and testing data.
               See the `input_data_config` Configuration Block section below.
        :param pulumi.Input[str] language_code: Two-letter language code for the language.
               One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        :param pulumi.Input[str] model_kms_key_id: The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
        :param pulumi.Input[str] name: Name for the Entity Recognizer.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] version_name: Name for the version of the Entity Recognizer.
               Each version must have a unique name within the Entity Recognizer.
               If omitted, the provider will assign a random, unique version name.
               If explicitly set to `""`, no version name will be set.
               Has a maximum length of 63 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name_prefix`.
        :param pulumi.Input[str] version_name_prefix: Creates a unique version name beginning with the specified prefix.
               Has a maximum length of 37 characters.
               Can contain upper- and lower-case letters, numbers, and hypen (`-`).
               Conflicts with `version_name`.
        :param pulumi.Input[str] volume_kms_key_id: ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
        :param pulumi.Input[Union['EntityRecognizerVpcConfigArgs', 'EntityRecognizerVpcConfigArgsDict']] vpc_config: Configuration parameters for VPC to contain Entity Recognizer resources.
               See the `vpc_config` Configuration Block section below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntityRecognizerState.__new__(_EntityRecognizerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["data_access_role_arn"] = data_access_role_arn
        __props__.__dict__["input_data_config"] = input_data_config
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["model_kms_key_id"] = model_kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version_name"] = version_name
        __props__.__dict__["version_name_prefix"] = version_name_prefix
        __props__.__dict__["volume_kms_key_id"] = volume_kms_key_id
        __props__.__dict__["vpc_config"] = vpc_config
        return EntityRecognizer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Entity Recognizer version.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataAccessRoleArn")
    def data_access_role_arn(self) -> pulumi.Output[str]:
        """
        The ARN for an IAM Role which allows Comprehend to read the training and testing data.
        """
        return pulumi.get(self, "data_access_role_arn")

    @property
    @pulumi.getter(name="inputDataConfig")
    def input_data_config(self) -> pulumi.Output['outputs.EntityRecognizerInputDataConfig']:
        """
        Configuration for the training and testing data.
        See the `input_data_config` Configuration Block section below.
        """
        return pulumi.get(self, "input_data_config")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[str]:
        """
        Two-letter language code for the language.
        One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
        """
        return pulumi.get(self, "model_kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for the Entity Recognizer.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Output[str]:
        """
        Name for the version of the Entity Recognizer.
        Each version must have a unique name within the Entity Recognizer.
        If omitted, the provider will assign a random, unique version name.
        If explicitly set to `""`, no version name will be set.
        Has a maximum length of 63 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name_prefix`.
        """
        return pulumi.get(self, "version_name")

    @property
    @pulumi.getter(name="versionNamePrefix")
    def version_name_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique version name beginning with the specified prefix.
        Has a maximum length of 37 characters.
        Can contain upper- and lower-case letters, numbers, and hypen (`-`).
        Conflicts with `version_name`.
        """
        return pulumi.get(self, "version_name_prefix")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.EntityRecognizerVpcConfig']]:
        """
        Configuration parameters for VPC to contain Entity Recognizer resources.
        See the `vpc_config` Configuration Block section below.
        """
        return pulumi.get(self, "vpc_config")

