# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnrollmentStatusArgs', 'EnrollmentStatus']

@pulumi.input_type
class EnrollmentStatusArgs:
    def __init__(__self__, *,
                 include_member_accounts: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a EnrollmentStatus resource.
        :param pulumi.Input[bool] include_member_accounts: Flag to enroll member accounts of the organization if the account is the management account. No drift detection is currently supported for this argument. Default value is `false`.
        """
        if include_member_accounts is not None:
            pulumi.set(__self__, "include_member_accounts", include_member_accounts)

    @property
    @pulumi.getter(name="includeMemberAccounts")
    def include_member_accounts(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enroll member accounts of the organization if the account is the management account. No drift detection is currently supported for this argument. Default value is `false`.
        """
        return pulumi.get(self, "include_member_accounts")

    @include_member_accounts.setter
    def include_member_accounts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_member_accounts", value)


@pulumi.input_type
class _EnrollmentStatusState:
    def __init__(__self__, *,
                 include_member_accounts: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EnrollmentStatus resources.
        :param pulumi.Input[bool] include_member_accounts: Flag to enroll member accounts of the organization if the account is the management account. No drift detection is currently supported for this argument. Default value is `false`.
        """
        if include_member_accounts is not None:
            pulumi.set(__self__, "include_member_accounts", include_member_accounts)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="includeMemberAccounts")
    def include_member_accounts(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to enroll member accounts of the organization if the account is the management account. No drift detection is currently supported for this argument. Default value is `false`.
        """
        return pulumi.get(self, "include_member_accounts")

    @include_member_accounts.setter
    def include_member_accounts(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_member_accounts", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class EnrollmentStatus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_member_accounts: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource for managing AWS Cost Optimization Hub Enrollment Status.

        > **TIP:** The Cost Optimization Hub only has a `us-east-1` endpoint. However, you can access the service globally with the AWS Provider from other regions. Other tools, such as the [AWS CLI](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cost-optimization-hub/index.html), may require you to specify the `us-east-1` region when using the service.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.costoptimizationhub.EnrollmentStatus("example")
        ```

        ### Usage with all the arguments

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.costoptimizationhub.EnrollmentStatus("example", include_member_accounts=True)
        ```

        ## Import

        Using `pulumi import`, import Cost Optimization Hub Enrollment Status using your AWS account ID. For example:

        ```sh
        $ pulumi import aws:costoptimizationhub/enrollmentStatus:EnrollmentStatus example 111222333444
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] include_member_accounts: Flag to enroll member accounts of the organization if the account is the management account. No drift detection is currently supported for this argument. Default value is `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EnrollmentStatusArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing AWS Cost Optimization Hub Enrollment Status.

        > **TIP:** The Cost Optimization Hub only has a `us-east-1` endpoint. However, you can access the service globally with the AWS Provider from other regions. Other tools, such as the [AWS CLI](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cost-optimization-hub/index.html), may require you to specify the `us-east-1` region when using the service.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.costoptimizationhub.EnrollmentStatus("example")
        ```

        ### Usage with all the arguments

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.costoptimizationhub.EnrollmentStatus("example", include_member_accounts=True)
        ```

        ## Import

        Using `pulumi import`, import Cost Optimization Hub Enrollment Status using your AWS account ID. For example:

        ```sh
        $ pulumi import aws:costoptimizationhub/enrollmentStatus:EnrollmentStatus example 111222333444
        ```

        :param str resource_name: The name of the resource.
        :param EnrollmentStatusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnrollmentStatusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_member_accounts: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnrollmentStatusArgs.__new__(EnrollmentStatusArgs)

            __props__.__dict__["include_member_accounts"] = include_member_accounts
            __props__.__dict__["status"] = None
        super(EnrollmentStatus, __self__).__init__(
            'aws:costoptimizationhub/enrollmentStatus:EnrollmentStatus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            include_member_accounts: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'EnrollmentStatus':
        """
        Get an existing EnrollmentStatus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] include_member_accounts: Flag to enroll member accounts of the organization if the account is the management account. No drift detection is currently supported for this argument. Default value is `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnrollmentStatusState.__new__(_EnrollmentStatusState)

        __props__.__dict__["include_member_accounts"] = include_member_accounts
        __props__.__dict__["status"] = status
        return EnrollmentStatus(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="includeMemberAccounts")
    def include_member_accounts(self) -> pulumi.Output[bool]:
        """
        Flag to enroll member accounts of the organization if the account is the management account. No drift detection is currently supported for this argument. Default value is `false`.
        """
        return pulumi.get(self, "include_member_accounts")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

