# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPipelineDefinitionResult',
    'AwaitableGetPipelineDefinitionResult',
    'get_pipeline_definition',
    'get_pipeline_definition_output',
]

@pulumi.output_type
class GetPipelineDefinitionResult:
    """
    A collection of values returned by getPipelineDefinition.
    """
    def __init__(__self__, id=None, parameter_objects=None, parameter_values=None, pipeline_id=None, pipeline_objects=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parameter_objects and not isinstance(parameter_objects, list):
            raise TypeError("Expected argument 'parameter_objects' to be a list")
        pulumi.set(__self__, "parameter_objects", parameter_objects)
        if parameter_values and not isinstance(parameter_values, list):
            raise TypeError("Expected argument 'parameter_values' to be a list")
        pulumi.set(__self__, "parameter_values", parameter_values)
        if pipeline_id and not isinstance(pipeline_id, str):
            raise TypeError("Expected argument 'pipeline_id' to be a str")
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if pipeline_objects and not isinstance(pipeline_objects, list):
            raise TypeError("Expected argument 'pipeline_objects' to be a list")
        pulumi.set(__self__, "pipeline_objects", pipeline_objects)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parameterObjects")
    def parameter_objects(self) -> Sequence['outputs.GetPipelineDefinitionParameterObjectResult']:
        """
        Parameter objects used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_objects")

    @property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[Sequence['outputs.GetPipelineDefinitionParameterValueResult']]:
        """
        Parameter values used in the pipeline definition. See below
        """
        return pulumi.get(self, "parameter_values")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> str:
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="pipelineObjects")
    def pipeline_objects(self) -> Sequence['outputs.GetPipelineDefinitionPipelineObjectResult']:
        """
        Objects defined in the pipeline. See below
        """
        return pulumi.get(self, "pipeline_objects")


class AwaitableGetPipelineDefinitionResult(GetPipelineDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPipelineDefinitionResult(
            id=self.id,
            parameter_objects=self.parameter_objects,
            parameter_values=self.parameter_values,
            pipeline_id=self.pipeline_id,
            pipeline_objects=self.pipeline_objects)


def get_pipeline_definition(parameter_values: Optional[Sequence[Union['GetPipelineDefinitionParameterValueArgs', 'GetPipelineDefinitionParameterValueArgsDict']]] = None,
                            pipeline_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPipelineDefinitionResult:
    """
    Provides details about a specific DataPipeline Pipeline Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.datapipeline.get_pipeline_definition(pipeline_id="pipelineID")
    ```


    :param Sequence[Union['GetPipelineDefinitionParameterValueArgs', 'GetPipelineDefinitionParameterValueArgsDict']] parameter_values: Parameter values used in the pipeline definition. See below
    :param str pipeline_id: ID of the pipeline.
    """
    __args__ = dict()
    __args__['parameterValues'] = parameter_values
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:datapipeline/getPipelineDefinition:getPipelineDefinition', __args__, opts=opts, typ=GetPipelineDefinitionResult).value

    return AwaitableGetPipelineDefinitionResult(
        id=pulumi.get(__ret__, 'id'),
        parameter_objects=pulumi.get(__ret__, 'parameter_objects'),
        parameter_values=pulumi.get(__ret__, 'parameter_values'),
        pipeline_id=pulumi.get(__ret__, 'pipeline_id'),
        pipeline_objects=pulumi.get(__ret__, 'pipeline_objects'))
def get_pipeline_definition_output(parameter_values: Optional[pulumi.Input[Optional[Sequence[Union['GetPipelineDefinitionParameterValueArgs', 'GetPipelineDefinitionParameterValueArgsDict']]]]] = None,
                                   pipeline_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPipelineDefinitionResult]:
    """
    Provides details about a specific DataPipeline Pipeline Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.datapipeline.get_pipeline_definition(pipeline_id="pipelineID")
    ```


    :param Sequence[Union['GetPipelineDefinitionParameterValueArgs', 'GetPipelineDefinitionParameterValueArgsDict']] parameter_values: Parameter values used in the pipeline definition. See below
    :param str pipeline_id: ID of the pipeline.
    """
    __args__ = dict()
    __args__['parameterValues'] = parameter_values
    __args__['pipelineId'] = pipeline_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:datapipeline/getPipelineDefinition:getPipelineDefinition', __args__, opts=opts, typ=GetPipelineDefinitionResult)
    return __ret__.apply(lambda __response__: GetPipelineDefinitionResult(
        id=pulumi.get(__response__, 'id'),
        parameter_objects=pulumi.get(__response__, 'parameter_objects'),
        parameter_values=pulumi.get(__response__, 'parameter_values'),
        pipeline_id=pulumi.get(__response__, 'pipeline_id'),
        pipeline_objects=pulumi.get(__response__, 'pipeline_objects')))
