# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HostedConnectionArgs', 'HostedConnection']

@pulumi.input_type
class HostedConnectionArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[str],
                 connection_id: pulumi.Input[str],
                 owner_account_id: pulumi.Input[str],
                 vlan: pulumi.Input[int],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HostedConnection resource.
        :param pulumi.Input[str] bandwidth: The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
        :param pulumi.Input[str] connection_id: The ID of the interconnect or LAG.
        :param pulumi.Input[str] owner_account_id: The ID of the AWS account of the customer for the connection.
        :param pulumi.Input[int] vlan: The dedicated VLAN provisioned to the hosted connection.
        :param pulumi.Input[str] name: The name of the connection.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "owner_account_id", owner_account_id)
        pulumi.set(__self__, "vlan", vlan)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[str]:
        """
        The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[str]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        The ID of the interconnect or LAG.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Input[str]:
        """
        The ID of the AWS account of the customer for the connection.
        """
        return pulumi.get(self, "owner_account_id")

    @owner_account_id.setter
    def owner_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner_account_id", value)

    @property
    @pulumi.getter
    def vlan(self) -> pulumi.Input[int]:
        """
        The dedicated VLAN provisioned to the hosted connection.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: pulumi.Input[int]):
        pulumi.set(self, "vlan", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _HostedConnectionState:
    def __init__(__self__, *,
                 aws_device: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 has_logical_redundancy: Optional[pulumi.Input[str]] = None,
                 jumbo_frame_capable: Optional[pulumi.Input[bool]] = None,
                 lag_id: Optional[pulumi.Input[str]] = None,
                 loa_issue_time: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_account_id: Optional[pulumi.Input[str]] = None,
                 partner_name: Optional[pulumi.Input[str]] = None,
                 provider_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering HostedConnection resources.
        :param pulumi.Input[str] aws_device: The Direct Connect endpoint on which the physical connection terminates.
        :param pulumi.Input[str] bandwidth: The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
        :param pulumi.Input[str] connection_id: The ID of the interconnect or LAG.
        :param pulumi.Input[str] has_logical_redundancy: Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
        :param pulumi.Input[bool] jumbo_frame_capable: Boolean value representing if jumbo frames have been enabled for this connection.
        :param pulumi.Input[str] lag_id: The ID of the LAG.
        :param pulumi.Input[str] loa_issue_time: The time of the most recent call to [DescribeLoa](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLoa.html) for this connection.
        :param pulumi.Input[str] location: The location of the connection.
        :param pulumi.Input[str] name: The name of the connection.
        :param pulumi.Input[str] owner_account_id: The ID of the AWS account of the customer for the connection.
        :param pulumi.Input[str] partner_name: The name of the AWS Direct Connect service provider associated with the connection.
        :param pulumi.Input[str] provider_name: The name of the service provider associated with the connection.
        :param pulumi.Input[str] region: The AWS Region where the connection is located.
        :param pulumi.Input[str] state: The state of the connection. Possible values include: ordering, requested, pending, available, down, deleting, deleted, rejected, unknown. See [AllocateHostedConnection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateHostedConnection.html) for a description of each connection state.
        :param pulumi.Input[int] vlan: The dedicated VLAN provisioned to the hosted connection.
        """
        if aws_device is not None:
            pulumi.set(__self__, "aws_device", aws_device)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if has_logical_redundancy is not None:
            pulumi.set(__self__, "has_logical_redundancy", has_logical_redundancy)
        if jumbo_frame_capable is not None:
            pulumi.set(__self__, "jumbo_frame_capable", jumbo_frame_capable)
        if lag_id is not None:
            pulumi.set(__self__, "lag_id", lag_id)
        if loa_issue_time is not None:
            pulumi.set(__self__, "loa_issue_time", loa_issue_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_account_id is not None:
            pulumi.set(__self__, "owner_account_id", owner_account_id)
        if partner_name is not None:
            pulumi.set(__self__, "partner_name", partner_name)
        if provider_name is not None:
            pulumi.set(__self__, "provider_name", provider_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="awsDevice")
    def aws_device(self) -> Optional[pulumi.Input[str]]:
        """
        The Direct Connect endpoint on which the physical connection terminates.
        """
        return pulumi.get(self, "aws_device")

    @aws_device.setter
    def aws_device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_device", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the interconnect or LAG.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="hasLogicalRedundancy")
    def has_logical_redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
        """
        return pulumi.get(self, "has_logical_redundancy")

    @has_logical_redundancy.setter
    def has_logical_redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "has_logical_redundancy", value)

    @property
    @pulumi.getter(name="jumboFrameCapable")
    def jumbo_frame_capable(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value representing if jumbo frames have been enabled for this connection.
        """
        return pulumi.get(self, "jumbo_frame_capable")

    @jumbo_frame_capable.setter
    def jumbo_frame_capable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jumbo_frame_capable", value)

    @property
    @pulumi.getter(name="lagId")
    def lag_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the LAG.
        """
        return pulumi.get(self, "lag_id")

    @lag_id.setter
    def lag_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lag_id", value)

    @property
    @pulumi.getter(name="loaIssueTime")
    def loa_issue_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time of the most recent call to [DescribeLoa](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLoa.html) for this connection.
        """
        return pulumi.get(self, "loa_issue_time")

    @loa_issue_time.setter
    def loa_issue_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loa_issue_time", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the connection.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AWS account of the customer for the connection.
        """
        return pulumi.get(self, "owner_account_id")

    @owner_account_id.setter
    def owner_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_account_id", value)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the AWS Direct Connect service provider associated with the connection.
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the service provider associated with the connection.
        """
        return pulumi.get(self, "provider_name")

    @provider_name.setter
    def provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region where the connection is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the connection. Possible values include: ordering, requested, pending, available, down, deleting, deleted, rejected, unknown. See [AllocateHostedConnection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateHostedConnection.html) for a description of each connection state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[int]]:
        """
        The dedicated VLAN provisioned to the hosted connection.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan", value)


class HostedConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_account_id: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects. Intended for use by AWS Direct Connect Partners only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        hosted = aws.directconnect.HostedConnection("hosted",
            connection_id="dxcon-ffabc123",
            bandwidth="100Mbps",
            name="tf-dx-hosted-connection",
            owner_account_id="123456789012",
            vlan=1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth: The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
        :param pulumi.Input[str] connection_id: The ID of the interconnect or LAG.
        :param pulumi.Input[str] name: The name of the connection.
        :param pulumi.Input[str] owner_account_id: The ID of the AWS account of the customer for the connection.
        :param pulumi.Input[int] vlan: The dedicated VLAN provisioned to the hosted connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostedConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects. Intended for use by AWS Direct Connect Partners only.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        hosted = aws.directconnect.HostedConnection("hosted",
            connection_id="dxcon-ffabc123",
            bandwidth="100Mbps",
            name="tf-dx-hosted-connection",
            owner_account_id="123456789012",
            vlan=1)
        ```

        :param str resource_name: The name of the resource.
        :param HostedConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostedConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 owner_account_id: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostedConnectionArgs.__new__(HostedConnectionArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            if connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_id'")
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["name"] = name
            if owner_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'owner_account_id'")
            __props__.__dict__["owner_account_id"] = owner_account_id
            if vlan is None and not opts.urn:
                raise TypeError("Missing required property 'vlan'")
            __props__.__dict__["vlan"] = vlan
            __props__.__dict__["aws_device"] = None
            __props__.__dict__["has_logical_redundancy"] = None
            __props__.__dict__["jumbo_frame_capable"] = None
            __props__.__dict__["lag_id"] = None
            __props__.__dict__["loa_issue_time"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["partner_name"] = None
            __props__.__dict__["provider_name"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["state"] = None
        super(HostedConnection, __self__).__init__(
            'aws:directconnect/hostedConnection:HostedConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_device: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            connection_id: Optional[pulumi.Input[str]] = None,
            has_logical_redundancy: Optional[pulumi.Input[str]] = None,
            jumbo_frame_capable: Optional[pulumi.Input[bool]] = None,
            lag_id: Optional[pulumi.Input[str]] = None,
            loa_issue_time: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            owner_account_id: Optional[pulumi.Input[str]] = None,
            partner_name: Optional[pulumi.Input[str]] = None,
            provider_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            vlan: Optional[pulumi.Input[int]] = None) -> 'HostedConnection':
        """
        Get an existing HostedConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_device: The Direct Connect endpoint on which the physical connection terminates.
        :param pulumi.Input[str] bandwidth: The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
        :param pulumi.Input[str] connection_id: The ID of the interconnect or LAG.
        :param pulumi.Input[str] has_logical_redundancy: Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
        :param pulumi.Input[bool] jumbo_frame_capable: Boolean value representing if jumbo frames have been enabled for this connection.
        :param pulumi.Input[str] lag_id: The ID of the LAG.
        :param pulumi.Input[str] loa_issue_time: The time of the most recent call to [DescribeLoa](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLoa.html) for this connection.
        :param pulumi.Input[str] location: The location of the connection.
        :param pulumi.Input[str] name: The name of the connection.
        :param pulumi.Input[str] owner_account_id: The ID of the AWS account of the customer for the connection.
        :param pulumi.Input[str] partner_name: The name of the AWS Direct Connect service provider associated with the connection.
        :param pulumi.Input[str] provider_name: The name of the service provider associated with the connection.
        :param pulumi.Input[str] region: The AWS Region where the connection is located.
        :param pulumi.Input[str] state: The state of the connection. Possible values include: ordering, requested, pending, available, down, deleting, deleted, rejected, unknown. See [AllocateHostedConnection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateHostedConnection.html) for a description of each connection state.
        :param pulumi.Input[int] vlan: The dedicated VLAN provisioned to the hosted connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostedConnectionState.__new__(_HostedConnectionState)

        __props__.__dict__["aws_device"] = aws_device
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["has_logical_redundancy"] = has_logical_redundancy
        __props__.__dict__["jumbo_frame_capable"] = jumbo_frame_capable
        __props__.__dict__["lag_id"] = lag_id
        __props__.__dict__["loa_issue_time"] = loa_issue_time
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_account_id"] = owner_account_id
        __props__.__dict__["partner_name"] = partner_name
        __props__.__dict__["provider_name"] = provider_name
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["vlan"] = vlan
        return HostedConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsDevice")
    def aws_device(self) -> pulumi.Output[str]:
        """
        The Direct Connect endpoint on which the physical connection terminates.
        """
        return pulumi.get(self, "aws_device")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps and 10Gbps. Case sensitive.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[str]:
        """
        The ID of the interconnect or LAG.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="hasLogicalRedundancy")
    def has_logical_redundancy(self) -> pulumi.Output[str]:
        """
        Indicates whether the connection supports a secondary BGP peer in the same address family (IPv4/IPv6).
        """
        return pulumi.get(self, "has_logical_redundancy")

    @property
    @pulumi.getter(name="jumboFrameCapable")
    def jumbo_frame_capable(self) -> pulumi.Output[bool]:
        """
        Boolean value representing if jumbo frames have been enabled for this connection.
        """
        return pulumi.get(self, "jumbo_frame_capable")

    @property
    @pulumi.getter(name="lagId")
    def lag_id(self) -> pulumi.Output[str]:
        """
        The ID of the LAG.
        """
        return pulumi.get(self, "lag_id")

    @property
    @pulumi.getter(name="loaIssueTime")
    def loa_issue_time(self) -> pulumi.Output[str]:
        """
        The time of the most recent call to [DescribeLoa](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLoa.html) for this connection.
        """
        return pulumi.get(self, "loa_issue_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the connection.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerAccountId")
    def owner_account_id(self) -> pulumi.Output[str]:
        """
        The ID of the AWS account of the customer for the connection.
        """
        return pulumi.get(self, "owner_account_id")

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Output[str]:
        """
        The name of the AWS Direct Connect service provider associated with the connection.
        """
        return pulumi.get(self, "partner_name")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[str]:
        """
        The name of the service provider associated with the connection.
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The AWS Region where the connection is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the connection. Possible values include: ordering, requested, pending, available, down, deleting, deleted, rejected, unknown. See [AllocateHostedConnection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateHostedConnection.html) for a description of each connection state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def vlan(self) -> pulumi.Output[int]:
        """
        The dedicated VLAN provisioned to the hosted connection.
        """
        return pulumi.get(self, "vlan")

