# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ReplicationConfigurationTemplatePitPolicy',
    'ReplicationConfigurationTemplateTimeouts',
]

@pulumi.output_type
class ReplicationConfigurationTemplatePitPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionDuration":
            suggest = "retention_duration"
        elif key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationTemplatePitPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationTemplatePitPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationTemplatePitPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: int,
                 retention_duration: int,
                 units: str,
                 enabled: Optional[bool] = None,
                 rule_id: Optional[int] = None):
        """
        :param int interval: How often, in the chosen units, a snapshot should be taken.
        :param int retention_duration: Duration to retain a snapshot for, in the chosen `units`.
        :param str units: Units used to measure the `interval` and `retention_duration`. Valid values are `MINUTE`, `HOUR`, and `DAY`.
        :param bool enabled: Whether this rule is enabled or not.
        :param int rule_id: ID of the rule. Valid values are integers.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "retention_duration", retention_duration)
        pulumi.set(__self__, "units", units)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        How often, in the chosen units, a snapshot should be taken.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> int:
        """
        Duration to retain a snapshot for, in the chosen `units`.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        Units used to measure the `interval` and `retention_duration`. Valid values are `MINUTE`, `HOUR`, and `DAY`.
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether this rule is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[int]:
        """
        ID of the rule. Valid values are integers.
        """
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class ReplicationConfigurationTemplateTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


