# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AmiLaunchPermissionArgs', 'AmiLaunchPermission']

@pulumi.input_type
class AmiLaunchPermissionArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 account_id: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 organization_arn: Optional[pulumi.Input[str]] = None,
                 organizational_unit_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AmiLaunchPermission resource.
        :param pulumi.Input[str] image_id: ID of the AMI.
        :param pulumi.Input[str] account_id: AWS account ID for the launch permission.
        :param pulumi.Input[str] group: Name of the group for the launch permission. Valid values: `"all"`.
        :param pulumi.Input[str] organization_arn: ARN of an organization for the launch permission.
        :param pulumi.Input[str] organizational_unit_arn: ARN of an organizational unit for the launch permission.
        """
        pulumi.set(__self__, "image_id", image_id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if organization_arn is not None:
            pulumi.set(__self__, "organization_arn", organization_arn)
        if organizational_unit_arn is not None:
            pulumi.set(__self__, "organizational_unit_arn", organizational_unit_arn)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        ID of the AMI.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID for the launch permission.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the group for the launch permission. Valid values: `"all"`.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="organizationArn")
    def organization_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of an organization for the launch permission.
        """
        return pulumi.get(self, "organization_arn")

    @organization_arn.setter
    def organization_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_arn", value)

    @property
    @pulumi.getter(name="organizationalUnitArn")
    def organizational_unit_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of an organizational unit for the launch permission.
        """
        return pulumi.get(self, "organizational_unit_arn")

    @organizational_unit_arn.setter
    def organizational_unit_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_arn", value)


@pulumi.input_type
class _AmiLaunchPermissionState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 organization_arn: Optional[pulumi.Input[str]] = None,
                 organizational_unit_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AmiLaunchPermission resources.
        :param pulumi.Input[str] account_id: AWS account ID for the launch permission.
        :param pulumi.Input[str] group: Name of the group for the launch permission. Valid values: `"all"`.
        :param pulumi.Input[str] image_id: ID of the AMI.
        :param pulumi.Input[str] organization_arn: ARN of an organization for the launch permission.
        :param pulumi.Input[str] organizational_unit_arn: ARN of an organizational unit for the launch permission.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if organization_arn is not None:
            pulumi.set(__self__, "organization_arn", organization_arn)
        if organizational_unit_arn is not None:
            pulumi.set(__self__, "organizational_unit_arn", organizational_unit_arn)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID for the launch permission.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the group for the launch permission. Valid values: `"all"`.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the AMI.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="organizationArn")
    def organization_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of an organization for the launch permission.
        """
        return pulumi.get(self, "organization_arn")

    @organization_arn.setter
    def organization_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_arn", value)

    @property
    @pulumi.getter(name="organizationalUnitArn")
    def organizational_unit_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of an organizational unit for the launch permission.
        """
        return pulumi.get(self, "organizational_unit_arn")

    @organizational_unit_arn.setter
    def organizational_unit_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_arn", value)


class AmiLaunchPermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 organization_arn: Optional[pulumi.Input[str]] = None,
                 organizational_unit_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Adds a launch permission to an Amazon Machine Image (AMI).

        ## Example Usage

        ### AWS Account ID

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiLaunchPermission("example",
            image_id="ami-12345678",
            account_id="123456789012")
        ```

        ### Public Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiLaunchPermission("example",
            image_id="ami-12345678",
            group="all")
        ```

        ### Organization Access

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.organizations.get_organization()
        example = aws.ec2.AmiLaunchPermission("example",
            image_id="ami-12345678",
            organization_arn=current.arn)
        ```

        ## Import

        Using `pulumi import`, import AMI Launch Permissions using `[ACCOUNT-ID|GROUP-NAME|ORGANIZATION-ARN|ORGANIZATIONAL-UNIT-ARN]/IMAGE-ID`. For example:

        ```sh
        $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: AWS account ID for the launch permission.
        :param pulumi.Input[str] group: Name of the group for the launch permission. Valid values: `"all"`.
        :param pulumi.Input[str] image_id: ID of the AMI.
        :param pulumi.Input[str] organization_arn: ARN of an organization for the launch permission.
        :param pulumi.Input[str] organizational_unit_arn: ARN of an organizational unit for the launch permission.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AmiLaunchPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Adds a launch permission to an Amazon Machine Image (AMI).

        ## Example Usage

        ### AWS Account ID

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiLaunchPermission("example",
            image_id="ami-12345678",
            account_id="123456789012")
        ```

        ### Public Access

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiLaunchPermission("example",
            image_id="ami-12345678",
            group="all")
        ```

        ### Organization Access

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.organizations.get_organization()
        example = aws.ec2.AmiLaunchPermission("example",
            image_id="ami-12345678",
            organization_arn=current.arn)
        ```

        ## Import

        Using `pulumi import`, import AMI Launch Permissions using `[ACCOUNT-ID|GROUP-NAME|ORGANIZATION-ARN|ORGANIZATIONAL-UNIT-ARN]/IMAGE-ID`. For example:

        ```sh
        $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
        ```

        :param str resource_name: The name of the resource.
        :param AmiLaunchPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AmiLaunchPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 organization_arn: Optional[pulumi.Input[str]] = None,
                 organizational_unit_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AmiLaunchPermissionArgs.__new__(AmiLaunchPermissionArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["group"] = group
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["organization_arn"] = organization_arn
            __props__.__dict__["organizational_unit_arn"] = organizational_unit_arn
        super(AmiLaunchPermission, __self__).__init__(
            'aws:ec2/amiLaunchPermission:AmiLaunchPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            group: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            organization_arn: Optional[pulumi.Input[str]] = None,
            organizational_unit_arn: Optional[pulumi.Input[str]] = None) -> 'AmiLaunchPermission':
        """
        Get an existing AmiLaunchPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: AWS account ID for the launch permission.
        :param pulumi.Input[str] group: Name of the group for the launch permission. Valid values: `"all"`.
        :param pulumi.Input[str] image_id: ID of the AMI.
        :param pulumi.Input[str] organization_arn: ARN of an organization for the launch permission.
        :param pulumi.Input[str] organizational_unit_arn: ARN of an organizational unit for the launch permission.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AmiLaunchPermissionState.__new__(_AmiLaunchPermissionState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["group"] = group
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["organization_arn"] = organization_arn
        __props__.__dict__["organizational_unit_arn"] = organizational_unit_arn
        return AmiLaunchPermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        AWS account ID for the launch permission.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the group for the launch permission. Valid values: `"all"`.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        ID of the AMI.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="organizationArn")
    def organization_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of an organization for the launch permission.
        """
        return pulumi.get(self, "organization_arn")

    @property
    @pulumi.getter(name="organizationalUnitArn")
    def organizational_unit_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of an organizational unit for the launch permission.
        """
        return pulumi.get(self, "organizational_unit_arn")

