# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DefaultRouteTableArgs', 'DefaultRouteTable']

@pulumi.input_type
class DefaultRouteTableArgs:
    def __init__(__self__, *,
                 default_route_table_id: pulumi.Input[str],
                 propagating_vgws: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DefaultRouteTable resource.
        :param pulumi.Input[str] default_route_table_id: ID of the default route table.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] propagating_vgws: List of virtual gateways for propagation.
        :param pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]] routes: Set of objects. Detailed below
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "default_route_table_id", default_route_table_id)
        if propagating_vgws is not None:
            pulumi.set(__self__, "propagating_vgws", propagating_vgws)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> pulumi.Input[str]:
        """
        ID of the default route table.

        The following arguments are optional:
        """
        return pulumi.get(self, "default_route_table_id")

    @default_route_table_id.setter
    def default_route_table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_route_table_id", value)

    @property
    @pulumi.getter(name="propagatingVgws")
    def propagating_vgws(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of virtual gateways for propagation.
        """
        return pulumi.get(self, "propagating_vgws")

    @propagating_vgws.setter
    def propagating_vgws(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "propagating_vgws", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]]]:
        """
        Set of objects. Detailed below
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DefaultRouteTableState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 default_route_table_id: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 propagating_vgws: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DefaultRouteTable resources.
        :param pulumi.Input[str] arn: The ARN of the route table.
        :param pulumi.Input[str] default_route_table_id: ID of the default route table.
               
               The following arguments are optional:
        :param pulumi.Input[str] owner_id: ID of the AWS account that owns the route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] propagating_vgws: List of virtual gateways for propagation.
        :param pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]] routes: Set of objects. Detailed below
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] vpc_id: ID of the VPC.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if default_route_table_id is not None:
            pulumi.set(__self__, "default_route_table_id", default_route_table_id)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if propagating_vgws is not None:
            pulumi.set(__self__, "propagating_vgws", propagating_vgws)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the route table.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the default route table.

        The following arguments are optional:
        """
        return pulumi.get(self, "default_route_table_id")

    @default_route_table_id.setter
    def default_route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_route_table_id", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the AWS account that owns the route table.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="propagatingVgws")
    def propagating_vgws(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of virtual gateways for propagation.
        """
        return pulumi.get(self, "propagating_vgws")

    @propagating_vgws.setter
    def propagating_vgws(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "propagating_vgws", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]]]:
        """
        Set of objects. Detailed below
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DefaultRouteTableRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class DefaultRouteTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route_table_id: Optional[pulumi.Input[str]] = None,
                 propagating_vgws: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DefaultRouteTableRouteArgs', 'DefaultRouteTableRouteArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage a default route table of a VPC. This resource can manage the default route table of the default or a non-default VPC.

        > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `ec2.DefaultRouteTable` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management. **Do not** use both `ec2.DefaultRouteTable` to manage a default route table **and** `ec2.MainRouteTableAssociation` with the same VPC due to possible route conflicts. See ec2.MainRouteTableAssociation documentation for more details.

        Every VPC has a default route table that can be managed but not destroyed. When the provider first adopts a default route table, it **immediately removes all defined routes**. It then proceeds to create any routes specified in the configuration. This step is required so that only the routes specified in the configuration exist in the default route table.

        For more information, see the Amazon VPC User Guide on [Route Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html). For information about managing normal route tables in this provider, see `ec2.RouteTable`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.DefaultRouteTable("example",
            default_route_table_id=example_aws_vpc["defaultRouteTableId"],
            routes=[
                {
                    "cidr_block": "10.0.1.0/24",
                    "gateway_id": example_aws_internet_gateway["id"],
                },
                {
                    "ipv6_cidr_block": "::/0",
                    "egress_only_gateway_id": example_aws_egress_only_internet_gateway["id"],
                },
            ],
            tags={
                "Name": "example",
            })
        ```

        To subsequently remove all managed routes:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.DefaultRouteTable("example",
            default_route_table_id=example_aws_vpc["defaultRouteTableId"],
            routes=[],
            tags={
                "Name": "example",
            })
        ```

        ## Import

        Using `pulumi import`, import Default VPC route tables using the `vpc_id`. For example:

        ```sh
        $ pulumi import aws:ec2/defaultRouteTable:DefaultRouteTable example vpc-33cc44dd
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_route_table_id: ID of the default route table.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] propagating_vgws: List of virtual gateways for propagation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DefaultRouteTableRouteArgs', 'DefaultRouteTableRouteArgsDict']]]] routes: Set of objects. Detailed below
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultRouteTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a default route table of a VPC. This resource can manage the default route table of the default or a non-default VPC.

        > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `ec2.DefaultRouteTable` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management. **Do not** use both `ec2.DefaultRouteTable` to manage a default route table **and** `ec2.MainRouteTableAssociation` with the same VPC due to possible route conflicts. See ec2.MainRouteTableAssociation documentation for more details.

        Every VPC has a default route table that can be managed but not destroyed. When the provider first adopts a default route table, it **immediately removes all defined routes**. It then proceeds to create any routes specified in the configuration. This step is required so that only the routes specified in the configuration exist in the default route table.

        For more information, see the Amazon VPC User Guide on [Route Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html). For information about managing normal route tables in this provider, see `ec2.RouteTable`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.DefaultRouteTable("example",
            default_route_table_id=example_aws_vpc["defaultRouteTableId"],
            routes=[
                {
                    "cidr_block": "10.0.1.0/24",
                    "gateway_id": example_aws_internet_gateway["id"],
                },
                {
                    "ipv6_cidr_block": "::/0",
                    "egress_only_gateway_id": example_aws_egress_only_internet_gateway["id"],
                },
            ],
            tags={
                "Name": "example",
            })
        ```

        To subsequently remove all managed routes:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.DefaultRouteTable("example",
            default_route_table_id=example_aws_vpc["defaultRouteTableId"],
            routes=[],
            tags={
                "Name": "example",
            })
        ```

        ## Import

        Using `pulumi import`, import Default VPC route tables using the `vpc_id`. For example:

        ```sh
        $ pulumi import aws:ec2/defaultRouteTable:DefaultRouteTable example vpc-33cc44dd
        ```

        :param str resource_name: The name of the resource.
        :param DefaultRouteTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultRouteTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route_table_id: Optional[pulumi.Input[str]] = None,
                 propagating_vgws: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DefaultRouteTableRouteArgs', 'DefaultRouteTableRouteArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultRouteTableArgs.__new__(DefaultRouteTableArgs)

            if default_route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'default_route_table_id'")
            __props__.__dict__["default_route_table_id"] = default_route_table_id
            __props__.__dict__["propagating_vgws"] = propagating_vgws
            __props__.__dict__["routes"] = routes
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(DefaultRouteTable, __self__).__init__(
            'aws:ec2/defaultRouteTable:DefaultRouteTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            default_route_table_id: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            propagating_vgws: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DefaultRouteTableRouteArgs', 'DefaultRouteTableRouteArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'DefaultRouteTable':
        """
        Get an existing DefaultRouteTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the route table.
        :param pulumi.Input[str] default_route_table_id: ID of the default route table.
               
               The following arguments are optional:
        :param pulumi.Input[str] owner_id: ID of the AWS account that owns the route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] propagating_vgws: List of virtual gateways for propagation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DefaultRouteTableRouteArgs', 'DefaultRouteTableRouteArgsDict']]]] routes: Set of objects. Detailed below
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] vpc_id: ID of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultRouteTableState.__new__(_DefaultRouteTableState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["default_route_table_id"] = default_route_table_id
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["propagating_vgws"] = propagating_vgws
        __props__.__dict__["routes"] = routes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_id"] = vpc_id
        return DefaultRouteTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the route table.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultRouteTableId")
    def default_route_table_id(self) -> pulumi.Output[str]:
        """
        ID of the default route table.

        The following arguments are optional:
        """
        return pulumi.get(self, "default_route_table_id")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        ID of the AWS account that owns the route table.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="propagatingVgws")
    def propagating_vgws(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of virtual gateways for propagation.
        """
        return pulumi.get(self, "propagating_vgws")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Sequence['outputs.DefaultRouteTableRoute']]:
        """
        Set of objects. Detailed below
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

