# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcsResult',
    'AwaitableGetVpcsResult',
    'get_vpcs',
    'get_vpcs_output',
]

@pulumi.output_type
class GetVpcsResult:
    """
    A collection of values returned by getVpcs.
    """
    def __init__(__self__, filters=None, id=None, ids=None, tags=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVpcsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        List of all the VPC Ids found.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")


class AwaitableGetVpcsResult(GetVpcsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcsResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            tags=self.tags)


def get_vpcs(filters: Optional[Sequence[Union['GetVpcsFilterArgs', 'GetVpcsFilterArgsDict']]] = None,
             tags: Optional[Mapping[str, str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcsResult:
    """
    This resource can be useful for getting back a list of VPC Ids for a region.

    The following example retrieves a list of VPC Ids with a custom tag of `service` set to a value of "production".

    ## Example Usage

    The following shows outputting all VPC Ids.

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ec2.get_vpcs(tags={
        "service": "production",
    })
    pulumi.export("foo", foo.ids)
    ```

    An example use case would be interpolate the `ec2_get_vpcs` output into `count` of an ec2.FlowLog resource.

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ec2.get_vpcs()
    foo_get_vpc = [aws.ec2.get_vpc(id=foo.ids[__index]) for __index in range(len(foo.ids))]
    test_flow_log = []
    for range in [{"value": i} for i in range(0, len(foo.ids))]:
        test_flow_log.append(aws.ec2.FlowLog(f"test_flow_log-{range['value']}", vpc_id=foo_get_vpc[range["value"]].id))
    pulumi.export("foo", foo.ids)
    ```


    :param Sequence[Union['GetVpcsFilterArgs', 'GetVpcsFilterArgsDict']] filters: Custom filter block as described below.
           
           More complex filters can be expressed using one or more `filter` sub-blocks,
           which take the following arguments:
    :param Mapping[str, str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired vpcs.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ec2/getVpcs:getVpcs', __args__, opts=opts, typ=GetVpcsResult).value

    return AwaitableGetVpcsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        tags=pulumi.get(__ret__, 'tags'))
def get_vpcs_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcsFilterArgs', 'GetVpcsFilterArgsDict']]]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcsResult]:
    """
    This resource can be useful for getting back a list of VPC Ids for a region.

    The following example retrieves a list of VPC Ids with a custom tag of `service` set to a value of "production".

    ## Example Usage

    The following shows outputting all VPC Ids.

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ec2.get_vpcs(tags={
        "service": "production",
    })
    pulumi.export("foo", foo.ids)
    ```

    An example use case would be interpolate the `ec2_get_vpcs` output into `count` of an ec2.FlowLog resource.

    ```python
    import pulumi
    import pulumi_aws as aws

    foo = aws.ec2.get_vpcs()
    foo_get_vpc = [aws.ec2.get_vpc(id=foo.ids[__index]) for __index in range(len(foo.ids))]
    test_flow_log = []
    for range in [{"value": i} for i in range(0, len(foo.ids))]:
        test_flow_log.append(aws.ec2.FlowLog(f"test_flow_log-{range['value']}", vpc_id=foo_get_vpc[range["value"]].id))
    pulumi.export("foo", foo.ids)
    ```


    :param Sequence[Union['GetVpcsFilterArgs', 'GetVpcsFilterArgsDict']] filters: Custom filter block as described below.
           
           More complex filters can be expressed using one or more `filter` sub-blocks,
           which take the following arguments:
    :param Mapping[str, str] tags: Map of tags, each pair of which must exactly match
           a pair on the desired vpcs.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ec2/getVpcs:getVpcs', __args__, opts=opts, typ=GetVpcsResult)
    return __ret__.apply(lambda __response__: GetVpcsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        tags=pulumi.get(__response__, 'tags')))
