# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubnetCidrReservationArgs', 'SubnetCidrReservation']

@pulumi.input_type
class SubnetCidrReservationArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[str],
                 reservation_type: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SubnetCidrReservation resource.
        :param pulumi.Input[str] cidr_block: The CIDR block for the reservation.
        :param pulumi.Input[str] reservation_type: The type of reservation to create. Valid values: `explicit`, `prefix`
        :param pulumi.Input[str] subnet_id: The ID of the subnet to create the reservation for.
        :param pulumi.Input[str] description: A brief description of the reservation.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "reservation_type", reservation_type)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[str]:
        """
        The CIDR block for the reservation.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="reservationType")
    def reservation_type(self) -> pulumi.Input[str]:
        """
        The type of reservation to create. Valid values: `explicit`, `prefix`
        """
        return pulumi.get(self, "reservation_type")

    @reservation_type.setter
    def reservation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "reservation_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The ID of the subnet to create the reservation for.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description of the reservation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _SubnetCidrReservationState:
    def __init__(__self__, *,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 reservation_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SubnetCidrReservation resources.
        :param pulumi.Input[str] cidr_block: The CIDR block for the reservation.
        :param pulumi.Input[str] description: A brief description of the reservation.
        :param pulumi.Input[str] owner_id: ID of the AWS account that owns this CIDR reservation.
        :param pulumi.Input[str] reservation_type: The type of reservation to create. Valid values: `explicit`, `prefix`
        :param pulumi.Input[str] subnet_id: The ID of the subnet to create the reservation for.
        """
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if reservation_type is not None:
            pulumi.set(__self__, "reservation_type", reservation_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the reservation.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A brief description of the reservation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the AWS account that owns this CIDR reservation.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="reservationType")
    def reservation_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of reservation to create. Valid values: `explicit`, `prefix`
        """
        return pulumi.get(self, "reservation_type")

    @reservation_type.setter
    def reservation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reservation_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the subnet to create the reservation for.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


class SubnetCidrReservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 reservation_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a subnet CIDR reservation resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.SubnetCidrReservation("example",
            cidr_block="10.0.0.16/28",
            reservation_type="prefix",
            subnet_id=example_aws_subnet["id"])
        ```

        ## Import

        Using `pulumi import`, import Existing CIDR reservations using `SUBNET_ID:RESERVATION_ID`. For example:

        ```sh
        $ pulumi import aws:ec2/subnetCidrReservation:SubnetCidrReservation example subnet-01llsxvsxabqiymcz:scr-4mnvz6wb7otksjcs9
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_block: The CIDR block for the reservation.
        :param pulumi.Input[str] description: A brief description of the reservation.
        :param pulumi.Input[str] reservation_type: The type of reservation to create. Valid values: `explicit`, `prefix`
        :param pulumi.Input[str] subnet_id: The ID of the subnet to create the reservation for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetCidrReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a subnet CIDR reservation resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.SubnetCidrReservation("example",
            cidr_block="10.0.0.16/28",
            reservation_type="prefix",
            subnet_id=example_aws_subnet["id"])
        ```

        ## Import

        Using `pulumi import`, import Existing CIDR reservations using `SUBNET_ID:RESERVATION_ID`. For example:

        ```sh
        $ pulumi import aws:ec2/subnetCidrReservation:SubnetCidrReservation example subnet-01llsxvsxabqiymcz:scr-4mnvz6wb7otksjcs9
        ```

        :param str resource_name: The name of the resource.
        :param SubnetCidrReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetCidrReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 reservation_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetCidrReservationArgs.__new__(SubnetCidrReservationArgs)

            if cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'cidr_block'")
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["description"] = description
            if reservation_type is None and not opts.urn:
                raise TypeError("Missing required property 'reservation_type'")
            __props__.__dict__["reservation_type"] = reservation_type
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["owner_id"] = None
        super(SubnetCidrReservation, __self__).__init__(
            'aws:ec2/subnetCidrReservation:SubnetCidrReservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr_block: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            reservation_type: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None) -> 'SubnetCidrReservation':
        """
        Get an existing SubnetCidrReservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_block: The CIDR block for the reservation.
        :param pulumi.Input[str] description: A brief description of the reservation.
        :param pulumi.Input[str] owner_id: ID of the AWS account that owns this CIDR reservation.
        :param pulumi.Input[str] reservation_type: The type of reservation to create. Valid values: `explicit`, `prefix`
        :param pulumi.Input[str] subnet_id: The ID of the subnet to create the reservation for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetCidrReservationState.__new__(_SubnetCidrReservationState)

        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["description"] = description
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["reservation_type"] = reservation_type
        __props__.__dict__["subnet_id"] = subnet_id
        return SubnetCidrReservation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[str]:
        """
        The CIDR block for the reservation.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A brief description of the reservation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        ID of the AWS account that owns this CIDR reservation.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="reservationType")
    def reservation_type(self) -> pulumi.Output[str]:
        """
        The type of reservation to create. Valid values: `explicit`, `prefix`
        """
        return pulumi.get(self, "reservation_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The ID of the subnet to create the reservation for.
        """
        return pulumi.get(self, "subnet_id")

