# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DefaultRouteTablePropagationArgs', 'DefaultRouteTablePropagation']

@pulumi.input_type
class DefaultRouteTablePropagationArgs:
    def __init__(__self__, *,
                 transit_gateway_id: pulumi.Input[str],
                 transit_gateway_route_table_id: pulumi.Input[str],
                 timeouts: Optional[pulumi.Input['DefaultRouteTablePropagationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a DefaultRouteTablePropagation resource.
        :param pulumi.Input[str] transit_gateway_id: ID of the Transit Gateway to change the default association route table on.
        :param pulumi.Input[str] transit_gateway_route_table_id: ID of the Transit Gateway Route Table to be made the default association route table.
        """
        pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        pulumi.set(__self__, "transit_gateway_route_table_id", transit_gateway_route_table_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Input[str]:
        """
        ID of the Transit Gateway to change the default association route table on.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> pulumi.Input[str]:
        """
        ID of the Transit Gateway Route Table to be made the default association route table.
        """
        return pulumi.get(self, "transit_gateway_route_table_id")

    @transit_gateway_route_table_id.setter
    def transit_gateway_route_table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_route_table_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DefaultRouteTablePropagationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DefaultRouteTablePropagationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _DefaultRouteTablePropagationState:
    def __init__(__self__, *,
                 original_default_route_table_id: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['DefaultRouteTablePropagationTimeoutsArgs']] = None,
                 transit_gateway_id: Optional[pulumi.Input[str]] = None,
                 transit_gateway_route_table_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DefaultRouteTablePropagation resources.
        :param pulumi.Input[str] transit_gateway_id: ID of the Transit Gateway to change the default association route table on.
        :param pulumi.Input[str] transit_gateway_route_table_id: ID of the Transit Gateway Route Table to be made the default association route table.
        """
        if original_default_route_table_id is not None:
            pulumi.set(__self__, "original_default_route_table_id", original_default_route_table_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if transit_gateway_route_table_id is not None:
            pulumi.set(__self__, "transit_gateway_route_table_id", transit_gateway_route_table_id)

    @property
    @pulumi.getter(name="originalDefaultRouteTableId")
    def original_default_route_table_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "original_default_route_table_id")

    @original_default_route_table_id.setter
    def original_default_route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "original_default_route_table_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DefaultRouteTablePropagationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DefaultRouteTablePropagationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Transit Gateway to change the default association route table on.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Transit Gateway Route Table to be made the default association route table.
        """
        return pulumi.get(self, "transit_gateway_route_table_id")

    @transit_gateway_route_table_id.setter
    def transit_gateway_route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_route_table_id", value)


class DefaultRouteTablePropagation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 timeouts: Optional[pulumi.Input[Union['DefaultRouteTablePropagationTimeoutsArgs', 'DefaultRouteTablePropagationTimeoutsArgsDict']]] = None,
                 transit_gateway_id: Optional[pulumi.Input[str]] = None,
                 transit_gateway_route_table_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS EC2 (Elastic Compute Cloud) Transit Gateway Default Route Table Propagation.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.DefaultRouteTablePropagation("example",
            transit_gateway_id=example_aws_ec2_transit_gateway["id"],
            transit_gateway_route_table_id=example_aws_ec2_transit_gateway_route_table["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] transit_gateway_id: ID of the Transit Gateway to change the default association route table on.
        :param pulumi.Input[str] transit_gateway_route_table_id: ID of the Transit Gateway Route Table to be made the default association route table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DefaultRouteTablePropagationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS EC2 (Elastic Compute Cloud) Transit Gateway Default Route Table Propagation.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2transitgateway.DefaultRouteTablePropagation("example",
            transit_gateway_id=example_aws_ec2_transit_gateway["id"],
            transit_gateway_route_table_id=example_aws_ec2_transit_gateway_route_table["id"])
        ```

        :param str resource_name: The name of the resource.
        :param DefaultRouteTablePropagationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DefaultRouteTablePropagationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 timeouts: Optional[pulumi.Input[Union['DefaultRouteTablePropagationTimeoutsArgs', 'DefaultRouteTablePropagationTimeoutsArgsDict']]] = None,
                 transit_gateway_id: Optional[pulumi.Input[str]] = None,
                 transit_gateway_route_table_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DefaultRouteTablePropagationArgs.__new__(DefaultRouteTablePropagationArgs)

            __props__.__dict__["timeouts"] = timeouts
            if transit_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_id'")
            __props__.__dict__["transit_gateway_id"] = transit_gateway_id
            if transit_gateway_route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_route_table_id'")
            __props__.__dict__["transit_gateway_route_table_id"] = transit_gateway_route_table_id
            __props__.__dict__["original_default_route_table_id"] = None
        super(DefaultRouteTablePropagation, __self__).__init__(
            'aws:ec2transitgateway/defaultRouteTablePropagation:DefaultRouteTablePropagation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            original_default_route_table_id: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[Union['DefaultRouteTablePropagationTimeoutsArgs', 'DefaultRouteTablePropagationTimeoutsArgsDict']]] = None,
            transit_gateway_id: Optional[pulumi.Input[str]] = None,
            transit_gateway_route_table_id: Optional[pulumi.Input[str]] = None) -> 'DefaultRouteTablePropagation':
        """
        Get an existing DefaultRouteTablePropagation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] transit_gateway_id: ID of the Transit Gateway to change the default association route table on.
        :param pulumi.Input[str] transit_gateway_route_table_id: ID of the Transit Gateway Route Table to be made the default association route table.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DefaultRouteTablePropagationState.__new__(_DefaultRouteTablePropagationState)

        __props__.__dict__["original_default_route_table_id"] = original_default_route_table_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["transit_gateway_id"] = transit_gateway_id
        __props__.__dict__["transit_gateway_route_table_id"] = transit_gateway_route_table_id
        return DefaultRouteTablePropagation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="originalDefaultRouteTableId")
    def original_default_route_table_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "original_default_route_table_id")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DefaultRouteTablePropagationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Output[str]:
        """
        ID of the Transit Gateway to change the default association route table on.
        """
        return pulumi.get(self, "transit_gateway_id")

    @property
    @pulumi.getter(name="transitGatewayRouteTableId")
    def transit_gateway_route_table_id(self) -> pulumi.Output[str]:
        """
        ID of the Transit Gateway Route Table to be made the default association route table.
        """
        return pulumi.get(self, "transit_gateway_route_table_id")

