# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TaskSetArgs', 'TaskSet']

@pulumi.input_type
class TaskSetArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[str],
                 service: pulumi.Input[str],
                 task_definition: pulumi.Input[str],
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 launch_type: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]] = None,
                 network_configuration: Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input['TaskSetScaleArgs']] = None,
                 service_registries: Optional[pulumi.Input['TaskSetServiceRegistriesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 wait_until_stable: Optional[pulumi.Input[bool]] = None,
                 wait_until_stable_timeout: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TaskSet resource.
        :param pulumi.Input[str] cluster: The short name or ARN of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[str] service: The short name or ARN of the ECS service.
        :param pulumi.Input[str] task_definition: The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]] capacity_provider_strategies: The capacity provider strategy to use for the service. Can be one or more.  Defined below.
        :param pulumi.Input[str] external_id: The external ID associated with the task set.
        :param pulumi.Input[bool] force_delete: Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
        :param pulumi.Input[str] launch_type: The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
        :param pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]] load_balancers: Details on load balancers that are used with a task set. Detailed below.
        :param pulumi.Input['TaskSetNetworkConfigurationArgs'] network_configuration: The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
        :param pulumi.Input[str] platform_version: The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input['TaskSetScaleArgs'] scale: A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
        :param pulumi.Input['TaskSetServiceRegistriesArgs'] service_registries: The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[bool] wait_until_stable: Whether the provider should wait until the task set has reached `STEADY_STATE`.
        :param pulumi.Input[str] wait_until_stable_timeout: Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "task_definition", task_definition)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if service_registries is not None:
            pulumi.set(__self__, "service_registries", service_registries)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wait_until_stable is not None:
            pulumi.set(__self__, "wait_until_stable", wait_until_stable)
        if wait_until_stable_timeout is not None:
            pulumi.set(__self__, "wait_until_stable_timeout", wait_until_stable_timeout)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[str]:
        """
        The short name or ARN of the cluster that hosts the service to create the task set in.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        The short name or ARN of the ECS service.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> pulumi.Input[str]:
        """
        The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.

        The following arguments are optional:
        """
        return pulumi.get(self, "task_definition")

    @task_definition.setter
    def task_definition(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_definition", value)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]]]:
        """
        The capacity provider strategy to use for the service. Can be one or more.  Defined below.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @capacity_provider_strategies.setter
    def capacity_provider_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]]]):
        pulumi.set(self, "capacity_provider_strategies", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        The external ID associated with the task set.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_type", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]]:
        """
        Details on load balancers that are used with a task set. Detailed below.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']]:
        """
        The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input['TaskSetScaleArgs']]:
        """
        A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input['TaskSetScaleArgs']]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> Optional[pulumi.Input['TaskSetServiceRegistriesArgs']]:
        """
        The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
        """
        return pulumi.get(self, "service_registries")

    @service_registries.setter
    def service_registries(self, value: Optional[pulumi.Input['TaskSetServiceRegistriesArgs']]):
        pulumi.set(self, "service_registries", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="waitUntilStable")
    def wait_until_stable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the provider should wait until the task set has reached `STEADY_STATE`.
        """
        return pulumi.get(self, "wait_until_stable")

    @wait_until_stable.setter
    def wait_until_stable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_stable", value)

    @property
    @pulumi.getter(name="waitUntilStableTimeout")
    def wait_until_stable_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
        """
        return pulumi.get(self, "wait_until_stable_timeout")

    @wait_until_stable_timeout.setter
    def wait_until_stable_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_until_stable_timeout", value)


@pulumi.input_type
class _TaskSetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 launch_type: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]] = None,
                 network_configuration: Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input['TaskSetScaleArgs']] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_registries: Optional[pulumi.Input['TaskSetServiceRegistriesArgs']] = None,
                 stability_status: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 task_definition: Optional[pulumi.Input[str]] = None,
                 task_set_id: Optional[pulumi.Input[str]] = None,
                 wait_until_stable: Optional[pulumi.Input[bool]] = None,
                 wait_until_stable_timeout: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TaskSet resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) that identifies the task set.
        :param pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]] capacity_provider_strategies: The capacity provider strategy to use for the service. Can be one or more.  Defined below.
        :param pulumi.Input[str] cluster: The short name or ARN of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[str] external_id: The external ID associated with the task set.
        :param pulumi.Input[bool] force_delete: Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
        :param pulumi.Input[str] launch_type: The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
        :param pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]] load_balancers: Details on load balancers that are used with a task set. Detailed below.
        :param pulumi.Input['TaskSetNetworkConfigurationArgs'] network_configuration: The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
        :param pulumi.Input[str] platform_version: The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input['TaskSetScaleArgs'] scale: A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
        :param pulumi.Input[str] service: The short name or ARN of the ECS service.
        :param pulumi.Input['TaskSetServiceRegistriesArgs'] service_registries: The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
        :param pulumi.Input[str] stability_status: The stability status. This indicates whether the task set has reached a steady state.
        :param pulumi.Input[str] status: The status of the task set.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] task_definition: The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
               
               The following arguments are optional:
        :param pulumi.Input[str] task_set_id: The ID of the task set.
        :param pulumi.Input[bool] wait_until_stable: Whether the provider should wait until the task set has reached `STEADY_STATE`.
        :param pulumi.Input[str] wait_until_stable_timeout: Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_registries is not None:
            pulumi.set(__self__, "service_registries", service_registries)
        if stability_status is not None:
            pulumi.set(__self__, "stability_status", stability_status)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if task_definition is not None:
            pulumi.set(__self__, "task_definition", task_definition)
        if task_set_id is not None:
            pulumi.set(__self__, "task_set_id", task_set_id)
        if wait_until_stable is not None:
            pulumi.set(__self__, "wait_until_stable", wait_until_stable)
        if wait_until_stable_timeout is not None:
            pulumi.set(__self__, "wait_until_stable_timeout", wait_until_stable_timeout)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) that identifies the task set.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]]]:
        """
        The capacity provider strategy to use for the service. Can be one or more.  Defined below.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @capacity_provider_strategies.setter
    def capacity_provider_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyArgs']]]]):
        pulumi.set(self, "capacity_provider_strategies", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[str]]:
        """
        The short name or ARN of the cluster that hosts the service to create the task set in.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        The external ID associated with the task set.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_type", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]]:
        """
        Details on load balancers that are used with a task set. Detailed below.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']]:
        """
        The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input['TaskSetScaleArgs']]:
        """
        A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input['TaskSetScaleArgs']]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The short name or ARN of the ECS service.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> Optional[pulumi.Input['TaskSetServiceRegistriesArgs']]:
        """
        The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
        """
        return pulumi.get(self, "service_registries")

    @service_registries.setter
    def service_registries(self, value: Optional[pulumi.Input['TaskSetServiceRegistriesArgs']]):
        pulumi.set(self, "service_registries", value)

    @property
    @pulumi.getter(name="stabilityStatus")
    def stability_status(self) -> Optional[pulumi.Input[str]]:
        """
        The stability status. This indicates whether the task set has reached a steady state.
        """
        return pulumi.get(self, "stability_status")

    @stability_status.setter
    def stability_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stability_status", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the task set.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> Optional[pulumi.Input[str]]:
        """
        The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.

        The following arguments are optional:
        """
        return pulumi.get(self, "task_definition")

    @task_definition.setter
    def task_definition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_definition", value)

    @property
    @pulumi.getter(name="taskSetId")
    def task_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the task set.
        """
        return pulumi.get(self, "task_set_id")

    @task_set_id.setter
    def task_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_set_id", value)

    @property
    @pulumi.getter(name="waitUntilStable")
    def wait_until_stable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the provider should wait until the task set has reached `STEADY_STATE`.
        """
        return pulumi.get(self, "wait_until_stable")

    @wait_until_stable.setter
    def wait_until_stable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_until_stable", value)

    @property
    @pulumi.getter(name="waitUntilStableTimeout")
    def wait_until_stable_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
        """
        return pulumi.get(self, "wait_until_stable_timeout")

    @wait_until_stable_timeout.setter
    def wait_until_stable_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_until_stable_timeout", value)


class TaskSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyArgs', 'TaskSetCapacityProviderStrategyArgsDict']]]]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 launch_type: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]]] = None,
                 network_configuration: Optional[pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_registries: Optional[pulumi.Input[Union['TaskSetServiceRegistriesArgs', 'TaskSetServiceRegistriesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 task_definition: Optional[pulumi.Input[str]] = None,
                 wait_until_stable: Optional[pulumi.Input[bool]] = None,
                 wait_until_stable_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an ECS task set - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).

        See [ECS Task Set section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-external.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.TaskSet("example",
            service=example_aws_ecs_service["id"],
            cluster=example_aws_ecs_cluster["id"],
            task_definition=example_aws_ecs_task_definition["arn"],
            load_balancers=[{
                "target_group_arn": example_aws_lb_target_group["arn"],
                "container_name": "mongo",
                "container_port": 8080,
            }])
        ```

        ### Ignoring Changes to Scale

        You can utilize the generic resource lifecycle configuration block with `ignore_changes` to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.TaskSet("example", scale={
            "value": 50,
        })
        ```

        ## Import

        Using `pulumi import`, import ECS Task Sets using the `task_set_id`, `service`, and `cluster` separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:ecs/taskSet:TaskSet example ecs-svc/7177320696926227436,arn:aws:ecs:us-west-2:123456789101:service/example/example-1234567890,arn:aws:ecs:us-west-2:123456789101:cluster/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyArgs', 'TaskSetCapacityProviderStrategyArgsDict']]]] capacity_provider_strategies: The capacity provider strategy to use for the service. Can be one or more.  Defined below.
        :param pulumi.Input[str] cluster: The short name or ARN of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[str] external_id: The external ID associated with the task set.
        :param pulumi.Input[bool] force_delete: Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
        :param pulumi.Input[str] launch_type: The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]] load_balancers: Details on load balancers that are used with a task set. Detailed below.
        :param pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']] network_configuration: The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
        :param pulumi.Input[str] platform_version: The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']] scale: A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
        :param pulumi.Input[str] service: The short name or ARN of the ECS service.
        :param pulumi.Input[Union['TaskSetServiceRegistriesArgs', 'TaskSetServiceRegistriesArgsDict']] service_registries: The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[str] task_definition: The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
               
               The following arguments are optional:
        :param pulumi.Input[bool] wait_until_stable: Whether the provider should wait until the task set has reached `STEADY_STATE`.
        :param pulumi.Input[str] wait_until_stable_timeout: Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ECS task set - effectively a task that is expected to run until an error occurs or a user terminates it (typically a webserver or a database).

        See [ECS Task Set section in AWS developer guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-external.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.TaskSet("example",
            service=example_aws_ecs_service["id"],
            cluster=example_aws_ecs_cluster["id"],
            task_definition=example_aws_ecs_task_definition["arn"],
            load_balancers=[{
                "target_group_arn": example_aws_lb_target_group["arn"],
                "container_name": "mongo",
                "container_port": 8080,
            }])
        ```

        ### Ignoring Changes to Scale

        You can utilize the generic resource lifecycle configuration block with `ignore_changes` to create an ECS service with an initial count of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ecs.TaskSet("example", scale={
            "value": 50,
        })
        ```

        ## Import

        Using `pulumi import`, import ECS Task Sets using the `task_set_id`, `service`, and `cluster` separated by commas (`,`). For example:

        ```sh
        $ pulumi import aws:ecs/taskSet:TaskSet example ecs-svc/7177320696926227436,arn:aws:ecs:us-west-2:123456789101:service/example/example-1234567890,arn:aws:ecs:us-west-2:123456789101:cluster/example
        ```

        :param str resource_name: The name of the resource.
        :param TaskSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyArgs', 'TaskSetCapacityProviderStrategyArgsDict']]]]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 launch_type: Optional[pulumi.Input[str]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]]] = None,
                 network_configuration: Optional[pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_registries: Optional[pulumi.Input[Union['TaskSetServiceRegistriesArgs', 'TaskSetServiceRegistriesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 task_definition: Optional[pulumi.Input[str]] = None,
                 wait_until_stable: Optional[pulumi.Input[bool]] = None,
                 wait_until_stable_timeout: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskSetArgs.__new__(TaskSetArgs)

            __props__.__dict__["capacity_provider_strategies"] = capacity_provider_strategies
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["launch_type"] = launch_type
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["platform_version"] = platform_version
            __props__.__dict__["scale"] = scale
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["service_registries"] = service_registries
            __props__.__dict__["tags"] = tags
            if task_definition is None and not opts.urn:
                raise TypeError("Missing required property 'task_definition'")
            __props__.__dict__["task_definition"] = task_definition
            __props__.__dict__["wait_until_stable"] = wait_until_stable
            __props__.__dict__["wait_until_stable_timeout"] = wait_until_stable_timeout
            __props__.__dict__["arn"] = None
            __props__.__dict__["stability_status"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["task_set_id"] = None
        super(TaskSet, __self__).__init__(
            'aws:ecs/taskSet:TaskSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            capacity_provider_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyArgs', 'TaskSetCapacityProviderStrategyArgsDict']]]]] = None,
            cluster: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            launch_type: Optional[pulumi.Input[str]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]]] = None,
            network_configuration: Optional[pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']]] = None,
            platform_version: Optional[pulumi.Input[str]] = None,
            scale: Optional[pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']]] = None,
            service: Optional[pulumi.Input[str]] = None,
            service_registries: Optional[pulumi.Input[Union['TaskSetServiceRegistriesArgs', 'TaskSetServiceRegistriesArgsDict']]] = None,
            stability_status: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            task_definition: Optional[pulumi.Input[str]] = None,
            task_set_id: Optional[pulumi.Input[str]] = None,
            wait_until_stable: Optional[pulumi.Input[bool]] = None,
            wait_until_stable_timeout: Optional[pulumi.Input[str]] = None) -> 'TaskSet':
        """
        Get an existing TaskSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) that identifies the task set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyArgs', 'TaskSetCapacityProviderStrategyArgsDict']]]] capacity_provider_strategies: The capacity provider strategy to use for the service. Can be one or more.  Defined below.
        :param pulumi.Input[str] cluster: The short name or ARN of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[str] external_id: The external ID associated with the task set.
        :param pulumi.Input[bool] force_delete: Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
        :param pulumi.Input[str] launch_type: The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]] load_balancers: Details on load balancers that are used with a task set. Detailed below.
        :param pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']] network_configuration: The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
        :param pulumi.Input[str] platform_version: The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']] scale: A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
        :param pulumi.Input[str] service: The short name or ARN of the ECS service.
        :param pulumi.Input[Union['TaskSetServiceRegistriesArgs', 'TaskSetServiceRegistriesArgsDict']] service_registries: The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
        :param pulumi.Input[str] stability_status: The stability status. This indicates whether the task set has reached a steady state.
        :param pulumi.Input[str] status: The status of the task set.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[str] task_definition: The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.
               
               The following arguments are optional:
        :param pulumi.Input[str] task_set_id: The ID of the task set.
        :param pulumi.Input[bool] wait_until_stable: Whether the provider should wait until the task set has reached `STEADY_STATE`.
        :param pulumi.Input[str] wait_until_stable_timeout: Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskSetState.__new__(_TaskSetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["capacity_provider_strategies"] = capacity_provider_strategies
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["launch_type"] = launch_type
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["platform_version"] = platform_version
        __props__.__dict__["scale"] = scale
        __props__.__dict__["service"] = service
        __props__.__dict__["service_registries"] = service_registries
        __props__.__dict__["stability_status"] = stability_status
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["task_definition"] = task_definition
        __props__.__dict__["task_set_id"] = task_set_id
        __props__.__dict__["wait_until_stable"] = wait_until_stable
        __props__.__dict__["wait_until_stable_timeout"] = wait_until_stable_timeout
        return TaskSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) that identifies the task set.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> pulumi.Output[Optional[Sequence['outputs.TaskSetCapacityProviderStrategy']]]:
        """
        The capacity provider strategy to use for the service. Can be one or more.  Defined below.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[str]:
        """
        The short name or ARN of the cluster that hosts the service to create the task set in.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        The external ID associated with the task set.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow deleting the task set without waiting for scaling down to 0. You can force a task set to delete even if it's in the process of scaling a resource. Normally, the provider drains all the tasks before deleting the task set. This bypasses that behavior and potentially leaves resources dangling.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> pulumi.Output[str]:
        """
        The launch type on which to run your service. The valid values are `EC2`, `FARGATE`, and `EXTERNAL`. Defaults to `EC2`.
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Optional[Sequence['outputs.TaskSetLoadBalancer']]]:
        """
        Details on load balancers that are used with a task set. Detailed below.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.TaskSetNetworkConfiguration']]:
        """
        The network configuration for the service. This parameter is required for task definitions that use the `awsvpc` network mode to receive their own Elastic Network Interface, and it is not supported for other network modes. Detailed below.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[str]:
        """
        The platform version on which to run your service. Only applicable for `launch_type` set to `FARGATE`. Defaults to `LATEST`. More information about Fargate platform versions can be found in the [AWS ECS User Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def scale(self) -> pulumi.Output['outputs.TaskSetScale']:
        """
        A floating-point percentage of the desired number of tasks to place and keep running in the task set. Detailed below.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        The short name or ARN of the ECS service.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> pulumi.Output[Optional['outputs.TaskSetServiceRegistries']]:
        """
        The service discovery registries for the service. The maximum number of `service_registries` blocks is `1`. Detailed below.
        """
        return pulumi.get(self, "service_registries")

    @property
    @pulumi.getter(name="stabilityStatus")
    def stability_status(self) -> pulumi.Output[str]:
        """
        The stability status. This indicates whether the task set has reached a steady state.
        """
        return pulumi.get(self, "stability_status")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the task set.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> pulumi.Output[str]:
        """
        The family and revision (`family:revision`) or full ARN of the task definition that you want to run in your service.

        The following arguments are optional:
        """
        return pulumi.get(self, "task_definition")

    @property
    @pulumi.getter(name="taskSetId")
    def task_set_id(self) -> pulumi.Output[str]:
        """
        The ID of the task set.
        """
        return pulumi.get(self, "task_set_id")

    @property
    @pulumi.getter(name="waitUntilStable")
    def wait_until_stable(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the provider should wait until the task set has reached `STEADY_STATE`.
        """
        return pulumi.get(self, "wait_until_stable")

    @property
    @pulumi.getter(name="waitUntilStableTimeout")
    def wait_until_stable_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        Wait timeout for task set to reach `STEADY_STATE`. Valid time units include `ns`, `us` (or `µs`), `ms`, `s`, `m`, and `h`. Default `10m`.
        """
        return pulumi.get(self, "wait_until_stable_timeout")

