# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReservedCacheNodeArgs', 'ReservedCacheNode']

@pulumi.input_type
class ReservedCacheNodeArgs:
    def __init__(__self__, *,
                 reserved_cache_nodes_offering_id: pulumi.Input[str],
                 cache_node_count: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['ReservedCacheNodeTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ReservedCacheNode resource.
        :param pulumi.Input[str] reserved_cache_nodes_offering_id: ID of the reserved cache node offering to purchase.
               To determine an `reserved_cache_nodes_offering_id`, see the `elasticache_get_reserved_cache_node_offering` data source.
               
               The following arguments are optional:
        :param pulumi.Input[float] cache_node_count: Number of cache node instances to reserve.
               Default value is `1`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "reserved_cache_nodes_offering_id", reserved_cache_nodes_offering_id)
        if cache_node_count is not None:
            pulumi.set(__self__, "cache_node_count", cache_node_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="reservedCacheNodesOfferingId")
    def reserved_cache_nodes_offering_id(self) -> pulumi.Input[str]:
        """
        ID of the reserved cache node offering to purchase.
        To determine an `reserved_cache_nodes_offering_id`, see the `elasticache_get_reserved_cache_node_offering` data source.

        The following arguments are optional:
        """
        return pulumi.get(self, "reserved_cache_nodes_offering_id")

    @reserved_cache_nodes_offering_id.setter
    def reserved_cache_nodes_offering_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "reserved_cache_nodes_offering_id", value)

    @property
    @pulumi.getter(name="cacheNodeCount")
    def cache_node_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of cache node instances to reserve.
        Default value is `1`.
        """
        return pulumi.get(self, "cache_node_count")

    @cache_node_count.setter
    def cache_node_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cache_node_count", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ReservedCacheNodeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ReservedCacheNodeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ReservedCacheNodeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 cache_node_count: Optional[pulumi.Input[float]] = None,
                 cache_node_type: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 fixed_price: Optional[pulumi.Input[float]] = None,
                 offering_type: Optional[pulumi.Input[str]] = None,
                 product_description: Optional[pulumi.Input[str]] = None,
                 recurring_charges: Optional[pulumi.Input[Sequence[pulumi.Input['ReservedCacheNodeRecurringChargeArgs']]]] = None,
                 reserved_cache_nodes_offering_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['ReservedCacheNodeTimeoutsArgs']] = None,
                 usage_price: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering ReservedCacheNode resources.
        :param pulumi.Input[str] arn: ARN for the reserved cache node.
        :param pulumi.Input[float] cache_node_count: Number of cache node instances to reserve.
               Default value is `1`.
        :param pulumi.Input[str] cache_node_type: Node type for the reserved cache nodes.
        :param pulumi.Input[str] duration: Duration of the reservation as an RFC3339 duration.
        :param pulumi.Input[float] fixed_price: Fixed price charged for this reserved cache node.
        :param pulumi.Input[str] offering_type: Offering type of this reserved cache node.
        :param pulumi.Input[str] product_description: Engine type for the reserved cache node.
        :param pulumi.Input[Sequence[pulumi.Input['ReservedCacheNodeRecurringChargeArgs']]] recurring_charges: Recurring price charged to run this reserved cache node.
        :param pulumi.Input[str] reserved_cache_nodes_offering_id: ID of the reserved cache node offering to purchase.
               To determine an `reserved_cache_nodes_offering_id`, see the `elasticache_get_reserved_cache_node_offering` data source.
               
               The following arguments are optional:
        :param pulumi.Input[str] start_time: Time the reservation started.
        :param pulumi.Input[str] state: State of the reserved cache node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[float] usage_price: Hourly price charged for this reserved cache node.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cache_node_count is not None:
            pulumi.set(__self__, "cache_node_count", cache_node_count)
        if cache_node_type is not None:
            pulumi.set(__self__, "cache_node_type", cache_node_type)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if fixed_price is not None:
            pulumi.set(__self__, "fixed_price", fixed_price)
        if offering_type is not None:
            pulumi.set(__self__, "offering_type", offering_type)
        if product_description is not None:
            pulumi.set(__self__, "product_description", product_description)
        if recurring_charges is not None:
            pulumi.set(__self__, "recurring_charges", recurring_charges)
        if reserved_cache_nodes_offering_id is not None:
            pulumi.set(__self__, "reserved_cache_nodes_offering_id", reserved_cache_nodes_offering_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if usage_price is not None:
            pulumi.set(__self__, "usage_price", usage_price)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the reserved cache node.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cacheNodeCount")
    def cache_node_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of cache node instances to reserve.
        Default value is `1`.
        """
        return pulumi.get(self, "cache_node_count")

    @cache_node_count.setter
    def cache_node_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cache_node_count", value)

    @property
    @pulumi.getter(name="cacheNodeType")
    def cache_node_type(self) -> Optional[pulumi.Input[str]]:
        """
        Node type for the reserved cache nodes.
        """
        return pulumi.get(self, "cache_node_type")

    @cache_node_type.setter
    def cache_node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_node_type", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        Duration of the reservation as an RFC3339 duration.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="fixedPrice")
    def fixed_price(self) -> Optional[pulumi.Input[float]]:
        """
        Fixed price charged for this reserved cache node.
        """
        return pulumi.get(self, "fixed_price")

    @fixed_price.setter
    def fixed_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "fixed_price", value)

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> Optional[pulumi.Input[str]]:
        """
        Offering type of this reserved cache node.
        """
        return pulumi.get(self, "offering_type")

    @offering_type.setter
    def offering_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offering_type", value)

    @property
    @pulumi.getter(name="productDescription")
    def product_description(self) -> Optional[pulumi.Input[str]]:
        """
        Engine type for the reserved cache node.
        """
        return pulumi.get(self, "product_description")

    @product_description.setter
    def product_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_description", value)

    @property
    @pulumi.getter(name="recurringCharges")
    def recurring_charges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReservedCacheNodeRecurringChargeArgs']]]]:
        """
        Recurring price charged to run this reserved cache node.
        """
        return pulumi.get(self, "recurring_charges")

    @recurring_charges.setter
    def recurring_charges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReservedCacheNodeRecurringChargeArgs']]]]):
        pulumi.set(self, "recurring_charges", value)

    @property
    @pulumi.getter(name="reservedCacheNodesOfferingId")
    def reserved_cache_nodes_offering_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the reserved cache node offering to purchase.
        To determine an `reserved_cache_nodes_offering_id`, see the `elasticache_get_reserved_cache_node_offering` data source.

        The following arguments are optional:
        """
        return pulumi.get(self, "reserved_cache_nodes_offering_id")

    @reserved_cache_nodes_offering_id.setter
    def reserved_cache_nodes_offering_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_cache_nodes_offering_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the reservation started.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the reserved cache node.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ReservedCacheNodeTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ReservedCacheNodeTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="usagePrice")
    def usage_price(self) -> Optional[pulumi.Input[float]]:
        """
        Hourly price charged for this reserved cache node.
        """
        return pulumi.get(self, "usage_price")

    @usage_price.setter
    def usage_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "usage_price", value)


class ReservedCacheNode(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_node_count: Optional[pulumi.Input[float]] = None,
                 reserved_cache_nodes_offering_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ReservedCacheNodeTimeoutsArgs', 'ReservedCacheNodeTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages an ElastiCache Reserved Cache Node.

        > **NOTE:** Once created, a reservation is valid for the `duration` of the provided `offering_id` and cannot be deleted. Performing a `destroy` will only remove the resource from state. For more information see [ElastiCache Reserved Nodes Documentation](https://aws.amazon.com/elasticache/reserved-cache-nodes/) and [PurchaseReservedCacheNodesOffering](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_PurchaseReservedCacheNodesOffering.html).

        > **NOTE:** Due to the expense of testing this resource, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.

        ## Import

        Using `pulumi import`, import ElastiCache Reserved Cache Node using the `id`. For example:

        ```sh
        $ pulumi import aws:elasticache/reservedCacheNode:ReservedCacheNode example CustomReservationID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] cache_node_count: Number of cache node instances to reserve.
               Default value is `1`.
        :param pulumi.Input[str] reserved_cache_nodes_offering_id: ID of the reserved cache node offering to purchase.
               To determine an `reserved_cache_nodes_offering_id`, see the `elasticache_get_reserved_cache_node_offering` data source.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReservedCacheNodeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ElastiCache Reserved Cache Node.

        > **NOTE:** Once created, a reservation is valid for the `duration` of the provided `offering_id` and cannot be deleted. Performing a `destroy` will only remove the resource from state. For more information see [ElastiCache Reserved Nodes Documentation](https://aws.amazon.com/elasticache/reserved-cache-nodes/) and [PurchaseReservedCacheNodesOffering](https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_PurchaseReservedCacheNodesOffering.html).

        > **NOTE:** Due to the expense of testing this resource, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.

        ## Import

        Using `pulumi import`, import ElastiCache Reserved Cache Node using the `id`. For example:

        ```sh
        $ pulumi import aws:elasticache/reservedCacheNode:ReservedCacheNode example CustomReservationID
        ```

        :param str resource_name: The name of the resource.
        :param ReservedCacheNodeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReservedCacheNodeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_node_count: Optional[pulumi.Input[float]] = None,
                 reserved_cache_nodes_offering_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['ReservedCacheNodeTimeoutsArgs', 'ReservedCacheNodeTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReservedCacheNodeArgs.__new__(ReservedCacheNodeArgs)

            __props__.__dict__["cache_node_count"] = cache_node_count
            if reserved_cache_nodes_offering_id is None and not opts.urn:
                raise TypeError("Missing required property 'reserved_cache_nodes_offering_id'")
            __props__.__dict__["reserved_cache_nodes_offering_id"] = reserved_cache_nodes_offering_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["cache_node_type"] = None
            __props__.__dict__["duration"] = None
            __props__.__dict__["fixed_price"] = None
            __props__.__dict__["offering_type"] = None
            __props__.__dict__["product_description"] = None
            __props__.__dict__["recurring_charges"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["usage_price"] = None
        super(ReservedCacheNode, __self__).__init__(
            'aws:elasticache/reservedCacheNode:ReservedCacheNode',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            cache_node_count: Optional[pulumi.Input[float]] = None,
            cache_node_type: Optional[pulumi.Input[str]] = None,
            duration: Optional[pulumi.Input[str]] = None,
            fixed_price: Optional[pulumi.Input[float]] = None,
            offering_type: Optional[pulumi.Input[str]] = None,
            product_description: Optional[pulumi.Input[str]] = None,
            recurring_charges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReservedCacheNodeRecurringChargeArgs', 'ReservedCacheNodeRecurringChargeArgsDict']]]]] = None,
            reserved_cache_nodes_offering_id: Optional[pulumi.Input[str]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['ReservedCacheNodeTimeoutsArgs', 'ReservedCacheNodeTimeoutsArgsDict']]] = None,
            usage_price: Optional[pulumi.Input[float]] = None) -> 'ReservedCacheNode':
        """
        Get an existing ReservedCacheNode resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN for the reserved cache node.
        :param pulumi.Input[float] cache_node_count: Number of cache node instances to reserve.
               Default value is `1`.
        :param pulumi.Input[str] cache_node_type: Node type for the reserved cache nodes.
        :param pulumi.Input[str] duration: Duration of the reservation as an RFC3339 duration.
        :param pulumi.Input[float] fixed_price: Fixed price charged for this reserved cache node.
        :param pulumi.Input[str] offering_type: Offering type of this reserved cache node.
        :param pulumi.Input[str] product_description: Engine type for the reserved cache node.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReservedCacheNodeRecurringChargeArgs', 'ReservedCacheNodeRecurringChargeArgsDict']]]] recurring_charges: Recurring price charged to run this reserved cache node.
        :param pulumi.Input[str] reserved_cache_nodes_offering_id: ID of the reserved cache node offering to purchase.
               To determine an `reserved_cache_nodes_offering_id`, see the `elasticache_get_reserved_cache_node_offering` data source.
               
               The following arguments are optional:
        :param pulumi.Input[str] start_time: Time the reservation started.
        :param pulumi.Input[str] state: State of the reserved cache node.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[float] usage_price: Hourly price charged for this reserved cache node.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReservedCacheNodeState.__new__(_ReservedCacheNodeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cache_node_count"] = cache_node_count
        __props__.__dict__["cache_node_type"] = cache_node_type
        __props__.__dict__["duration"] = duration
        __props__.__dict__["fixed_price"] = fixed_price
        __props__.__dict__["offering_type"] = offering_type
        __props__.__dict__["product_description"] = product_description
        __props__.__dict__["recurring_charges"] = recurring_charges
        __props__.__dict__["reserved_cache_nodes_offering_id"] = reserved_cache_nodes_offering_id
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["usage_price"] = usage_price
        return ReservedCacheNode(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN for the reserved cache node.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cacheNodeCount")
    def cache_node_count(self) -> pulumi.Output[float]:
        """
        Number of cache node instances to reserve.
        Default value is `1`.
        """
        return pulumi.get(self, "cache_node_count")

    @property
    @pulumi.getter(name="cacheNodeType")
    def cache_node_type(self) -> pulumi.Output[str]:
        """
        Node type for the reserved cache nodes.
        """
        return pulumi.get(self, "cache_node_type")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[str]:
        """
        Duration of the reservation as an RFC3339 duration.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="fixedPrice")
    def fixed_price(self) -> pulumi.Output[float]:
        """
        Fixed price charged for this reserved cache node.
        """
        return pulumi.get(self, "fixed_price")

    @property
    @pulumi.getter(name="offeringType")
    def offering_type(self) -> pulumi.Output[str]:
        """
        Offering type of this reserved cache node.
        """
        return pulumi.get(self, "offering_type")

    @property
    @pulumi.getter(name="productDescription")
    def product_description(self) -> pulumi.Output[str]:
        """
        Engine type for the reserved cache node.
        """
        return pulumi.get(self, "product_description")

    @property
    @pulumi.getter(name="recurringCharges")
    def recurring_charges(self) -> pulumi.Output[Sequence['outputs.ReservedCacheNodeRecurringCharge']]:
        """
        Recurring price charged to run this reserved cache node.
        """
        return pulumi.get(self, "recurring_charges")

    @property
    @pulumi.getter(name="reservedCacheNodesOfferingId")
    def reserved_cache_nodes_offering_id(self) -> pulumi.Output[str]:
        """
        ID of the reserved cache node offering to purchase.
        To determine an `reserved_cache_nodes_offering_id`, see the `elasticache_get_reserved_cache_node_offering` data source.

        The following arguments are optional:
        """
        return pulumi.get(self, "reserved_cache_nodes_offering_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        Time the reservation started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the reserved cache node.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the reservation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ReservedCacheNodeTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="usagePrice")
    def usage_price(self) -> pulumi.Output[float]:
        """
        Hourly price charged for this reserved cache node.
        """
        return pulumi.get(self, "usage_price")

