# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OpenZfsFileSystemArgs', 'OpenZfsFileSystem']

@pulumi.input_type
class OpenZfsFileSystemArgs:
    def __init__(__self__, *,
                 deployment_type: pulumi.Input[str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 throughput_capacity: pulumi.Input[int],
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 copy_tags_to_volumes: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs']] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 root_volume_configuration: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs']] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OpenZfsFileSystem resource.
        :param pulumi.Input[str] deployment_type: Filesystem deployment type. See the [AWS API documentation](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemOpenZFSConfiguration.html#FSx-Type-CreateFileSystemOpenZFSConfiguration-DeploymentType) for a list of valid values.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from.
        :param pulumi.Input[int] throughput_capacity: Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
               
               The following arguments are optional:
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
        :param pulumi.Input[bool] copy_tags_to_volumes: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delete_options: List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
        :param pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs'] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[str] endpoint_ip_address_range: (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[str] preferred_subnet_id: (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
        :param pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs'] root_volume_configuration: The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. Only `SSD` is supported.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        pulumi.set(__self__, "deployment_type", deployment_type)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if copy_tags_to_volumes is not None:
            pulumi.set(__self__, "copy_tags_to_volumes", copy_tags_to_volumes)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if endpoint_ip_address_range is not None:
            pulumi.set(__self__, "endpoint_ip_address_range", endpoint_ip_address_range)
        if final_backup_tags is not None:
            pulumi.set(__self__, "final_backup_tags", final_backup_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if root_volume_configuration is not None:
            pulumi.set(__self__, "root_volume_configuration", root_volume_configuration)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if skip_final_backup is not None:
            pulumi.set(__self__, "skip_final_backup", skip_final_backup)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Input[str]:
        """
        Filesystem deployment type. See the [AWS API documentation](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemOpenZFSConfiguration.html#FSx-Type-CreateFileSystemOpenZFSConfiguration-DeploymentType) for a list of valid values.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of IDs for the subnets that the file system will be accessible from.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> pulumi.Input[int]:
        """
        Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.

        The following arguments are optional:
        """
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source backup to create the filesystem from.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="copyTagsToVolumes")
    def copy_tags_to_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_volumes")

    @copy_tags_to_volumes.setter
    def copy_tags_to_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_volumes", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
        """
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delete_options", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs']]:
        """
        The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> Optional[pulumi.Input[str]]:
        """
        (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
        """
        return pulumi.get(self, "endpoint_ip_address_range")

    @endpoint_ip_address_range.setter
    def endpoint_ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address_range", value)

    @property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to apply to the file system's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @final_backup_tags.setter
    def final_backup_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "final_backup_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
        """
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="rootVolumeConfiguration")
    def root_volume_configuration(self) -> Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs']]:
        """
        The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
        """
        return pulumi.get(self, "root_volume_configuration")

    @root_volume_configuration.setter
    def root_volume_configuration(self, value: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs']]):
        pulumi.set(self, "root_volume_configuration", value)

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        """
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @skip_final_backup.setter
    def skip_final_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_backup", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The filesystem storage type. Only `SSD` is supported.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


@pulumi.input_type
class _OpenZfsFileSystemState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 copy_tags_to_volumes: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs']] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 endpoint_ip_address: Optional[pulumi.Input[str]] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 root_volume_configuration: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs']] = None,
                 root_volume_id: Optional[pulumi.Input[str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OpenZfsFileSystem resources.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
        :param pulumi.Input[bool] copy_tags_to_volumes: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delete_options: List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
        :param pulumi.Input[str] deployment_type: Filesystem deployment type. See the [AWS API documentation](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemOpenZFSConfiguration.html#FSx-Type-CreateFileSystemOpenZFSConfiguration-DeploymentType) for a list of valid values.
        :param pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs'] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[str] dns_name: DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
        :param pulumi.Input[str] endpoint_ip_address: IP address of the endpoint that is used to access data or to manage the file system.
        :param pulumi.Input[str] endpoint_ip_address_range: (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[str] preferred_subnet_id: (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
        :param pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs'] root_volume_configuration: The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
        :param pulumi.Input[str] root_volume_id: Identifier of the root volume, e.g., `fsvol-12345678`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. Only `SSD` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] throughput_capacity: Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
               
               The following arguments are optional:
        :param pulumi.Input[str] vpc_id: Identifier of the Virtual Private Cloud for the file system.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if automatic_backup_retention_days is not None:
            pulumi.set(__self__, "automatic_backup_retention_days", automatic_backup_retention_days)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if copy_tags_to_backups is not None:
            pulumi.set(__self__, "copy_tags_to_backups", copy_tags_to_backups)
        if copy_tags_to_volumes is not None:
            pulumi.set(__self__, "copy_tags_to_volumes", copy_tags_to_volumes)
        if daily_automatic_backup_start_time is not None:
            pulumi.set(__self__, "daily_automatic_backup_start_time", daily_automatic_backup_start_time)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if disk_iops_configuration is not None:
            pulumi.set(__self__, "disk_iops_configuration", disk_iops_configuration)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if endpoint_ip_address is not None:
            pulumi.set(__self__, "endpoint_ip_address", endpoint_ip_address)
        if endpoint_ip_address_range is not None:
            pulumi.set(__self__, "endpoint_ip_address_range", endpoint_ip_address_range)
        if final_backup_tags is not None:
            pulumi.set(__self__, "final_backup_tags", final_backup_tags)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if network_interface_ids is not None:
            pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if preferred_subnet_id is not None:
            pulumi.set(__self__, "preferred_subnet_id", preferred_subnet_id)
        if root_volume_configuration is not None:
            pulumi.set(__self__, "root_volume_configuration", root_volume_configuration)
        if root_volume_id is not None:
            pulumi.set(__self__, "root_volume_id", root_volume_id)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if skip_final_backup is not None:
            pulumi.set(__self__, "skip_final_backup", skip_final_backup)
        if storage_capacity is not None:
            pulumi.set(__self__, "storage_capacity", storage_capacity)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if throughput_capacity is not None:
            pulumi.set(__self__, "throughput_capacity", throughput_capacity)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if weekly_maintenance_start_time is not None:
            pulumi.set(__self__, "weekly_maintenance_start_time", weekly_maintenance_start_time)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @automatic_backup_retention_days.setter
    def automatic_backup_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "automatic_backup_retention_days", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the source backup to create the filesystem from.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @copy_tags_to_backups.setter
    def copy_tags_to_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_backups", value)

    @property
    @pulumi.getter(name="copyTagsToVolumes")
    def copy_tags_to_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_volumes")

    @copy_tags_to_volumes.setter
    def copy_tags_to_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_volumes", value)

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @daily_automatic_backup_start_time.setter
    def daily_automatic_backup_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "daily_automatic_backup_start_time", value)

    @property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
        """
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delete_options", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Filesystem deployment type. See the [AWS API documentation](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemOpenZFSConfiguration.html#FSx-Type-CreateFileSystemOpenZFSConfiguration-DeploymentType) for a list of valid values.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> Optional[pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs']]:
        """
        The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @disk_iops_configuration.setter
    def disk_iops_configuration(self, value: Optional[pulumi.Input['OpenZfsFileSystemDiskIopsConfigurationArgs']]):
        pulumi.set(self, "disk_iops_configuration", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the endpoint that is used to access data or to manage the file system.
        """
        return pulumi.get(self, "endpoint_ip_address")

    @endpoint_ip_address.setter
    def endpoint_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address", value)

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> Optional[pulumi.Input[str]]:
        """
        (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
        """
        return pulumi.get(self, "endpoint_ip_address_range")

    @endpoint_ip_address_range.setter
    def endpoint_ip_address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address_range", value)

    @property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to apply to the file system's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @final_backup_tags.setter
    def final_backup_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "final_backup_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        """
        return pulumi.get(self, "network_interface_ids")

    @network_interface_ids.setter
    def network_interface_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_interface_ids", value)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
        """
        return pulumi.get(self, "preferred_subnet_id")

    @preferred_subnet_id.setter
    def preferred_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_subnet_id", value)

    @property
    @pulumi.getter(name="rootVolumeConfiguration")
    def root_volume_configuration(self) -> Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs']]:
        """
        The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
        """
        return pulumi.get(self, "root_volume_configuration")

    @root_volume_configuration.setter
    def root_volume_configuration(self, value: Optional[pulumi.Input['OpenZfsFileSystemRootVolumeConfigurationArgs']]):
        pulumi.set(self, "root_volume_configuration", value)

    @property
    @pulumi.getter(name="rootVolumeId")
    def root_volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the root volume, e.g., `fsvol-12345678`
        """
        return pulumi.get(self, "root_volume_id")

    @root_volume_id.setter
    def root_volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_volume_id", value)

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        """
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @skip_final_backup.setter
    def skip_final_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_backup", value)

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
        """
        return pulumi.get(self, "storage_capacity")

    @storage_capacity.setter
    def storage_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_capacity", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        The filesystem storage type. Only `SSD` is supported.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs for the subnets that the file system will be accessible from.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.

        The following arguments are optional:
        """
        return pulumi.get(self, "throughput_capacity")

    @throughput_capacity.setter
    def throughput_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throughput_capacity", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the Virtual Private Cloud for the file system.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

    @weekly_maintenance_start_time.setter
    def weekly_maintenance_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weekly_maintenance_start_time", value)


class OpenZfsFileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 copy_tags_to_volumes: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input[Union['OpenZfsFileSystemDiskIopsConfigurationArgs', 'OpenZfsFileSystemDiskIopsConfigurationArgsDict']]] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 root_volume_configuration: Optional[pulumi.Input[Union['OpenZfsFileSystemRootVolumeConfigurationArgs', 'OpenZfsFileSystemRootVolumeConfigurationArgsDict']]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an Amazon FSx for OpenZFS file system.
        See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OpenZfsFileSystem("test",
            storage_capacity=64,
            subnet_ids=[test1["id"]],
            deployment_type="SINGLE_AZ_1",
            throughput_capacity=64)
        ```

        ## Import

        Using `pulumi import`, import FSx File Systems using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/openZfsFileSystem:OpenZfsFileSystem example fs-543ab12b1ca672f33
        ```
        Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
        :param pulumi.Input[bool] copy_tags_to_volumes: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delete_options: List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
        :param pulumi.Input[str] deployment_type: Filesystem deployment type. See the [AWS API documentation](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemOpenZFSConfiguration.html#FSx-Type-CreateFileSystemOpenZFSConfiguration-DeploymentType) for a list of valid values.
        :param pulumi.Input[Union['OpenZfsFileSystemDiskIopsConfigurationArgs', 'OpenZfsFileSystemDiskIopsConfigurationArgsDict']] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[str] endpoint_ip_address_range: (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[str] preferred_subnet_id: (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
        :param pulumi.Input[Union['OpenZfsFileSystemRootVolumeConfigurationArgs', 'OpenZfsFileSystemRootVolumeConfigurationArgsDict']] root_volume_configuration: The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. Only `SSD` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[int] throughput_capacity: Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
               
               The following arguments are optional:
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OpenZfsFileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon FSx for OpenZFS file system.
        See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.fsx.OpenZfsFileSystem("test",
            storage_capacity=64,
            subnet_ids=[test1["id"]],
            deployment_type="SINGLE_AZ_1",
            throughput_capacity=64)
        ```

        ## Import

        Using `pulumi import`, import FSx File Systems using the `id`. For example:

        ```sh
        $ pulumi import aws:fsx/openZfsFileSystem:OpenZfsFileSystem example fs-543ab12b1ca672f33
        ```
        Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:

        :param str resource_name: The name of the resource.
        :param OpenZfsFileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OpenZfsFileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
                 copy_tags_to_volumes: Optional[pulumi.Input[bool]] = None,
                 daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 disk_iops_configuration: Optional[pulumi.Input[Union['OpenZfsFileSystemDiskIopsConfigurationArgs', 'OpenZfsFileSystemDiskIopsConfigurationArgsDict']]] = None,
                 endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
                 final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 preferred_subnet_id: Optional[pulumi.Input[str]] = None,
                 root_volume_configuration: Optional[pulumi.Input[Union['OpenZfsFileSystemRootVolumeConfigurationArgs', 'OpenZfsFileSystemRootVolumeConfigurationArgsDict']]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 skip_final_backup: Optional[pulumi.Input[bool]] = None,
                 storage_capacity: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 throughput_capacity: Optional[pulumi.Input[int]] = None,
                 weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OpenZfsFileSystemArgs.__new__(OpenZfsFileSystemArgs)

            __props__.__dict__["automatic_backup_retention_days"] = automatic_backup_retention_days
            __props__.__dict__["backup_id"] = backup_id
            __props__.__dict__["copy_tags_to_backups"] = copy_tags_to_backups
            __props__.__dict__["copy_tags_to_volumes"] = copy_tags_to_volumes
            __props__.__dict__["daily_automatic_backup_start_time"] = daily_automatic_backup_start_time
            __props__.__dict__["delete_options"] = delete_options
            if deployment_type is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_type'")
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["disk_iops_configuration"] = disk_iops_configuration
            __props__.__dict__["endpoint_ip_address_range"] = endpoint_ip_address_range
            __props__.__dict__["final_backup_tags"] = final_backup_tags
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["preferred_subnet_id"] = preferred_subnet_id
            __props__.__dict__["root_volume_configuration"] = root_volume_configuration
            __props__.__dict__["route_table_ids"] = route_table_ids
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["skip_final_backup"] = skip_final_backup
            __props__.__dict__["storage_capacity"] = storage_capacity
            __props__.__dict__["storage_type"] = storage_type
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            if throughput_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'throughput_capacity'")
            __props__.__dict__["throughput_capacity"] = throughput_capacity
            __props__.__dict__["weekly_maintenance_start_time"] = weekly_maintenance_start_time
            __props__.__dict__["arn"] = None
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["endpoint_ip_address"] = None
            __props__.__dict__["network_interface_ids"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["root_volume_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(OpenZfsFileSystem, __self__).__init__(
            'aws:fsx/openZfsFileSystem:OpenZfsFileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            automatic_backup_retention_days: Optional[pulumi.Input[int]] = None,
            backup_id: Optional[pulumi.Input[str]] = None,
            copy_tags_to_backups: Optional[pulumi.Input[bool]] = None,
            copy_tags_to_volumes: Optional[pulumi.Input[bool]] = None,
            daily_automatic_backup_start_time: Optional[pulumi.Input[str]] = None,
            delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            disk_iops_configuration: Optional[pulumi.Input[Union['OpenZfsFileSystemDiskIopsConfigurationArgs', 'OpenZfsFileSystemDiskIopsConfigurationArgsDict']]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            endpoint_ip_address: Optional[pulumi.Input[str]] = None,
            endpoint_ip_address_range: Optional[pulumi.Input[str]] = None,
            final_backup_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            owner_id: Optional[pulumi.Input[str]] = None,
            preferred_subnet_id: Optional[pulumi.Input[str]] = None,
            root_volume_configuration: Optional[pulumi.Input[Union['OpenZfsFileSystemRootVolumeConfigurationArgs', 'OpenZfsFileSystemRootVolumeConfigurationArgsDict']]] = None,
            root_volume_id: Optional[pulumi.Input[str]] = None,
            route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            skip_final_backup: Optional[pulumi.Input[bool]] = None,
            storage_capacity: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            throughput_capacity: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            weekly_maintenance_start_time: Optional[pulumi.Input[str]] = None) -> 'OpenZfsFileSystem':
        """
        Get an existing OpenZfsFileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: Amazon Resource Name of the file system.
        :param pulumi.Input[int] automatic_backup_retention_days: The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        :param pulumi.Input[str] backup_id: The ID of the source backup to create the filesystem from.
        :param pulumi.Input[bool] copy_tags_to_backups: A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
        :param pulumi.Input[bool] copy_tags_to_volumes: A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        :param pulumi.Input[str] daily_automatic_backup_start_time: A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delete_options: List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
        :param pulumi.Input[str] deployment_type: Filesystem deployment type. See the [AWS API documentation](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemOpenZFSConfiguration.html#FSx-Type-CreateFileSystemOpenZFSConfiguration-DeploymentType) for a list of valid values.
        :param pulumi.Input[Union['OpenZfsFileSystemDiskIopsConfigurationArgs', 'OpenZfsFileSystemDiskIopsConfigurationArgsDict']] disk_iops_configuration: The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
        :param pulumi.Input[str] dns_name: DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
        :param pulumi.Input[str] endpoint_ip_address: IP address of the endpoint that is used to access data or to manage the file system.
        :param pulumi.Input[str] endpoint_ip_address_range: (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] final_backup_tags: A map of tags to apply to the file system's final backup.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        :param pulumi.Input[str] owner_id: AWS account identifier that created the file system.
        :param pulumi.Input[str] preferred_subnet_id: (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
        :param pulumi.Input[Union['OpenZfsFileSystemRootVolumeConfigurationArgs', 'OpenZfsFileSystemRootVolumeConfigurationArgsDict']] root_volume_configuration: The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
        :param pulumi.Input[str] root_volume_id: Identifier of the root volume, e.g., `fsvol-12345678`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_ids: (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        :param pulumi.Input[bool] skip_final_backup: When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        :param pulumi.Input[int] storage_capacity: The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
        :param pulumi.Input[str] storage_type: The filesystem storage type. Only `SSD` is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: A list of IDs for the subnets that the file system will be accessible from.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[int] throughput_capacity: Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
               
               The following arguments are optional:
        :param pulumi.Input[str] vpc_id: Identifier of the Virtual Private Cloud for the file system.
        :param pulumi.Input[str] weekly_maintenance_start_time: The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OpenZfsFileSystemState.__new__(_OpenZfsFileSystemState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["automatic_backup_retention_days"] = automatic_backup_retention_days
        __props__.__dict__["backup_id"] = backup_id
        __props__.__dict__["copy_tags_to_backups"] = copy_tags_to_backups
        __props__.__dict__["copy_tags_to_volumes"] = copy_tags_to_volumes
        __props__.__dict__["daily_automatic_backup_start_time"] = daily_automatic_backup_start_time
        __props__.__dict__["delete_options"] = delete_options
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["disk_iops_configuration"] = disk_iops_configuration
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["endpoint_ip_address"] = endpoint_ip_address
        __props__.__dict__["endpoint_ip_address_range"] = endpoint_ip_address_range
        __props__.__dict__["final_backup_tags"] = final_backup_tags
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["network_interface_ids"] = network_interface_ids
        __props__.__dict__["owner_id"] = owner_id
        __props__.__dict__["preferred_subnet_id"] = preferred_subnet_id
        __props__.__dict__["root_volume_configuration"] = root_volume_configuration
        __props__.__dict__["root_volume_id"] = root_volume_id
        __props__.__dict__["route_table_ids"] = route_table_ids
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["skip_final_backup"] = skip_final_backup
        __props__.__dict__["storage_capacity"] = storage_capacity
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["throughput_capacity"] = throughput_capacity
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["weekly_maintenance_start_time"] = weekly_maintenance_start_time
        return OpenZfsFileSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name of the file system.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="automaticBackupRetentionDays")
    def automatic_backup_retention_days(self) -> pulumi.Output[Optional[int]]:
        """
        The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
        """
        return pulumi.get(self, "automatic_backup_retention_days")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the source backup to create the filesystem from.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="copyTagsToBackups")
    def copy_tags_to_backups(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_backups")

    @property
    @pulumi.getter(name="copyTagsToVolumes")
    def copy_tags_to_volumes(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
        """
        return pulumi.get(self, "copy_tags_to_volumes")

    @property
    @pulumi.getter(name="dailyAutomaticBackupStartTime")
    def daily_automatic_backup_start_time(self) -> pulumi.Output[str]:
        """
        A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
        """
        return pulumi.get(self, "daily_automatic_backup_start_time")

    @property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
        """
        return pulumi.get(self, "delete_options")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[str]:
        """
        Filesystem deployment type. See the [AWS API documentation](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileSystemOpenZFSConfiguration.html#FSx-Type-CreateFileSystemOpenZFSConfiguration-DeploymentType) for a list of valid values.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="diskIopsConfiguration")
    def disk_iops_configuration(self) -> pulumi.Output['outputs.OpenZfsFileSystemDiskIopsConfiguration']:
        """
        The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
        """
        return pulumi.get(self, "disk_iops_configuration")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> pulumi.Output[str]:
        """
        IP address of the endpoint that is used to access data or to manage the file system.
        """
        return pulumi.get(self, "endpoint_ip_address")

    @property
    @pulumi.getter(name="endpointIpAddressRange")
    def endpoint_ip_address_range(self) -> pulumi.Output[str]:
        """
        (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
        """
        return pulumi.get(self, "endpoint_ip_address_range")

    @property
    @pulumi.getter(name="finalBackupTags")
    def final_backup_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to apply to the file system's final backup.
        """
        return pulumi.get(self, "final_backup_tags")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
        """
        return pulumi.get(self, "network_interface_ids")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        AWS account identifier that created the file system.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="preferredSubnetId")
    def preferred_subnet_id(self) -> pulumi.Output[Optional[str]]:
        """
        (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
        """
        return pulumi.get(self, "preferred_subnet_id")

    @property
    @pulumi.getter(name="rootVolumeConfiguration")
    def root_volume_configuration(self) -> pulumi.Output['outputs.OpenZfsFileSystemRootVolumeConfiguration']:
        """
        The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
        """
        return pulumi.get(self, "root_volume_configuration")

    @property
    @pulumi.getter(name="rootVolumeId")
    def root_volume_id(self) -> pulumi.Output[str]:
        """
        Identifier of the root volume, e.g., `fsvol-12345678`
        """
        return pulumi.get(self, "root_volume_id")

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
        """
        return pulumi.get(self, "route_table_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="skipFinalBackup")
    def skip_final_backup(self) -> pulumi.Output[Optional[bool]]:
        """
        When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
        """
        return pulumi.get(self, "skip_final_backup")

    @property
    @pulumi.getter(name="storageCapacity")
    def storage_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
        """
        return pulumi.get(self, "storage_capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[Optional[str]]:
        """
        The filesystem storage type. Only `SSD` is supported.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IDs for the subnets that the file system will be accessible from.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="throughputCapacity")
    def throughput_capacity(self) -> pulumi.Output[int]:
        """
        Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.

        The following arguments are optional:
        """
        return pulumi.get(self, "throughput_capacity")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Identifier of the Virtual Private Cloud for the file system.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="weeklyMaintenanceStartTime")
    def weekly_maintenance_start_time(self) -> pulumi.Output[str]:
        """
        The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
        """
        return pulumi.get(self, "weekly_maintenance_start_time")

