# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceServiceAccountArgs', 'WorkspaceServiceAccount']

@pulumi.input_type
class WorkspaceServiceAccountArgs:
    def __init__(__self__, *,
                 grafana_role: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkspaceServiceAccount resource.
        :param pulumi.Input[str] grafana_role: The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
        :param pulumi.Input[str] workspace_id: The Grafana workspace with which the service account is associated.
        :param pulumi.Input[str] name: A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
        """
        pulumi.set(__self__, "grafana_role", grafana_role)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="grafanaRole")
    def grafana_role(self) -> pulumi.Input[str]:
        """
        The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
        """
        return pulumi.get(self, "grafana_role")

    @grafana_role.setter
    def grafana_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "grafana_role", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The Grafana workspace with which the service account is associated.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _WorkspaceServiceAccountState:
    def __init__(__self__, *,
                 grafana_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_account_id: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceServiceAccount resources.
        :param pulumi.Input[str] grafana_role: The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
        :param pulumi.Input[str] name: A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
        :param pulumi.Input[str] service_account_id: Identifier of the service account in the given Grafana workspace
        :param pulumi.Input[str] workspace_id: The Grafana workspace with which the service account is associated.
        """
        if grafana_role is not None:
            pulumi.set(__self__, "grafana_role", grafana_role)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="grafanaRole")
    def grafana_role(self) -> Optional[pulumi.Input[str]]:
        """
        The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
        """
        return pulumi.get(self, "grafana_role")

    @grafana_role.setter
    def grafana_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grafana_role", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the service account in the given Grafana workspace
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_id", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Grafana workspace with which the service account is associated.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class WorkspaceServiceAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grafana_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.grafana.WorkspaceServiceAccount("example",
            name="example-admin",
            grafana_role="ADMIN",
            workspace_id=example_aws_grafana_workspace["id"])
        ```

        ## Import

        Using `pulumi import`, import Managed Grafana Workspace Service Account using the `workspace_id` and `service_account_id` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:grafana/workspaceServiceAccount:WorkspaceServiceAccount example g-abc12345,1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] grafana_role: The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
        :param pulumi.Input[str] name: A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
        :param pulumi.Input[str] workspace_id: The Grafana workspace with which the service account is associated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceServiceAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.grafana.WorkspaceServiceAccount("example",
            name="example-admin",
            grafana_role="ADMIN",
            workspace_id=example_aws_grafana_workspace["id"])
        ```

        ## Import

        Using `pulumi import`, import Managed Grafana Workspace Service Account using the `workspace_id` and `service_account_id` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:grafana/workspaceServiceAccount:WorkspaceServiceAccount example g-abc12345,1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceServiceAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceServiceAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 grafana_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceServiceAccountArgs.__new__(WorkspaceServiceAccountArgs)

            if grafana_role is None and not opts.urn:
                raise TypeError("Missing required property 'grafana_role'")
            __props__.__dict__["grafana_role"] = grafana_role
            __props__.__dict__["name"] = name
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["service_account_id"] = None
        super(WorkspaceServiceAccount, __self__).__init__(
            'aws:grafana/workspaceServiceAccount:WorkspaceServiceAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            grafana_role: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            service_account_id: Optional[pulumi.Input[str]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'WorkspaceServiceAccount':
        """
        Get an existing WorkspaceServiceAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] grafana_role: The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
        :param pulumi.Input[str] name: A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
        :param pulumi.Input[str] service_account_id: Identifier of the service account in the given Grafana workspace
        :param pulumi.Input[str] workspace_id: The Grafana workspace with which the service account is associated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceServiceAccountState.__new__(_WorkspaceServiceAccountState)

        __props__.__dict__["grafana_role"] = grafana_role
        __props__.__dict__["name"] = name
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceServiceAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="grafanaRole")
    def grafana_role(self) -> pulumi.Output[str]:
        """
        The permission level to use for this service account. For more information about the roles and the permissions each has, see the [User roles](https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html) documentation.
        """
        return pulumi.get(self, "grafana_role")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name for the service account. The name must be unique within the workspace, as it determines the ID associated with the service account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[str]:
        """
        Identifier of the service account in the given Grafana workspace
        """
        return pulumi.get(self, "service_account_id")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The Grafana workspace with which the service account is associated.
        """
        return pulumi.get(self, "workspace_id")

