# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDetectorResult',
    'AwaitableGetDetectorResult',
    'get_detector',
    'get_detector_output',
]

@pulumi.output_type
class GetDetectorResult:
    """
    A collection of values returned by getDetector.
    """
    def __init__(__self__, features=None, finding_publishing_frequency=None, id=None, service_role_arn=None, status=None):
        if features and not isinstance(features, list):
            raise TypeError("Expected argument 'features' to be a list")
        pulumi.set(__self__, "features", features)
        if finding_publishing_frequency and not isinstance(finding_publishing_frequency, str):
            raise TypeError("Expected argument 'finding_publishing_frequency' to be a str")
        pulumi.set(__self__, "finding_publishing_frequency", finding_publishing_frequency)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_role_arn and not isinstance(service_role_arn, str):
            raise TypeError("Expected argument 'service_role_arn' to be a str")
        pulumi.set(__self__, "service_role_arn", service_role_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetDetectorFeatureResult']:
        """
        Current configuration of the detector features.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="findingPublishingFrequency")
    def finding_publishing_frequency(self) -> str:
        """
        The frequency of notifications sent about subsequent finding occurrences.
        """
        return pulumi.get(self, "finding_publishing_frequency")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceRoleArn")
    def service_role_arn(self) -> str:
        """
        Service-linked role that grants GuardDuty access to the resources in the AWS account.
        """
        return pulumi.get(self, "service_role_arn")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of the detector.
        """
        return pulumi.get(self, "status")


class AwaitableGetDetectorResult(GetDetectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDetectorResult(
            features=self.features,
            finding_publishing_frequency=self.finding_publishing_frequency,
            id=self.id,
            service_role_arn=self.service_role_arn,
            status=self.status)


def get_detector(id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDetectorResult:
    """
    Retrieve information about a GuardDuty detector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.guardduty.get_detector()
    ```


    :param str id: ID of the detector.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:guardduty/getDetector:getDetector', __args__, opts=opts, typ=GetDetectorResult).value

    return AwaitableGetDetectorResult(
        features=pulumi.get(__ret__, 'features'),
        finding_publishing_frequency=pulumi.get(__ret__, 'finding_publishing_frequency'),
        id=pulumi.get(__ret__, 'id'),
        service_role_arn=pulumi.get(__ret__, 'service_role_arn'),
        status=pulumi.get(__ret__, 'status'))
def get_detector_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDetectorResult]:
    """
    Retrieve information about a GuardDuty detector.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.guardduty.get_detector()
    ```


    :param str id: ID of the detector.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:guardduty/getDetector:getDetector', __args__, opts=opts, typ=GetDetectorResult)
    return __ret__.apply(lambda __response__: GetDetectorResult(
        features=pulumi.get(__response__, 'features'),
        finding_publishing_frequency=pulumi.get(__response__, 'finding_publishing_frequency'),
        id=pulumi.get(__response__, 'id'),
        service_role_arn=pulumi.get(__response__, 'service_role_arn'),
        status=pulumi.get(__response__, 'status')))
