# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupPolicyAttachmentsExclusiveArgs', 'GroupPolicyAttachmentsExclusive']

@pulumi.input_type
class GroupPolicyAttachmentsExclusiveArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 policy_arns: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a GroupPolicyAttachmentsExclusive resource.
        :param pulumi.Input[str] group_name: IAM group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the group. Policies attached to this group but not configured in this argument will be removed.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "policy_arns", policy_arns)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        IAM group name.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of managed IAM policy ARNs to be attached to the group. Policies attached to this group but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "policy_arns", value)


@pulumi.input_type
class _GroupPolicyAttachmentsExclusiveState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering GroupPolicyAttachmentsExclusive resources.
        :param pulumi.Input[str] group_name: IAM group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the group. Policies attached to this group but not configured in this argument will be removed.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        IAM group name.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of managed IAM policy ARNs to be attached to the group. Policies attached to this group but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)


class GroupPolicyAttachmentsExclusive(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Import

        Using `pulumi import`, import exclusive management of managed IAM policy assignments using the `group_name`. For example:

        ```sh
        $ pulumi import aws:iam/groupPolicyAttachmentsExclusive:GroupPolicyAttachmentsExclusive example MyGroup
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: IAM group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the group. Policies attached to this group but not configured in this argument will be removed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupPolicyAttachmentsExclusiveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Using `pulumi import`, import exclusive management of managed IAM policy assignments using the `group_name`. For example:

        ```sh
        $ pulumi import aws:iam/groupPolicyAttachmentsExclusive:GroupPolicyAttachmentsExclusive example MyGroup
        ```

        :param str resource_name: The name of the resource.
        :param GroupPolicyAttachmentsExclusiveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupPolicyAttachmentsExclusiveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupPolicyAttachmentsExclusiveArgs.__new__(GroupPolicyAttachmentsExclusiveArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            if policy_arns is None and not opts.urn:
                raise TypeError("Missing required property 'policy_arns'")
            __props__.__dict__["policy_arns"] = policy_arns
        super(GroupPolicyAttachmentsExclusive, __self__).__init__(
            'aws:iam/groupPolicyAttachmentsExclusive:GroupPolicyAttachmentsExclusive',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'GroupPolicyAttachmentsExclusive':
        """
        Get an existing GroupPolicyAttachmentsExclusive resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: IAM group name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: A list of managed IAM policy ARNs to be attached to the group. Policies attached to this group but not configured in this argument will be removed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupPolicyAttachmentsExclusiveState.__new__(_GroupPolicyAttachmentsExclusiveState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["policy_arns"] = policy_arns
        return GroupPolicyAttachmentsExclusive(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        IAM group name.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of managed IAM policy ARNs to be attached to the group. Policies attached to this group but not configured in this argument will be removed.
        """
        return pulumi.get(self, "policy_arns")

