# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EventConfigurationsArgs', 'EventConfigurations']

@pulumi.input_type
class EventConfigurationsArgs:
    def __init__(__self__, *,
                 event_configurations: pulumi.Input[Mapping[str, pulumi.Input[bool]]]):
        """
        The set of arguments for constructing a EventConfigurations resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] event_configurations: Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
        """
        pulumi.set(__self__, "event_configurations", event_configurations)

    @property
    @pulumi.getter(name="eventConfigurations")
    def event_configurations(self) -> pulumi.Input[Mapping[str, pulumi.Input[bool]]]:
        """
        Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
        """
        return pulumi.get(self, "event_configurations")

    @event_configurations.setter
    def event_configurations(self, value: pulumi.Input[Mapping[str, pulumi.Input[bool]]]):
        pulumi.set(self, "event_configurations", value)


@pulumi.input_type
class _EventConfigurationsState:
    def __init__(__self__, *,
                 event_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None):
        """
        Input properties used for looking up and filtering EventConfigurations resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] event_configurations: Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
        """
        if event_configurations is not None:
            pulumi.set(__self__, "event_configurations", event_configurations)

    @property
    @pulumi.getter(name="eventConfigurations")
    def event_configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]:
        """
        Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
        """
        return pulumi.get(self, "event_configurations")

    @event_configurations.setter
    def event_configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]]):
        pulumi.set(self, "event_configurations", value)


class EventConfigurations(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 __props__=None):
        """
        Manages IoT event configurations.

        > **NOTE:** Deleting this resource does not disable the event configurations, the resource in simply removed from state instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iot.EventConfigurations("example", event_configurations={
            "THING": True,
            "THING_GROUP": False,
            "THING_TYPE": False,
            "THING_GROUP_MEMBERSHIP": False,
            "THING_GROUP_HIERARCHY": False,
            "THING_TYPE_ASSOCIATION": False,
            "JOB": False,
            "JOB_EXECUTION": False,
            "POLICY": False,
            "CERTIFICATE": True,
            "CA_CERTIFICATE": False,
        })
        ```

        ## Import

        Using `pulumi import`, import IoT Event Configurations using the AWS Region. For example:

        ```sh
        $ pulumi import aws:iot/eventConfigurations:EventConfigurations example us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] event_configurations: Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventConfigurationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages IoT event configurations.

        > **NOTE:** Deleting this resource does not disable the event configurations, the resource in simply removed from state instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iot.EventConfigurations("example", event_configurations={
            "THING": True,
            "THING_GROUP": False,
            "THING_TYPE": False,
            "THING_GROUP_MEMBERSHIP": False,
            "THING_GROUP_HIERARCHY": False,
            "THING_TYPE_ASSOCIATION": False,
            "JOB": False,
            "JOB_EXECUTION": False,
            "POLICY": False,
            "CERTIFICATE": True,
            "CA_CERTIFICATE": False,
        })
        ```

        ## Import

        Using `pulumi import`, import IoT Event Configurations using the AWS Region. For example:

        ```sh
        $ pulumi import aws:iot/eventConfigurations:EventConfigurations example us-west-2
        ```

        :param str resource_name: The name of the resource.
        :param EventConfigurationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventConfigurationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventConfigurationsArgs.__new__(EventConfigurationsArgs)

            if event_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'event_configurations'")
            __props__.__dict__["event_configurations"] = event_configurations
        super(EventConfigurations, __self__).__init__(
            'aws:iot/eventConfigurations:EventConfigurations',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            event_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[bool]]]] = None) -> 'EventConfigurations':
        """
        Get an existing EventConfigurations resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[bool]]] event_configurations: Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventConfigurationsState.__new__(_EventConfigurationsState)

        __props__.__dict__["event_configurations"] = event_configurations
        return EventConfigurations(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eventConfigurations")
    def event_configurations(self) -> pulumi.Output[Mapping[str, bool]]:
        """
        Map. The new event configuration values. You can use only these strings as keys: `THING_GROUP_HIERARCHY`, `THING_GROUP_MEMBERSHIP`, `THING_TYPE`, `THING_TYPE_ASSOCIATION`, `THING_GROUP`, `THING`, `POLICY`, `CA_CERTIFICATE`, `JOB_EXECUTION`, `CERTIFICATE`, `JOB`. Use boolean for values of mapping.
        """
        return pulumi.get(self, "event_configurations")

