# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DataSourceConfiguration',
    'DataSourceConfigurationS3Configuration',
    'DataSourceConfigurationS3ConfigurationAccessControlListConfiguration',
    'DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration',
    'DataSourceConfigurationWebCrawlerConfiguration',
    'DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfiguration',
    'DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication',
    'DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration',
    'DataSourceConfigurationWebCrawlerConfigurationUrls',
    'DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration',
    'DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration',
    'DataSourceCustomDocumentEnrichmentConfiguration',
    'DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration',
    'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition',
    'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValue',
    'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget',
    'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue',
    'DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration',
    'DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationCondition',
    'DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValue',
    'DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration',
    'DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition',
    'DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue',
    'ExperienceConfiguration',
    'ExperienceConfigurationContentSourceConfiguration',
    'ExperienceConfigurationUserIdentityConfiguration',
    'ExperienceEndpoint',
    'FaqS3Path',
    'IndexCapacityUnits',
    'IndexDocumentMetadataConfigurationUpdate',
    'IndexDocumentMetadataConfigurationUpdateRelevance',
    'IndexDocumentMetadataConfigurationUpdateSearch',
    'IndexIndexStatistic',
    'IndexIndexStatisticFaqStatistic',
    'IndexIndexStatisticTextDocumentStatistic',
    'IndexServerSideEncryptionConfiguration',
    'IndexUserGroupResolutionConfiguration',
    'IndexUserTokenConfigurations',
    'IndexUserTokenConfigurationsJsonTokenTypeConfiguration',
    'IndexUserTokenConfigurationsJwtTokenTypeConfiguration',
    'QuerySuggestionsBlockListSourceS3Path',
    'ThesaurusSourceS3Path',
    'GetExperienceConfigurationResult',
    'GetExperienceConfigurationContentSourceConfigurationResult',
    'GetExperienceConfigurationUserIdentityConfigurationResult',
    'GetExperienceEndpointResult',
    'GetFaqS3PathResult',
    'GetIndexCapacityUnitResult',
    'GetIndexDocumentMetadataConfigurationUpdateResult',
    'GetIndexDocumentMetadataConfigurationUpdateRelevanceResult',
    'GetIndexDocumentMetadataConfigurationUpdateSearchResult',
    'GetIndexIndexStatisticResult',
    'GetIndexIndexStatisticFaqStatisticResult',
    'GetIndexIndexStatisticTextDocumentStatisticResult',
    'GetIndexServerSideEncryptionConfigurationResult',
    'GetIndexUserGroupResolutionConfigurationResult',
    'GetIndexUserTokenConfigurationResult',
    'GetIndexUserTokenConfigurationJsonTokenTypeConfigurationResult',
    'GetIndexUserTokenConfigurationJwtTokenTypeConfigurationResult',
    'GetQuerySuggestionsBlockListSourceS3PathResult',
    'GetThesaurusSourceS3PathResult',
]

@pulumi.output_type
class DataSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Configuration":
            suggest = "s3_configuration"
        elif key == "webCrawlerConfiguration":
            suggest = "web_crawler_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_configuration: Optional['outputs.DataSourceConfigurationS3Configuration'] = None,
                 web_crawler_configuration: Optional['outputs.DataSourceConfigurationWebCrawlerConfiguration'] = None):
        """
        :param 'DataSourceConfigurationS3ConfigurationArgs' s3_configuration: A block that provides the configuration information to connect to an Amazon S3 bucket as your data source. Detailed below.
        :param 'DataSourceConfigurationWebCrawlerConfigurationArgs' web_crawler_configuration: A block that provides the configuration information required for Amazon Kendra Web Crawler. Detailed below.
        """
        if s3_configuration is not None:
            pulumi.set(__self__, "s3_configuration", s3_configuration)
        if web_crawler_configuration is not None:
            pulumi.set(__self__, "web_crawler_configuration", web_crawler_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> Optional['outputs.DataSourceConfigurationS3Configuration']:
        """
        A block that provides the configuration information to connect to an Amazon S3 bucket as your data source. Detailed below.
        """
        return pulumi.get(self, "s3_configuration")

    @property
    @pulumi.getter(name="webCrawlerConfiguration")
    def web_crawler_configuration(self) -> Optional['outputs.DataSourceConfigurationWebCrawlerConfiguration']:
        """
        A block that provides the configuration information required for Amazon Kendra Web Crawler. Detailed below.
        """
        return pulumi.get(self, "web_crawler_configuration")


@pulumi.output_type
class DataSourceConfigurationS3Configuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "accessControlListConfiguration":
            suggest = "access_control_list_configuration"
        elif key == "documentsMetadataConfiguration":
            suggest = "documents_metadata_configuration"
        elif key == "exclusionPatterns":
            suggest = "exclusion_patterns"
        elif key == "inclusionPatterns":
            suggest = "inclusion_patterns"
        elif key == "inclusionPrefixes":
            suggest = "inclusion_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 access_control_list_configuration: Optional['outputs.DataSourceConfigurationS3ConfigurationAccessControlListConfiguration'] = None,
                 documents_metadata_configuration: Optional['outputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration'] = None,
                 exclusion_patterns: Optional[Sequence[str]] = None,
                 inclusion_patterns: Optional[Sequence[str]] = None,
                 inclusion_prefixes: Optional[Sequence[str]] = None):
        """
        :param str bucket_name: The name of the bucket that contains the documents.
        :param 'DataSourceConfigurationS3ConfigurationAccessControlListConfigurationArgs' access_control_list_configuration: A block that provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html). Detailed below.
        :param 'DataSourceConfigurationS3ConfigurationDocumentsMetadataConfigurationArgs' documents_metadata_configuration: A block that defines the Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document. Detailed below.
        :param Sequence[str] exclusion_patterns: A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
        :param Sequence[str] inclusion_patterns: A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
        :param Sequence[str] inclusion_prefixes: A list of S3 prefixes for the documents that should be included in the index.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if access_control_list_configuration is not None:
            pulumi.set(__self__, "access_control_list_configuration", access_control_list_configuration)
        if documents_metadata_configuration is not None:
            pulumi.set(__self__, "documents_metadata_configuration", documents_metadata_configuration)
        if exclusion_patterns is not None:
            pulumi.set(__self__, "exclusion_patterns", exclusion_patterns)
        if inclusion_patterns is not None:
            pulumi.set(__self__, "inclusion_patterns", inclusion_patterns)
        if inclusion_prefixes is not None:
            pulumi.set(__self__, "inclusion_prefixes", inclusion_prefixes)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of the bucket that contains the documents.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="accessControlListConfiguration")
    def access_control_list_configuration(self) -> Optional['outputs.DataSourceConfigurationS3ConfigurationAccessControlListConfiguration']:
        """
        A block that provides the path to the S3 bucket that contains the user context filtering files for the data source. For the format of the file, see [Access control for S3 data sources](https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html). Detailed below.
        """
        return pulumi.get(self, "access_control_list_configuration")

    @property
    @pulumi.getter(name="documentsMetadataConfiguration")
    def documents_metadata_configuration(self) -> Optional['outputs.DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration']:
        """
        A block that defines the Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes. Each metadata file contains metadata about a single document. Detailed below.
        """
        return pulumi.get(self, "documents_metadata_configuration")

    @property
    @pulumi.getter(name="exclusionPatterns")
    def exclusion_patterns(self) -> Optional[Sequence[str]]:
        """
        A list of glob patterns for documents that should not be indexed. If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Exclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-ExclusionPatterns).
        """
        return pulumi.get(self, "exclusion_patterns")

    @property
    @pulumi.getter(name="inclusionPatterns")
    def inclusion_patterns(self) -> Optional[Sequence[str]]:
        """
        A list of glob patterns for documents that should be indexed. If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed. Refer to [Inclusion Patterns for more examples](https://docs.aws.amazon.com/kendra/latest/dg/API_S3DataSourceConfiguration.html#Kendra-Type-S3DataSourceConfiguration-InclusionPatterns).
        """
        return pulumi.get(self, "inclusion_patterns")

    @property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Optional[Sequence[str]]:
        """
        A list of S3 prefixes for the documents that should be included in the index.
        """
        return pulumi.get(self, "inclusion_prefixes")


@pulumi.output_type
class DataSourceConfigurationS3ConfigurationAccessControlListConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPath":
            suggest = "key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationS3ConfigurationAccessControlListConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationS3ConfigurationAccessControlListConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationS3ConfigurationAccessControlListConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_path: Optional[str] = None):
        """
        :param str key_path: Path to the AWS S3 bucket that contains the ACL files.
        """
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[str]:
        """
        Path to the AWS S3 bucket that contains the ACL files.
        """
        return pulumi.get(self, "key_path")


@pulumi.output_type
class DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Prefix":
            suggest = "s3_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationS3ConfigurationDocumentsMetadataConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_prefix: Optional[str] = None):
        """
        :param str s3_prefix: A prefix used to filter metadata configuration files in the AWS S3 bucket. The S3 bucket might contain multiple metadata files. Use `s3_prefix` to include only the desired metadata files.
        """
        if s3_prefix is not None:
            pulumi.set(__self__, "s3_prefix", s3_prefix)

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> Optional[str]:
        """
        A prefix used to filter metadata configuration files in the AWS S3 bucket. The S3 bucket might contain multiple metadata files. Use `s3_prefix` to include only the desired metadata files.
        """
        return pulumi.get(self, "s3_prefix")


@pulumi.output_type
class DataSourceConfigurationWebCrawlerConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationConfiguration":
            suggest = "authentication_configuration"
        elif key == "crawlDepth":
            suggest = "crawl_depth"
        elif key == "maxContentSizePerPageInMegaBytes":
            suggest = "max_content_size_per_page_in_mega_bytes"
        elif key == "maxLinksPerPage":
            suggest = "max_links_per_page"
        elif key == "maxUrlsPerMinuteCrawlRate":
            suggest = "max_urls_per_minute_crawl_rate"
        elif key == "proxyConfiguration":
            suggest = "proxy_configuration"
        elif key == "urlExclusionPatterns":
            suggest = "url_exclusion_patterns"
        elif key == "urlInclusionPatterns":
            suggest = "url_inclusion_patterns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationWebCrawlerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationWebCrawlerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationWebCrawlerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 urls: 'outputs.DataSourceConfigurationWebCrawlerConfigurationUrls',
                 authentication_configuration: Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfiguration'] = None,
                 crawl_depth: Optional[int] = None,
                 max_content_size_per_page_in_mega_bytes: Optional[float] = None,
                 max_links_per_page: Optional[int] = None,
                 max_urls_per_minute_crawl_rate: Optional[int] = None,
                 proxy_configuration: Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration'] = None,
                 url_exclusion_patterns: Optional[Sequence[str]] = None,
                 url_inclusion_patterns: Optional[Sequence[str]] = None):
        """
        :param 'DataSourceConfigurationWebCrawlerConfigurationUrlsArgs' urls: A block that specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. You can include website subdomains. You can list up to `100` seed URLs and up to `3` sitemap URLs. You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling. When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index. Detailed below.
        :param 'DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationArgs' authentication_configuration: A block with the configuration information required to connect to websites using authentication. You can connect to websites using basic authentication of user name and password. You use a secret in AWS Secrets Manager to store your authentication credentials. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Detailed below.
        :param int crawl_depth: Specifies the number of levels in a website that you want to crawl. The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1. The default crawl depth is set to `2`. Minimum value of `0`. Maximum value of `10`.
        :param float max_content_size_per_page_in_mega_bytes: The maximum size (in MB) of a webpage or attachment to crawl. Files larger than this size (in MB) are skipped/not crawled. The default maximum size of a webpage or attachment is set to `50` MB. Minimum value of `1.0e-06`. Maximum value of `50`.
        :param int max_links_per_page: The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage. As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance. The default maximum links per page is `100`. Minimum value of `1`. Maximum value of `1000`.
        :param int max_urls_per_minute_crawl_rate: The maximum number of URLs crawled per website host per minute. The default maximum number of URLs crawled per website host per minute is `300`. Minimum value of `1`. Maximum value of `300`.
        :param 'DataSourceConfigurationWebCrawlerConfigurationProxyConfigurationArgs' proxy_configuration: Configuration information required to connect to your internal websites via a web proxy. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). Detailed below.
        :param Sequence[str] url_exclusion_patterns: A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
        :param Sequence[str] url_inclusion_patterns: A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
        """
        pulumi.set(__self__, "urls", urls)
        if authentication_configuration is not None:
            pulumi.set(__self__, "authentication_configuration", authentication_configuration)
        if crawl_depth is not None:
            pulumi.set(__self__, "crawl_depth", crawl_depth)
        if max_content_size_per_page_in_mega_bytes is not None:
            pulumi.set(__self__, "max_content_size_per_page_in_mega_bytes", max_content_size_per_page_in_mega_bytes)
        if max_links_per_page is not None:
            pulumi.set(__self__, "max_links_per_page", max_links_per_page)
        if max_urls_per_minute_crawl_rate is not None:
            pulumi.set(__self__, "max_urls_per_minute_crawl_rate", max_urls_per_minute_crawl_rate)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if url_exclusion_patterns is not None:
            pulumi.set(__self__, "url_exclusion_patterns", url_exclusion_patterns)
        if url_inclusion_patterns is not None:
            pulumi.set(__self__, "url_inclusion_patterns", url_inclusion_patterns)

    @property
    @pulumi.getter
    def urls(self) -> 'outputs.DataSourceConfigurationWebCrawlerConfigurationUrls':
        """
        A block that specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. You can include website subdomains. You can list up to `100` seed URLs and up to `3` sitemap URLs. You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling. When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index. Detailed below.
        """
        return pulumi.get(self, "urls")

    @property
    @pulumi.getter(name="authenticationConfiguration")
    def authentication_configuration(self) -> Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfiguration']:
        """
        A block with the configuration information required to connect to websites using authentication. You can connect to websites using basic authentication of user name and password. You use a secret in AWS Secrets Manager to store your authentication credentials. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Detailed below.
        """
        return pulumi.get(self, "authentication_configuration")

    @property
    @pulumi.getter(name="crawlDepth")
    def crawl_depth(self) -> Optional[int]:
        """
        Specifies the number of levels in a website that you want to crawl. The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1. The default crawl depth is set to `2`. Minimum value of `0`. Maximum value of `10`.
        """
        return pulumi.get(self, "crawl_depth")

    @property
    @pulumi.getter(name="maxContentSizePerPageInMegaBytes")
    def max_content_size_per_page_in_mega_bytes(self) -> Optional[float]:
        """
        The maximum size (in MB) of a webpage or attachment to crawl. Files larger than this size (in MB) are skipped/not crawled. The default maximum size of a webpage or attachment is set to `50` MB. Minimum value of `1.0e-06`. Maximum value of `50`.
        """
        return pulumi.get(self, "max_content_size_per_page_in_mega_bytes")

    @property
    @pulumi.getter(name="maxLinksPerPage")
    def max_links_per_page(self) -> Optional[int]:
        """
        The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage. As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance. The default maximum links per page is `100`. Minimum value of `1`. Maximum value of `1000`.
        """
        return pulumi.get(self, "max_links_per_page")

    @property
    @pulumi.getter(name="maxUrlsPerMinuteCrawlRate")
    def max_urls_per_minute_crawl_rate(self) -> Optional[int]:
        """
        The maximum number of URLs crawled per website host per minute. The default maximum number of URLs crawled per website host per minute is `300`. Minimum value of `1`. Maximum value of `300`.
        """
        return pulumi.get(self, "max_urls_per_minute_crawl_rate")

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration']:
        """
        Configuration information required to connect to your internal websites via a web proxy. You must provide the website host name and port number. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"` and the port is `443`, the standard port for HTTPS. Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). Detailed below.
        """
        return pulumi.get(self, "proxy_configuration")

    @property
    @pulumi.getter(name="urlExclusionPatterns")
    def url_exclusion_patterns(self) -> Optional[Sequence[str]]:
        """
        A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
        """
        return pulumi.get(self, "url_exclusion_patterns")

    @property
    @pulumi.getter(name="urlInclusionPatterns")
    def url_inclusion_patterns(self) -> Optional[Sequence[str]]:
        """
        A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `150`.
        """
        return pulumi.get(self, "url_inclusion_patterns")


@pulumi.output_type
class DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuthentications":
            suggest = "basic_authentications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_authentications: Optional[Sequence['outputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication']] = None):
        """
        :param Sequence['DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthenticationArgs'] basic_authentications: The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
        """
        if basic_authentications is not None:
            pulumi.set(__self__, "basic_authentications", basic_authentications)

    @property
    @pulumi.getter(name="basicAuthentications")
    def basic_authentications(self) -> Optional[Sequence['outputs.DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication']]:
        """
        The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials. The list includes the name and port number of the website host. Detailed below.
        """
        return pulumi.get(self, "basic_authentications")


@pulumi.output_type
class DataSourceConfigurationWebCrawlerConfigurationAuthenticationConfigurationBasicAuthentication(dict):
    def __init__(__self__, *,
                 credentials: str,
                 host: str,
                 port: int):
        """
        :param str credentials: Your secret ARN, which you can create in AWS Secrets Manager. You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
        :param str host: The name of the website host you want to connect to using authentication credentials. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
        :param int port: The port number of the website host you want to connect to using authentication credentials. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def credentials(self) -> str:
        """
        Your secret ARN, which you can create in AWS Secrets Manager. You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The name of the website host you want to connect to using authentication credentials. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the website host you want to connect to using authentication credentials. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DataSourceConfigurationWebCrawlerConfigurationProxyConfiguration(dict):
    def __init__(__self__, *,
                 host: str,
                 port: int,
                 credentials: Optional[str] = None):
        """
        :param str host: The name of the website host you want to connect to via a web proxy server. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
        :param int port: The port number of the website host you want to connect to via a web proxy server. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
        :param str credentials: Your secret ARN, which you can create in AWS Secrets Manager. The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The name of the website host you want to connect to via a web proxy server. For example, the host name of `https://a.example.com/page1.html` is `"a.example.com"`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port number of the website host you want to connect to via a web proxy server. For example, the port for `https://a.example.com/page1.html` is `443`, the standard port for HTTPS.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[str]:
        """
        Your secret ARN, which you can create in AWS Secrets Manager. The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
        """
        return pulumi.get(self, "credentials")


@pulumi.output_type
class DataSourceConfigurationWebCrawlerConfigurationUrls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "seedUrlConfiguration":
            suggest = "seed_url_configuration"
        elif key == "siteMapsConfiguration":
            suggest = "site_maps_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationWebCrawlerConfigurationUrls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationUrls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationUrls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 seed_url_configuration: Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration'] = None,
                 site_maps_configuration: Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration'] = None):
        """
        :param 'DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfigurationArgs' seed_url_configuration: A block that specifies the configuration of the seed or starting point URLs of the websites you want to crawl. You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to. You can list up to `100` seed URLs. Detailed below.
        :param 'DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfigurationArgs' site_maps_configuration: A block that specifies the configuration of the sitemap URLs of the websites you want to crawl. Only URLs belonging to the same website host names are crawled. You can list up to `3` sitemap URLs. Detailed below.
        """
        if seed_url_configuration is not None:
            pulumi.set(__self__, "seed_url_configuration", seed_url_configuration)
        if site_maps_configuration is not None:
            pulumi.set(__self__, "site_maps_configuration", site_maps_configuration)

    @property
    @pulumi.getter(name="seedUrlConfiguration")
    def seed_url_configuration(self) -> Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration']:
        """
        A block that specifies the configuration of the seed or starting point URLs of the websites you want to crawl. You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to. You can list up to `100` seed URLs. Detailed below.
        """
        return pulumi.get(self, "seed_url_configuration")

    @property
    @pulumi.getter(name="siteMapsConfiguration")
    def site_maps_configuration(self) -> Optional['outputs.DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration']:
        """
        A block that specifies the configuration of the sitemap URLs of the websites you want to crawl. Only URLs belonging to the same website host names are crawled. You can list up to `3` sitemap URLs. Detailed below.
        """
        return pulumi.get(self, "site_maps_configuration")


@pulumi.output_type
class DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "seedUrls":
            suggest = "seed_urls"
        elif key == "webCrawlerMode":
            suggest = "web_crawler_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationUrlsSeedUrlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 seed_urls: Sequence[str],
                 web_crawler_mode: Optional[str] = None):
        """
        :param Sequence[str] seed_urls: The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
        :param str web_crawler_mode: The default mode is set to `HOST_ONLY`. You can choose one of the following modes:
               * `HOST_ONLY` – crawl only the website host names. For example, if the seed URL is `"abc.example.com"`, then only URLs with host name `"abc.example.com"` are crawled.
               * `SUBDOMAINS` – crawl the website host names with subdomains. For example, if the seed URL is `"abc.example.com"`, then `"a.abc.example.com"` and `"b.abc.example.com"` are also crawled.
               * `EVERYTHING` – crawl the website host names with subdomains and other domains that the webpages link to.
        """
        pulumi.set(__self__, "seed_urls", seed_urls)
        if web_crawler_mode is not None:
            pulumi.set(__self__, "web_crawler_mode", web_crawler_mode)

    @property
    @pulumi.getter(name="seedUrls")
    def seed_urls(self) -> Sequence[str]:
        """
        The list of seed or starting point URLs of the websites you want to crawl. The list can include a maximum of `100` seed URLs. Array Members: Minimum number of `0` items. Maximum number of `100` items. Length Constraints: Minimum length of `1`. Maximum length of `2048`.
        """
        return pulumi.get(self, "seed_urls")

    @property
    @pulumi.getter(name="webCrawlerMode")
    def web_crawler_mode(self) -> Optional[str]:
        """
        The default mode is set to `HOST_ONLY`. You can choose one of the following modes:
        * `HOST_ONLY` – crawl only the website host names. For example, if the seed URL is `"abc.example.com"`, then only URLs with host name `"abc.example.com"` are crawled.
        * `SUBDOMAINS` – crawl the website host names with subdomains. For example, if the seed URL is `"abc.example.com"`, then `"a.abc.example.com"` and `"b.abc.example.com"` are also crawled.
        * `EVERYTHING` – crawl the website host names with subdomains and other domains that the webpages link to.
        """
        return pulumi.get(self, "web_crawler_mode")


@pulumi.output_type
class DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "siteMaps":
            suggest = "site_maps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceConfigurationWebCrawlerConfigurationUrlsSiteMapsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 site_maps: Sequence[str]):
        """
        :param Sequence[str] site_maps: The list of sitemap URLs of the websites you want to crawl. The list can include a maximum of `3` sitemap URLs.
        """
        pulumi.set(__self__, "site_maps", site_maps)

    @property
    @pulumi.getter(name="siteMaps")
    def site_maps(self) -> Sequence[str]:
        """
        The list of sitemap URLs of the websites you want to crawl. The list can include a maximum of `3` sitemap URLs.
        """
        return pulumi.get(self, "site_maps")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inlineConfigurations":
            suggest = "inline_configurations"
        elif key == "postExtractionHookConfiguration":
            suggest = "post_extraction_hook_configuration"
        elif key == "preExtractionHookConfiguration":
            suggest = "pre_extraction_hook_configuration"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inline_configurations: Optional[Sequence['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration']] = None,
                 post_extraction_hook_configuration: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration'] = None,
                 pre_extraction_hook_configuration: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration'] = None,
                 role_arn: Optional[str] = None):
        """
        :param Sequence['DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationArgs'] inline_configurations: Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
        :param 'DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationArgs' post_extraction_hook_configuration: A block that specifies the configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
        :param 'DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationArgs' pre_extraction_hook_configuration: Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
        :param str role_arn: The Amazon Resource Name (ARN) of a role with permission to run `pre_extraction_hook_configuration` and `post_extraction_hook_configuration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        """
        if inline_configurations is not None:
            pulumi.set(__self__, "inline_configurations", inline_configurations)
        if post_extraction_hook_configuration is not None:
            pulumi.set(__self__, "post_extraction_hook_configuration", post_extraction_hook_configuration)
        if pre_extraction_hook_configuration is not None:
            pulumi.set(__self__, "pre_extraction_hook_configuration", pre_extraction_hook_configuration)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="inlineConfigurations")
    def inline_configurations(self) -> Optional[Sequence['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration']]:
        """
        Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra. Minimum number of `0` items. Maximum number of `100` items. Detailed below.
        """
        return pulumi.get(self, "inline_configurations")

    @property
    @pulumi.getter(name="postExtractionHookConfiguration")
    def post_extraction_hook_configuration(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration']:
        """
        A block that specifies the configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
        """
        return pulumi.get(self, "post_extraction_hook_configuration")

    @property
    @pulumi.getter(name="preExtractionHookConfiguration")
    def pre_extraction_hook_configuration(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration']:
        """
        Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation). Detailed below.
        """
        return pulumi.get(self, "pre_extraction_hook_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of a role with permission to run `pre_extraction_hook_configuration` and `post_extraction_hook_configuration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentContentDeletion":
            suggest = "document_content_deletion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition'] = None,
                 document_content_deletion: Optional[bool] = None,
                 target: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget'] = None):
        """
        :param 'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionArgs' condition: Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. See condition.
        :param bool document_content_deletion: `TRUE` to delete content if the condition used for the target attribute is met.
        :param 'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetArgs' target: Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value. Detailed below.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if document_content_deletion is not None:
            pulumi.set(__self__, "document_content_deletion", document_content_deletion)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def condition(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition']:
        """
        Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra. See condition.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="documentContentDeletion")
    def document_content_deletion(self) -> Optional[bool]:
        """
        `TRUE` to delete content if the condition used for the target attribute is met.
        """
        return pulumi.get(self, "document_content_deletion")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget']:
        """
        Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value. Detailed below.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionDocumentAttributeKey":
            suggest = "condition_document_attribute_key"
        elif key == "conditionOnValue":
            suggest = "condition_on_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_document_attribute_key: str,
                 operator: str,
                 condition_on_value: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValue'] = None):
        """
        :param str condition_document_attribute_key: The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
        :param str operator: The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
        :param 'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValueArgs' condition_on_value: The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
        """
        pulumi.set(__self__, "condition_document_attribute_key", condition_document_attribute_key)
        pulumi.set(__self__, "operator", operator)
        if condition_on_value is not None:
            pulumi.set(__self__, "condition_on_value", condition_on_value)

    @property
    @pulumi.getter(name="conditionDocumentAttributeKey")
    def condition_document_attribute_key(self) -> str:
        """
        The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
        """
        return pulumi.get(self, "condition_document_attribute_key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="conditionOnValue")
    def condition_on_value(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValue']:
        """
        The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
        """
        return pulumi.get(self, "condition_on_value")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateValue":
            suggest = "date_value"
        elif key == "longValue":
            suggest = "long_value"
        elif key == "stringListValues":
            suggest = "string_list_values"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationConditionConditionOnValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_value: Optional[str] = None,
                 long_value: Optional[int] = None,
                 string_list_values: Optional[Sequence[str]] = None,
                 string_value: Optional[str] = None):
        """
        :param str date_value: A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        :param int long_value: A long integer value.
        :param Sequence[str] string_list_values: A list of strings.
        """
        if date_value is not None:
            pulumi.set(__self__, "date_value", date_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if string_list_values is not None:
            pulumi.set(__self__, "string_list_values", string_list_values)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> Optional[str]:
        """
        A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        """
        return pulumi.get(self, "date_value")

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[int]:
        """
        A long integer value.
        """
        return pulumi.get(self, "long_value")

    @property
    @pulumi.getter(name="stringListValues")
    def string_list_values(self) -> Optional[Sequence[str]]:
        """
        A list of strings.
        """
        return pulumi.get(self, "string_list_values")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        return pulumi.get(self, "string_value")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetDocumentAttributeKey":
            suggest = "target_document_attribute_key"
        elif key == "targetDocumentAttributeValue":
            suggest = "target_document_attribute_value"
        elif key == "targetDocumentAttributeValueDeletion":
            suggest = "target_document_attribute_value_deletion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_document_attribute_key: Optional[str] = None,
                 target_document_attribute_value: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue'] = None,
                 target_document_attribute_value_deletion: Optional[bool] = None):
        """
        :param str target_document_attribute_key: The identifier of the target document attribute or metadata field. For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
        :param 'DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValueArgs' target_document_attribute_value: The target value you want to create for the target attribute. For example, 'Finance' could be the target value for the target attribute key 'Department'. See target_document_attribute_value.
        :param bool target_document_attribute_value_deletion: `TRUE` to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to `TRUE`. To create a target value (`TargetDocumentAttributeValue`), set this to `FALSE`.
        """
        if target_document_attribute_key is not None:
            pulumi.set(__self__, "target_document_attribute_key", target_document_attribute_key)
        if target_document_attribute_value is not None:
            pulumi.set(__self__, "target_document_attribute_value", target_document_attribute_value)
        if target_document_attribute_value_deletion is not None:
            pulumi.set(__self__, "target_document_attribute_value_deletion", target_document_attribute_value_deletion)

    @property
    @pulumi.getter(name="targetDocumentAttributeKey")
    def target_document_attribute_key(self) -> Optional[str]:
        """
        The identifier of the target document attribute or metadata field. For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
        """
        return pulumi.get(self, "target_document_attribute_key")

    @property
    @pulumi.getter(name="targetDocumentAttributeValue")
    def target_document_attribute_value(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue']:
        """
        The target value you want to create for the target attribute. For example, 'Finance' could be the target value for the target attribute key 'Department'. See target_document_attribute_value.
        """
        return pulumi.get(self, "target_document_attribute_value")

    @property
    @pulumi.getter(name="targetDocumentAttributeValueDeletion")
    def target_document_attribute_value_deletion(self) -> Optional[bool]:
        """
        `TRUE` to delete the existing target value for your specified target attribute key. You cannot create a target value and set this to `TRUE`. To create a target value (`TargetDocumentAttributeValue`), set this to `FALSE`.
        """
        return pulumi.get(self, "target_document_attribute_value_deletion")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateValue":
            suggest = "date_value"
        elif key == "longValue":
            suggest = "long_value"
        elif key == "stringListValues":
            suggest = "string_list_values"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationInlineConfigurationTargetTargetDocumentAttributeValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_value: Optional[str] = None,
                 long_value: Optional[int] = None,
                 string_list_values: Optional[Sequence[str]] = None,
                 string_value: Optional[str] = None):
        """
        :param str date_value: A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        :param int long_value: A long integer value.
        :param Sequence[str] string_list_values: A list of strings.
        """
        if date_value is not None:
            pulumi.set(__self__, "date_value", date_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if string_list_values is not None:
            pulumi.set(__self__, "string_list_values", string_list_values)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> Optional[str]:
        """
        A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        """
        return pulumi.get(self, "date_value")

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[int]:
        """
        A long integer value.
        """
        return pulumi.get(self, "long_value")

    @property
    @pulumi.getter(name="stringListValues")
    def string_list_values(self) -> Optional[Sequence[str]]:
        """
        A list of strings.
        """
        return pulumi.get(self, "string_list_values")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        return pulumi.get(self, "string_value")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "invocationCondition":
            suggest = "invocation_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str,
                 s3_bucket: str,
                 invocation_condition: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationCondition'] = None):
        """
        :param str lambda_arn: The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
        :param str s3_bucket: Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
        :param 'DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionArgs' invocation_condition: A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        if invocation_condition is not None:
            pulumi.set(__self__, "invocation_condition", invocation_condition)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="invocationCondition")
    def invocation_condition(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationCondition']:
        """
        A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
        """
        return pulumi.get(self, "invocation_condition")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionDocumentAttributeKey":
            suggest = "condition_document_attribute_key"
        elif key == "conditionOnValue":
            suggest = "condition_on_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_document_attribute_key: str,
                 operator: str,
                 condition_on_value: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValue'] = None):
        """
        :param str condition_document_attribute_key: The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
        :param str operator: The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
        :param 'DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValueArgs' condition_on_value: The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
        """
        pulumi.set(__self__, "condition_document_attribute_key", condition_document_attribute_key)
        pulumi.set(__self__, "operator", operator)
        if condition_on_value is not None:
            pulumi.set(__self__, "condition_on_value", condition_on_value)

    @property
    @pulumi.getter(name="conditionDocumentAttributeKey")
    def condition_document_attribute_key(self) -> str:
        """
        The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
        """
        return pulumi.get(self, "condition_document_attribute_key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="conditionOnValue")
    def condition_on_value(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValue']:
        """
        The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
        """
        return pulumi.get(self, "condition_on_value")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateValue":
            suggest = "date_value"
        elif key == "longValue":
            suggest = "long_value"
        elif key == "stringListValues":
            suggest = "string_list_values"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPostExtractionHookConfigurationInvocationConditionConditionOnValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_value: Optional[str] = None,
                 long_value: Optional[int] = None,
                 string_list_values: Optional[Sequence[str]] = None,
                 string_value: Optional[str] = None):
        """
        :param str date_value: A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        :param int long_value: A long integer value.
        :param Sequence[str] string_list_values: A list of strings.
        """
        if date_value is not None:
            pulumi.set(__self__, "date_value", date_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if string_list_values is not None:
            pulumi.set(__self__, "string_list_values", string_list_values)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> Optional[str]:
        """
        A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        """
        return pulumi.get(self, "date_value")

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[int]:
        """
        A long integer value.
        """
        return pulumi.get(self, "long_value")

    @property
    @pulumi.getter(name="stringListValues")
    def string_list_values(self) -> Optional[Sequence[str]]:
        """
        A list of strings.
        """
        return pulumi.get(self, "string_list_values")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        return pulumi.get(self, "string_value")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "invocationCondition":
            suggest = "invocation_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str,
                 s3_bucket: str,
                 invocation_condition: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition'] = None):
        """
        :param str lambda_arn: The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
        :param str s3_bucket: Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
        :param 'DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionArgs' invocation_condition: A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        if invocation_condition is not None:
            pulumi.set(__self__, "invocation_condition", invocation_condition)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of a Lambda Function that can manipulate your document metadata fields or attributes and content.
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="invocationCondition")
    def invocation_condition(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition']:
        """
        A block that specifies the condition used for when a Lambda function should be invoked. For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time. See invocation_condition.
        """
        return pulumi.get(self, "invocation_condition")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionDocumentAttributeKey":
            suggest = "condition_document_attribute_key"
        elif key == "conditionOnValue":
            suggest = "condition_on_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_document_attribute_key: str,
                 operator: str,
                 condition_on_value: Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue'] = None):
        """
        :param str condition_document_attribute_key: The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
        :param str operator: The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
        :param 'DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValueArgs' condition_on_value: The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
        """
        pulumi.set(__self__, "condition_document_attribute_key", condition_document_attribute_key)
        pulumi.set(__self__, "operator", operator)
        if condition_on_value is not None:
            pulumi.set(__self__, "condition_on_value", condition_on_value)

    @property
    @pulumi.getter(name="conditionDocumentAttributeKey")
    def condition_document_attribute_key(self) -> str:
        """
        The identifier of the document attribute used for the condition. For example, `_source_uri` could be an identifier for the attribute or metadata field that contains source URIs associated with the documents. Amazon Kendra currently does not support `_document_body` as an attribute key used for the condition.
        """
        return pulumi.get(self, "condition_document_attribute_key")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The condition operator. For example, you can use `Contains` to partially match a string. Valid Values: `GreaterThan` | `GreaterThanOrEquals` | `LessThan` | `LessThanOrEquals` | `Equals` | `NotEquals` | `Contains` | `NotContains` | `Exists` | `NotExists` | `BeginsWith`.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="conditionOnValue")
    def condition_on_value(self) -> Optional['outputs.DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue']:
        """
        The value used by the operator. For example, you can specify the value 'financial' for strings in the `_source_uri` field that partially match or contain this value. See condition_on_value.
        """
        return pulumi.get(self, "condition_on_value")


@pulumi.output_type
class DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateValue":
            suggest = "date_value"
        elif key == "longValue":
            suggest = "long_value"
        elif key == "stringListValues":
            suggest = "string_list_values"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceCustomDocumentEnrichmentConfigurationPreExtractionHookConfigurationInvocationConditionConditionOnValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_value: Optional[str] = None,
                 long_value: Optional[int] = None,
                 string_list_values: Optional[Sequence[str]] = None,
                 string_value: Optional[str] = None):
        """
        :param str date_value: A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        :param int long_value: A long integer value.
        :param Sequence[str] string_list_values: A list of strings.
        """
        if date_value is not None:
            pulumi.set(__self__, "date_value", date_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if string_list_values is not None:
            pulumi.set(__self__, "string_list_values", string_list_values)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> Optional[str]:
        """
        A date expressed as an ISO 8601 string. It is important for the time zone to be included in the ISO 8601 date-time format. As of this writing only UTC is supported. For example, `2012-03-25T12:30:10+00:00`.
        """
        return pulumi.get(self, "date_value")

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[int]:
        """
        A long integer value.
        """
        return pulumi.get(self, "long_value")

    @property
    @pulumi.getter(name="stringListValues")
    def string_list_values(self) -> Optional[Sequence[str]]:
        """
        A list of strings.
        """
        return pulumi.get(self, "string_list_values")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[str]:
        return pulumi.get(self, "string_value")


@pulumi.output_type
class ExperienceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentSourceConfiguration":
            suggest = "content_source_configuration"
        elif key == "userIdentityConfiguration":
            suggest = "user_identity_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperienceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperienceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperienceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_source_configuration: Optional['outputs.ExperienceConfigurationContentSourceConfiguration'] = None,
                 user_identity_configuration: Optional['outputs.ExperienceConfigurationUserIdentityConfiguration'] = None):
        """
        :param 'ExperienceConfigurationContentSourceConfigurationArgs' content_source_configuration: The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the `BatchPutDocument API`. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
        :param 'ExperienceConfigurationUserIdentityConfigurationArgs' user_identity_configuration: The AWS SSO field name that contains the identifiers of your users, such as their emails. Detailed below.
        """
        if content_source_configuration is not None:
            pulumi.set(__self__, "content_source_configuration", content_source_configuration)
        if user_identity_configuration is not None:
            pulumi.set(__self__, "user_identity_configuration", user_identity_configuration)

    @property
    @pulumi.getter(name="contentSourceConfiguration")
    def content_source_configuration(self) -> Optional['outputs.ExperienceConfigurationContentSourceConfiguration']:
        """
        The identifiers of your data sources and FAQs. Or, you can specify that you want to use documents indexed via the `BatchPutDocument API`. The provider will only perform drift detection of its value when present in a configuration. Detailed below.
        """
        return pulumi.get(self, "content_source_configuration")

    @property
    @pulumi.getter(name="userIdentityConfiguration")
    def user_identity_configuration(self) -> Optional['outputs.ExperienceConfigurationUserIdentityConfiguration']:
        """
        The AWS SSO field name that contains the identifiers of your users, such as their emails. Detailed below.
        """
        return pulumi.get(self, "user_identity_configuration")


@pulumi.output_type
class ExperienceConfigurationContentSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceIds":
            suggest = "data_source_ids"
        elif key == "directPutContent":
            suggest = "direct_put_content"
        elif key == "faqIds":
            suggest = "faq_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperienceConfigurationContentSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperienceConfigurationContentSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperienceConfigurationContentSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_ids: Optional[Sequence[str]] = None,
                 direct_put_content: Optional[bool] = None,
                 faq_ids: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] data_source_ids: The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
        :param bool direct_put_content: Whether to use documents you indexed directly using the `BatchPutDocument API`. Defaults to `false`.
        :param Sequence[str] faq_ids: The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
        """
        if data_source_ids is not None:
            pulumi.set(__self__, "data_source_ids", data_source_ids)
        if direct_put_content is not None:
            pulumi.set(__self__, "direct_put_content", direct_put_content)
        if faq_ids is not None:
            pulumi.set(__self__, "faq_ids", faq_ids)

    @property
    @pulumi.getter(name="dataSourceIds")
    def data_source_ids(self) -> Optional[Sequence[str]]:
        """
        The identifiers of the data sources you want to use for your Amazon Kendra experience. Maximum number of 100 items.
        """
        return pulumi.get(self, "data_source_ids")

    @property
    @pulumi.getter(name="directPutContent")
    def direct_put_content(self) -> Optional[bool]:
        """
        Whether to use documents you indexed directly using the `BatchPutDocument API`. Defaults to `false`.
        """
        return pulumi.get(self, "direct_put_content")

    @property
    @pulumi.getter(name="faqIds")
    def faq_ids(self) -> Optional[Sequence[str]]:
        """
        The identifier of the FAQs that you want to use for your Amazon Kendra experience. Maximum number of 100 items.
        """
        return pulumi.get(self, "faq_ids")


@pulumi.output_type
class ExperienceConfigurationUserIdentityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityAttributeName":
            suggest = "identity_attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperienceConfigurationUserIdentityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperienceConfigurationUserIdentityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperienceConfigurationUserIdentityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_attribute_name: str):
        """
        :param str identity_attribute_name: The AWS SSO field name that contains the identifiers of your users, such as their emails.
        """
        pulumi.set(__self__, "identity_attribute_name", identity_attribute_name)

    @property
    @pulumi.getter(name="identityAttributeName")
    def identity_attribute_name(self) -> str:
        """
        The AWS SSO field name that contains the identifiers of your users, such as their emails.
        """
        return pulumi.get(self, "identity_attribute_name")


@pulumi.output_type
class ExperienceEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperienceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperienceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperienceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[str] = None,
                 endpoint_type: Optional[str] = None):
        """
        :param str endpoint: The endpoint of your Amazon Kendra experience.
        :param str endpoint_type: The type of endpoint for your Amazon Kendra experience.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The endpoint of your Amazon Kendra experience.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[str]:
        """
        The type of endpoint for your Amazon Kendra experience.
        """
        return pulumi.get(self, "endpoint_type")


@pulumi.output_type
class FaqS3Path(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        :param str bucket: The name of the S3 bucket that contains the file.
        :param str key: The name of the file.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the file.

        The following arguments are optional:
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class IndexCapacityUnits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryCapacityUnits":
            suggest = "query_capacity_units"
        elif key == "storageCapacityUnits":
            suggest = "storage_capacity_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexCapacityUnits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexCapacityUnits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexCapacityUnits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_capacity_units: Optional[int] = None,
                 storage_capacity_units: Optional[int] = None):
        """
        :param int query_capacity_units: The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/dg/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
        :param int storage_capacity_units: The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
        """
        if query_capacity_units is not None:
            pulumi.set(__self__, "query_capacity_units", query_capacity_units)
        if storage_capacity_units is not None:
            pulumi.set(__self__, "storage_capacity_units", storage_capacity_units)

    @property
    @pulumi.getter(name="queryCapacityUnits")
    def query_capacity_units(self) -> Optional[int]:
        """
        The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/dg/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
        """
        return pulumi.get(self, "query_capacity_units")

    @property
    @pulumi.getter(name="storageCapacityUnits")
    def storage_capacity_units(self) -> Optional[int]:
        """
        The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
        """
        return pulumi.get(self, "storage_capacity_units")


@pulumi.output_type
class IndexDocumentMetadataConfigurationUpdate(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 relevance: Optional['outputs.IndexDocumentMetadataConfigurationUpdateRelevance'] = None,
                 search: Optional['outputs.IndexDocumentMetadataConfigurationUpdateSearch'] = None):
        """
        :param str name: The name of the index field. Minimum length of 1. Maximum length of 30.
        :param str type: The data type of the index field. Valid values are `STRING_VALUE`, `STRING_LIST_VALUE`, `LONG_VALUE`, `DATE_VALUE`.
        :param 'IndexDocumentMetadataConfigurationUpdateRelevanceArgs' relevance: A block that provides manual tuning parameters to determine how the field affects the search results. Detailed below
        :param 'IndexDocumentMetadataConfigurationUpdateSearchArgs' search: A block that provides information about how the field is used during a search. Documented below. Detailed below
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if relevance is not None:
            pulumi.set(__self__, "relevance", relevance)
        if search is not None:
            pulumi.set(__self__, "search", search)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the index field. Minimum length of 1. Maximum length of 30.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The data type of the index field. Valid values are `STRING_VALUE`, `STRING_LIST_VALUE`, `LONG_VALUE`, `DATE_VALUE`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def relevance(self) -> Optional['outputs.IndexDocumentMetadataConfigurationUpdateRelevance']:
        """
        A block that provides manual tuning parameters to determine how the field affects the search results. Detailed below
        """
        return pulumi.get(self, "relevance")

    @property
    @pulumi.getter
    def search(self) -> Optional['outputs.IndexDocumentMetadataConfigurationUpdateSearch']:
        """
        A block that provides information about how the field is used during a search. Documented below. Detailed below
        """
        return pulumi.get(self, "search")


@pulumi.output_type
class IndexDocumentMetadataConfigurationUpdateRelevance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rankOrder":
            suggest = "rank_order"
        elif key == "valuesImportanceMap":
            suggest = "values_importance_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexDocumentMetadataConfigurationUpdateRelevance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexDocumentMetadataConfigurationUpdateRelevance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexDocumentMetadataConfigurationUpdateRelevance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: Optional[str] = None,
                 freshness: Optional[bool] = None,
                 importance: Optional[int] = None,
                 rank_order: Optional[str] = None,
                 values_importance_map: Optional[Mapping[str, int]] = None):
        """
        :param str duration: Specifies the time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Duration).
        :param bool freshness: Indicates that this field determines how "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Freshness).
        :param int importance: The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
        :param str rank_order: Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
        :param Mapping[str, int] values_importance_map: A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
        """
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if freshness is not None:
            pulumi.set(__self__, "freshness", freshness)
        if importance is not None:
            pulumi.set(__self__, "importance", importance)
        if rank_order is not None:
            pulumi.set(__self__, "rank_order", rank_order)
        if values_importance_map is not None:
            pulumi.set(__self__, "values_importance_map", values_importance_map)

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        Specifies the time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Duration).
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def freshness(self) -> Optional[bool]:
        """
        Indicates that this field determines how "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-Freshness).
        """
        return pulumi.get(self, "freshness")

    @property
    @pulumi.getter
    def importance(self) -> Optional[int]:
        """
        The relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
        """
        return pulumi.get(self, "importance")

    @property
    @pulumi.getter(name="rankOrder")
    def rank_order(self) -> Optional[str]:
        """
        Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
        """
        return pulumi.get(self, "rank_order")

    @property
    @pulumi.getter(name="valuesImportanceMap")
    def values_importance_map(self) -> Optional[Mapping[str, int]]:
        """
        A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/dg/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
        """
        return pulumi.get(self, "values_importance_map")


@pulumi.output_type
class IndexDocumentMetadataConfigurationUpdateSearch(dict):
    def __init__(__self__, *,
                 displayable: Optional[bool] = None,
                 facetable: Optional[bool] = None,
                 searchable: Optional[bool] = None,
                 sortable: Optional[bool] = None):
        """
        :param bool displayable: Determines whether the field is returned in the query response. The default is `true`.
        :param bool facetable: Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
        :param bool searchable: Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
        :param bool sortable: Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
        """
        if displayable is not None:
            pulumi.set(__self__, "displayable", displayable)
        if facetable is not None:
            pulumi.set(__self__, "facetable", facetable)
        if searchable is not None:
            pulumi.set(__self__, "searchable", searchable)
        if sortable is not None:
            pulumi.set(__self__, "sortable", sortable)

    @property
    @pulumi.getter
    def displayable(self) -> Optional[bool]:
        """
        Determines whether the field is returned in the query response. The default is `true`.
        """
        return pulumi.get(self, "displayable")

    @property
    @pulumi.getter
    def facetable(self) -> Optional[bool]:
        """
        Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
        """
        return pulumi.get(self, "facetable")

    @property
    @pulumi.getter
    def searchable(self) -> Optional[bool]:
        """
        Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
        """
        return pulumi.get(self, "searchable")

    @property
    @pulumi.getter
    def sortable(self) -> Optional[bool]:
        """
        Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
        """
        return pulumi.get(self, "sortable")


@pulumi.output_type
class IndexIndexStatistic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "faqStatistics":
            suggest = "faq_statistics"
        elif key == "textDocumentStatistics":
            suggest = "text_document_statistics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexIndexStatistic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexIndexStatistic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexIndexStatistic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 faq_statistics: Optional[Sequence['outputs.IndexIndexStatisticFaqStatistic']] = None,
                 text_document_statistics: Optional[Sequence['outputs.IndexIndexStatisticTextDocumentStatistic']] = None):
        """
        :param Sequence['IndexIndexStatisticFaqStatisticArgs'] faq_statistics: A block that specifies the number of question and answer topics in the index. Detailed below.
        :param Sequence['IndexIndexStatisticTextDocumentStatisticArgs'] text_document_statistics: A block that specifies the number of text documents indexed. Detailed below.
        """
        if faq_statistics is not None:
            pulumi.set(__self__, "faq_statistics", faq_statistics)
        if text_document_statistics is not None:
            pulumi.set(__self__, "text_document_statistics", text_document_statistics)

    @property
    @pulumi.getter(name="faqStatistics")
    def faq_statistics(self) -> Optional[Sequence['outputs.IndexIndexStatisticFaqStatistic']]:
        """
        A block that specifies the number of question and answer topics in the index. Detailed below.
        """
        return pulumi.get(self, "faq_statistics")

    @property
    @pulumi.getter(name="textDocumentStatistics")
    def text_document_statistics(self) -> Optional[Sequence['outputs.IndexIndexStatisticTextDocumentStatistic']]:
        """
        A block that specifies the number of text documents indexed. Detailed below.
        """
        return pulumi.get(self, "text_document_statistics")


@pulumi.output_type
class IndexIndexStatisticFaqStatistic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexedQuestionAnswersCount":
            suggest = "indexed_question_answers_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexIndexStatisticFaqStatistic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexIndexStatisticFaqStatistic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexIndexStatisticFaqStatistic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 indexed_question_answers_count: Optional[int] = None):
        """
        :param int indexed_question_answers_count: The total number of FAQ questions and answers contained in the index.
        """
        if indexed_question_answers_count is not None:
            pulumi.set(__self__, "indexed_question_answers_count", indexed_question_answers_count)

    @property
    @pulumi.getter(name="indexedQuestionAnswersCount")
    def indexed_question_answers_count(self) -> Optional[int]:
        """
        The total number of FAQ questions and answers contained in the index.
        """
        return pulumi.get(self, "indexed_question_answers_count")


@pulumi.output_type
class IndexIndexStatisticTextDocumentStatistic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexedTextBytes":
            suggest = "indexed_text_bytes"
        elif key == "indexedTextDocumentsCount":
            suggest = "indexed_text_documents_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexIndexStatisticTextDocumentStatistic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexIndexStatisticTextDocumentStatistic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexIndexStatisticTextDocumentStatistic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 indexed_text_bytes: Optional[int] = None,
                 indexed_text_documents_count: Optional[int] = None):
        """
        :param int indexed_text_bytes: The total size, in bytes, of the indexed documents.
        :param int indexed_text_documents_count: The number of text documents indexed.
        """
        if indexed_text_bytes is not None:
            pulumi.set(__self__, "indexed_text_bytes", indexed_text_bytes)
        if indexed_text_documents_count is not None:
            pulumi.set(__self__, "indexed_text_documents_count", indexed_text_documents_count)

    @property
    @pulumi.getter(name="indexedTextBytes")
    def indexed_text_bytes(self) -> Optional[int]:
        """
        The total size, in bytes, of the indexed documents.
        """
        return pulumi.get(self, "indexed_text_bytes")

    @property
    @pulumi.getter(name="indexedTextDocumentsCount")
    def indexed_text_documents_count(self) -> Optional[int]:
        """
        The number of text documents indexed.
        """
        return pulumi.get(self, "indexed_text_documents_count")


@pulumi.output_type
class IndexServerSideEncryptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexServerSideEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexServerSideEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexServerSideEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        :param str kms_key_id: The identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class IndexUserGroupResolutionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userGroupResolutionMode":
            suggest = "user_group_resolution_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexUserGroupResolutionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexUserGroupResolutionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexUserGroupResolutionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_group_resolution_mode: str):
        """
        :param str user_group_resolution_mode: The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
        """
        pulumi.set(__self__, "user_group_resolution_mode", user_group_resolution_mode)

    @property
    @pulumi.getter(name="userGroupResolutionMode")
    def user_group_resolution_mode(self) -> str:
        """
        The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
        """
        return pulumi.get(self, "user_group_resolution_mode")


@pulumi.output_type
class IndexUserTokenConfigurations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonTokenTypeConfiguration":
            suggest = "json_token_type_configuration"
        elif key == "jwtTokenTypeConfiguration":
            suggest = "jwt_token_type_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexUserTokenConfigurations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexUserTokenConfigurations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexUserTokenConfigurations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_token_type_configuration: Optional['outputs.IndexUserTokenConfigurationsJsonTokenTypeConfiguration'] = None,
                 jwt_token_type_configuration: Optional['outputs.IndexUserTokenConfigurationsJwtTokenTypeConfiguration'] = None):
        """
        :param 'IndexUserTokenConfigurationsJsonTokenTypeConfigurationArgs' json_token_type_configuration: A block that specifies the information about the JSON token type configuration. Detailed below.
        :param 'IndexUserTokenConfigurationsJwtTokenTypeConfigurationArgs' jwt_token_type_configuration: A block that specifies the information about the JWT token type configuration. Detailed below.
        """
        if json_token_type_configuration is not None:
            pulumi.set(__self__, "json_token_type_configuration", json_token_type_configuration)
        if jwt_token_type_configuration is not None:
            pulumi.set(__self__, "jwt_token_type_configuration", jwt_token_type_configuration)

    @property
    @pulumi.getter(name="jsonTokenTypeConfiguration")
    def json_token_type_configuration(self) -> Optional['outputs.IndexUserTokenConfigurationsJsonTokenTypeConfiguration']:
        """
        A block that specifies the information about the JSON token type configuration. Detailed below.
        """
        return pulumi.get(self, "json_token_type_configuration")

    @property
    @pulumi.getter(name="jwtTokenTypeConfiguration")
    def jwt_token_type_configuration(self) -> Optional['outputs.IndexUserTokenConfigurationsJwtTokenTypeConfiguration']:
        """
        A block that specifies the information about the JWT token type configuration. Detailed below.
        """
        return pulumi.get(self, "jwt_token_type_configuration")


@pulumi.output_type
class IndexUserTokenConfigurationsJsonTokenTypeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupAttributeField":
            suggest = "group_attribute_field"
        elif key == "userNameAttributeField":
            suggest = "user_name_attribute_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexUserTokenConfigurationsJsonTokenTypeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexUserTokenConfigurationsJsonTokenTypeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexUserTokenConfigurationsJsonTokenTypeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_attribute_field: str,
                 user_name_attribute_field: str):
        """
        :param str group_attribute_field: The group attribute field. Minimum length of 1. Maximum length of 2048.
        :param str user_name_attribute_field: The user name attribute field. Minimum length of 1. Maximum length of 2048.
        """
        pulumi.set(__self__, "group_attribute_field", group_attribute_field)
        pulumi.set(__self__, "user_name_attribute_field", user_name_attribute_field)

    @property
    @pulumi.getter(name="groupAttributeField")
    def group_attribute_field(self) -> str:
        """
        The group attribute field. Minimum length of 1. Maximum length of 2048.
        """
        return pulumi.get(self, "group_attribute_field")

    @property
    @pulumi.getter(name="userNameAttributeField")
    def user_name_attribute_field(self) -> str:
        """
        The user name attribute field. Minimum length of 1. Maximum length of 2048.
        """
        return pulumi.get(self, "user_name_attribute_field")


@pulumi.output_type
class IndexUserTokenConfigurationsJwtTokenTypeConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyLocation":
            suggest = "key_location"
        elif key == "claimRegex":
            suggest = "claim_regex"
        elif key == "groupAttributeField":
            suggest = "group_attribute_field"
        elif key == "secretsManagerArn":
            suggest = "secrets_manager_arn"
        elif key == "userNameAttributeField":
            suggest = "user_name_attribute_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexUserTokenConfigurationsJwtTokenTypeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexUserTokenConfigurationsJwtTokenTypeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexUserTokenConfigurationsJwtTokenTypeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_location: str,
                 claim_regex: Optional[str] = None,
                 group_attribute_field: Optional[str] = None,
                 issuer: Optional[str] = None,
                 secrets_manager_arn: Optional[str] = None,
                 url: Optional[str] = None,
                 user_name_attribute_field: Optional[str] = None):
        """
        :param str key_location: The location of the key. Valid values are `URL` or `SECRET_MANAGER`
        :param str claim_regex: The regular expression that identifies the claim. Minimum length of 1. Maximum length of 100.
        :param str group_attribute_field: The group attribute field. Minimum length of 1. Maximum length of 100.
        :param str issuer: The issuer of the token. Minimum length of 1. Maximum length of 65.
        :param str secrets_manager_arn: The Amazon Resource Name (ARN) of the secret.
        :param str url: The signing key URL. Valid pattern is `^(https?|ftp|file):\\/\\/([^\\s]*)`
        :param str user_name_attribute_field: The user name attribute field. Minimum length of 1. Maximum length of 100.
        """
        pulumi.set(__self__, "key_location", key_location)
        if claim_regex is not None:
            pulumi.set(__self__, "claim_regex", claim_regex)
        if group_attribute_field is not None:
            pulumi.set(__self__, "group_attribute_field", group_attribute_field)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if secrets_manager_arn is not None:
            pulumi.set(__self__, "secrets_manager_arn", secrets_manager_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_name_attribute_field is not None:
            pulumi.set(__self__, "user_name_attribute_field", user_name_attribute_field)

    @property
    @pulumi.getter(name="keyLocation")
    def key_location(self) -> str:
        """
        The location of the key. Valid values are `URL` or `SECRET_MANAGER`
        """
        return pulumi.get(self, "key_location")

    @property
    @pulumi.getter(name="claimRegex")
    def claim_regex(self) -> Optional[str]:
        """
        The regular expression that identifies the claim. Minimum length of 1. Maximum length of 100.
        """
        return pulumi.get(self, "claim_regex")

    @property
    @pulumi.getter(name="groupAttributeField")
    def group_attribute_field(self) -> Optional[str]:
        """
        The group attribute field. Minimum length of 1. Maximum length of 100.
        """
        return pulumi.get(self, "group_attribute_field")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[str]:
        """
        The issuer of the token. Minimum length of 1. Maximum length of 65.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The signing key URL. Valid pattern is `^(https?|ftp|file):\\/\\/([^\\s]*)`
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userNameAttributeField")
    def user_name_attribute_field(self) -> Optional[str]:
        """
        The user name attribute field. Minimum length of 1. Maximum length of 100.
        """
        return pulumi.get(self, "user_name_attribute_field")


@pulumi.output_type
class QuerySuggestionsBlockListSourceS3Path(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        :param str bucket: Name of the S3 bucket that contains the file.
        :param str key: Name of the file.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Name of the file.

        The following arguments are optional:
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class ThesaurusSourceS3Path(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        :param str bucket: The name of the S3 bucket that contains the file.
        :param str key: The name of the file.
               
               The following arguments are optional:
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the file.

        The following arguments are optional:
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetExperienceConfigurationResult(dict):
    def __init__(__self__, *,
                 content_source_configurations: Sequence['outputs.GetExperienceConfigurationContentSourceConfigurationResult'],
                 user_identity_configurations: Sequence['outputs.GetExperienceConfigurationUserIdentityConfigurationResult']):
        """
        :param Sequence['GetExperienceConfigurationContentSourceConfigurationArgs'] content_source_configurations: The identifiers of your data sources and FAQs. This is the content you want to use for your Amazon Kendra Experience. Documented below.
        :param Sequence['GetExperienceConfigurationUserIdentityConfigurationArgs'] user_identity_configurations: The AWS SSO field name that contains the identifiers of your users, such as their emails. Documented below.
        """
        pulumi.set(__self__, "content_source_configurations", content_source_configurations)
        pulumi.set(__self__, "user_identity_configurations", user_identity_configurations)

    @property
    @pulumi.getter(name="contentSourceConfigurations")
    def content_source_configurations(self) -> Sequence['outputs.GetExperienceConfigurationContentSourceConfigurationResult']:
        """
        The identifiers of your data sources and FAQs. This is the content you want to use for your Amazon Kendra Experience. Documented below.
        """
        return pulumi.get(self, "content_source_configurations")

    @property
    @pulumi.getter(name="userIdentityConfigurations")
    def user_identity_configurations(self) -> Sequence['outputs.GetExperienceConfigurationUserIdentityConfigurationResult']:
        """
        The AWS SSO field name that contains the identifiers of your users, such as their emails. Documented below.
        """
        return pulumi.get(self, "user_identity_configurations")


@pulumi.output_type
class GetExperienceConfigurationContentSourceConfigurationResult(dict):
    def __init__(__self__, *,
                 data_source_ids: Sequence[str],
                 direct_put_content: bool,
                 faq_ids: Sequence[str]):
        """
        :param Sequence[str] data_source_ids: Identifiers of the data sources you want to use for your Amazon Kendra Experience.
        :param bool direct_put_content: Whether to use documents you indexed directly using the `BatchPutDocument API`.
        :param Sequence[str] faq_ids: Identifier of the FAQs that you want to use for your Amazon Kendra Experience.
        """
        pulumi.set(__self__, "data_source_ids", data_source_ids)
        pulumi.set(__self__, "direct_put_content", direct_put_content)
        pulumi.set(__self__, "faq_ids", faq_ids)

    @property
    @pulumi.getter(name="dataSourceIds")
    def data_source_ids(self) -> Sequence[str]:
        """
        Identifiers of the data sources you want to use for your Amazon Kendra Experience.
        """
        return pulumi.get(self, "data_source_ids")

    @property
    @pulumi.getter(name="directPutContent")
    def direct_put_content(self) -> bool:
        """
        Whether to use documents you indexed directly using the `BatchPutDocument API`.
        """
        return pulumi.get(self, "direct_put_content")

    @property
    @pulumi.getter(name="faqIds")
    def faq_ids(self) -> Sequence[str]:
        """
        Identifier of the FAQs that you want to use for your Amazon Kendra Experience.
        """
        return pulumi.get(self, "faq_ids")


@pulumi.output_type
class GetExperienceConfigurationUserIdentityConfigurationResult(dict):
    def __init__(__self__, *,
                 identity_attribute_name: str):
        """
        :param str identity_attribute_name: The AWS SSO field name that contains the identifiers of your users, such as their emails.
        """
        pulumi.set(__self__, "identity_attribute_name", identity_attribute_name)

    @property
    @pulumi.getter(name="identityAttributeName")
    def identity_attribute_name(self) -> str:
        """
        The AWS SSO field name that contains the identifiers of your users, such as their emails.
        """
        return pulumi.get(self, "identity_attribute_name")


@pulumi.output_type
class GetExperienceEndpointResult(dict):
    def __init__(__self__, *,
                 endpoint: str,
                 endpoint_type: str):
        """
        :param str endpoint: Endpoint of your Amazon Kendra Experience.
        :param str endpoint_type: Type of endpoint for your Amazon Kendra Experience.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "endpoint_type", endpoint_type)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Endpoint of your Amazon Kendra Experience.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of endpoint for your Amazon Kendra Experience.
        """
        return pulumi.get(self, "endpoint_type")


@pulumi.output_type
class GetFaqS3PathResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        :param str bucket: Name of the S3 bucket that contains the file.
        :param str key: Name of the file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Name of the file.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetIndexCapacityUnitResult(dict):
    def __init__(__self__, *,
                 query_capacity_units: int,
                 storage_capacity_units: int):
        """
        :param int query_capacity_units: The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
        :param int storage_capacity_units: The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
        """
        pulumi.set(__self__, "query_capacity_units", query_capacity_units)
        pulumi.set(__self__, "storage_capacity_units", storage_capacity_units)

    @property
    @pulumi.getter(name="queryCapacityUnits")
    def query_capacity_units(self) -> int:
        """
        The amount of extra query capacity for an index and GetQuerySuggestions capacity. For more information, refer to [QueryCapacityUnits](https://docs.aws.amazon.com/kendra/latest/APIReference/API_CapacityUnitsConfiguration.html#Kendra-Type-CapacityUnitsConfiguration-QueryCapacityUnits).
        """
        return pulumi.get(self, "query_capacity_units")

    @property
    @pulumi.getter(name="storageCapacityUnits")
    def storage_capacity_units(self) -> int:
        """
        The amount of extra storage capacity for an index. A single capacity unit provides 30 GB of storage space or 100,000 documents, whichever is reached first. Minimum value of 0.
        """
        return pulumi.get(self, "storage_capacity_units")


@pulumi.output_type
class GetIndexDocumentMetadataConfigurationUpdateResult(dict):
    def __init__(__self__, *,
                 name: str,
                 relevances: Sequence['outputs.GetIndexDocumentMetadataConfigurationUpdateRelevanceResult'],
                 searches: Sequence['outputs.GetIndexDocumentMetadataConfigurationUpdateSearchResult'],
                 type: str):
        """
        :param str name: Name of the index field. Minimum length of 1. Maximum length of 30.
        :param Sequence['GetIndexDocumentMetadataConfigurationUpdateRelevanceArgs'] relevances: Block that provides manual tuning parameters to determine how the field affects the search results. Documented below.
        :param Sequence['GetIndexDocumentMetadataConfigurationUpdateSearchArgs'] searches: Block that provides information about how the field is used during a search. Documented below.
        :param str type: Data type of the index field. Valid values are `STRING_VALUE`, `STRING_LIST_VALUE`, `LONG_VALUE`, `DATE_VALUE`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "relevances", relevances)
        pulumi.set(__self__, "searches", searches)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the index field. Minimum length of 1. Maximum length of 30.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def relevances(self) -> Sequence['outputs.GetIndexDocumentMetadataConfigurationUpdateRelevanceResult']:
        """
        Block that provides manual tuning parameters to determine how the field affects the search results. Documented below.
        """
        return pulumi.get(self, "relevances")

    @property
    @pulumi.getter
    def searches(self) -> Sequence['outputs.GetIndexDocumentMetadataConfigurationUpdateSearchResult']:
        """
        Block that provides information about how the field is used during a search. Documented below.
        """
        return pulumi.get(self, "searches")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Data type of the index field. Valid values are `STRING_VALUE`, `STRING_LIST_VALUE`, `LONG_VALUE`, `DATE_VALUE`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetIndexDocumentMetadataConfigurationUpdateRelevanceResult(dict):
    def __init__(__self__, *,
                 duration: str,
                 freshness: bool,
                 importance: int,
                 rank_order: str,
                 values_importance_map: Mapping[str, int]):
        """
        :param str duration: Time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-Duration).
        :param bool freshness: How "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-Freshness).
        :param int importance: Relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
        :param str rank_order: Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
        :param Mapping[str, int] values_importance_map: A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "freshness", freshness)
        pulumi.set(__self__, "importance", importance)
        pulumi.set(__self__, "rank_order", rank_order)
        pulumi.set(__self__, "values_importance_map", values_importance_map)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        Time period that the boost applies to. For more information, refer to [Duration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-Duration).
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def freshness(self) -> bool:
        """
        How "fresh" a document is. For more information, refer to [Freshness](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-Freshness).
        """
        return pulumi.get(self, "freshness")

    @property
    @pulumi.getter
    def importance(self) -> int:
        """
        Relative importance of the field in the search. Larger numbers provide more of a boost than smaller numbers. Minimum value of 1. Maximum value of 10.
        """
        return pulumi.get(self, "importance")

    @property
    @pulumi.getter(name="rankOrder")
    def rank_order(self) -> str:
        """
        Determines how values should be interpreted. For more information, refer to [RankOrder](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-RankOrder).
        """
        return pulumi.get(self, "rank_order")

    @property
    @pulumi.getter(name="valuesImportanceMap")
    def values_importance_map(self) -> Mapping[str, int]:
        """
        A list of values that should be given a different boost when they appear in the result list. For more information, refer to [ValueImportanceMap](https://docs.aws.amazon.com/kendra/latest/APIReference/API_Relevance.html#Kendra-Type-Relevance-ValueImportanceMap).
        """
        return pulumi.get(self, "values_importance_map")


@pulumi.output_type
class GetIndexDocumentMetadataConfigurationUpdateSearchResult(dict):
    def __init__(__self__, *,
                 displayable: bool,
                 facetable: bool,
                 searchable: bool,
                 sortable: bool):
        """
        :param bool displayable: Determines whether the field is returned in the query response. The default is `true`.
        :param bool facetable: Whether the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
        :param bool searchable: Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
        :param bool sortable: Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
        """
        pulumi.set(__self__, "displayable", displayable)
        pulumi.set(__self__, "facetable", facetable)
        pulumi.set(__self__, "searchable", searchable)
        pulumi.set(__self__, "sortable", sortable)

    @property
    @pulumi.getter
    def displayable(self) -> bool:
        """
        Determines whether the field is returned in the query response. The default is `true`.
        """
        return pulumi.get(self, "displayable")

    @property
    @pulumi.getter
    def facetable(self) -> bool:
        """
        Whether the field can be used to create search facets, a count of results for each value in the field. The default is `false`.
        """
        return pulumi.get(self, "facetable")

    @property
    @pulumi.getter
    def searchable(self) -> bool:
        """
        Determines whether the field is used in the search. If the Searchable field is true, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for `string` fields and `false` for `number` and `date` fields.
        """
        return pulumi.get(self, "searchable")

    @property
    @pulumi.getter
    def sortable(self) -> bool:
        """
        Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have Sortable set to true, Amazon Kendra returns an exception. The default is `false`.
        """
        return pulumi.get(self, "sortable")


@pulumi.output_type
class GetIndexIndexStatisticResult(dict):
    def __init__(__self__, *,
                 faq_statistics: Sequence['outputs.GetIndexIndexStatisticFaqStatisticResult'],
                 text_document_statistics: Sequence['outputs.GetIndexIndexStatisticTextDocumentStatisticResult']):
        """
        :param Sequence['GetIndexIndexStatisticFaqStatisticArgs'] faq_statistics: Block that specifies the number of question and answer topics in the index. Documented below.
        :param Sequence['GetIndexIndexStatisticTextDocumentStatisticArgs'] text_document_statistics: A block that specifies the number of text documents indexed.
        """
        pulumi.set(__self__, "faq_statistics", faq_statistics)
        pulumi.set(__self__, "text_document_statistics", text_document_statistics)

    @property
    @pulumi.getter(name="faqStatistics")
    def faq_statistics(self) -> Sequence['outputs.GetIndexIndexStatisticFaqStatisticResult']:
        """
        Block that specifies the number of question and answer topics in the index. Documented below.
        """
        return pulumi.get(self, "faq_statistics")

    @property
    @pulumi.getter(name="textDocumentStatistics")
    def text_document_statistics(self) -> Sequence['outputs.GetIndexIndexStatisticTextDocumentStatisticResult']:
        """
        A block that specifies the number of text documents indexed.
        """
        return pulumi.get(self, "text_document_statistics")


@pulumi.output_type
class GetIndexIndexStatisticFaqStatisticResult(dict):
    def __init__(__self__, *,
                 indexed_question_answers_count: int):
        """
        :param int indexed_question_answers_count: The total number of FAQ questions and answers contained in the index.
        """
        pulumi.set(__self__, "indexed_question_answers_count", indexed_question_answers_count)

    @property
    @pulumi.getter(name="indexedQuestionAnswersCount")
    def indexed_question_answers_count(self) -> int:
        """
        The total number of FAQ questions and answers contained in the index.
        """
        return pulumi.get(self, "indexed_question_answers_count")


@pulumi.output_type
class GetIndexIndexStatisticTextDocumentStatisticResult(dict):
    def __init__(__self__, *,
                 indexed_text_bytes: int,
                 indexed_text_documents_count: int):
        """
        :param int indexed_text_bytes: Total size, in bytes, of the indexed documents.
        :param int indexed_text_documents_count: The number of text documents indexed.
        """
        pulumi.set(__self__, "indexed_text_bytes", indexed_text_bytes)
        pulumi.set(__self__, "indexed_text_documents_count", indexed_text_documents_count)

    @property
    @pulumi.getter(name="indexedTextBytes")
    def indexed_text_bytes(self) -> int:
        """
        Total size, in bytes, of the indexed documents.
        """
        return pulumi.get(self, "indexed_text_bytes")

    @property
    @pulumi.getter(name="indexedTextDocumentsCount")
    def indexed_text_documents_count(self) -> int:
        """
        The number of text documents indexed.
        """
        return pulumi.get(self, "indexed_text_documents_count")


@pulumi.output_type
class GetIndexServerSideEncryptionConfigurationResult(dict):
    def __init__(__self__, *,
                 kms_key_id: str):
        """
        :param str kms_key_id: Identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        Identifier of the AWS KMScustomer master key (CMK). Amazon Kendra doesn't support asymmetric CMKs.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetIndexUserGroupResolutionConfigurationResult(dict):
    def __init__(__self__, *,
                 user_group_resolution_mode: str):
        """
        :param str user_group_resolution_mode: The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
        """
        pulumi.set(__self__, "user_group_resolution_mode", user_group_resolution_mode)

    @property
    @pulumi.getter(name="userGroupResolutionMode")
    def user_group_resolution_mode(self) -> str:
        """
        The identity store provider (mode) you want to use to fetch access levels of groups and users. AWS Single Sign-On is currently the only available mode. Your users and groups must exist in an AWS SSO identity source in order to use this mode. Valid Values are `AWS_SSO` or `NONE`.
        """
        return pulumi.get(self, "user_group_resolution_mode")


@pulumi.output_type
class GetIndexUserTokenConfigurationResult(dict):
    def __init__(__self__, *,
                 json_token_type_configurations: Sequence['outputs.GetIndexUserTokenConfigurationJsonTokenTypeConfigurationResult'],
                 jwt_token_type_configurations: Sequence['outputs.GetIndexUserTokenConfigurationJwtTokenTypeConfigurationResult']):
        """
        :param Sequence['GetIndexUserTokenConfigurationJsonTokenTypeConfigurationArgs'] json_token_type_configurations: A block that specifies the information about the JSON token type configuration.
        :param Sequence['GetIndexUserTokenConfigurationJwtTokenTypeConfigurationArgs'] jwt_token_type_configurations: A block that specifies the information about the JWT token type configuration.
        """
        pulumi.set(__self__, "json_token_type_configurations", json_token_type_configurations)
        pulumi.set(__self__, "jwt_token_type_configurations", jwt_token_type_configurations)

    @property
    @pulumi.getter(name="jsonTokenTypeConfigurations")
    def json_token_type_configurations(self) -> Sequence['outputs.GetIndexUserTokenConfigurationJsonTokenTypeConfigurationResult']:
        """
        A block that specifies the information about the JSON token type configuration.
        """
        return pulumi.get(self, "json_token_type_configurations")

    @property
    @pulumi.getter(name="jwtTokenTypeConfigurations")
    def jwt_token_type_configurations(self) -> Sequence['outputs.GetIndexUserTokenConfigurationJwtTokenTypeConfigurationResult']:
        """
        A block that specifies the information about the JWT token type configuration.
        """
        return pulumi.get(self, "jwt_token_type_configurations")


@pulumi.output_type
class GetIndexUserTokenConfigurationJsonTokenTypeConfigurationResult(dict):
    def __init__(__self__, *,
                 group_attribute_field: str,
                 user_name_attribute_field: str):
        """
        :param str group_attribute_field: The group attribute field.
        :param str user_name_attribute_field: The user name attribute field.
        """
        pulumi.set(__self__, "group_attribute_field", group_attribute_field)
        pulumi.set(__self__, "user_name_attribute_field", user_name_attribute_field)

    @property
    @pulumi.getter(name="groupAttributeField")
    def group_attribute_field(self) -> str:
        """
        The group attribute field.
        """
        return pulumi.get(self, "group_attribute_field")

    @property
    @pulumi.getter(name="userNameAttributeField")
    def user_name_attribute_field(self) -> str:
        """
        The user name attribute field.
        """
        return pulumi.get(self, "user_name_attribute_field")


@pulumi.output_type
class GetIndexUserTokenConfigurationJwtTokenTypeConfigurationResult(dict):
    def __init__(__self__, *,
                 claim_regex: str,
                 group_attribute_field: str,
                 issuer: str,
                 key_location: str,
                 secrets_manager_arn: str,
                 url: str,
                 user_name_attribute_field: str):
        """
        :param str claim_regex: Regular expression that identifies the claim.
        :param str group_attribute_field: The group attribute field.
        :param str issuer: Issuer of the token.
        :param str key_location: Location of the key. Valid values are `URL` or `SECRET_MANAGER`
        :param str secrets_manager_arn: ARN of the secret.
        :param str url: Signing key URL.
        :param str user_name_attribute_field: The user name attribute field.
        """
        pulumi.set(__self__, "claim_regex", claim_regex)
        pulumi.set(__self__, "group_attribute_field", group_attribute_field)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "key_location", key_location)
        pulumi.set(__self__, "secrets_manager_arn", secrets_manager_arn)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user_name_attribute_field", user_name_attribute_field)

    @property
    @pulumi.getter(name="claimRegex")
    def claim_regex(self) -> str:
        """
        Regular expression that identifies the claim.
        """
        return pulumi.get(self, "claim_regex")

    @property
    @pulumi.getter(name="groupAttributeField")
    def group_attribute_field(self) -> str:
        """
        The group attribute field.
        """
        return pulumi.get(self, "group_attribute_field")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Issuer of the token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="keyLocation")
    def key_location(self) -> str:
        """
        Location of the key. Valid values are `URL` or `SECRET_MANAGER`
        """
        return pulumi.get(self, "key_location")

    @property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> str:
        """
        ARN of the secret.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Signing key URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userNameAttributeField")
    def user_name_attribute_field(self) -> str:
        """
        The user name attribute field.
        """
        return pulumi.get(self, "user_name_attribute_field")


@pulumi.output_type
class GetQuerySuggestionsBlockListSourceS3PathResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        :param str bucket: Name of the S3 bucket that contains the file.
        :param str key: Name of the file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Name of the file.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetThesaurusSourceS3PathResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 key: str):
        """
        :param str bucket: Name of the S3 bucket that contains the file.
        :param str key: Name of the file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Name of the file.
        """
        return pulumi.get(self, "key")


