# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GrantConstraint',
    'GetKeyMultiRegionConfigurationResult',
    'GetKeyMultiRegionConfigurationPrimaryKeyResult',
    'GetKeyMultiRegionConfigurationReplicaKeyResult',
    'GetKeyXksKeyConfigurationResult',
    'GetSecretSecretResult',
    'GetSecretsSecretResult',
]

@pulumi.output_type
class GrantConstraint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionContextEquals":
            suggest = "encryption_context_equals"
        elif key == "encryptionContextSubset":
            suggest = "encryption_context_subset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GrantConstraint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GrantConstraint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GrantConstraint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_context_equals: Optional[Mapping[str, str]] = None,
                 encryption_context_subset: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] encryption_context_equals: A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        :param Mapping[str, str] encryption_context_subset: A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        if encryption_context_equals is not None:
            pulumi.set(__self__, "encryption_context_equals", encryption_context_equals)
        if encryption_context_subset is not None:
            pulumi.set(__self__, "encryption_context_subset", encryption_context_subset)

    @property
    @pulumi.getter(name="encryptionContextEquals")
    def encryption_context_equals(self) -> Optional[Mapping[str, str]]:
        """
        A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
        """
        return pulumi.get(self, "encryption_context_equals")

    @property
    @pulumi.getter(name="encryptionContextSubset")
    def encryption_context_subset(self) -> Optional[Mapping[str, str]]:
        """
        A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
        """
        return pulumi.get(self, "encryption_context_subset")


@pulumi.output_type
class GetKeyMultiRegionConfigurationResult(dict):
    def __init__(__self__, *,
                 multi_region_key_type: str,
                 primary_keys: Sequence['outputs.GetKeyMultiRegionConfigurationPrimaryKeyResult'],
                 replica_keys: Sequence['outputs.GetKeyMultiRegionConfigurationReplicaKeyResult']):
        """
        :param str multi_region_key_type: Indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
        :param Sequence['GetKeyMultiRegionConfigurationPrimaryKeyArgs'] primary_keys: The key ARN and Region of the primary key. This is the current KMS key if it is the primary key.
        :param Sequence['GetKeyMultiRegionConfigurationReplicaKeyArgs'] replica_keys: The key ARNs and Regions of all replica keys. Includes the current KMS key if it is a replica key.
        """
        pulumi.set(__self__, "multi_region_key_type", multi_region_key_type)
        pulumi.set(__self__, "primary_keys", primary_keys)
        pulumi.set(__self__, "replica_keys", replica_keys)

    @property
    @pulumi.getter(name="multiRegionKeyType")
    def multi_region_key_type(self) -> str:
        """
        Indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
        """
        return pulumi.get(self, "multi_region_key_type")

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Sequence['outputs.GetKeyMultiRegionConfigurationPrimaryKeyResult']:
        """
        The key ARN and Region of the primary key. This is the current KMS key if it is the primary key.
        """
        return pulumi.get(self, "primary_keys")

    @property
    @pulumi.getter(name="replicaKeys")
    def replica_keys(self) -> Sequence['outputs.GetKeyMultiRegionConfigurationReplicaKeyResult']:
        """
        The key ARNs and Regions of all replica keys. Includes the current KMS key if it is a replica key.
        """
        return pulumi.get(self, "replica_keys")


@pulumi.output_type
class GetKeyMultiRegionConfigurationPrimaryKeyResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 region: str):
        """
        :param str arn: The key ARN of a primary or replica key of a multi-Region key.
        :param str region: The AWS Region of a primary or replica key in a multi-Region key.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The key ARN of a primary or replica key of a multi-Region key.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The AWS Region of a primary or replica key in a multi-Region key.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetKeyMultiRegionConfigurationReplicaKeyResult(dict):
    def __init__(__self__, *,
                 arn: str,
                 region: str):
        """
        :param str arn: The key ARN of a primary or replica key of a multi-Region key.
        :param str region: The AWS Region of a primary or replica key in a multi-Region key.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        The key ARN of a primary or replica key of a multi-Region key.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The AWS Region of a primary or replica key in a multi-Region key.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetKeyXksKeyConfigurationResult(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: The globally unique identifier for the key
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The globally unique identifier for the key
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetSecretSecretResult(dict):
    def __init__(__self__, *,
                 name: str,
                 payload: str,
                 context: Optional[Mapping[str, str]] = None,
                 grant_tokens: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def payload(self) -> str:
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "grant_tokens")


@pulumi.output_type
class GetSecretsSecretResult(dict):
    def __init__(__self__, *,
                 name: str,
                 payload: str,
                 context: Optional[Mapping[str, str]] = None,
                 encryption_algorithm: Optional[str] = None,
                 grant_tokens: Optional[Sequence[str]] = None,
                 key_id: Optional[str] = None):
        """
        :param str name: Name to export this secret under in the attributes.
        :param str payload: Base64 encoded payload, as returned from a KMS encrypt operation.
        :param Mapping[str, str] context: An optional mapping that makes up the Encryption Context for the secret.
        :param str encryption_algorithm: The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        :param Sequence[str] grant_tokens: An optional list of Grant Tokens for the secret.
        :param str key_id: Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
               
               For more information on `context` and `grant_tokens` see the [KMS
               Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payload", payload)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if grant_tokens is not None:
            pulumi.set(__self__, "grant_tokens", grant_tokens)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name to export this secret under in the attributes.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def payload(self) -> str:
        """
        Base64 encoded payload, as returned from a KMS encrypt operation.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, str]]:
        """
        An optional mapping that makes up the Encryption Context for the secret.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[str]:
        """
        The encryption algorithm that will be used to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. Valid Values: SYMMETRIC_DEFAULT | RSAES_OAEP_SHA_1 | RSAES_OAEP_SHA_256 | SM2PKE
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="grantTokens")
    def grant_tokens(self) -> Optional[Sequence[str]]:
        """
        An optional list of Grant Tokens for the secret.
        """
        return pulumi.get(self, "grant_tokens")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        Specifies the KMS key that AWS KMS uses to decrypt the ciphertext. This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.

        For more information on `context` and `grant_tokens` see the [KMS
        Concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
        """
        return pulumi.get(self, "key_id")


