# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FunctionRecursionConfigArgs', 'FunctionRecursionConfig']

@pulumi.input_type
class FunctionRecursionConfigArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[str],
                 recursive_loop: pulumi.Input[str]):
        """
        The set of arguments for constructing a FunctionRecursionConfig resource.
        :param pulumi.Input[str] function_name: Lambda function name.
        :param pulumi.Input[str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "recursive_loop", recursive_loop)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        Lambda function name.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> pulumi.Input[str]:
        """
        Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
        """
        return pulumi.get(self, "recursive_loop")

    @recursive_loop.setter
    def recursive_loop(self, value: pulumi.Input[str]):
        pulumi.set(self, "recursive_loop", value)


@pulumi.input_type
class _FunctionRecursionConfigState:
    def __init__(__self__, *,
                 function_name: Optional[pulumi.Input[str]] = None,
                 recursive_loop: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FunctionRecursionConfig resources.
        :param pulumi.Input[str] function_name: Lambda function name.
        :param pulumi.Input[str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
        """
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if recursive_loop is not None:
            pulumi.set(__self__, "recursive_loop", recursive_loop)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        Lambda function name.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> Optional[pulumi.Input[str]]:
        """
        Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
        """
        return pulumi.get(self, "recursive_loop")

    @recursive_loop.setter
    def recursive_loop(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recursive_loop", value)


class FunctionRecursionConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 recursive_loop: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lambda Function Recursion Config.

        > Destruction of this resource will return the `recursive_loop` configuration back to the default value of `Terminate`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionRecursionConfig("example",
            function_name="SomeFunction",
            recursive_loop="Allow")
        ```

        ## Import

        Using `pulumi import`, import AWS Lambda Function Recursion Config using the `function_name`. For example:

        ```sh
        $ pulumi import aws:lambda/functionRecursionConfig:FunctionRecursionConfig example SomeFunction
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] function_name: Lambda function name.
        :param pulumi.Input[str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionRecursionConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lambda Function Recursion Config.

        > Destruction of this resource will return the `recursive_loop` configuration back to the default value of `Terminate`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionRecursionConfig("example",
            function_name="SomeFunction",
            recursive_loop="Allow")
        ```

        ## Import

        Using `pulumi import`, import AWS Lambda Function Recursion Config using the `function_name`. For example:

        ```sh
        $ pulumi import aws:lambda/functionRecursionConfig:FunctionRecursionConfig example SomeFunction
        ```

        :param str resource_name: The name of the resource.
        :param FunctionRecursionConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionRecursionConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 recursive_loop: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionRecursionConfigArgs.__new__(FunctionRecursionConfigArgs)

            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            if recursive_loop is None and not opts.urn:
                raise TypeError("Missing required property 'recursive_loop'")
            __props__.__dict__["recursive_loop"] = recursive_loop
        super(FunctionRecursionConfig, __self__).__init__(
            'aws:lambda/functionRecursionConfig:FunctionRecursionConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            function_name: Optional[pulumi.Input[str]] = None,
            recursive_loop: Optional[pulumi.Input[str]] = None) -> 'FunctionRecursionConfig':
        """
        Get an existing FunctionRecursionConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] function_name: Lambda function name.
        :param pulumi.Input[str] recursive_loop: Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionRecursionConfigState.__new__(_FunctionRecursionConfigState)

        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["recursive_loop"] = recursive_loop
        return FunctionRecursionConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        Lambda function name.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> pulumi.Output[str]:
        """
        Lambda function recursion configuration. Valid values are `Allow` or `Terminate`.
        """
        return pulumi.get(self, "recursive_loop")

