# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFunctionResult',
    'AwaitableGetFunctionResult',
    'get_function',
    'get_function_output',
]

@pulumi.output_type
class GetFunctionResult:
    """
    A collection of values returned by getFunction.
    """
    def __init__(__self__, architectures=None, arn=None, code_sha256=None, code_signing_config_arn=None, dead_letter_config=None, description=None, environment=None, ephemeral_storages=None, file_system_configs=None, function_name=None, handler=None, id=None, image_uri=None, invoke_arn=None, kms_key_arn=None, last_modified=None, layers=None, logging_configs=None, memory_size=None, qualified_arn=None, qualified_invoke_arn=None, qualifier=None, reserved_concurrent_executions=None, role=None, runtime=None, signing_job_arn=None, signing_profile_version_arn=None, source_code_hash=None, source_code_size=None, tags=None, timeout=None, tracing_config=None, version=None, vpc_config=None):
        if architectures and not isinstance(architectures, list):
            raise TypeError("Expected argument 'architectures' to be a list")
        pulumi.set(__self__, "architectures", architectures)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if code_sha256 and not isinstance(code_sha256, str):
            raise TypeError("Expected argument 'code_sha256' to be a str")
        pulumi.set(__self__, "code_sha256", code_sha256)
        if code_signing_config_arn and not isinstance(code_signing_config_arn, str):
            raise TypeError("Expected argument 'code_signing_config_arn' to be a str")
        pulumi.set(__self__, "code_signing_config_arn", code_signing_config_arn)
        if dead_letter_config and not isinstance(dead_letter_config, dict):
            raise TypeError("Expected argument 'dead_letter_config' to be a dict")
        pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if ephemeral_storages and not isinstance(ephemeral_storages, list):
            raise TypeError("Expected argument 'ephemeral_storages' to be a list")
        pulumi.set(__self__, "ephemeral_storages", ephemeral_storages)
        if file_system_configs and not isinstance(file_system_configs, list):
            raise TypeError("Expected argument 'file_system_configs' to be a list")
        pulumi.set(__self__, "file_system_configs", file_system_configs)
        if function_name and not isinstance(function_name, str):
            raise TypeError("Expected argument 'function_name' to be a str")
        pulumi.set(__self__, "function_name", function_name)
        if handler and not isinstance(handler, str):
            raise TypeError("Expected argument 'handler' to be a str")
        pulumi.set(__self__, "handler", handler)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_uri and not isinstance(image_uri, str):
            raise TypeError("Expected argument 'image_uri' to be a str")
        pulumi.set(__self__, "image_uri", image_uri)
        if invoke_arn and not isinstance(invoke_arn, str):
            raise TypeError("Expected argument 'invoke_arn' to be a str")
        pulumi.set(__self__, "invoke_arn", invoke_arn)
        if kms_key_arn and not isinstance(kms_key_arn, str):
            raise TypeError("Expected argument 'kms_key_arn' to be a str")
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if last_modified and not isinstance(last_modified, str):
            raise TypeError("Expected argument 'last_modified' to be a str")
        pulumi.set(__self__, "last_modified", last_modified)
        if layers and not isinstance(layers, list):
            raise TypeError("Expected argument 'layers' to be a list")
        pulumi.set(__self__, "layers", layers)
        if logging_configs and not isinstance(logging_configs, list):
            raise TypeError("Expected argument 'logging_configs' to be a list")
        pulumi.set(__self__, "logging_configs", logging_configs)
        if memory_size and not isinstance(memory_size, int):
            raise TypeError("Expected argument 'memory_size' to be a int")
        pulumi.set(__self__, "memory_size", memory_size)
        if qualified_arn and not isinstance(qualified_arn, str):
            raise TypeError("Expected argument 'qualified_arn' to be a str")
        pulumi.set(__self__, "qualified_arn", qualified_arn)
        if qualified_invoke_arn and not isinstance(qualified_invoke_arn, str):
            raise TypeError("Expected argument 'qualified_invoke_arn' to be a str")
        pulumi.set(__self__, "qualified_invoke_arn", qualified_invoke_arn)
        if qualifier and not isinstance(qualifier, str):
            raise TypeError("Expected argument 'qualifier' to be a str")
        pulumi.set(__self__, "qualifier", qualifier)
        if reserved_concurrent_executions and not isinstance(reserved_concurrent_executions, int):
            raise TypeError("Expected argument 'reserved_concurrent_executions' to be a int")
        pulumi.set(__self__, "reserved_concurrent_executions", reserved_concurrent_executions)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if signing_job_arn and not isinstance(signing_job_arn, str):
            raise TypeError("Expected argument 'signing_job_arn' to be a str")
        pulumi.set(__self__, "signing_job_arn", signing_job_arn)
        if signing_profile_version_arn and not isinstance(signing_profile_version_arn, str):
            raise TypeError("Expected argument 'signing_profile_version_arn' to be a str")
        pulumi.set(__self__, "signing_profile_version_arn", signing_profile_version_arn)
        if source_code_hash and not isinstance(source_code_hash, str):
            raise TypeError("Expected argument 'source_code_hash' to be a str")
        pulumi.set(__self__, "source_code_hash", source_code_hash)
        if source_code_size and not isinstance(source_code_size, int):
            raise TypeError("Expected argument 'source_code_size' to be a int")
        pulumi.set(__self__, "source_code_size", source_code_size)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)
        if tracing_config and not isinstance(tracing_config, dict):
            raise TypeError("Expected argument 'tracing_config' to be a dict")
        pulumi.set(__self__, "tracing_config", tracing_config)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if vpc_config and not isinstance(vpc_config, dict):
            raise TypeError("Expected argument 'vpc_config' to be a dict")
        pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def architectures(self) -> Sequence[str]:
        """
        Instruction set architecture for the Lambda function.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        Unqualified (no `:QUALIFIER` or `:VERSION` suffix) ARN identifying your Lambda Function. See also `qualified_arn`.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="codeSha256")
    def code_sha256(self) -> str:
        """
        Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "code_sha256")

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> str:
        """
        ARN for a Code Signing Configuration.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> 'outputs.GetFunctionDeadLetterConfigResult':
        """
        Configure the function's *dead letter queue*.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of what your Lambda Function does.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.GetFunctionEnvironmentResult':
        """
        Lambda environment's configuration settings.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ephemeralStorages")
    def ephemeral_storages(self) -> Sequence['outputs.GetFunctionEphemeralStorageResult']:
        """
        Amount of Ephemeral storage(`/tmp`) allocated for the Lambda Function.
        """
        return pulumi.get(self, "ephemeral_storages")

    @property
    @pulumi.getter(name="fileSystemConfigs")
    def file_system_configs(self) -> Sequence['outputs.GetFunctionFileSystemConfigResult']:
        """
        Connection settings for an Amazon EFS file system.
        """
        return pulumi.get(self, "file_system_configs")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> str:
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def handler(self) -> str:
        """
        Function entrypoint in your code.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        URI of the container image.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="invokeArn")
    def invoke_arn(self) -> str:
        """
        ARN to be used for invoking Lambda Function from API Gateway. **NOTE:** Starting with `v4.51.0` of the provider, this will *not* include the qualifier.
        """
        return pulumi.get(self, "invoke_arn")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> str:
        """
        ARN for the KMS encryption key.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> str:
        """
        Date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def layers(self) -> Sequence[str]:
        """
        List of Lambda Layer ARNs attached to your Lambda Function.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="loggingConfigs")
    def logging_configs(self) -> Sequence['outputs.GetFunctionLoggingConfigResult']:
        """
        Advanced logging settings.
        """
        return pulumi.get(self, "logging_configs")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> int:
        """
        Amount of memory in MB your Lambda Function can use at runtime.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter(name="qualifiedArn")
    def qualified_arn(self) -> str:
        """
        Qualified (`:QUALIFIER` or `:VERSION` suffix) ARN identifying your Lambda Function. See also `arn`.
        """
        return pulumi.get(self, "qualified_arn")

    @property
    @pulumi.getter(name="qualifiedInvokeArn")
    def qualified_invoke_arn(self) -> str:
        """
        Qualified (`:QUALIFIER` or `:VERSION` suffix) ARN to be used for invoking Lambda Function from API Gateway. See also `invoke_arn`.
        """
        return pulumi.get(self, "qualified_invoke_arn")

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[str]:
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> int:
        """
        The amount of reserved concurrent executions for this lambda function or `-1` if unreserved.
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        IAM role attached to the Lambda Function.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def runtime(self) -> str:
        """
        Runtime environment for the Lambda function.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="signingJobArn")
    def signing_job_arn(self) -> str:
        """
        ARN of a signing job.
        """
        return pulumi.get(self, "signing_job_arn")

    @property
    @pulumi.getter(name="signingProfileVersionArn")
    def signing_profile_version_arn(self) -> str:
        """
        The ARN for a signing profile version.
        """
        return pulumi.get(self, "signing_profile_version_arn")

    @property
    @pulumi.getter(name="sourceCodeHash")
    @_utilities.deprecated("""This attribute is deprecated and will be removed in a future major version. Use `code_sha256` instead.""")
    def source_code_hash(self) -> str:
        """
        (**Deprecated** use `code_sha256` instead) Base64-encoded representation of raw SHA-256 sum of the zip file.
        """
        return pulumi.get(self, "source_code_hash")

    @property
    @pulumi.getter(name="sourceCodeSize")
    def source_code_size(self) -> int:
        """
        Size in bytes of the function .zip file.
        """
        return pulumi.get(self, "source_code_size")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        Function execution time at which Lambda should terminate the function.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> 'outputs.GetFunctionTracingConfigResult':
        """
        Tracing settings of the function.
        """
        return pulumi.get(self, "tracing_config")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the Lambda function returned. If `qualifier` is not set, this will resolve to the most recent published version. If no published version of the function exists, `version` will resolve to `$LATEST`.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> 'outputs.GetFunctionVpcConfigResult':
        """
        VPC configuration associated with your Lambda function.
        """
        return pulumi.get(self, "vpc_config")


class AwaitableGetFunctionResult(GetFunctionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionResult(
            architectures=self.architectures,
            arn=self.arn,
            code_sha256=self.code_sha256,
            code_signing_config_arn=self.code_signing_config_arn,
            dead_letter_config=self.dead_letter_config,
            description=self.description,
            environment=self.environment,
            ephemeral_storages=self.ephemeral_storages,
            file_system_configs=self.file_system_configs,
            function_name=self.function_name,
            handler=self.handler,
            id=self.id,
            image_uri=self.image_uri,
            invoke_arn=self.invoke_arn,
            kms_key_arn=self.kms_key_arn,
            last_modified=self.last_modified,
            layers=self.layers,
            logging_configs=self.logging_configs,
            memory_size=self.memory_size,
            qualified_arn=self.qualified_arn,
            qualified_invoke_arn=self.qualified_invoke_arn,
            qualifier=self.qualifier,
            reserved_concurrent_executions=self.reserved_concurrent_executions,
            role=self.role,
            runtime=self.runtime,
            signing_job_arn=self.signing_job_arn,
            signing_profile_version_arn=self.signing_profile_version_arn,
            source_code_hash=self.source_code_hash,
            source_code_size=self.source_code_size,
            tags=self.tags,
            timeout=self.timeout,
            tracing_config=self.tracing_config,
            version=self.version,
            vpc_config=self.vpc_config)


def get_function(function_name: Optional[str] = None,
                 qualifier: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionResult:
    """
    Provides information about a Lambda Function.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    function_name = config.require("functionName")
    existing = aws.lambda.get_function(function_name=function_name)
    ```


    :param str function_name: Name of the lambda function.
    :param str qualifier: Alias name or version number of the lambda functionE.g., `$LATEST`, `my-alias`, or `1`. When not included: the data source resolves to the most recent published version; if no published version exists: it resolves to the most recent unpublished version.
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['qualifier'] = qualifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lambda/getFunction:getFunction', __args__, opts=opts, typ=GetFunctionResult).value

    return AwaitableGetFunctionResult(
        architectures=pulumi.get(__ret__, 'architectures'),
        arn=pulumi.get(__ret__, 'arn'),
        code_sha256=pulumi.get(__ret__, 'code_sha256'),
        code_signing_config_arn=pulumi.get(__ret__, 'code_signing_config_arn'),
        dead_letter_config=pulumi.get(__ret__, 'dead_letter_config'),
        description=pulumi.get(__ret__, 'description'),
        environment=pulumi.get(__ret__, 'environment'),
        ephemeral_storages=pulumi.get(__ret__, 'ephemeral_storages'),
        file_system_configs=pulumi.get(__ret__, 'file_system_configs'),
        function_name=pulumi.get(__ret__, 'function_name'),
        handler=pulumi.get(__ret__, 'handler'),
        id=pulumi.get(__ret__, 'id'),
        image_uri=pulumi.get(__ret__, 'image_uri'),
        invoke_arn=pulumi.get(__ret__, 'invoke_arn'),
        kms_key_arn=pulumi.get(__ret__, 'kms_key_arn'),
        last_modified=pulumi.get(__ret__, 'last_modified'),
        layers=pulumi.get(__ret__, 'layers'),
        logging_configs=pulumi.get(__ret__, 'logging_configs'),
        memory_size=pulumi.get(__ret__, 'memory_size'),
        qualified_arn=pulumi.get(__ret__, 'qualified_arn'),
        qualified_invoke_arn=pulumi.get(__ret__, 'qualified_invoke_arn'),
        qualifier=pulumi.get(__ret__, 'qualifier'),
        reserved_concurrent_executions=pulumi.get(__ret__, 'reserved_concurrent_executions'),
        role=pulumi.get(__ret__, 'role'),
        runtime=pulumi.get(__ret__, 'runtime'),
        signing_job_arn=pulumi.get(__ret__, 'signing_job_arn'),
        signing_profile_version_arn=pulumi.get(__ret__, 'signing_profile_version_arn'),
        source_code_hash=pulumi.get(__ret__, 'source_code_hash'),
        source_code_size=pulumi.get(__ret__, 'source_code_size'),
        tags=pulumi.get(__ret__, 'tags'),
        timeout=pulumi.get(__ret__, 'timeout'),
        tracing_config=pulumi.get(__ret__, 'tracing_config'),
        version=pulumi.get(__ret__, 'version'),
        vpc_config=pulumi.get(__ret__, 'vpc_config'))
def get_function_output(function_name: Optional[pulumi.Input[str]] = None,
                        qualifier: Optional[pulumi.Input[Optional[str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionResult]:
    """
    Provides information about a Lambda Function.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    function_name = config.require("functionName")
    existing = aws.lambda.get_function(function_name=function_name)
    ```


    :param str function_name: Name of the lambda function.
    :param str qualifier: Alias name or version number of the lambda functionE.g., `$LATEST`, `my-alias`, or `1`. When not included: the data source resolves to the most recent published version; if no published version exists: it resolves to the most recent unpublished version.
    """
    __args__ = dict()
    __args__['functionName'] = function_name
    __args__['qualifier'] = qualifier
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lambda/getFunction:getFunction', __args__, opts=opts, typ=GetFunctionResult)
    return __ret__.apply(lambda __response__: GetFunctionResult(
        architectures=pulumi.get(__response__, 'architectures'),
        arn=pulumi.get(__response__, 'arn'),
        code_sha256=pulumi.get(__response__, 'code_sha256'),
        code_signing_config_arn=pulumi.get(__response__, 'code_signing_config_arn'),
        dead_letter_config=pulumi.get(__response__, 'dead_letter_config'),
        description=pulumi.get(__response__, 'description'),
        environment=pulumi.get(__response__, 'environment'),
        ephemeral_storages=pulumi.get(__response__, 'ephemeral_storages'),
        file_system_configs=pulumi.get(__response__, 'file_system_configs'),
        function_name=pulumi.get(__response__, 'function_name'),
        handler=pulumi.get(__response__, 'handler'),
        id=pulumi.get(__response__, 'id'),
        image_uri=pulumi.get(__response__, 'image_uri'),
        invoke_arn=pulumi.get(__response__, 'invoke_arn'),
        kms_key_arn=pulumi.get(__response__, 'kms_key_arn'),
        last_modified=pulumi.get(__response__, 'last_modified'),
        layers=pulumi.get(__response__, 'layers'),
        logging_configs=pulumi.get(__response__, 'logging_configs'),
        memory_size=pulumi.get(__response__, 'memory_size'),
        qualified_arn=pulumi.get(__response__, 'qualified_arn'),
        qualified_invoke_arn=pulumi.get(__response__, 'qualified_invoke_arn'),
        qualifier=pulumi.get(__response__, 'qualifier'),
        reserved_concurrent_executions=pulumi.get(__response__, 'reserved_concurrent_executions'),
        role=pulumi.get(__response__, 'role'),
        runtime=pulumi.get(__response__, 'runtime'),
        signing_job_arn=pulumi.get(__response__, 'signing_job_arn'),
        signing_profile_version_arn=pulumi.get(__response__, 'signing_profile_version_arn'),
        source_code_hash=pulumi.get(__response__, 'source_code_hash'),
        source_code_size=pulumi.get(__response__, 'source_code_size'),
        tags=pulumi.get(__response__, 'tags'),
        timeout=pulumi.get(__response__, 'timeout'),
        tracing_config=pulumi.get(__response__, 'tracing_config'),
        version=pulumi.get(__response__, 'version'),
        vpc_config=pulumi.get(__response__, 'vpc_config')))
