# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuntimeManagementConfigArgs', 'RuntimeManagementConfig']

@pulumi.input_type
class RuntimeManagementConfigArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[str],
                 qualifier: Optional[pulumi.Input[str]] = None,
                 runtime_version_arn: Optional[pulumi.Input[str]] = None,
                 update_runtime_on: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RuntimeManagementConfig resource.
        :param pulumi.Input[str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[str] qualifier: Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
        :param pulumi.Input[str] runtime_version_arn: ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
        :param pulumi.Input[str] update_runtime_on: Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
        """
        pulumi.set(__self__, "function_name", function_name)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if runtime_version_arn is not None:
            pulumi.set(__self__, "runtime_version_arn", runtime_version_arn)
        if update_runtime_on is not None:
            pulumi.set(__self__, "update_runtime_on", update_runtime_on)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        Name or ARN of the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter(name="runtimeVersionArn")
    def runtime_version_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
        """
        return pulumi.get(self, "runtime_version_arn")

    @runtime_version_arn.setter
    def runtime_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version_arn", value)

    @property
    @pulumi.getter(name="updateRuntimeOn")
    def update_runtime_on(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
        """
        return pulumi.get(self, "update_runtime_on")

    @update_runtime_on.setter
    def update_runtime_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_runtime_on", value)


@pulumi.input_type
class _RuntimeManagementConfigState:
    def __init__(__self__, *,
                 function_arn: Optional[pulumi.Input[str]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 runtime_version_arn: Optional[pulumi.Input[str]] = None,
                 update_runtime_on: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RuntimeManagementConfig resources.
        :param pulumi.Input[str] function_arn: ARN of the function.
        :param pulumi.Input[str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[str] qualifier: Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
        :param pulumi.Input[str] runtime_version_arn: ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
        :param pulumi.Input[str] update_runtime_on: Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
        """
        if function_arn is not None:
            pulumi.set(__self__, "function_arn", function_arn)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if runtime_version_arn is not None:
            pulumi.set(__self__, "runtime_version_arn", runtime_version_arn)
        if update_runtime_on is not None:
            pulumi.set(__self__, "update_runtime_on", update_runtime_on)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the function.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name or ARN of the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter(name="runtimeVersionArn")
    def runtime_version_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
        """
        return pulumi.get(self, "runtime_version_arn")

    @runtime_version_arn.setter
    def runtime_version_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version_arn", value)

    @property
    @pulumi.getter(name="updateRuntimeOn")
    def update_runtime_on(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
        """
        return pulumi.get(self, "update_runtime_on")

    @update_runtime_on.setter
    def update_runtime_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_runtime_on", value)


class RuntimeManagementConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 runtime_version_arn: Optional[pulumi.Input[str]] = None,
                 update_runtime_on: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lambda Runtime Management Config.

        Refer to the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) for supported runtimes.

        > Deletion of this resource returns the runtime update mode to `Auto` (the default behavior).
        To leave the configured runtime management options in-place, use a `removed` block with the destroy lifecycle set to `false`.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.RuntimeManagementConfig("example",
            function_name=test["functionName"],
            update_runtime_on="FunctionUpdate")
        ```

        ### `Manual` Update

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.RuntimeManagementConfig("example",
            function_name=test["functionName"],
            update_runtime_on="Manual",
            runtime_version_arn="arn:aws:lambda:us-east-1::runtime:abcd1234")
        ```

        > Once the runtime update mode is set to `Manual`, the `lambda.Function` `runtime` cannot be updated. To upgrade a runtime, the `update_runtime_on` argument must be set to `Auto` or `FunctionUpdate` prior to changing the function's `runtime` argument.

        ## Import

        Using `pulumi import`, import Lambda Runtime Management Config using a comma-delimited string combining `function_name` and `qualifier`. For example:

        ```sh
        $ pulumi import aws:lambda/runtimeManagementConfig:RuntimeManagementConfig example my-function,$LATEST
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[str] qualifier: Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
        :param pulumi.Input[str] runtime_version_arn: ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
        :param pulumi.Input[str] update_runtime_on: Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuntimeManagementConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lambda Runtime Management Config.

        Refer to the [AWS Lambda documentation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) for supported runtimes.

        > Deletion of this resource returns the runtime update mode to `Auto` (the default behavior).
        To leave the configured runtime management options in-place, use a `removed` block with the destroy lifecycle set to `false`.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.RuntimeManagementConfig("example",
            function_name=test["functionName"],
            update_runtime_on="FunctionUpdate")
        ```

        ### `Manual` Update

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.RuntimeManagementConfig("example",
            function_name=test["functionName"],
            update_runtime_on="Manual",
            runtime_version_arn="arn:aws:lambda:us-east-1::runtime:abcd1234")
        ```

        > Once the runtime update mode is set to `Manual`, the `lambda.Function` `runtime` cannot be updated. To upgrade a runtime, the `update_runtime_on` argument must be set to `Auto` or `FunctionUpdate` prior to changing the function's `runtime` argument.

        ## Import

        Using `pulumi import`, import Lambda Runtime Management Config using a comma-delimited string combining `function_name` and `qualifier`. For example:

        ```sh
        $ pulumi import aws:lambda/runtimeManagementConfig:RuntimeManagementConfig example my-function,$LATEST
        ```

        :param str resource_name: The name of the resource.
        :param RuntimeManagementConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuntimeManagementConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 qualifier: Optional[pulumi.Input[str]] = None,
                 runtime_version_arn: Optional[pulumi.Input[str]] = None,
                 update_runtime_on: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuntimeManagementConfigArgs.__new__(RuntimeManagementConfigArgs)

            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["runtime_version_arn"] = runtime_version_arn
            __props__.__dict__["update_runtime_on"] = update_runtime_on
            __props__.__dict__["function_arn"] = None
        super(RuntimeManagementConfig, __self__).__init__(
            'aws:lambda/runtimeManagementConfig:RuntimeManagementConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            function_arn: Optional[pulumi.Input[str]] = None,
            function_name: Optional[pulumi.Input[str]] = None,
            qualifier: Optional[pulumi.Input[str]] = None,
            runtime_version_arn: Optional[pulumi.Input[str]] = None,
            update_runtime_on: Optional[pulumi.Input[str]] = None) -> 'RuntimeManagementConfig':
        """
        Get an existing RuntimeManagementConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] function_arn: ARN of the function.
        :param pulumi.Input[str] function_name: Name or ARN of the Lambda function.
               
               The following arguments are optional:
        :param pulumi.Input[str] qualifier: Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
        :param pulumi.Input[str] runtime_version_arn: ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
        :param pulumi.Input[str] update_runtime_on: Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuntimeManagementConfigState.__new__(_RuntimeManagementConfigState)

        __props__.__dict__["function_arn"] = function_arn
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["runtime_version_arn"] = runtime_version_arn
        __props__.__dict__["update_runtime_on"] = update_runtime_on
        return RuntimeManagementConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Output[str]:
        """
        ARN of the function.
        """
        return pulumi.get(self, "function_arn")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[str]:
        """
        Name or ARN of the Lambda function.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[str]]:
        """
        Version of the function. This can be `$LATEST` or a published version number. If omitted, this resource will manage the runtime configuration for `$LATEST`.
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="runtimeVersionArn")
    def runtime_version_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of the runtime version. Only required when `update_runtime_on` is `Manual`.
        """
        return pulumi.get(self, "runtime_version_arn")

    @property
    @pulumi.getter(name="updateRuntimeOn")
    def update_runtime_on(self) -> pulumi.Output[Optional[str]]:
        """
        Runtime update mode. Valid values are `Auto`, `FunctionUpdate`, and `Manual`. When a function is created, the default mode is `Auto`.
        """
        return pulumi.get(self, "update_runtime_on")

