# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetListenerRuleResult',
    'AwaitableGetListenerRuleResult',
    'get_listener_rule',
    'get_listener_rule_output',
]

@pulumi.output_type
class GetListenerRuleResult:
    """
    A collection of values returned by getListenerRule.
    """
    def __init__(__self__, actions=None, arn=None, conditions=None, id=None, listener_arn=None, priority=None, tags=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listener_arn and not isinstance(listener_arn, str):
            raise TypeError("Expected argument 'listener_arn' to be a str")
        pulumi.set(__self__, "listener_arn", listener_arn)
        if priority and not isinstance(priority, float):
            raise TypeError("Expected argument 'priority' to be a float")
        pulumi.set(__self__, "priority", priority)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Sequence['outputs.GetListenerRuleActionResult']]:
        """
        List of actions associated with the rule, sorted by `order`.
        Detailed below.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the target group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.GetListenerRuleConditionResult']]:
        """
        Set of conditions associated with the rule.
        Detailed below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> str:
        return pulumi.get(self, "listener_arn")

    @property
    @pulumi.getter
    def priority(self) -> float:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Tags assigned to the Listener Rule.
        """
        return pulumi.get(self, "tags")


class AwaitableGetListenerRuleResult(GetListenerRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenerRuleResult(
            actions=self.actions,
            arn=self.arn,
            conditions=self.conditions,
            id=self.id,
            listener_arn=self.listener_arn,
            priority=self.priority,
            tags=self.tags)


def get_listener_rule(actions: Optional[Sequence[Union['GetListenerRuleActionArgs', 'GetListenerRuleActionArgsDict']]] = None,
                      arn: Optional[str] = None,
                      conditions: Optional[Sequence[Union['GetListenerRuleConditionArgs', 'GetListenerRuleConditionArgsDict']]] = None,
                      listener_arn: Optional[str] = None,
                      priority: Optional[float] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenerRuleResult:
    """
    Provides information about an AWS Elastic Load Balancing Listener Rule.

    ## Example Usage

    ### Match by Rule ARN

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_rule_arn = config.require("lbRuleArn")
    example = aws.lb.get_listener_rule(arn=lb_rule_arn)
    ```

    ### Match by Listener ARN and Priority

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_listener_arn = config.require("lbListenerArn")
    lb_rule_priority = config.require_float("lbRulePriority")
    example = aws.lb.get_listener_rule(listener_arn=lb_listener_arn,
        priority=lb_rule_priority)
    ```


    :param Sequence[Union['GetListenerRuleActionArgs', 'GetListenerRuleActionArgsDict']] actions: List of actions associated with the rule, sorted by `order`.
           Detailed below.
    :param str arn: ARN of the Listener Rule.
           Either `arn` or `listener_arn` must be set.
    :param Sequence[Union['GetListenerRuleConditionArgs', 'GetListenerRuleConditionArgsDict']] conditions: Set of conditions associated with the rule.
           Detailed below.
    :param str listener_arn: ARN of the associated Listener.
           Either `arn` or `listener_arn` must be set.
    :param float priority: Priority of the Listener Rule within the Listener.
           Must be set if `listener_arn` is set, otherwise must not be set.
    """
    __args__ = dict()
    __args__['actions'] = actions
    __args__['arn'] = arn
    __args__['conditions'] = conditions
    __args__['listenerArn'] = listener_arn
    __args__['priority'] = priority
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lb/getListenerRule:getListenerRule', __args__, opts=opts, typ=GetListenerRuleResult).value

    return AwaitableGetListenerRuleResult(
        actions=pulumi.get(__ret__, 'actions'),
        arn=pulumi.get(__ret__, 'arn'),
        conditions=pulumi.get(__ret__, 'conditions'),
        id=pulumi.get(__ret__, 'id'),
        listener_arn=pulumi.get(__ret__, 'listener_arn'),
        priority=pulumi.get(__ret__, 'priority'),
        tags=pulumi.get(__ret__, 'tags'))
def get_listener_rule_output(actions: Optional[pulumi.Input[Optional[Sequence[Union['GetListenerRuleActionArgs', 'GetListenerRuleActionArgsDict']]]]] = None,
                             arn: Optional[pulumi.Input[Optional[str]]] = None,
                             conditions: Optional[pulumi.Input[Optional[Sequence[Union['GetListenerRuleConditionArgs', 'GetListenerRuleConditionArgsDict']]]]] = None,
                             listener_arn: Optional[pulumi.Input[Optional[str]]] = None,
                             priority: Optional[pulumi.Input[Optional[float]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenerRuleResult]:
    """
    Provides information about an AWS Elastic Load Balancing Listener Rule.

    ## Example Usage

    ### Match by Rule ARN

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_rule_arn = config.require("lbRuleArn")
    example = aws.lb.get_listener_rule(arn=lb_rule_arn)
    ```

    ### Match by Listener ARN and Priority

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_listener_arn = config.require("lbListenerArn")
    lb_rule_priority = config.require_float("lbRulePriority")
    example = aws.lb.get_listener_rule(listener_arn=lb_listener_arn,
        priority=lb_rule_priority)
    ```


    :param Sequence[Union['GetListenerRuleActionArgs', 'GetListenerRuleActionArgsDict']] actions: List of actions associated with the rule, sorted by `order`.
           Detailed below.
    :param str arn: ARN of the Listener Rule.
           Either `arn` or `listener_arn` must be set.
    :param Sequence[Union['GetListenerRuleConditionArgs', 'GetListenerRuleConditionArgsDict']] conditions: Set of conditions associated with the rule.
           Detailed below.
    :param str listener_arn: ARN of the associated Listener.
           Either `arn` or `listener_arn` must be set.
    :param float priority: Priority of the Listener Rule within the Listener.
           Must be set if `listener_arn` is set, otherwise must not be set.
    """
    __args__ = dict()
    __args__['actions'] = actions
    __args__['arn'] = arn
    __args__['conditions'] = conditions
    __args__['listenerArn'] = listener_arn
    __args__['priority'] = priority
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lb/getListenerRule:getListenerRule', __args__, opts=opts, typ=GetListenerRuleResult)
    return __ret__.apply(lambda __response__: GetListenerRuleResult(
        actions=pulumi.get(__response__, 'actions'),
        arn=pulumi.get(__response__, 'arn'),
        conditions=pulumi.get(__response__, 'conditions'),
        id=pulumi.get(__response__, 'id'),
        listener_arn=pulumi.get(__response__, 'listener_arn'),
        priority=pulumi.get(__response__, 'priority'),
        tags=pulumi.get(__response__, 'tags')))
