# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTargetGroupResult',
    'AwaitableGetTargetGroupResult',
    'get_target_group',
    'get_target_group_output',
]

@pulumi.output_type
class GetTargetGroupResult:
    """
    A collection of values returned by getTargetGroup.
    """
    def __init__(__self__, arn=None, arn_suffix=None, connection_termination=None, deregistration_delay=None, health_check=None, id=None, lambda_multi_value_headers_enabled=None, load_balancer_arns=None, load_balancing_algorithm_type=None, load_balancing_anomaly_mitigation=None, load_balancing_cross_zone_enabled=None, name=None, port=None, preserve_client_ip=None, protocol=None, protocol_version=None, proxy_protocol_v2=None, slow_start=None, stickiness=None, tags=None, target_type=None, vpc_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if arn_suffix and not isinstance(arn_suffix, str):
            raise TypeError("Expected argument 'arn_suffix' to be a str")
        pulumi.set(__self__, "arn_suffix", arn_suffix)
        if connection_termination and not isinstance(connection_termination, bool):
            raise TypeError("Expected argument 'connection_termination' to be a bool")
        pulumi.set(__self__, "connection_termination", connection_termination)
        if deregistration_delay and not isinstance(deregistration_delay, str):
            raise TypeError("Expected argument 'deregistration_delay' to be a str")
        pulumi.set(__self__, "deregistration_delay", deregistration_delay)
        if health_check and not isinstance(health_check, dict):
            raise TypeError("Expected argument 'health_check' to be a dict")
        pulumi.set(__self__, "health_check", health_check)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lambda_multi_value_headers_enabled and not isinstance(lambda_multi_value_headers_enabled, bool):
            raise TypeError("Expected argument 'lambda_multi_value_headers_enabled' to be a bool")
        pulumi.set(__self__, "lambda_multi_value_headers_enabled", lambda_multi_value_headers_enabled)
        if load_balancer_arns and not isinstance(load_balancer_arns, list):
            raise TypeError("Expected argument 'load_balancer_arns' to be a list")
        pulumi.set(__self__, "load_balancer_arns", load_balancer_arns)
        if load_balancing_algorithm_type and not isinstance(load_balancing_algorithm_type, str):
            raise TypeError("Expected argument 'load_balancing_algorithm_type' to be a str")
        pulumi.set(__self__, "load_balancing_algorithm_type", load_balancing_algorithm_type)
        if load_balancing_anomaly_mitigation and not isinstance(load_balancing_anomaly_mitigation, str):
            raise TypeError("Expected argument 'load_balancing_anomaly_mitigation' to be a str")
        pulumi.set(__self__, "load_balancing_anomaly_mitigation", load_balancing_anomaly_mitigation)
        if load_balancing_cross_zone_enabled and not isinstance(load_balancing_cross_zone_enabled, str):
            raise TypeError("Expected argument 'load_balancing_cross_zone_enabled' to be a str")
        pulumi.set(__self__, "load_balancing_cross_zone_enabled", load_balancing_cross_zone_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if preserve_client_ip and not isinstance(preserve_client_ip, str):
            raise TypeError("Expected argument 'preserve_client_ip' to be a str")
        pulumi.set(__self__, "preserve_client_ip", preserve_client_ip)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if protocol_version and not isinstance(protocol_version, str):
            raise TypeError("Expected argument 'protocol_version' to be a str")
        pulumi.set(__self__, "protocol_version", protocol_version)
        if proxy_protocol_v2 and not isinstance(proxy_protocol_v2, bool):
            raise TypeError("Expected argument 'proxy_protocol_v2' to be a bool")
        pulumi.set(__self__, "proxy_protocol_v2", proxy_protocol_v2)
        if slow_start and not isinstance(slow_start, int):
            raise TypeError("Expected argument 'slow_start' to be a int")
        pulumi.set(__self__, "slow_start", slow_start)
        if stickiness and not isinstance(stickiness, dict):
            raise TypeError("Expected argument 'stickiness' to be a dict")
        pulumi.set(__self__, "stickiness", stickiness)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if target_type and not isinstance(target_type, str):
            raise TypeError("Expected argument 'target_type' to be a str")
        pulumi.set(__self__, "target_type", target_type)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="arnSuffix")
    def arn_suffix(self) -> str:
        return pulumi.get(self, "arn_suffix")

    @property
    @pulumi.getter(name="connectionTermination")
    def connection_termination(self) -> bool:
        return pulumi.get(self, "connection_termination")

    @property
    @pulumi.getter(name="deregistrationDelay")
    def deregistration_delay(self) -> str:
        return pulumi.get(self, "deregistration_delay")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> 'outputs.GetTargetGroupHealthCheckResult':
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lambdaMultiValueHeadersEnabled")
    def lambda_multi_value_headers_enabled(self) -> bool:
        return pulumi.get(self, "lambda_multi_value_headers_enabled")

    @property
    @pulumi.getter(name="loadBalancerArns")
    def load_balancer_arns(self) -> Sequence[str]:
        return pulumi.get(self, "load_balancer_arns")

    @property
    @pulumi.getter(name="loadBalancingAlgorithmType")
    def load_balancing_algorithm_type(self) -> str:
        return pulumi.get(self, "load_balancing_algorithm_type")

    @property
    @pulumi.getter(name="loadBalancingAnomalyMitigation")
    def load_balancing_anomaly_mitigation(self) -> str:
        return pulumi.get(self, "load_balancing_anomaly_mitigation")

    @property
    @pulumi.getter(name="loadBalancingCrossZoneEnabled")
    def load_balancing_cross_zone_enabled(self) -> str:
        return pulumi.get(self, "load_balancing_cross_zone_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preserveClientIp")
    def preserve_client_ip(self) -> str:
        return pulumi.get(self, "preserve_client_ip")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> str:
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="proxyProtocolV2")
    def proxy_protocol_v2(self) -> bool:
        return pulumi.get(self, "proxy_protocol_v2")

    @property
    @pulumi.getter(name="slowStart")
    def slow_start(self) -> int:
        return pulumi.get(self, "slow_start")

    @property
    @pulumi.getter
    def stickiness(self) -> 'outputs.GetTargetGroupStickinessResult':
        return pulumi.get(self, "stickiness")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetTargetGroupResult(GetTargetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetGroupResult(
            arn=self.arn,
            arn_suffix=self.arn_suffix,
            connection_termination=self.connection_termination,
            deregistration_delay=self.deregistration_delay,
            health_check=self.health_check,
            id=self.id,
            lambda_multi_value_headers_enabled=self.lambda_multi_value_headers_enabled,
            load_balancer_arns=self.load_balancer_arns,
            load_balancing_algorithm_type=self.load_balancing_algorithm_type,
            load_balancing_anomaly_mitigation=self.load_balancing_anomaly_mitigation,
            load_balancing_cross_zone_enabled=self.load_balancing_cross_zone_enabled,
            name=self.name,
            port=self.port,
            preserve_client_ip=self.preserve_client_ip,
            protocol=self.protocol,
            protocol_version=self.protocol_version,
            proxy_protocol_v2=self.proxy_protocol_v2,
            slow_start=self.slow_start,
            stickiness=self.stickiness,
            tags=self.tags,
            target_type=self.target_type,
            vpc_id=self.vpc_id)


def get_target_group(arn: Optional[str] = None,
                     load_balancing_anomaly_mitigation: Optional[str] = None,
                     name: Optional[str] = None,
                     tags: Optional[Mapping[str, str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetGroupResult:
    """
    > **Note:** `alb.TargetGroup` is known as `lb.TargetGroup`. The functionality is identical.

    Provides information about a Load Balancer Target Group.

    This data source can prove useful when a module accepts an LB Target Group as an
    input variable and needs to know its attributes. It can also be used to get the ARN of
    an LB Target Group for use in other resources, given LB Target Group name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_tg_arn = config.get("lbTgArn")
    if lb_tg_arn is None:
        lb_tg_arn = ""
    lb_tg_name = config.get("lbTgName")
    if lb_tg_name is None:
        lb_tg_name = ""
    test = aws.lb.get_target_group(arn=lb_tg_arn,
        name=lb_tg_name)
    ```


    :param str arn: Full ARN of the target group.
    :param str name: Unique name of the target group.
    :param Mapping[str, str] tags: Mapping of tags, each pair of which must exactly match a pair on the desired target group.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has the lowest precedence.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['loadBalancingAnomalyMitigation'] = load_balancing_anomaly_mitigation
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lb/getTargetGroup:getTargetGroup', __args__, opts=opts, typ=GetTargetGroupResult).value

    return AwaitableGetTargetGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        arn_suffix=pulumi.get(__ret__, 'arn_suffix'),
        connection_termination=pulumi.get(__ret__, 'connection_termination'),
        deregistration_delay=pulumi.get(__ret__, 'deregistration_delay'),
        health_check=pulumi.get(__ret__, 'health_check'),
        id=pulumi.get(__ret__, 'id'),
        lambda_multi_value_headers_enabled=pulumi.get(__ret__, 'lambda_multi_value_headers_enabled'),
        load_balancer_arns=pulumi.get(__ret__, 'load_balancer_arns'),
        load_balancing_algorithm_type=pulumi.get(__ret__, 'load_balancing_algorithm_type'),
        load_balancing_anomaly_mitigation=pulumi.get(__ret__, 'load_balancing_anomaly_mitigation'),
        load_balancing_cross_zone_enabled=pulumi.get(__ret__, 'load_balancing_cross_zone_enabled'),
        name=pulumi.get(__ret__, 'name'),
        port=pulumi.get(__ret__, 'port'),
        preserve_client_ip=pulumi.get(__ret__, 'preserve_client_ip'),
        protocol=pulumi.get(__ret__, 'protocol'),
        protocol_version=pulumi.get(__ret__, 'protocol_version'),
        proxy_protocol_v2=pulumi.get(__ret__, 'proxy_protocol_v2'),
        slow_start=pulumi.get(__ret__, 'slow_start'),
        stickiness=pulumi.get(__ret__, 'stickiness'),
        tags=pulumi.get(__ret__, 'tags'),
        target_type=pulumi.get(__ret__, 'target_type'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_target_group_output(arn: Optional[pulumi.Input[Optional[str]]] = None,
                            load_balancing_anomaly_mitigation: Optional[pulumi.Input[Optional[str]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTargetGroupResult]:
    """
    > **Note:** `alb.TargetGroup` is known as `lb.TargetGroup`. The functionality is identical.

    Provides information about a Load Balancer Target Group.

    This data source can prove useful when a module accepts an LB Target Group as an
    input variable and needs to know its attributes. It can also be used to get the ARN of
    an LB Target Group for use in other resources, given LB Target Group name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_tg_arn = config.get("lbTgArn")
    if lb_tg_arn is None:
        lb_tg_arn = ""
    lb_tg_name = config.get("lbTgName")
    if lb_tg_name is None:
        lb_tg_name = ""
    test = aws.lb.get_target_group(arn=lb_tg_arn,
        name=lb_tg_name)
    ```


    :param str arn: Full ARN of the target group.
    :param str name: Unique name of the target group.
    :param Mapping[str, str] tags: Mapping of tags, each pair of which must exactly match a pair on the desired target group.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence. `tags` has the lowest precedence.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['loadBalancingAnomalyMitigation'] = load_balancing_anomaly_mitigation
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lb/getTargetGroup:getTargetGroup', __args__, opts=opts, typ=GetTargetGroupResult)
    return __ret__.apply(lambda __response__: GetTargetGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        arn_suffix=pulumi.get(__response__, 'arn_suffix'),
        connection_termination=pulumi.get(__response__, 'connection_termination'),
        deregistration_delay=pulumi.get(__response__, 'deregistration_delay'),
        health_check=pulumi.get(__response__, 'health_check'),
        id=pulumi.get(__response__, 'id'),
        lambda_multi_value_headers_enabled=pulumi.get(__response__, 'lambda_multi_value_headers_enabled'),
        load_balancer_arns=pulumi.get(__response__, 'load_balancer_arns'),
        load_balancing_algorithm_type=pulumi.get(__response__, 'load_balancing_algorithm_type'),
        load_balancing_anomaly_mitigation=pulumi.get(__response__, 'load_balancing_anomaly_mitigation'),
        load_balancing_cross_zone_enabled=pulumi.get(__response__, 'load_balancing_cross_zone_enabled'),
        name=pulumi.get(__response__, 'name'),
        port=pulumi.get(__response__, 'port'),
        preserve_client_ip=pulumi.get(__response__, 'preserve_client_ip'),
        protocol=pulumi.get(__response__, 'protocol'),
        protocol_version=pulumi.get(__response__, 'protocol_version'),
        proxy_protocol_v2=pulumi.get(__response__, 'proxy_protocol_v2'),
        slow_start=pulumi.get(__response__, 'slow_start'),
        stickiness=pulumi.get(__response__, 'stickiness'),
        tags=pulumi.get(__response__, 'tags'),
        target_type=pulumi.get(__response__, 'target_type'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
