# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTrustStoreResult',
    'AwaitableGetTrustStoreResult',
    'get_trust_store',
    'get_trust_store_output',
]

@pulumi.output_type
class GetTrustStoreResult:
    """
    A collection of values returned by getTrustStore.
    """
    def __init__(__self__, arn=None, id=None, name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


class AwaitableGetTrustStoreResult(GetTrustStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrustStoreResult(
            arn=self.arn,
            id=self.id,
            name=self.name)


def get_trust_store(arn: Optional[str] = None,
                    name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrustStoreResult:
    """
    > **Note:** `aws_alb_trust_store` is known as `lb.TrustStore`. The functionality is identical.

    Provides information about a Load Balancer Trust Store.

    This data source can prove useful when a module accepts an LB Trust Store as an
    input variable and needs to know its attributes. It can also be used to get the ARN of
    an LB Trust Store for use in other resources, given LB Trust Store name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_ts_arn = config.get("lbTsArn")
    if lb_ts_arn is None:
        lb_ts_arn = ""
    lb_ts_name = config.get("lbTsName")
    if lb_ts_name is None:
        lb_ts_name = ""
    test = aws.lb.get_trust_store(arn=lb_ts_arn,
        name=lb_ts_name)
    ```


    :param str arn: Full ARN of the trust store.
    :param str name: Unique name of the trust store.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lb/getTrustStore:getTrustStore', __args__, opts=opts, typ=GetTrustStoreResult).value

    return AwaitableGetTrustStoreResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_trust_store_output(arn: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrustStoreResult]:
    """
    > **Note:** `aws_alb_trust_store` is known as `lb.TrustStore`. The functionality is identical.

    Provides information about a Load Balancer Trust Store.

    This data source can prove useful when a module accepts an LB Trust Store as an
    input variable and needs to know its attributes. It can also be used to get the ARN of
    an LB Trust Store for use in other resources, given LB Trust Store name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    lb_ts_arn = config.get("lbTsArn")
    if lb_ts_arn is None:
        lb_ts_arn = ""
    lb_ts_name = config.get("lbTsName")
    if lb_ts_name is None:
        lb_ts_name = ""
    test = aws.lb.get_trust_store(arn=lb_ts_arn,
        name=lb_ts_name)
    ```


    :param str arn: Full ARN of the trust store.
    :param str name: Unique name of the trust store.
           
           > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lb/getTrustStore:getTrustStore', __args__, opts=opts, typ=GetTrustStoreResult)
    return __ret__.apply(lambda __response__: GetTrustStoreResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
