# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerRuleArgs', 'ListenerRule']

@pulumi.input_type
class ListenerRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]],
                 conditions: pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]],
                 listener_arn: pulumi.Input[str],
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ListenerRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]] actions: An Action block. Action blocks are documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "listener_arn", listener_arn)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]]:
        """
        An Action block. Action blocks are documented below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]]:
        """
        A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the listener to which to attach the rule.
        """
        return pulumi.get(self, "listener_arn")

    @listener_arn.setter
    def listener_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_arn", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ListenerRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]]] = None,
                 listener_arn: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ListenerRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]] actions: An Action block. Action blocks are documented below.
        :param pulumi.Input[str] arn: The ARN of the rule (matches `id`)
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if listener_arn is not None:
            pulumi.set(__self__, "listener_arn", listener_arn)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]]]:
        """
        An Action block. Action blocks are documented below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the rule (matches `id`)
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]]]:
        """
        A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the listener to which to attach the rule.
        """
        return pulumi.get(self, "listener_arn")

    @listener_arn.setter
    def listener_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_arn", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class ListenerRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleActionArgs', 'ListenerRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleConditionArgs', 'ListenerRuleConditionArgsDict']]]]] = None,
                 listener_arn: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Load Balancer Listener Rule resource.

        > **Note:** `alb.ListenerRule` is known as `lb.ListenerRule`. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end")
        static = aws.lb.ListenerRule("static",
            listener_arn=front_end_listener.arn,
            priority=100,
            actions=[{
                "type": "forward",
                "target_group_arn": static_aws_lb_target_group["arn"],
            }],
            conditions=[
                {
                    "path_pattern": {
                        "values": ["/static/*"],
                    },
                },
                {
                    "host_header": {
                        "values": ["example.com"],
                    },
                },
            ])
        # Forward action
        host_based_weighted_routing = aws.lb.ListenerRule("host_based_weighted_routing",
            listener_arn=front_end_listener.arn,
            priority=99,
            actions=[{
                "type": "forward",
                "target_group_arn": static_aws_lb_target_group["arn"],
            }],
            conditions=[{
                "host_header": {
                    "values": ["my-service.*.mycompany.io"],
                },
            }])
        # Weighted Forward action
        host_based_routing = aws.lb.ListenerRule("host_based_routing",
            listener_arn=front_end_listener.arn,
            priority=99,
            actions=[{
                "type": "forward",
                "forward": {
                    "target_groups": [
                        {
                            "arn": main["arn"],
                            "weight": 80,
                        },
                        {
                            "arn": canary["arn"],
                            "weight": 20,
                        },
                    ],
                    "stickiness": {
                        "enabled": True,
                        "duration": 600,
                    },
                },
            }],
            conditions=[{
                "host_header": {
                    "values": ["my-service.*.mycompany.io"],
                },
            }])
        # Redirect action
        redirect_http_to_https = aws.lb.ListenerRule("redirect_http_to_https",
            listener_arn=front_end_listener.arn,
            actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }],
            conditions=[{
                "http_header": {
                    "http_header_name": "X-Forwarded-For",
                    "values": ["192.168.1.*"],
                },
            }])
        # Fixed-response action
        health_check = aws.lb.ListenerRule("health_check",
            listener_arn=front_end_listener.arn,
            actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "HEALTHY",
                    "status_code": "200",
                },
            }],
            conditions=[{
                "query_strings": [
                    {
                        "key": "health",
                        "value": "check",
                    },
                    {
                        "value": "bar",
                    },
                ],
            }])
        # Authenticate-cognito Action
        pool = aws.cognito.UserPool("pool")
        client = aws.cognito.UserPoolClient("client")
        domain = aws.cognito.UserPoolDomain("domain")
        admin = aws.lb.ListenerRule("admin",
            listener_arn=front_end_listener.arn,
            actions=[
                {
                    "type": "authenticate-cognito",
                    "authenticate_cognito": {
                        "user_pool_arn": pool.arn,
                        "user_pool_client_id": client.id,
                        "user_pool_domain": domain.domain,
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": static_aws_lb_target_group["arn"],
                },
            ])
        # Authenticate-oidc Action
        oidc = aws.lb.ListenerRule("oidc",
            listener_arn=front_end_listener.arn,
            actions=[
                {
                    "type": "authenticate-oidc",
                    "authenticate_oidc": {
                        "authorization_endpoint": "https://example.com/authorization_endpoint",
                        "client_id": "client_id",
                        "client_secret": "client_secret",
                        "issuer": "https://example.com",
                        "token_endpoint": "https://example.com/token_endpoint",
                        "user_info_endpoint": "https://example.com/user_info_endpoint",
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": static_aws_lb_target_group["arn"],
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import rules using their ARN. For example:

        ```sh
        $ pulumi import aws:lb/listenerRule:ListenerRule front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener-rule/app/test/8e4497da625e2d8a/9ab28ade35828f96/67b3d2d36dd7c26b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleActionArgs', 'ListenerRuleActionArgsDict']]]] actions: An Action block. Action blocks are documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleConditionArgs', 'ListenerRuleConditionArgsDict']]]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Load Balancer Listener Rule resource.

        > **Note:** `alb.ListenerRule` is known as `lb.ListenerRule`. The functionality is identical.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end")
        static = aws.lb.ListenerRule("static",
            listener_arn=front_end_listener.arn,
            priority=100,
            actions=[{
                "type": "forward",
                "target_group_arn": static_aws_lb_target_group["arn"],
            }],
            conditions=[
                {
                    "path_pattern": {
                        "values": ["/static/*"],
                    },
                },
                {
                    "host_header": {
                        "values": ["example.com"],
                    },
                },
            ])
        # Forward action
        host_based_weighted_routing = aws.lb.ListenerRule("host_based_weighted_routing",
            listener_arn=front_end_listener.arn,
            priority=99,
            actions=[{
                "type": "forward",
                "target_group_arn": static_aws_lb_target_group["arn"],
            }],
            conditions=[{
                "host_header": {
                    "values": ["my-service.*.mycompany.io"],
                },
            }])
        # Weighted Forward action
        host_based_routing = aws.lb.ListenerRule("host_based_routing",
            listener_arn=front_end_listener.arn,
            priority=99,
            actions=[{
                "type": "forward",
                "forward": {
                    "target_groups": [
                        {
                            "arn": main["arn"],
                            "weight": 80,
                        },
                        {
                            "arn": canary["arn"],
                            "weight": 20,
                        },
                    ],
                    "stickiness": {
                        "enabled": True,
                        "duration": 600,
                    },
                },
            }],
            conditions=[{
                "host_header": {
                    "values": ["my-service.*.mycompany.io"],
                },
            }])
        # Redirect action
        redirect_http_to_https = aws.lb.ListenerRule("redirect_http_to_https",
            listener_arn=front_end_listener.arn,
            actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }],
            conditions=[{
                "http_header": {
                    "http_header_name": "X-Forwarded-For",
                    "values": ["192.168.1.*"],
                },
            }])
        # Fixed-response action
        health_check = aws.lb.ListenerRule("health_check",
            listener_arn=front_end_listener.arn,
            actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "HEALTHY",
                    "status_code": "200",
                },
            }],
            conditions=[{
                "query_strings": [
                    {
                        "key": "health",
                        "value": "check",
                    },
                    {
                        "value": "bar",
                    },
                ],
            }])
        # Authenticate-cognito Action
        pool = aws.cognito.UserPool("pool")
        client = aws.cognito.UserPoolClient("client")
        domain = aws.cognito.UserPoolDomain("domain")
        admin = aws.lb.ListenerRule("admin",
            listener_arn=front_end_listener.arn,
            actions=[
                {
                    "type": "authenticate-cognito",
                    "authenticate_cognito": {
                        "user_pool_arn": pool.arn,
                        "user_pool_client_id": client.id,
                        "user_pool_domain": domain.domain,
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": static_aws_lb_target_group["arn"],
                },
            ])
        # Authenticate-oidc Action
        oidc = aws.lb.ListenerRule("oidc",
            listener_arn=front_end_listener.arn,
            actions=[
                {
                    "type": "authenticate-oidc",
                    "authenticate_oidc": {
                        "authorization_endpoint": "https://example.com/authorization_endpoint",
                        "client_id": "client_id",
                        "client_secret": "client_secret",
                        "issuer": "https://example.com",
                        "token_endpoint": "https://example.com/token_endpoint",
                        "user_info_endpoint": "https://example.com/user_info_endpoint",
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": static_aws_lb_target_group["arn"],
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import rules using their ARN. For example:

        ```sh
        $ pulumi import aws:lb/listenerRule:ListenerRule front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener-rule/app/test/8e4497da625e2d8a/9ab28ade35828f96/67b3d2d36dd7c26b
        ```

        :param str resource_name: The name of the resource.
        :param ListenerRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleActionArgs', 'ListenerRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleConditionArgs', 'ListenerRuleConditionArgsDict']]]]] = None,
                 listener_arn: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerRuleArgs.__new__(ListenerRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if conditions is None and not opts.urn:
                raise TypeError("Missing required property 'conditions'")
            __props__.__dict__["conditions"] = conditions
            if listener_arn is None and not opts.urn:
                raise TypeError("Missing required property 'listener_arn'")
            __props__.__dict__["listener_arn"] = listener_arn
            __props__.__dict__["priority"] = priority
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:elasticloadbalancingv2/listenerRule:ListenerRule")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ListenerRule, __self__).__init__(
            'aws:lb/listenerRule:ListenerRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleActionArgs', 'ListenerRuleActionArgsDict']]]]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleConditionArgs', 'ListenerRuleConditionArgsDict']]]]] = None,
            listener_arn: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'ListenerRule':
        """
        Get an existing ListenerRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleActionArgs', 'ListenerRuleActionArgsDict']]]] actions: An Action block. Action blocks are documented below.
        :param pulumi.Input[str] arn: The ARN of the rule (matches `id`)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerRuleConditionArgs', 'ListenerRuleConditionArgsDict']]]] conditions: A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
        :param pulumi.Input[str] listener_arn: The ARN of the listener to which to attach the rule.
        :param pulumi.Input[int] priority: The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerRuleState.__new__(_ListenerRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["arn"] = arn
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["listener_arn"] = listener_arn
        __props__.__dict__["priority"] = priority
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return ListenerRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.ListenerRuleAction']]:
        """
        An Action block. Action blocks are documented below.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the rule (matches `id`)
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.ListenerRuleCondition']]:
        """
        A Condition block. Multiple condition blocks of different types can be set and all must be satisfied for the rule to match. Condition blocks are documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the listener to which to attach the rule.
        """
        return pulumi.get(self, "listener_arn")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        The priority for the rule between `1` and `50000`. Leaving it unset will automatically set the rule with next available priority after currently existing highest rule. A listener can't have multiple rules with the same priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

