# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2modelsBotVersionArgs', 'V2modelsBotVersion']

@pulumi.input_type
class V2modelsBotVersionArgs:
    def __init__(__self__, *,
                 bot_id: pulumi.Input[str],
                 locale_specification: pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]],
                 bot_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsBotVersionTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a V2modelsBotVersion resource.
        :param pulumi.Input[str] bot_id: Idientifier of the bot to create the version for.
        :param pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]] locale_specification: Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
               
               The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
               * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
        :param pulumi.Input[str] bot_version: Version number assigned to the version.
        :param pulumi.Input[str] description: A description of the version. Use the description to help identify the version in lists.
        """
        pulumi.set(__self__, "bot_id", bot_id)
        pulumi.set(__self__, "locale_specification", locale_specification)
        if bot_version is not None:
            pulumi.set(__self__, "bot_version", bot_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Input[str]:
        """
        Idientifier of the bot to create the version for.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="localeSpecification")
    def locale_specification(self) -> pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]]:
        """
        Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.

        The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
        * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
        """
        return pulumi.get(self, "locale_specification")

    @locale_specification.setter
    def locale_specification(self, value: pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]]):
        pulumi.set(self, "locale_specification", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version number assigned to the version.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the version. Use the description to help identify the version in lists.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsBotVersionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsBotVersionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _V2modelsBotVersionState:
    def __init__(__self__, *,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 locale_specification: Optional[pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsBotVersionTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering V2modelsBotVersion resources.
        :param pulumi.Input[str] bot_id: Idientifier of the bot to create the version for.
        :param pulumi.Input[str] bot_version: Version number assigned to the version.
        :param pulumi.Input[str] description: A description of the version. Use the description to help identify the version in lists.
        :param pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]] locale_specification: Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
               
               The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
               * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
        """
        if bot_id is not None:
            pulumi.set(__self__, "bot_id", bot_id)
        if bot_version is not None:
            pulumi.set(__self__, "bot_version", bot_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if locale_specification is not None:
            pulumi.set(__self__, "locale_specification", locale_specification)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Idientifier of the bot to create the version for.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version number assigned to the version.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the version. Use the description to help identify the version in lists.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="localeSpecification")
    def locale_specification(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]]]:
        """
        Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.

        The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
        * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
        """
        return pulumi.get(self, "locale_specification")

    @locale_specification.setter
    def locale_specification(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['V2modelsBotVersionLocaleSpecificationArgs']]]]):
        pulumi.set(self, "locale_specification", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsBotVersionTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsBotVersionTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class V2modelsBotVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 locale_specification: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['V2modelsBotVersionLocaleSpecificationArgs', 'V2modelsBotVersionLocaleSpecificationArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsBotVersionTimeoutsArgs', 'V2modelsBotVersionTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lex V2 Models Bot Version.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lex.V2modelsBotVersion("test",
            bot_id=test_aws_lexv2models_bot["id"],
            locale_specification={
                "en_US": {
                    "source_bot_version": "DRAFT",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Lex V2 Models Bot Version using the `id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsBotVersion:V2modelsBotVersion example id-12345678,1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Idientifier of the bot to create the version for.
        :param pulumi.Input[str] bot_version: Version number assigned to the version.
        :param pulumi.Input[str] description: A description of the version. Use the description to help identify the version in lists.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['V2modelsBotVersionLocaleSpecificationArgs', 'V2modelsBotVersionLocaleSpecificationArgsDict']]]] locale_specification: Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
               
               The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
               * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2modelsBotVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lex V2 Models Bot Version.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lex.V2modelsBotVersion("test",
            bot_id=test_aws_lexv2models_bot["id"],
            locale_specification={
                "en_US": {
                    "source_bot_version": "DRAFT",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Lex V2 Models Bot Version using the `id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsBotVersion:V2modelsBotVersion example id-12345678,1
        ```

        :param str resource_name: The name of the resource.
        :param V2modelsBotVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2modelsBotVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 locale_specification: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['V2modelsBotVersionLocaleSpecificationArgs', 'V2modelsBotVersionLocaleSpecificationArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsBotVersionTimeoutsArgs', 'V2modelsBotVersionTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2modelsBotVersionArgs.__new__(V2modelsBotVersionArgs)

            if bot_id is None and not opts.urn:
                raise TypeError("Missing required property 'bot_id'")
            __props__.__dict__["bot_id"] = bot_id
            __props__.__dict__["bot_version"] = bot_version
            __props__.__dict__["description"] = description
            if locale_specification is None and not opts.urn:
                raise TypeError("Missing required property 'locale_specification'")
            __props__.__dict__["locale_specification"] = locale_specification
            __props__.__dict__["timeouts"] = timeouts
        super(V2modelsBotVersion, __self__).__init__(
            'aws:lex/v2modelsBotVersion:V2modelsBotVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bot_id: Optional[pulumi.Input[str]] = None,
            bot_version: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            locale_specification: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['V2modelsBotVersionLocaleSpecificationArgs', 'V2modelsBotVersionLocaleSpecificationArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['V2modelsBotVersionTimeoutsArgs', 'V2modelsBotVersionTimeoutsArgsDict']]] = None) -> 'V2modelsBotVersion':
        """
        Get an existing V2modelsBotVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Idientifier of the bot to create the version for.
        :param pulumi.Input[str] bot_version: Version number assigned to the version.
        :param pulumi.Input[str] description: A description of the version. Use the description to help identify the version in lists.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['V2modelsBotVersionLocaleSpecificationArgs', 'V2modelsBotVersionLocaleSpecificationArgsDict']]]] locale_specification: Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
               
               The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
               * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2modelsBotVersionState.__new__(_V2modelsBotVersionState)

        __props__.__dict__["bot_id"] = bot_id
        __props__.__dict__["bot_version"] = bot_version
        __props__.__dict__["description"] = description
        __props__.__dict__["locale_specification"] = locale_specification
        __props__.__dict__["timeouts"] = timeouts
        return V2modelsBotVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Output[str]:
        """
        Idientifier of the bot to create the version for.
        """
        return pulumi.get(self, "bot_id")

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Output[str]:
        """
        Version number assigned to the version.
        """
        return pulumi.get(self, "bot_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the version. Use the description to help identify the version in lists.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="localeSpecification")
    def locale_specification(self) -> pulumi.Output[Mapping[str, 'outputs.V2modelsBotVersionLocaleSpecification']]:
        """
        Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.

        The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
        * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
        """
        return pulumi.get(self, "locale_specification")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.V2modelsBotVersionTimeouts']]:
        return pulumi.get(self, "timeouts")

