# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2modelsIntentArgs', 'V2modelsIntent']

@pulumi.input_type
class V2modelsIntentArgs:
    def __init__(__self__, *,
                 bot_id: pulumi.Input[str],
                 bot_version: pulumi.Input[str],
                 locale_id: pulumi.Input[str],
                 closing_setting: Optional[pulumi.Input['V2modelsIntentClosingSettingArgs']] = None,
                 confirmation_setting: Optional[pulumi.Input['V2modelsIntentConfirmationSettingArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dialog_code_hook: Optional[pulumi.Input['V2modelsIntentDialogCodeHookArgs']] = None,
                 fulfillment_code_hook: Optional[pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs']] = None,
                 initial_response_setting: Optional[pulumi.Input['V2modelsIntentInitialResponseSettingArgs']] = None,
                 input_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]]] = None,
                 kendra_configuration: Optional[pulumi.Input['V2modelsIntentKendraConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]]] = None,
                 parent_intent_signature: Optional[pulumi.Input[str]] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]]] = None,
                 slot_priorities: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsIntentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a V2modelsIntent resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this intent.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this intent.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input['V2modelsIntentClosingSettingArgs'] closing_setting: Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
        :param pulumi.Input[str] description: Description of the intent. Use the description to help identify the intent in lists.
        :param pulumi.Input['V2modelsIntentDialogCodeHookArgs'] dialog_code_hook: Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
        :param pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs'] fulfillment_code_hook: Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
        :param pulumi.Input['V2modelsIntentInitialResponseSettingArgs'] initial_response_setting: Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]] input_contexts: Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
        :param pulumi.Input['V2modelsIntentKendraConfigurationArgs'] kendra_configuration: Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
        :param pulumi.Input[str] name: Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]] output_contexts: Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
        :param pulumi.Input[str] parent_intent_signature: Identifier for the built-in intent to base this intent on.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]] sample_utterances: Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]] slot_priorities: Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
        """
        pulumi.set(__self__, "bot_id", bot_id)
        pulumi.set(__self__, "bot_version", bot_version)
        pulumi.set(__self__, "locale_id", locale_id)
        if closing_setting is not None:
            pulumi.set(__self__, "closing_setting", closing_setting)
        if confirmation_setting is not None:
            pulumi.set(__self__, "confirmation_setting", confirmation_setting)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dialog_code_hook is not None:
            pulumi.set(__self__, "dialog_code_hook", dialog_code_hook)
        if fulfillment_code_hook is not None:
            pulumi.set(__self__, "fulfillment_code_hook", fulfillment_code_hook)
        if initial_response_setting is not None:
            pulumi.set(__self__, "initial_response_setting", initial_response_setting)
        if input_contexts is not None:
            pulumi.set(__self__, "input_contexts", input_contexts)
        if kendra_configuration is not None:
            pulumi.set(__self__, "kendra_configuration", kendra_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_contexts is not None:
            pulumi.set(__self__, "output_contexts", output_contexts)
        if parent_intent_signature is not None:
            pulumi.set(__self__, "parent_intent_signature", parent_intent_signature)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if slot_priorities is not None:
            pulumi.set(__self__, "slot_priorities", slot_priorities)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Input[str]:
        """
        Identifier of the bot associated with this intent.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Input[str]:
        """
        Version of the bot associated with this intent.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Input[str]:
        """
        Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale_id", value)

    @property
    @pulumi.getter(name="closingSetting")
    def closing_setting(self) -> Optional[pulumi.Input['V2modelsIntentClosingSettingArgs']]:
        """
        Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
        """
        return pulumi.get(self, "closing_setting")

    @closing_setting.setter
    def closing_setting(self, value: Optional[pulumi.Input['V2modelsIntentClosingSettingArgs']]):
        pulumi.set(self, "closing_setting", value)

    @property
    @pulumi.getter(name="confirmationSetting")
    def confirmation_setting(self) -> Optional[pulumi.Input['V2modelsIntentConfirmationSettingArgs']]:
        return pulumi.get(self, "confirmation_setting")

    @confirmation_setting.setter
    def confirmation_setting(self, value: Optional[pulumi.Input['V2modelsIntentConfirmationSettingArgs']]):
        pulumi.set(self, "confirmation_setting", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the intent. Use the description to help identify the intent in lists.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> Optional[pulumi.Input['V2modelsIntentDialogCodeHookArgs']]:
        """
        Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
        """
        return pulumi.get(self, "dialog_code_hook")

    @dialog_code_hook.setter
    def dialog_code_hook(self, value: Optional[pulumi.Input['V2modelsIntentDialogCodeHookArgs']]):
        pulumi.set(self, "dialog_code_hook", value)

    @property
    @pulumi.getter(name="fulfillmentCodeHook")
    def fulfillment_code_hook(self) -> Optional[pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs']]:
        """
        Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
        """
        return pulumi.get(self, "fulfillment_code_hook")

    @fulfillment_code_hook.setter
    def fulfillment_code_hook(self, value: Optional[pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs']]):
        pulumi.set(self, "fulfillment_code_hook", value)

    @property
    @pulumi.getter(name="initialResponseSetting")
    def initial_response_setting(self) -> Optional[pulumi.Input['V2modelsIntentInitialResponseSettingArgs']]:
        """
        Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
        """
        return pulumi.get(self, "initial_response_setting")

    @initial_response_setting.setter
    def initial_response_setting(self, value: Optional[pulumi.Input['V2modelsIntentInitialResponseSettingArgs']]):
        pulumi.set(self, "initial_response_setting", value)

    @property
    @pulumi.getter(name="inputContexts")
    def input_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]]]:
        """
        Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
        """
        return pulumi.get(self, "input_contexts")

    @input_contexts.setter
    def input_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]]]):
        pulumi.set(self, "input_contexts", value)

    @property
    @pulumi.getter(name="kendraConfiguration")
    def kendra_configuration(self) -> Optional[pulumi.Input['V2modelsIntentKendraConfigurationArgs']]:
        """
        Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
        """
        return pulumi.get(self, "kendra_configuration")

    @kendra_configuration.setter
    def kendra_configuration(self, value: Optional[pulumi.Input['V2modelsIntentKendraConfigurationArgs']]):
        pulumi.set(self, "kendra_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputContexts")
    def output_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]]]:
        """
        Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
        """
        return pulumi.get(self, "output_contexts")

    @output_contexts.setter
    def output_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]]]):
        pulumi.set(self, "output_contexts", value)

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the built-in intent to base this intent on.
        """
        return pulumi.get(self, "parent_intent_signature")

    @parent_intent_signature.setter
    def parent_intent_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_intent_signature", value)

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]]]:
        """
        Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
        """
        return pulumi.get(self, "sample_utterances")

    @sample_utterances.setter
    def sample_utterances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]]]):
        pulumi.set(self, "sample_utterances", value)

    @property
    @pulumi.getter(name="slotPriorities")
    def slot_priorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]]]:
        """
        Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
        """
        return pulumi.get(self, "slot_priorities")

    @slot_priorities.setter
    def slot_priorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]]]):
        pulumi.set(self, "slot_priorities", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsIntentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsIntentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _V2modelsIntentState:
    def __init__(__self__, *,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 closing_setting: Optional[pulumi.Input['V2modelsIntentClosingSettingArgs']] = None,
                 confirmation_setting: Optional[pulumi.Input['V2modelsIntentConfirmationSettingArgs']] = None,
                 creation_date_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dialog_code_hook: Optional[pulumi.Input['V2modelsIntentDialogCodeHookArgs']] = None,
                 fulfillment_code_hook: Optional[pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs']] = None,
                 initial_response_setting: Optional[pulumi.Input['V2modelsIntentInitialResponseSettingArgs']] = None,
                 input_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]]] = None,
                 intent_id: Optional[pulumi.Input[str]] = None,
                 kendra_configuration: Optional[pulumi.Input['V2modelsIntentKendraConfigurationArgs']] = None,
                 last_updated_date_time: Optional[pulumi.Input[str]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]]] = None,
                 parent_intent_signature: Optional[pulumi.Input[str]] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]]] = None,
                 slot_priorities: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsIntentTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering V2modelsIntent resources.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this intent.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this intent.
        :param pulumi.Input['V2modelsIntentClosingSettingArgs'] closing_setting: Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
        :param pulumi.Input[str] creation_date_time: Timestamp of the date and time that the intent was created.
        :param pulumi.Input[str] description: Description of the intent. Use the description to help identify the intent in lists.
        :param pulumi.Input['V2modelsIntentDialogCodeHookArgs'] dialog_code_hook: Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
        :param pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs'] fulfillment_code_hook: Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
        :param pulumi.Input['V2modelsIntentInitialResponseSettingArgs'] initial_response_setting: Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]] input_contexts: Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
        :param pulumi.Input[str] intent_id: Unique identifier for the intent.
        :param pulumi.Input['V2modelsIntentKendraConfigurationArgs'] kendra_configuration: Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
        :param pulumi.Input[str] last_updated_date_time: Timestamp of the last time that the intent was modified.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[str] name: Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]] output_contexts: Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
        :param pulumi.Input[str] parent_intent_signature: Identifier for the built-in intent to base this intent on.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]] sample_utterances: Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]] slot_priorities: Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
        """
        if bot_id is not None:
            pulumi.set(__self__, "bot_id", bot_id)
        if bot_version is not None:
            pulumi.set(__self__, "bot_version", bot_version)
        if closing_setting is not None:
            pulumi.set(__self__, "closing_setting", closing_setting)
        if confirmation_setting is not None:
            pulumi.set(__self__, "confirmation_setting", confirmation_setting)
        if creation_date_time is not None:
            pulumi.set(__self__, "creation_date_time", creation_date_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dialog_code_hook is not None:
            pulumi.set(__self__, "dialog_code_hook", dialog_code_hook)
        if fulfillment_code_hook is not None:
            pulumi.set(__self__, "fulfillment_code_hook", fulfillment_code_hook)
        if initial_response_setting is not None:
            pulumi.set(__self__, "initial_response_setting", initial_response_setting)
        if input_contexts is not None:
            pulumi.set(__self__, "input_contexts", input_contexts)
        if intent_id is not None:
            pulumi.set(__self__, "intent_id", intent_id)
        if kendra_configuration is not None:
            pulumi.set(__self__, "kendra_configuration", kendra_configuration)
        if last_updated_date_time is not None:
            pulumi.set(__self__, "last_updated_date_time", last_updated_date_time)
        if locale_id is not None:
            pulumi.set(__self__, "locale_id", locale_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_contexts is not None:
            pulumi.set(__self__, "output_contexts", output_contexts)
        if parent_intent_signature is not None:
            pulumi.set(__self__, "parent_intent_signature", parent_intent_signature)
        if sample_utterances is not None:
            pulumi.set(__self__, "sample_utterances", sample_utterances)
        if slot_priorities is not None:
            pulumi.set(__self__, "slot_priorities", slot_priorities)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the bot associated with this intent.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the bot associated with this intent.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter(name="closingSetting")
    def closing_setting(self) -> Optional[pulumi.Input['V2modelsIntentClosingSettingArgs']]:
        """
        Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
        """
        return pulumi.get(self, "closing_setting")

    @closing_setting.setter
    def closing_setting(self, value: Optional[pulumi.Input['V2modelsIntentClosingSettingArgs']]):
        pulumi.set(self, "closing_setting", value)

    @property
    @pulumi.getter(name="confirmationSetting")
    def confirmation_setting(self) -> Optional[pulumi.Input['V2modelsIntentConfirmationSettingArgs']]:
        return pulumi.get(self, "confirmation_setting")

    @confirmation_setting.setter
    def confirmation_setting(self, value: Optional[pulumi.Input['V2modelsIntentConfirmationSettingArgs']]):
        pulumi.set(self, "confirmation_setting", value)

    @property
    @pulumi.getter(name="creationDateTime")
    def creation_date_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the date and time that the intent was created.
        """
        return pulumi.get(self, "creation_date_time")

    @creation_date_time.setter
    def creation_date_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the intent. Use the description to help identify the intent in lists.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> Optional[pulumi.Input['V2modelsIntentDialogCodeHookArgs']]:
        """
        Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
        """
        return pulumi.get(self, "dialog_code_hook")

    @dialog_code_hook.setter
    def dialog_code_hook(self, value: Optional[pulumi.Input['V2modelsIntentDialogCodeHookArgs']]):
        pulumi.set(self, "dialog_code_hook", value)

    @property
    @pulumi.getter(name="fulfillmentCodeHook")
    def fulfillment_code_hook(self) -> Optional[pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs']]:
        """
        Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
        """
        return pulumi.get(self, "fulfillment_code_hook")

    @fulfillment_code_hook.setter
    def fulfillment_code_hook(self, value: Optional[pulumi.Input['V2modelsIntentFulfillmentCodeHookArgs']]):
        pulumi.set(self, "fulfillment_code_hook", value)

    @property
    @pulumi.getter(name="initialResponseSetting")
    def initial_response_setting(self) -> Optional[pulumi.Input['V2modelsIntentInitialResponseSettingArgs']]:
        """
        Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
        """
        return pulumi.get(self, "initial_response_setting")

    @initial_response_setting.setter
    def initial_response_setting(self, value: Optional[pulumi.Input['V2modelsIntentInitialResponseSettingArgs']]):
        pulumi.set(self, "initial_response_setting", value)

    @property
    @pulumi.getter(name="inputContexts")
    def input_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]]]:
        """
        Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
        """
        return pulumi.get(self, "input_contexts")

    @input_contexts.setter
    def input_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentInputContextArgs']]]]):
        pulumi.set(self, "input_contexts", value)

    @property
    @pulumi.getter(name="intentId")
    def intent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the intent.
        """
        return pulumi.get(self, "intent_id")

    @intent_id.setter
    def intent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intent_id", value)

    @property
    @pulumi.getter(name="kendraConfiguration")
    def kendra_configuration(self) -> Optional[pulumi.Input['V2modelsIntentKendraConfigurationArgs']]:
        """
        Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
        """
        return pulumi.get(self, "kendra_configuration")

    @kendra_configuration.setter
    def kendra_configuration(self, value: Optional[pulumi.Input['V2modelsIntentKendraConfigurationArgs']]):
        pulumi.set(self, "kendra_configuration", value)

    @property
    @pulumi.getter(name="lastUpdatedDateTime")
    def last_updated_date_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last time that the intent was modified.
        """
        return pulumi.get(self, "last_updated_date_time")

    @last_updated_date_time.setter
    def last_updated_date_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_date_time", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputContexts")
    def output_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]]]:
        """
        Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
        """
        return pulumi.get(self, "output_contexts")

    @output_contexts.setter
    def output_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentOutputContextArgs']]]]):
        pulumi.set(self, "output_contexts", value)

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the built-in intent to base this intent on.
        """
        return pulumi.get(self, "parent_intent_signature")

    @parent_intent_signature.setter
    def parent_intent_signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_intent_signature", value)

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]]]:
        """
        Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
        """
        return pulumi.get(self, "sample_utterances")

    @sample_utterances.setter
    def sample_utterances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSampleUtteranceArgs']]]]):
        pulumi.set(self, "sample_utterances", value)

    @property
    @pulumi.getter(name="slotPriorities")
    def slot_priorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]]]:
        """
        Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
        """
        return pulumi.get(self, "slot_priorities")

    @slot_priorities.setter
    def slot_priorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsIntentSlotPriorityArgs']]]]):
        pulumi.set(self, "slot_priorities", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsIntentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsIntentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class V2modelsIntent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 closing_setting: Optional[pulumi.Input[Union['V2modelsIntentClosingSettingArgs', 'V2modelsIntentClosingSettingArgsDict']]] = None,
                 confirmation_setting: Optional[pulumi.Input[Union['V2modelsIntentConfirmationSettingArgs', 'V2modelsIntentConfirmationSettingArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dialog_code_hook: Optional[pulumi.Input[Union['V2modelsIntentDialogCodeHookArgs', 'V2modelsIntentDialogCodeHookArgsDict']]] = None,
                 fulfillment_code_hook: Optional[pulumi.Input[Union['V2modelsIntentFulfillmentCodeHookArgs', 'V2modelsIntentFulfillmentCodeHookArgsDict']]] = None,
                 initial_response_setting: Optional[pulumi.Input[Union['V2modelsIntentInitialResponseSettingArgs', 'V2modelsIntentInitialResponseSettingArgsDict']]] = None,
                 input_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentInputContextArgs', 'V2modelsIntentInputContextArgsDict']]]]] = None,
                 kendra_configuration: Optional[pulumi.Input[Union['V2modelsIntentKendraConfigurationArgs', 'V2modelsIntentKendraConfigurationArgsDict']]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentOutputContextArgs', 'V2modelsIntentOutputContextArgsDict']]]]] = None,
                 parent_intent_signature: Optional[pulumi.Input[str]] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSampleUtteranceArgs', 'V2modelsIntentSampleUtteranceArgsDict']]]]] = None,
                 slot_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSlotPriorityArgs', 'V2modelsIntentSlotPriorityArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsIntentTimeoutsArgs', 'V2modelsIntentTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        ## Import

        Using `pulumi import`, import Lex V2 Models Intent using the `intent_id:bot_id:bot_version:locale_id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsIntent:V2modelsIntent example intent-42874:bot-11376:DRAFT:en_US
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this intent.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this intent.
        :param pulumi.Input[Union['V2modelsIntentClosingSettingArgs', 'V2modelsIntentClosingSettingArgsDict']] closing_setting: Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
        :param pulumi.Input[str] description: Description of the intent. Use the description to help identify the intent in lists.
        :param pulumi.Input[Union['V2modelsIntentDialogCodeHookArgs', 'V2modelsIntentDialogCodeHookArgsDict']] dialog_code_hook: Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
        :param pulumi.Input[Union['V2modelsIntentFulfillmentCodeHookArgs', 'V2modelsIntentFulfillmentCodeHookArgsDict']] fulfillment_code_hook: Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
        :param pulumi.Input[Union['V2modelsIntentInitialResponseSettingArgs', 'V2modelsIntentInitialResponseSettingArgsDict']] initial_response_setting: Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentInputContextArgs', 'V2modelsIntentInputContextArgsDict']]]] input_contexts: Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
        :param pulumi.Input[Union['V2modelsIntentKendraConfigurationArgs', 'V2modelsIntentKendraConfigurationArgsDict']] kendra_configuration: Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[str] name: Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentOutputContextArgs', 'V2modelsIntentOutputContextArgsDict']]]] output_contexts: Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
        :param pulumi.Input[str] parent_intent_signature: Identifier for the built-in intent to base this intent on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSampleUtteranceArgs', 'V2modelsIntentSampleUtteranceArgsDict']]]] sample_utterances: Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSlotPriorityArgs', 'V2modelsIntentSlotPriorityArgsDict']]]] slot_priorities: Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2modelsIntentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Using `pulumi import`, import Lex V2 Models Intent using the `intent_id:bot_id:bot_version:locale_id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsIntent:V2modelsIntent example intent-42874:bot-11376:DRAFT:en_US
        ```

        :param str resource_name: The name of the resource.
        :param V2modelsIntentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2modelsIntentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 closing_setting: Optional[pulumi.Input[Union['V2modelsIntentClosingSettingArgs', 'V2modelsIntentClosingSettingArgsDict']]] = None,
                 confirmation_setting: Optional[pulumi.Input[Union['V2modelsIntentConfirmationSettingArgs', 'V2modelsIntentConfirmationSettingArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dialog_code_hook: Optional[pulumi.Input[Union['V2modelsIntentDialogCodeHookArgs', 'V2modelsIntentDialogCodeHookArgsDict']]] = None,
                 fulfillment_code_hook: Optional[pulumi.Input[Union['V2modelsIntentFulfillmentCodeHookArgs', 'V2modelsIntentFulfillmentCodeHookArgsDict']]] = None,
                 initial_response_setting: Optional[pulumi.Input[Union['V2modelsIntentInitialResponseSettingArgs', 'V2modelsIntentInitialResponseSettingArgsDict']]] = None,
                 input_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentInputContextArgs', 'V2modelsIntentInputContextArgsDict']]]]] = None,
                 kendra_configuration: Optional[pulumi.Input[Union['V2modelsIntentKendraConfigurationArgs', 'V2modelsIntentKendraConfigurationArgsDict']]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentOutputContextArgs', 'V2modelsIntentOutputContextArgsDict']]]]] = None,
                 parent_intent_signature: Optional[pulumi.Input[str]] = None,
                 sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSampleUtteranceArgs', 'V2modelsIntentSampleUtteranceArgsDict']]]]] = None,
                 slot_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSlotPriorityArgs', 'V2modelsIntentSlotPriorityArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsIntentTimeoutsArgs', 'V2modelsIntentTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2modelsIntentArgs.__new__(V2modelsIntentArgs)

            if bot_id is None and not opts.urn:
                raise TypeError("Missing required property 'bot_id'")
            __props__.__dict__["bot_id"] = bot_id
            if bot_version is None and not opts.urn:
                raise TypeError("Missing required property 'bot_version'")
            __props__.__dict__["bot_version"] = bot_version
            __props__.__dict__["closing_setting"] = closing_setting
            __props__.__dict__["confirmation_setting"] = confirmation_setting
            __props__.__dict__["description"] = description
            __props__.__dict__["dialog_code_hook"] = dialog_code_hook
            __props__.__dict__["fulfillment_code_hook"] = fulfillment_code_hook
            __props__.__dict__["initial_response_setting"] = initial_response_setting
            __props__.__dict__["input_contexts"] = input_contexts
            __props__.__dict__["kendra_configuration"] = kendra_configuration
            if locale_id is None and not opts.urn:
                raise TypeError("Missing required property 'locale_id'")
            __props__.__dict__["locale_id"] = locale_id
            __props__.__dict__["name"] = name
            __props__.__dict__["output_contexts"] = output_contexts
            __props__.__dict__["parent_intent_signature"] = parent_intent_signature
            __props__.__dict__["sample_utterances"] = sample_utterances
            __props__.__dict__["slot_priorities"] = slot_priorities
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["creation_date_time"] = None
            __props__.__dict__["intent_id"] = None
            __props__.__dict__["last_updated_date_time"] = None
        super(V2modelsIntent, __self__).__init__(
            'aws:lex/v2modelsIntent:V2modelsIntent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bot_id: Optional[pulumi.Input[str]] = None,
            bot_version: Optional[pulumi.Input[str]] = None,
            closing_setting: Optional[pulumi.Input[Union['V2modelsIntentClosingSettingArgs', 'V2modelsIntentClosingSettingArgsDict']]] = None,
            confirmation_setting: Optional[pulumi.Input[Union['V2modelsIntentConfirmationSettingArgs', 'V2modelsIntentConfirmationSettingArgsDict']]] = None,
            creation_date_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dialog_code_hook: Optional[pulumi.Input[Union['V2modelsIntentDialogCodeHookArgs', 'V2modelsIntentDialogCodeHookArgsDict']]] = None,
            fulfillment_code_hook: Optional[pulumi.Input[Union['V2modelsIntentFulfillmentCodeHookArgs', 'V2modelsIntentFulfillmentCodeHookArgsDict']]] = None,
            initial_response_setting: Optional[pulumi.Input[Union['V2modelsIntentInitialResponseSettingArgs', 'V2modelsIntentInitialResponseSettingArgsDict']]] = None,
            input_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentInputContextArgs', 'V2modelsIntentInputContextArgsDict']]]]] = None,
            intent_id: Optional[pulumi.Input[str]] = None,
            kendra_configuration: Optional[pulumi.Input[Union['V2modelsIntentKendraConfigurationArgs', 'V2modelsIntentKendraConfigurationArgsDict']]] = None,
            last_updated_date_time: Optional[pulumi.Input[str]] = None,
            locale_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentOutputContextArgs', 'V2modelsIntentOutputContextArgsDict']]]]] = None,
            parent_intent_signature: Optional[pulumi.Input[str]] = None,
            sample_utterances: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSampleUtteranceArgs', 'V2modelsIntentSampleUtteranceArgsDict']]]]] = None,
            slot_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSlotPriorityArgs', 'V2modelsIntentSlotPriorityArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['V2modelsIntentTimeoutsArgs', 'V2modelsIntentTimeoutsArgsDict']]] = None) -> 'V2modelsIntent':
        """
        Get an existing V2modelsIntent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with this intent.
        :param pulumi.Input[str] bot_version: Version of the bot associated with this intent.
        :param pulumi.Input[Union['V2modelsIntentClosingSettingArgs', 'V2modelsIntentClosingSettingArgsDict']] closing_setting: Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
        :param pulumi.Input[str] creation_date_time: Timestamp of the date and time that the intent was created.
        :param pulumi.Input[str] description: Description of the intent. Use the description to help identify the intent in lists.
        :param pulumi.Input[Union['V2modelsIntentDialogCodeHookArgs', 'V2modelsIntentDialogCodeHookArgsDict']] dialog_code_hook: Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
        :param pulumi.Input[Union['V2modelsIntentFulfillmentCodeHookArgs', 'V2modelsIntentFulfillmentCodeHookArgsDict']] fulfillment_code_hook: Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
        :param pulumi.Input[Union['V2modelsIntentInitialResponseSettingArgs', 'V2modelsIntentInitialResponseSettingArgsDict']] initial_response_setting: Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentInputContextArgs', 'V2modelsIntentInputContextArgsDict']]]] input_contexts: Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
        :param pulumi.Input[str] intent_id: Unique identifier for the intent.
        :param pulumi.Input[Union['V2modelsIntentKendraConfigurationArgs', 'V2modelsIntentKendraConfigurationArgsDict']] kendra_configuration: Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
        :param pulumi.Input[str] last_updated_date_time: Timestamp of the last time that the intent was modified.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        :param pulumi.Input[str] name: Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentOutputContextArgs', 'V2modelsIntentOutputContextArgsDict']]]] output_contexts: Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
        :param pulumi.Input[str] parent_intent_signature: Identifier for the built-in intent to base this intent on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSampleUtteranceArgs', 'V2modelsIntentSampleUtteranceArgsDict']]]] sample_utterances: Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsIntentSlotPriorityArgs', 'V2modelsIntentSlotPriorityArgsDict']]]] slot_priorities: Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2modelsIntentState.__new__(_V2modelsIntentState)

        __props__.__dict__["bot_id"] = bot_id
        __props__.__dict__["bot_version"] = bot_version
        __props__.__dict__["closing_setting"] = closing_setting
        __props__.__dict__["confirmation_setting"] = confirmation_setting
        __props__.__dict__["creation_date_time"] = creation_date_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dialog_code_hook"] = dialog_code_hook
        __props__.__dict__["fulfillment_code_hook"] = fulfillment_code_hook
        __props__.__dict__["initial_response_setting"] = initial_response_setting
        __props__.__dict__["input_contexts"] = input_contexts
        __props__.__dict__["intent_id"] = intent_id
        __props__.__dict__["kendra_configuration"] = kendra_configuration
        __props__.__dict__["last_updated_date_time"] = last_updated_date_time
        __props__.__dict__["locale_id"] = locale_id
        __props__.__dict__["name"] = name
        __props__.__dict__["output_contexts"] = output_contexts
        __props__.__dict__["parent_intent_signature"] = parent_intent_signature
        __props__.__dict__["sample_utterances"] = sample_utterances
        __props__.__dict__["slot_priorities"] = slot_priorities
        __props__.__dict__["timeouts"] = timeouts
        return V2modelsIntent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Output[str]:
        """
        Identifier of the bot associated with this intent.
        """
        return pulumi.get(self, "bot_id")

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Output[str]:
        """
        Version of the bot associated with this intent.
        """
        return pulumi.get(self, "bot_version")

    @property
    @pulumi.getter(name="closingSetting")
    def closing_setting(self) -> pulumi.Output[Optional['outputs.V2modelsIntentClosingSetting']]:
        """
        Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
        """
        return pulumi.get(self, "closing_setting")

    @property
    @pulumi.getter(name="confirmationSetting")
    def confirmation_setting(self) -> pulumi.Output[Optional['outputs.V2modelsIntentConfirmationSetting']]:
        return pulumi.get(self, "confirmation_setting")

    @property
    @pulumi.getter(name="creationDateTime")
    def creation_date_time(self) -> pulumi.Output[str]:
        """
        Timestamp of the date and time that the intent was created.
        """
        return pulumi.get(self, "creation_date_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the intent. Use the description to help identify the intent in lists.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dialogCodeHook")
    def dialog_code_hook(self) -> pulumi.Output[Optional['outputs.V2modelsIntentDialogCodeHook']]:
        """
        Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
        """
        return pulumi.get(self, "dialog_code_hook")

    @property
    @pulumi.getter(name="fulfillmentCodeHook")
    def fulfillment_code_hook(self) -> pulumi.Output[Optional['outputs.V2modelsIntentFulfillmentCodeHook']]:
        """
        Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
        """
        return pulumi.get(self, "fulfillment_code_hook")

    @property
    @pulumi.getter(name="initialResponseSetting")
    def initial_response_setting(self) -> pulumi.Output[Optional['outputs.V2modelsIntentInitialResponseSetting']]:
        """
        Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
        """
        return pulumi.get(self, "initial_response_setting")

    @property
    @pulumi.getter(name="inputContexts")
    def input_contexts(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsIntentInputContext']]]:
        """
        Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
        """
        return pulumi.get(self, "input_contexts")

    @property
    @pulumi.getter(name="intentId")
    def intent_id(self) -> pulumi.Output[str]:
        """
        Unique identifier for the intent.
        """
        return pulumi.get(self, "intent_id")

    @property
    @pulumi.getter(name="kendraConfiguration")
    def kendra_configuration(self) -> pulumi.Output[Optional['outputs.V2modelsIntentKendraConfiguration']]:
        """
        Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
        """
        return pulumi.get(self, "kendra_configuration")

    @property
    @pulumi.getter(name="lastUpdatedDateTime")
    def last_updated_date_time(self) -> pulumi.Output[str]:
        """
        Timestamp of the last time that the intent was modified.
        """
        return pulumi.get(self, "last_updated_date_time")

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Output[str]:
        """
        Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
        """
        return pulumi.get(self, "locale_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputContexts")
    def output_contexts(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsIntentOutputContext']]]:
        """
        Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
        """
        return pulumi.get(self, "output_contexts")

    @property
    @pulumi.getter(name="parentIntentSignature")
    def parent_intent_signature(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier for the built-in intent to base this intent on.
        """
        return pulumi.get(self, "parent_intent_signature")

    @property
    @pulumi.getter(name="sampleUtterances")
    def sample_utterances(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsIntentSampleUtterance']]]:
        """
        Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
        """
        return pulumi.get(self, "sample_utterances")

    @property
    @pulumi.getter(name="slotPriorities")
    def slot_priorities(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsIntentSlotPriority']]]:
        """
        Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
        """
        return pulumi.get(self, "slot_priorities")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.V2modelsIntentTimeouts']]:
        return pulumi.get(self, "timeouts")

