# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['V2modelsSlotArgs', 'V2modelsSlot']

@pulumi.input_type
class V2modelsSlotArgs:
    def __init__(__self__, *,
                 bot_id: pulumi.Input[str],
                 bot_version: pulumi.Input[str],
                 intent_id: pulumi.Input[str],
                 locale_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 multiple_values_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obfuscation_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]]] = None,
                 slot_type_id: Optional[pulumi.Input[str]] = None,
                 sub_slot_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsSlotTimeoutsArgs']] = None,
                 value_elicitation_setting: Optional[pulumi.Input['V2modelsSlotValueElicitationSettingArgs']] = None):
        """
        The set of arguments for constructing a V2modelsSlot resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with the slot.
        :param pulumi.Input[str] bot_version: Version of the bot associated with the slot.
        :param pulumi.Input[str] intent_id: Identifier of the intent that contains the slot.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale that the slot will be used in.
        :param pulumi.Input[str] description: Description of the slot.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]] multiple_values_settings: Whether the slot returns multiple values in one response.
               See the `multiple_values_setting` argument reference below.
        :param pulumi.Input[str] name: Name of the slot.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]] obfuscation_settings: Determines how slot values are used in Amazon CloudWatch logs.
               See the `obfuscation_setting` argument reference below.
        :param pulumi.Input[str] slot_type_id: Unique identifier for the slot type associated with this slot.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]] sub_slot_settings: Specifications for the constituent sub slots and the expression for the composite slot.
               See the `sub_slot_setting` argument reference below.
        """
        pulumi.set(__self__, "bot_id", bot_id)
        pulumi.set(__self__, "bot_version", bot_version)
        pulumi.set(__self__, "intent_id", intent_id)
        pulumi.set(__self__, "locale_id", locale_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if multiple_values_settings is not None:
            pulumi.set(__self__, "multiple_values_settings", multiple_values_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if obfuscation_settings is not None:
            pulumi.set(__self__, "obfuscation_settings", obfuscation_settings)
        if slot_type_id is not None:
            pulumi.set(__self__, "slot_type_id", slot_type_id)
        if sub_slot_settings is not None:
            pulumi.set(__self__, "sub_slot_settings", sub_slot_settings)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if value_elicitation_setting is not None:
            pulumi.set(__self__, "value_elicitation_setting", value_elicitation_setting)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Input[str]:
        """
        Identifier of the bot associated with the slot.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Input[str]:
        """
        Version of the bot associated with the slot.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter(name="intentId")
    def intent_id(self) -> pulumi.Input[str]:
        """
        Identifier of the intent that contains the slot.
        """
        return pulumi.get(self, "intent_id")

    @intent_id.setter
    def intent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "intent_id", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Input[str]:
        """
        Identifier of the language and locale that the slot will be used in.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the slot.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="multipleValuesSettings")
    def multiple_values_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]]]:
        """
        Whether the slot returns multiple values in one response.
        See the `multiple_values_setting` argument reference below.
        """
        return pulumi.get(self, "multiple_values_settings")

    @multiple_values_settings.setter
    def multiple_values_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]]]):
        pulumi.set(self, "multiple_values_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the slot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="obfuscationSettings")
    def obfuscation_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]]]:
        """
        Determines how slot values are used in Amazon CloudWatch logs.
        See the `obfuscation_setting` argument reference below.
        """
        return pulumi.get(self, "obfuscation_settings")

    @obfuscation_settings.setter
    def obfuscation_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]]]):
        pulumi.set(self, "obfuscation_settings", value)

    @property
    @pulumi.getter(name="slotTypeId")
    def slot_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the slot type associated with this slot.
        """
        return pulumi.get(self, "slot_type_id")

    @slot_type_id.setter
    def slot_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slot_type_id", value)

    @property
    @pulumi.getter(name="subSlotSettings")
    def sub_slot_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]]]:
        """
        Specifications for the constituent sub slots and the expression for the composite slot.
        See the `sub_slot_setting` argument reference below.
        """
        return pulumi.get(self, "sub_slot_settings")

    @sub_slot_settings.setter
    def sub_slot_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]]]):
        pulumi.set(self, "sub_slot_settings", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsSlotTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsSlotTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="valueElicitationSetting")
    def value_elicitation_setting(self) -> Optional[pulumi.Input['V2modelsSlotValueElicitationSettingArgs']]:
        return pulumi.get(self, "value_elicitation_setting")

    @value_elicitation_setting.setter
    def value_elicitation_setting(self, value: Optional[pulumi.Input['V2modelsSlotValueElicitationSettingArgs']]):
        pulumi.set(self, "value_elicitation_setting", value)


@pulumi.input_type
class _V2modelsSlotState:
    def __init__(__self__, *,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 intent_id: Optional[pulumi.Input[str]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 multiple_values_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obfuscation_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]]] = None,
                 slot_id: Optional[pulumi.Input[str]] = None,
                 slot_type_id: Optional[pulumi.Input[str]] = None,
                 sub_slot_settings: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['V2modelsSlotTimeoutsArgs']] = None,
                 value_elicitation_setting: Optional[pulumi.Input['V2modelsSlotValueElicitationSettingArgs']] = None):
        """
        Input properties used for looking up and filtering V2modelsSlot resources.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with the slot.
        :param pulumi.Input[str] bot_version: Version of the bot associated with the slot.
        :param pulumi.Input[str] description: Description of the slot.
        :param pulumi.Input[str] intent_id: Identifier of the intent that contains the slot.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale that the slot will be used in.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]] multiple_values_settings: Whether the slot returns multiple values in one response.
               See the `multiple_values_setting` argument reference below.
        :param pulumi.Input[str] name: Name of the slot.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]] obfuscation_settings: Determines how slot values are used in Amazon CloudWatch logs.
               See the `obfuscation_setting` argument reference below.
        :param pulumi.Input[str] slot_id: Unique identifier associated with the slot.
        :param pulumi.Input[str] slot_type_id: Unique identifier for the slot type associated with this slot.
        :param pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]] sub_slot_settings: Specifications for the constituent sub slots and the expression for the composite slot.
               See the `sub_slot_setting` argument reference below.
        """
        if bot_id is not None:
            pulumi.set(__self__, "bot_id", bot_id)
        if bot_version is not None:
            pulumi.set(__self__, "bot_version", bot_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if intent_id is not None:
            pulumi.set(__self__, "intent_id", intent_id)
        if locale_id is not None:
            pulumi.set(__self__, "locale_id", locale_id)
        if multiple_values_settings is not None:
            pulumi.set(__self__, "multiple_values_settings", multiple_values_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if obfuscation_settings is not None:
            pulumi.set(__self__, "obfuscation_settings", obfuscation_settings)
        if slot_id is not None:
            pulumi.set(__self__, "slot_id", slot_id)
        if slot_type_id is not None:
            pulumi.set(__self__, "slot_type_id", slot_type_id)
        if sub_slot_settings is not None:
            pulumi.set(__self__, "sub_slot_settings", sub_slot_settings)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if value_elicitation_setting is not None:
            pulumi.set(__self__, "value_elicitation_setting", value_elicitation_setting)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the bot associated with the slot.
        """
        return pulumi.get(self, "bot_id")

    @bot_id.setter
    def bot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_id", value)

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the bot associated with the slot.
        """
        return pulumi.get(self, "bot_version")

    @bot_version.setter
    def bot_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bot_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the slot.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="intentId")
    def intent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the intent that contains the slot.
        """
        return pulumi.get(self, "intent_id")

    @intent_id.setter
    def intent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intent_id", value)

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the language and locale that the slot will be used in.
        """
        return pulumi.get(self, "locale_id")

    @locale_id.setter
    def locale_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale_id", value)

    @property
    @pulumi.getter(name="multipleValuesSettings")
    def multiple_values_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]]]:
        """
        Whether the slot returns multiple values in one response.
        See the `multiple_values_setting` argument reference below.
        """
        return pulumi.get(self, "multiple_values_settings")

    @multiple_values_settings.setter
    def multiple_values_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotMultipleValuesSettingArgs']]]]):
        pulumi.set(self, "multiple_values_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the slot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="obfuscationSettings")
    def obfuscation_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]]]:
        """
        Determines how slot values are used in Amazon CloudWatch logs.
        See the `obfuscation_setting` argument reference below.
        """
        return pulumi.get(self, "obfuscation_settings")

    @obfuscation_settings.setter
    def obfuscation_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotObfuscationSettingArgs']]]]):
        pulumi.set(self, "obfuscation_settings", value)

    @property
    @pulumi.getter(name="slotId")
    def slot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier associated with the slot.
        """
        return pulumi.get(self, "slot_id")

    @slot_id.setter
    def slot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slot_id", value)

    @property
    @pulumi.getter(name="slotTypeId")
    def slot_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the slot type associated with this slot.
        """
        return pulumi.get(self, "slot_type_id")

    @slot_type_id.setter
    def slot_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slot_type_id", value)

    @property
    @pulumi.getter(name="subSlotSettings")
    def sub_slot_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]]]:
        """
        Specifications for the constituent sub slots and the expression for the composite slot.
        See the `sub_slot_setting` argument reference below.
        """
        return pulumi.get(self, "sub_slot_settings")

    @sub_slot_settings.setter
    def sub_slot_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['V2modelsSlotSubSlotSettingArgs']]]]):
        pulumi.set(self, "sub_slot_settings", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['V2modelsSlotTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['V2modelsSlotTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="valueElicitationSetting")
    def value_elicitation_setting(self) -> Optional[pulumi.Input['V2modelsSlotValueElicitationSettingArgs']]:
        return pulumi.get(self, "value_elicitation_setting")

    @value_elicitation_setting.setter
    def value_elicitation_setting(self, value: Optional[pulumi.Input['V2modelsSlotValueElicitationSettingArgs']]):
        pulumi.set(self, "value_elicitation_setting", value)


class V2modelsSlot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 intent_id: Optional[pulumi.Input[str]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 multiple_values_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotMultipleValuesSettingArgs', 'V2modelsSlotMultipleValuesSettingArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obfuscation_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotObfuscationSettingArgs', 'V2modelsSlotObfuscationSettingArgsDict']]]]] = None,
                 slot_type_id: Optional[pulumi.Input[str]] = None,
                 sub_slot_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotSubSlotSettingArgs', 'V2modelsSlotSubSlotSettingArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsSlotTimeoutsArgs', 'V2modelsSlotTimeoutsArgsDict']]] = None,
                 value_elicitation_setting: Optional[pulumi.Input[Union['V2modelsSlotValueElicitationSettingArgs', 'V2modelsSlotValueElicitationSettingArgsDict']]] = None,
                 __props__=None):
        """
        ## Import

        Using `pulumi import`, import Lex V2 Models Slot using the `id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsSlot:V2modelsSlot example bot-1234,1,intent-5678,en-US,slot-9012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with the slot.
        :param pulumi.Input[str] bot_version: Version of the bot associated with the slot.
        :param pulumi.Input[str] description: Description of the slot.
        :param pulumi.Input[str] intent_id: Identifier of the intent that contains the slot.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale that the slot will be used in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotMultipleValuesSettingArgs', 'V2modelsSlotMultipleValuesSettingArgsDict']]]] multiple_values_settings: Whether the slot returns multiple values in one response.
               See the `multiple_values_setting` argument reference below.
        :param pulumi.Input[str] name: Name of the slot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotObfuscationSettingArgs', 'V2modelsSlotObfuscationSettingArgsDict']]]] obfuscation_settings: Determines how slot values are used in Amazon CloudWatch logs.
               See the `obfuscation_setting` argument reference below.
        :param pulumi.Input[str] slot_type_id: Unique identifier for the slot type associated with this slot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotSubSlotSettingArgs', 'V2modelsSlotSubSlotSettingArgsDict']]]] sub_slot_settings: Specifications for the constituent sub slots and the expression for the composite slot.
               See the `sub_slot_setting` argument reference below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V2modelsSlotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Using `pulumi import`, import Lex V2 Models Slot using the `id`. For example:

        ```sh
        $ pulumi import aws:lex/v2modelsSlot:V2modelsSlot example bot-1234,1,intent-5678,en-US,slot-9012
        ```

        :param str resource_name: The name of the resource.
        :param V2modelsSlotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V2modelsSlotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_id: Optional[pulumi.Input[str]] = None,
                 bot_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 intent_id: Optional[pulumi.Input[str]] = None,
                 locale_id: Optional[pulumi.Input[str]] = None,
                 multiple_values_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotMultipleValuesSettingArgs', 'V2modelsSlotMultipleValuesSettingArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 obfuscation_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotObfuscationSettingArgs', 'V2modelsSlotObfuscationSettingArgsDict']]]]] = None,
                 slot_type_id: Optional[pulumi.Input[str]] = None,
                 sub_slot_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotSubSlotSettingArgs', 'V2modelsSlotSubSlotSettingArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['V2modelsSlotTimeoutsArgs', 'V2modelsSlotTimeoutsArgsDict']]] = None,
                 value_elicitation_setting: Optional[pulumi.Input[Union['V2modelsSlotValueElicitationSettingArgs', 'V2modelsSlotValueElicitationSettingArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V2modelsSlotArgs.__new__(V2modelsSlotArgs)

            if bot_id is None and not opts.urn:
                raise TypeError("Missing required property 'bot_id'")
            __props__.__dict__["bot_id"] = bot_id
            if bot_version is None and not opts.urn:
                raise TypeError("Missing required property 'bot_version'")
            __props__.__dict__["bot_version"] = bot_version
            __props__.__dict__["description"] = description
            if intent_id is None and not opts.urn:
                raise TypeError("Missing required property 'intent_id'")
            __props__.__dict__["intent_id"] = intent_id
            if locale_id is None and not opts.urn:
                raise TypeError("Missing required property 'locale_id'")
            __props__.__dict__["locale_id"] = locale_id
            __props__.__dict__["multiple_values_settings"] = multiple_values_settings
            __props__.__dict__["name"] = name
            __props__.__dict__["obfuscation_settings"] = obfuscation_settings
            __props__.__dict__["slot_type_id"] = slot_type_id
            __props__.__dict__["sub_slot_settings"] = sub_slot_settings
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["value_elicitation_setting"] = value_elicitation_setting
            __props__.__dict__["slot_id"] = None
        super(V2modelsSlot, __self__).__init__(
            'aws:lex/v2modelsSlot:V2modelsSlot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bot_id: Optional[pulumi.Input[str]] = None,
            bot_version: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            intent_id: Optional[pulumi.Input[str]] = None,
            locale_id: Optional[pulumi.Input[str]] = None,
            multiple_values_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotMultipleValuesSettingArgs', 'V2modelsSlotMultipleValuesSettingArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            obfuscation_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotObfuscationSettingArgs', 'V2modelsSlotObfuscationSettingArgsDict']]]]] = None,
            slot_id: Optional[pulumi.Input[str]] = None,
            slot_type_id: Optional[pulumi.Input[str]] = None,
            sub_slot_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotSubSlotSettingArgs', 'V2modelsSlotSubSlotSettingArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['V2modelsSlotTimeoutsArgs', 'V2modelsSlotTimeoutsArgsDict']]] = None,
            value_elicitation_setting: Optional[pulumi.Input[Union['V2modelsSlotValueElicitationSettingArgs', 'V2modelsSlotValueElicitationSettingArgsDict']]] = None) -> 'V2modelsSlot':
        """
        Get an existing V2modelsSlot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bot_id: Identifier of the bot associated with the slot.
        :param pulumi.Input[str] bot_version: Version of the bot associated with the slot.
        :param pulumi.Input[str] description: Description of the slot.
        :param pulumi.Input[str] intent_id: Identifier of the intent that contains the slot.
        :param pulumi.Input[str] locale_id: Identifier of the language and locale that the slot will be used in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotMultipleValuesSettingArgs', 'V2modelsSlotMultipleValuesSettingArgsDict']]]] multiple_values_settings: Whether the slot returns multiple values in one response.
               See the `multiple_values_setting` argument reference below.
        :param pulumi.Input[str] name: Name of the slot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotObfuscationSettingArgs', 'V2modelsSlotObfuscationSettingArgsDict']]]] obfuscation_settings: Determines how slot values are used in Amazon CloudWatch logs.
               See the `obfuscation_setting` argument reference below.
        :param pulumi.Input[str] slot_id: Unique identifier associated with the slot.
        :param pulumi.Input[str] slot_type_id: Unique identifier for the slot type associated with this slot.
        :param pulumi.Input[Sequence[pulumi.Input[Union['V2modelsSlotSubSlotSettingArgs', 'V2modelsSlotSubSlotSettingArgsDict']]]] sub_slot_settings: Specifications for the constituent sub slots and the expression for the composite slot.
               See the `sub_slot_setting` argument reference below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V2modelsSlotState.__new__(_V2modelsSlotState)

        __props__.__dict__["bot_id"] = bot_id
        __props__.__dict__["bot_version"] = bot_version
        __props__.__dict__["description"] = description
        __props__.__dict__["intent_id"] = intent_id
        __props__.__dict__["locale_id"] = locale_id
        __props__.__dict__["multiple_values_settings"] = multiple_values_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["obfuscation_settings"] = obfuscation_settings
        __props__.__dict__["slot_id"] = slot_id
        __props__.__dict__["slot_type_id"] = slot_type_id
        __props__.__dict__["sub_slot_settings"] = sub_slot_settings
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["value_elicitation_setting"] = value_elicitation_setting
        return V2modelsSlot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="botId")
    def bot_id(self) -> pulumi.Output[str]:
        """
        Identifier of the bot associated with the slot.
        """
        return pulumi.get(self, "bot_id")

    @property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> pulumi.Output[str]:
        """
        Version of the bot associated with the slot.
        """
        return pulumi.get(self, "bot_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the slot.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="intentId")
    def intent_id(self) -> pulumi.Output[str]:
        """
        Identifier of the intent that contains the slot.
        """
        return pulumi.get(self, "intent_id")

    @property
    @pulumi.getter(name="localeId")
    def locale_id(self) -> pulumi.Output[str]:
        """
        Identifier of the language and locale that the slot will be used in.
        """
        return pulumi.get(self, "locale_id")

    @property
    @pulumi.getter(name="multipleValuesSettings")
    def multiple_values_settings(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsSlotMultipleValuesSetting']]]:
        """
        Whether the slot returns multiple values in one response.
        See the `multiple_values_setting` argument reference below.
        """
        return pulumi.get(self, "multiple_values_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the slot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="obfuscationSettings")
    def obfuscation_settings(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsSlotObfuscationSetting']]]:
        """
        Determines how slot values are used in Amazon CloudWatch logs.
        See the `obfuscation_setting` argument reference below.
        """
        return pulumi.get(self, "obfuscation_settings")

    @property
    @pulumi.getter(name="slotId")
    def slot_id(self) -> pulumi.Output[str]:
        """
        Unique identifier associated with the slot.
        """
        return pulumi.get(self, "slot_id")

    @property
    @pulumi.getter(name="slotTypeId")
    def slot_type_id(self) -> pulumi.Output[str]:
        """
        Unique identifier for the slot type associated with this slot.
        """
        return pulumi.get(self, "slot_type_id")

    @property
    @pulumi.getter(name="subSlotSettings")
    def sub_slot_settings(self) -> pulumi.Output[Optional[Sequence['outputs.V2modelsSlotSubSlotSetting']]]:
        """
        Specifications for the constituent sub slots and the expression for the composite slot.
        See the `sub_slot_setting` argument reference below.
        """
        return pulumi.get(self, "sub_slot_settings")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.V2modelsSlotTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="valueElicitationSetting")
    def value_elicitation_setting(self) -> pulumi.Output[Optional['outputs.V2modelsSlotValueElicitationSetting']]:
        return pulumi.get(self, "value_elicitation_setting")

