# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 blueprint_id: pulumi.Input[str],
                 bundle_id: pulumi.Input[str],
                 master_database_name: pulumi.Input[str],
                 master_password: pulumi.Input[str],
                 master_username: pulumi.Input[str],
                 relational_database_name: pulumi.Input[str],
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_enabled: Optional[pulumi.Input[bool]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[str] blueprint_id: The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
        :param pulumi.Input[str] bundle_id: The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
        :param pulumi.Input[str] master_database_name: The name of the master database created when the Lightsail database resource is created.
        :param pulumi.Input[str] master_password: The password for the master user of your new database. The password can include any printable ASCII character except "/", \"\"\", or "@".
        :param pulumi.Input[str] master_username: The master user name for your new database.
        :param pulumi.Input[str] relational_database_name: The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input[bool] apply_immediately: When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
        :param pulumi.Input[str] availability_zone: The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
        :param pulumi.Input[bool] backup_retention_enabled: When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
        :param pulumi.Input[str] final_snapshot_name: The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
        :param pulumi.Input[str] preferred_backup_window: The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
        :param pulumi.Input[bool] publicly_accessible: Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
        """
        pulumi.set(__self__, "blueprint_id", blueprint_id)
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "master_database_name", master_database_name)
        pulumi.set(__self__, "master_password", master_password)
        pulumi.set(__self__, "master_username", master_username)
        pulumi.set(__self__, "relational_database_name", relational_database_name)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_enabled is not None:
            pulumi.set(__self__, "backup_retention_enabled", backup_retention_enabled)
        if final_snapshot_name is not None:
            pulumi.set(__self__, "final_snapshot_name", final_snapshot_name)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="blueprintId")
    def blueprint_id(self) -> pulumi.Input[str]:
        """
        The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
        """
        return pulumi.get(self, "blueprint_id")

    @blueprint_id.setter
    def blueprint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "blueprint_id", value)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Input[str]:
        """
        The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="masterDatabaseName")
    def master_database_name(self) -> pulumi.Input[str]:
        """
        The name of the master database created when the Lightsail database resource is created.
        """
        return pulumi.get(self, "master_database_name")

    @master_database_name.setter
    def master_database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_database_name", value)

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> pulumi.Input[str]:
        """
        The password for the master user of your new database. The password can include any printable ASCII character except "/", \"\"\", or "@".
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Input[str]:
        """
        The master user name for your new database.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="relationalDatabaseName")
    def relational_database_name(self) -> pulumi.Input[str]:
        """
        The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
        """
        return pulumi.get(self, "relational_database_name")

    @relational_database_name.setter
    def relational_database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "relational_database_name", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupRetentionEnabled")
    def backup_retention_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
        """
        return pulumi.get(self, "backup_retention_enabled")

    @backup_retention_enabled.setter
    def backup_retention_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_retention_enabled", value)

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
        """
        return pulumi.get(self, "final_snapshot_name")

    @final_snapshot_name.setter
    def final_snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_name", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_enabled: Optional[pulumi.Input[bool]] = None,
                 blueprint_id: Optional[pulumi.Input[str]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 ca_certificate_identifier: Optional[pulumi.Input[str]] = None,
                 cpu_count: Optional[pulumi.Input[int]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[float]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 master_database_name: Optional[pulumi.Input[str]] = None,
                 master_endpoint_address: Optional[pulumi.Input[str]] = None,
                 master_endpoint_port: Optional[pulumi.Input[int]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 ram_size: Optional[pulumi.Input[float]] = None,
                 relational_database_name: Optional[pulumi.Input[str]] = None,
                 secondary_availability_zone: Optional[pulumi.Input[str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 support_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[bool] apply_immediately: When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
        :param pulumi.Input[str] arn: The ARN of the Lightsail instance (matches `id`).
        :param pulumi.Input[str] availability_zone: The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
        :param pulumi.Input[bool] backup_retention_enabled: When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
        :param pulumi.Input[str] blueprint_id: The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
        :param pulumi.Input[str] bundle_id: The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
        :param pulumi.Input[str] ca_certificate_identifier: The certificate associated with the database.
        :param pulumi.Input[int] cpu_count: The number of vCPUs for the database.
        :param pulumi.Input[str] created_at: The timestamp when the instance was created.
        :param pulumi.Input[float] disk_size: The size of the disk for the database.
        :param pulumi.Input[str] engine: The database software (for example, MySQL).
        :param pulumi.Input[str] engine_version: The database engine version (for example, 5.7.23).
        :param pulumi.Input[str] final_snapshot_name: The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
        :param pulumi.Input[str] master_database_name: The name of the master database created when the Lightsail database resource is created.
        :param pulumi.Input[str] master_endpoint_address: The master endpoint fqdn for the database.
        :param pulumi.Input[int] master_endpoint_port: The master endpoint network port for the database.
        :param pulumi.Input[str] master_password: The password for the master user of your new database. The password can include any printable ASCII character except "/", \"\"\", or "@".
        :param pulumi.Input[str] master_username: The master user name for your new database.
        :param pulumi.Input[str] preferred_backup_window: The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
        :param pulumi.Input[bool] publicly_accessible: Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
        :param pulumi.Input[float] ram_size: The amount of RAM in GB for the database.
        :param pulumi.Input[str] relational_database_name: The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input[str] secondary_availability_zone: Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
        :param pulumi.Input[str] support_code: The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_retention_enabled is not None:
            pulumi.set(__self__, "backup_retention_enabled", backup_retention_enabled)
        if blueprint_id is not None:
            pulumi.set(__self__, "blueprint_id", blueprint_id)
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if ca_certificate_identifier is not None:
            pulumi.set(__self__, "ca_certificate_identifier", ca_certificate_identifier)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if final_snapshot_name is not None:
            pulumi.set(__self__, "final_snapshot_name", final_snapshot_name)
        if master_database_name is not None:
            pulumi.set(__self__, "master_database_name", master_database_name)
        if master_endpoint_address is not None:
            pulumi.set(__self__, "master_endpoint_address", master_endpoint_address)
        if master_endpoint_port is not None:
            pulumi.set(__self__, "master_endpoint_port", master_endpoint_port)
        if master_password is not None:
            pulumi.set(__self__, "master_password", master_password)
        if master_username is not None:
            pulumi.set(__self__, "master_username", master_username)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if ram_size is not None:
            pulumi.set(__self__, "ram_size", ram_size)
        if relational_database_name is not None:
            pulumi.set(__self__, "relational_database_name", relational_database_name)
        if secondary_availability_zone is not None:
            pulumi.set(__self__, "secondary_availability_zone", secondary_availability_zone)
        if skip_final_snapshot is not None:
            pulumi.set(__self__, "skip_final_snapshot", skip_final_snapshot)
        if support_code is not None:
            pulumi.set(__self__, "support_code", support_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Lightsail instance (matches `id`).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupRetentionEnabled")
    def backup_retention_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
        """
        return pulumi.get(self, "backup_retention_enabled")

    @backup_retention_enabled.setter
    def backup_retention_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_retention_enabled", value)

    @property
    @pulumi.getter(name="blueprintId")
    def blueprint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
        """
        return pulumi.get(self, "blueprint_id")

    @blueprint_id.setter
    def blueprint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blueprint_id", value)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="caCertificateIdentifier")
    def ca_certificate_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate associated with the database.
        """
        return pulumi.get(self, "ca_certificate_identifier")

    @ca_certificate_identifier.setter
    def ca_certificate_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_identifier", value)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of vCPUs for the database.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_count", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the instance was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[float]]:
        """
        The size of the disk for the database.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The database software (for example, MySQL).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine version (for example, 5.7.23).
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
        """
        return pulumi.get(self, "final_snapshot_name")

    @final_snapshot_name.setter
    def final_snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "final_snapshot_name", value)

    @property
    @pulumi.getter(name="masterDatabaseName")
    def master_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the master database created when the Lightsail database resource is created.
        """
        return pulumi.get(self, "master_database_name")

    @master_database_name.setter
    def master_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_database_name", value)

    @property
    @pulumi.getter(name="masterEndpointAddress")
    def master_endpoint_address(self) -> Optional[pulumi.Input[str]]:
        """
        The master endpoint fqdn for the database.
        """
        return pulumi.get(self, "master_endpoint_address")

    @master_endpoint_address.setter
    def master_endpoint_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_endpoint_address", value)

    @property
    @pulumi.getter(name="masterEndpointPort")
    def master_endpoint_port(self) -> Optional[pulumi.Input[int]]:
        """
        The master endpoint network port for the database.
        """
        return pulumi.get(self, "master_endpoint_port")

    @master_endpoint_port.setter
    def master_endpoint_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "master_endpoint_port", value)

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the master user of your new database. The password can include any printable ASCII character except "/", \"\"\", or "@".
        """
        return pulumi.get(self, "master_password")

    @master_password.setter
    def master_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_password", value)

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> Optional[pulumi.Input[str]]:
        """
        The master user name for your new database.
        """
        return pulumi.get(self, "master_username")

    @master_username.setter
    def master_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_username", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="ramSize")
    def ram_size(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of RAM in GB for the database.
        """
        return pulumi.get(self, "ram_size")

    @ram_size.setter
    def ram_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ram_size", value)

    @property
    @pulumi.getter(name="relationalDatabaseName")
    def relational_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
        """
        return pulumi.get(self, "relational_database_name")

    @relational_database_name.setter
    def relational_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relational_database_name", value)

    @property
    @pulumi.getter(name="secondaryAvailabilityZone")
    def secondary_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
        """
        return pulumi.get(self, "secondary_availability_zone")

    @secondary_availability_zone.setter
    def secondary_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_availability_zone", value)

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @skip_final_snapshot.setter
    def skip_final_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_final_snapshot", value)

    @property
    @pulumi.getter(name="supportCode")
    def support_code(self) -> Optional[pulumi.Input[str]]:
        """
        The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
        """
        return pulumi.get(self, "support_code")

    @support_code.setter
    def support_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_code", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_enabled: Optional[pulumi.Input[bool]] = None,
                 blueprint_id: Optional[pulumi.Input[str]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 master_database_name: Optional[pulumi.Input[str]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 relational_database_name: Optional[pulumi.Input[str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Lightsail Database. Amazon Lightsail is a service to provide easy virtual private servers
        with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
        for more information.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones"](https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/) for more details

        ## Example Usage

        ### Basic mysql blueprint

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="mysql_8_0",
            bundle_id="micro_1_0")
        ```

        ### Basic postrgres blueprint

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0")
        ```

        ### Custom backup and maintenance windows

        Below is an example that sets a custom backup and maintenance window. Times are specified in UTC. This example will allow daily backups to take place between 16:00 and 16:30 each day. This example also requires any maintiance tasks (anything that would cause an outage, including changing some attributes) to take place on Tuesdays between 17:00 and 17:30. An action taken against this database that would cause an outage will wait until this time window to make the requested changes.

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0",
            preferred_backup_window="16:00-16:30",
            preferred_maintenance_window="Tue:17:00-Tue:17:30")
        ```

        ### Final Snapshots

        To enable creating a final snapshot of your database on deletion, use the `final_snapshot_name` argument to provide a name to be used for the snapshot.

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0",
            preferred_backup_window="16:00-16:30",
            preferred_maintenance_window="Tue:17:00-Tue:17:30",
            final_snapshot_name="MyFinalSnapshot")
        ```

        ### Apply Immediately

        To enable applying changes immediately instead of waiting for a maintiance window, use the `apply_immediately` argument.

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0",
            apply_immediately=True)
        ```

        ## Blueprint Ids

        A list of all available Lightsail Blueprints for Relational Databases the [aws lightsail get-relational-database-blueprints](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-blueprints.html) aws cli command.

        ### Examples

        - `mysql_8_0`
        - `postgres_12`

        ### Prefix

        A Blueprint ID starts with a prefix of the engine type.

        ### Suffix

        A Blueprint ID has a sufix of the engine version.

        ## Bundles

        A list of all available Lightsail Bundles for Relational Databases the [aws lightsail get-relational-database-bundles](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-bundles.html) aws cli command.

        ### Examples

        - `small_1_0`
        - `small_ha_1_0`
        - `large_1_0`
        - `large_ha_1_0`

        ### Prefix

        A Bundle ID starts with one of the below size prefixes:

        - `micro_`
        - `small_`
        - `medium_`
        - `large_`

        ### Infixes (Optional for HA Database)

        A Bundle Id can have the following infix added in order to use the HA option of the selected bundle.

        - `ha_`

        ### Suffix

        A Bundle ID ends with one of the following suffix: `1_0`

        ## Import

        Using `pulumi import`, import Lightsail Databases using their name. For example:

        ```sh
        $ pulumi import aws:lightsail/database:Database foo 'bar'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_immediately: When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
        :param pulumi.Input[str] availability_zone: The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
        :param pulumi.Input[bool] backup_retention_enabled: When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
        :param pulumi.Input[str] blueprint_id: The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
        :param pulumi.Input[str] bundle_id: The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
        :param pulumi.Input[str] final_snapshot_name: The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
        :param pulumi.Input[str] master_database_name: The name of the master database created when the Lightsail database resource is created.
        :param pulumi.Input[str] master_password: The password for the master user of your new database. The password can include any printable ASCII character except "/", \"\"\", or "@".
        :param pulumi.Input[str] master_username: The master user name for your new database.
        :param pulumi.Input[str] preferred_backup_window: The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
        :param pulumi.Input[bool] publicly_accessible: Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
        :param pulumi.Input[str] relational_database_name: The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Lightsail Database. Amazon Lightsail is a service to provide easy virtual private servers
        with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
        for more information.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones"](https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/) for more details

        ## Example Usage

        ### Basic mysql blueprint

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="mysql_8_0",
            bundle_id="micro_1_0")
        ```

        ### Basic postrgres blueprint

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0")
        ```

        ### Custom backup and maintenance windows

        Below is an example that sets a custom backup and maintenance window. Times are specified in UTC. This example will allow daily backups to take place between 16:00 and 16:30 each day. This example also requires any maintiance tasks (anything that would cause an outage, including changing some attributes) to take place on Tuesdays between 17:00 and 17:30. An action taken against this database that would cause an outage will wait until this time window to make the requested changes.

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0",
            preferred_backup_window="16:00-16:30",
            preferred_maintenance_window="Tue:17:00-Tue:17:30")
        ```

        ### Final Snapshots

        To enable creating a final snapshot of your database on deletion, use the `final_snapshot_name` argument to provide a name to be used for the snapshot.

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0",
            preferred_backup_window="16:00-16:30",
            preferred_maintenance_window="Tue:17:00-Tue:17:30",
            final_snapshot_name="MyFinalSnapshot")
        ```

        ### Apply Immediately

        To enable applying changes immediately instead of waiting for a maintiance window, use the `apply_immediately` argument.

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.lightsail.Database("test",
            relational_database_name="test",
            availability_zone="us-east-1a",
            master_database_name="testdatabasename",
            master_password="testdatabasepassword",
            master_username="test",
            blueprint_id="postgres_12",
            bundle_id="micro_1_0",
            apply_immediately=True)
        ```

        ## Blueprint Ids

        A list of all available Lightsail Blueprints for Relational Databases the [aws lightsail get-relational-database-blueprints](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-blueprints.html) aws cli command.

        ### Examples

        - `mysql_8_0`
        - `postgres_12`

        ### Prefix

        A Blueprint ID starts with a prefix of the engine type.

        ### Suffix

        A Blueprint ID has a sufix of the engine version.

        ## Bundles

        A list of all available Lightsail Bundles for Relational Databases the [aws lightsail get-relational-database-bundles](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-bundles.html) aws cli command.

        ### Examples

        - `small_1_0`
        - `small_ha_1_0`
        - `large_1_0`
        - `large_ha_1_0`

        ### Prefix

        A Bundle ID starts with one of the below size prefixes:

        - `micro_`
        - `small_`
        - `medium_`
        - `large_`

        ### Infixes (Optional for HA Database)

        A Bundle Id can have the following infix added in order to use the HA option of the selected bundle.

        - `ha_`

        ### Suffix

        A Bundle ID ends with one of the following suffix: `1_0`

        ## Import

        Using `pulumi import`, import Lightsail Databases using their name. For example:

        ```sh
        $ pulumi import aws:lightsail/database:Database foo 'bar'
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_retention_enabled: Optional[pulumi.Input[bool]] = None,
                 blueprint_id: Optional[pulumi.Input[str]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 final_snapshot_name: Optional[pulumi.Input[str]] = None,
                 master_database_name: Optional[pulumi.Input[str]] = None,
                 master_password: Optional[pulumi.Input[str]] = None,
                 master_username: Optional[pulumi.Input[str]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 relational_database_name: Optional[pulumi.Input[str]] = None,
                 skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_retention_enabled"] = backup_retention_enabled
            if blueprint_id is None and not opts.urn:
                raise TypeError("Missing required property 'blueprint_id'")
            __props__.__dict__["blueprint_id"] = blueprint_id
            if bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'bundle_id'")
            __props__.__dict__["bundle_id"] = bundle_id
            __props__.__dict__["final_snapshot_name"] = final_snapshot_name
            if master_database_name is None and not opts.urn:
                raise TypeError("Missing required property 'master_database_name'")
            __props__.__dict__["master_database_name"] = master_database_name
            if master_password is None and not opts.urn:
                raise TypeError("Missing required property 'master_password'")
            __props__.__dict__["master_password"] = None if master_password is None else pulumi.Output.secret(master_password)
            if master_username is None and not opts.urn:
                raise TypeError("Missing required property 'master_username'")
            __props__.__dict__["master_username"] = master_username
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            if relational_database_name is None and not opts.urn:
                raise TypeError("Missing required property 'relational_database_name'")
            __props__.__dict__["relational_database_name"] = relational_database_name
            __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["ca_certificate_identifier"] = None
            __props__.__dict__["cpu_count"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk_size"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["engine_version"] = None
            __props__.__dict__["master_endpoint_address"] = None
            __props__.__dict__["master_endpoint_port"] = None
            __props__.__dict__["ram_size"] = None
            __props__.__dict__["secondary_availability_zone"] = None
            __props__.__dict__["support_code"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["masterPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Database, __self__).__init__(
            'aws:lightsail/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_immediately: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_retention_enabled: Optional[pulumi.Input[bool]] = None,
            blueprint_id: Optional[pulumi.Input[str]] = None,
            bundle_id: Optional[pulumi.Input[str]] = None,
            ca_certificate_identifier: Optional[pulumi.Input[str]] = None,
            cpu_count: Optional[pulumi.Input[int]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            disk_size: Optional[pulumi.Input[float]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            final_snapshot_name: Optional[pulumi.Input[str]] = None,
            master_database_name: Optional[pulumi.Input[str]] = None,
            master_endpoint_address: Optional[pulumi.Input[str]] = None,
            master_endpoint_port: Optional[pulumi.Input[int]] = None,
            master_password: Optional[pulumi.Input[str]] = None,
            master_username: Optional[pulumi.Input[str]] = None,
            preferred_backup_window: Optional[pulumi.Input[str]] = None,
            preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
            publicly_accessible: Optional[pulumi.Input[bool]] = None,
            ram_size: Optional[pulumi.Input[float]] = None,
            relational_database_name: Optional[pulumi.Input[str]] = None,
            secondary_availability_zone: Optional[pulumi.Input[str]] = None,
            skip_final_snapshot: Optional[pulumi.Input[bool]] = None,
            support_code: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_immediately: When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
        :param pulumi.Input[str] arn: The ARN of the Lightsail instance (matches `id`).
        :param pulumi.Input[str] availability_zone: The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
        :param pulumi.Input[bool] backup_retention_enabled: When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
        :param pulumi.Input[str] blueprint_id: The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
        :param pulumi.Input[str] bundle_id: The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
        :param pulumi.Input[str] ca_certificate_identifier: The certificate associated with the database.
        :param pulumi.Input[int] cpu_count: The number of vCPUs for the database.
        :param pulumi.Input[str] created_at: The timestamp when the instance was created.
        :param pulumi.Input[float] disk_size: The size of the disk for the database.
        :param pulumi.Input[str] engine: The database software (for example, MySQL).
        :param pulumi.Input[str] engine_version: The database engine version (for example, 5.7.23).
        :param pulumi.Input[str] final_snapshot_name: The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
        :param pulumi.Input[str] master_database_name: The name of the master database created when the Lightsail database resource is created.
        :param pulumi.Input[str] master_endpoint_address: The master endpoint fqdn for the database.
        :param pulumi.Input[int] master_endpoint_port: The master endpoint network port for the database.
        :param pulumi.Input[str] master_password: The password for the master user of your new database. The password can include any printable ASCII character except "/", \"\"\", or "@".
        :param pulumi.Input[str] master_username: The master user name for your new database.
        :param pulumi.Input[str] preferred_backup_window: The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
        :param pulumi.Input[bool] publicly_accessible: Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
        :param pulumi.Input[float] ram_size: The amount of RAM in GB for the database.
        :param pulumi.Input[str] relational_database_name: The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
        :param pulumi.Input[str] secondary_availability_zone: Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
        :param pulumi.Input[bool] skip_final_snapshot: Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
        :param pulumi.Input[str] support_code: The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_retention_enabled"] = backup_retention_enabled
        __props__.__dict__["blueprint_id"] = blueprint_id
        __props__.__dict__["bundle_id"] = bundle_id
        __props__.__dict__["ca_certificate_identifier"] = ca_certificate_identifier
        __props__.__dict__["cpu_count"] = cpu_count
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["disk_size"] = disk_size
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["final_snapshot_name"] = final_snapshot_name
        __props__.__dict__["master_database_name"] = master_database_name
        __props__.__dict__["master_endpoint_address"] = master_endpoint_address
        __props__.__dict__["master_endpoint_port"] = master_endpoint_port
        __props__.__dict__["master_password"] = master_password
        __props__.__dict__["master_username"] = master_username
        __props__.__dict__["preferred_backup_window"] = preferred_backup_window
        __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["ram_size"] = ram_size
        __props__.__dict__["relational_database_name"] = relational_database_name
        __props__.__dict__["secondary_availability_zone"] = secondary_availability_zone
        __props__.__dict__["skip_final_snapshot"] = skip_final_snapshot
        __props__.__dict__["support_code"] = support_code
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[bool]:
        """
        When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
        """
        return pulumi.get(self, "apply_immediately")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the Lightsail instance (matches `id`).
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupRetentionEnabled")
    def backup_retention_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
        """
        return pulumi.get(self, "backup_retention_enabled")

    @property
    @pulumi.getter(name="blueprintId")
    def blueprint_id(self) -> pulumi.Output[str]:
        """
        The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
        """
        return pulumi.get(self, "blueprint_id")

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[str]:
        """
        The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="caCertificateIdentifier")
    def ca_certificate_identifier(self) -> pulumi.Output[str]:
        """
        The certificate associated with the database.
        """
        return pulumi.get(self, "ca_certificate_identifier")

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Output[int]:
        """
        The number of vCPUs for the database.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The timestamp when the instance was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[float]:
        """
        The size of the disk for the database.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        The database software (for example, MySQL).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The database engine version (for example, 5.7.23).
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="finalSnapshotName")
    def final_snapshot_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
        """
        return pulumi.get(self, "final_snapshot_name")

    @property
    @pulumi.getter(name="masterDatabaseName")
    def master_database_name(self) -> pulumi.Output[str]:
        """
        The name of the master database created when the Lightsail database resource is created.
        """
        return pulumi.get(self, "master_database_name")

    @property
    @pulumi.getter(name="masterEndpointAddress")
    def master_endpoint_address(self) -> pulumi.Output[str]:
        """
        The master endpoint fqdn for the database.
        """
        return pulumi.get(self, "master_endpoint_address")

    @property
    @pulumi.getter(name="masterEndpointPort")
    def master_endpoint_port(self) -> pulumi.Output[int]:
        """
        The master endpoint network port for the database.
        """
        return pulumi.get(self, "master_endpoint_port")

    @property
    @pulumi.getter(name="masterPassword")
    def master_password(self) -> pulumi.Output[str]:
        """
        The password for the master user of your new database. The password can include any printable ASCII character except "/", \"\"\", or "@".
        """
        return pulumi.get(self, "master_password")

    @property
    @pulumi.getter(name="masterUsername")
    def master_username(self) -> pulumi.Output[str]:
        """
        The master user name for your new database.
        """
        return pulumi.get(self, "master_username")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[str]:
        """
        The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[str]:
        """
        The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="ramSize")
    def ram_size(self) -> pulumi.Output[float]:
        """
        The amount of RAM in GB for the database.
        """
        return pulumi.get(self, "ram_size")

    @property
    @pulumi.getter(name="relationalDatabaseName")
    def relational_database_name(self) -> pulumi.Output[str]:
        """
        The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
        """
        return pulumi.get(self, "relational_database_name")

    @property
    @pulumi.getter(name="secondaryAvailabilityZone")
    def secondary_availability_zone(self) -> pulumi.Output[str]:
        """
        Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
        """
        return pulumi.get(self, "secondary_availability_zone")

    @property
    @pulumi.getter(name="skipFinalSnapshot")
    def skip_final_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
        """
        return pulumi.get(self, "skip_final_snapshot")

    @property
    @pulumi.getter(name="supportCode")
    def support_code(self) -> pulumi.Output[str]:
        """
        The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
        """
        return pulumi.get(self, "support_code")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

