# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CertificateDomainValidationOption',
    'ContainerServiceDeploymentVersionContainer',
    'ContainerServiceDeploymentVersionPublicEndpoint',
    'ContainerServiceDeploymentVersionPublicEndpointHealthCheck',
    'ContainerServicePrivateRegistryAccess',
    'ContainerServicePrivateRegistryAccessEcrImagePullerRole',
    'ContainerServicePublicDomainNames',
    'ContainerServicePublicDomainNamesCertificate',
    'DistributionCacheBehavior',
    'DistributionCacheBehaviorSettings',
    'DistributionCacheBehaviorSettingsForwardedCookies',
    'DistributionCacheBehaviorSettingsForwardedHeaders',
    'DistributionCacheBehaviorSettingsForwardedQueryStrings',
    'DistributionDefaultCacheBehavior',
    'DistributionLocation',
    'DistributionOrigin',
    'InstanceAddOn',
    'InstancePublicPortsPortInfo',
    'LbCertificateDomainValidationRecord',
]

@pulumi.output_type
class CertificateDomainValidationOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "resourceRecordName":
            suggest = "resource_record_name"
        elif key == "resourceRecordType":
            suggest = "resource_record_type"
        elif key == "resourceRecordValue":
            suggest = "resource_record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDomainValidationOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDomainValidationOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDomainValidationOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 resource_record_name: Optional[str] = None,
                 resource_record_type: Optional[str] = None,
                 resource_record_value: Optional[str] = None):
        """
        :param str domain_name: A domain name for which the certificate should be issued.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if resource_record_name is not None:
            pulumi.set(__self__, "resource_record_name", resource_record_name)
        if resource_record_type is not None:
            pulumi.set(__self__, "resource_record_type", resource_record_type)
        if resource_record_value is not None:
            pulumi.set(__self__, "resource_record_value", resource_record_value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        A domain name for which the certificate should be issued.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="resourceRecordName")
    def resource_record_name(self) -> Optional[str]:
        return pulumi.get(self, "resource_record_name")

    @property
    @pulumi.getter(name="resourceRecordType")
    def resource_record_type(self) -> Optional[str]:
        return pulumi.get(self, "resource_record_type")

    @property
    @pulumi.getter(name="resourceRecordValue")
    def resource_record_value(self) -> Optional[str]:
        return pulumi.get(self, "resource_record_value")


@pulumi.output_type
class ContainerServiceDeploymentVersionContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeploymentVersionContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeploymentVersionContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeploymentVersionContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 image: str,
                 commands: Optional[Sequence[str]] = None,
                 environment: Optional[Mapping[str, str]] = None,
                 ports: Optional[Mapping[str, str]] = None):
        """
        :param str container_name: The name for the container.
        :param str image: The name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
        :param Sequence[str] commands: The launch command for the container. A list of string.
        :param Mapping[str, str] environment: A key-value map of the environment variables of the container.
        :param Mapping[str, str] ports: A key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image", image)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        The name for the container.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The name of the image used for the container. Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (`:`). For example, `:container-service-1.mystaticwebsite.1`. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, `nginx:latest` or `nginx`.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        The launch command for the container. A list of string.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Mapping[str, str]]:
        """
        A key-value map of the environment variables of the container.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Mapping[str, str]]:
        """
        A key-value map of the open firewall ports of the container. Valid values: `HTTP`, `HTTPS`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ContainerServiceDeploymentVersionPublicEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "healthCheck":
            suggest = "health_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeploymentVersionPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeploymentVersionPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeploymentVersionPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 container_port: int,
                 health_check: 'outputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheck'):
        """
        :param str container_name: The name of the container for the endpoint.
        :param int container_port: The port of the container to which traffic is forwarded to.
        :param 'ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs' health_check: A configuration block that describes the health check configuration of the container. Detailed below.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "health_check", health_check)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        The name of the container for the endpoint.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        The port of the container to which traffic is forwarded to.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> 'outputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheck':
        """
        A configuration block that describes the health check configuration of the container. Detailed below.
        """
        return pulumi.get(self, "health_check")


@pulumi.output_type
class ContainerServiceDeploymentVersionPublicEndpointHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "successCodes":
            suggest = "success_codes"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeploymentVersionPublicEndpointHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeploymentVersionPublicEndpointHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeploymentVersionPublicEndpointHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 healthy_threshold: Optional[int] = None,
                 interval_seconds: Optional[int] = None,
                 path: Optional[str] = None,
                 success_codes: Optional[str] = None,
                 timeout_seconds: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        :param int healthy_threshold: The number of consecutive health checks successes required before moving the container to the Healthy state. Defaults to 2.
        :param int interval_seconds: The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
        :param str path: The path on the container on which to perform the health check. Defaults to "/".
        :param str success_codes: The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
        :param int timeout_seconds: The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
        :param int unhealthy_threshold: The number of consecutive health checks failures required before moving the container to the Unhealthy state. Defaults to 2.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_codes is not None:
            pulumi.set(__self__, "success_codes", success_codes)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[int]:
        """
        The number of consecutive health checks successes required before moving the container to the Healthy state. Defaults to 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[int]:
        """
        The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. Defaults to 5.
        """
        return pulumi.get(self, "interval_seconds")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path on the container on which to perform the health check. Defaults to "/".
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="successCodes")
    def success_codes(self) -> Optional[str]:
        """
        The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. Defaults to "200-499".
        """
        return pulumi.get(self, "success_codes")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. Defaults to 2.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The number of consecutive health checks failures required before moving the container to the Unhealthy state. Defaults to 2.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ContainerServicePrivateRegistryAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ecrImagePullerRole":
            suggest = "ecr_image_puller_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServicePrivateRegistryAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServicePrivateRegistryAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServicePrivateRegistryAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ecr_image_puller_role: Optional['outputs.ContainerServicePrivateRegistryAccessEcrImagePullerRole'] = None):
        """
        :param 'ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs' ecr_image_puller_role: Describes a request to configure an Amazon Lightsail container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See ECR Image Puller Role below for more details.
        """
        if ecr_image_puller_role is not None:
            pulumi.set(__self__, "ecr_image_puller_role", ecr_image_puller_role)

    @property
    @pulumi.getter(name="ecrImagePullerRole")
    def ecr_image_puller_role(self) -> Optional['outputs.ContainerServicePrivateRegistryAccessEcrImagePullerRole']:
        """
        Describes a request to configure an Amazon Lightsail container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See ECR Image Puller Role below for more details.
        """
        return pulumi.get(self, "ecr_image_puller_role")


@pulumi.output_type
class ContainerServicePrivateRegistryAccessEcrImagePullerRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isActive":
            suggest = "is_active"
        elif key == "principalArn":
            suggest = "principal_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServicePrivateRegistryAccessEcrImagePullerRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServicePrivateRegistryAccessEcrImagePullerRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServicePrivateRegistryAccessEcrImagePullerRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_active: Optional[bool] = None,
                 principal_arn: Optional[str] = None):
        """
        :param bool is_active: A Boolean value that indicates whether to activate the role. The default is `false`.
        :param str principal_arn: The principal ARN of the container service. The principal ARN can be used to create a trust
               relationship between your standard AWS account and your Lightsail container service. This allows you to give your
               service permission to access resources in your standard AWS account.
        """
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if principal_arn is not None:
            pulumi.set(__self__, "principal_arn", principal_arn)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[bool]:
        """
        A Boolean value that indicates whether to activate the role. The default is `false`.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> Optional[str]:
        """
        The principal ARN of the container service. The principal ARN can be used to create a trust
        relationship between your standard AWS account and your Lightsail container service. This allows you to give your
        service permission to access resources in your standard AWS account.
        """
        return pulumi.get(self, "principal_arn")


@pulumi.output_type
class ContainerServicePublicDomainNames(dict):
    def __init__(__self__, *,
                 certificates: Sequence['outputs.ContainerServicePublicDomainNamesCertificate']):
        pulumi.set(__self__, "certificates", certificates)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.ContainerServicePublicDomainNamesCertificate']:
        return pulumi.get(self, "certificates")


@pulumi.output_type
class ContainerServicePublicDomainNamesCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateName":
            suggest = "certificate_name"
        elif key == "domainNames":
            suggest = "domain_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServicePublicDomainNamesCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServicePublicDomainNamesCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServicePublicDomainNamesCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_name: str,
                 domain_names: Sequence[str]):
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "domain_names", domain_names)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> str:
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Sequence[str]:
        return pulumi.get(self, "domain_names")


@pulumi.output_type
class DistributionCacheBehavior(dict):
    def __init__(__self__, *,
                 behavior: str,
                 path: str):
        """
        :param str behavior: The cache behavior for the specified path.
        :param str path: The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/\\*), and file types (\\*.html, \\*jpg, \\*js). Directories and file paths are case-sensitive.
        """
        pulumi.set(__self__, "behavior", behavior)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def behavior(self) -> str:
        """
        The cache behavior for the specified path.
        """
        return pulumi.get(self, "behavior")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/\\*), and file types (\\*.html, \\*jpg, \\*js). Directories and file paths are case-sensitive.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DistributionCacheBehaviorSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHttpMethods":
            suggest = "allowed_http_methods"
        elif key == "cachedHttpMethods":
            suggest = "cached_http_methods"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "forwardedCookies":
            suggest = "forwarded_cookies"
        elif key == "forwardedHeaders":
            suggest = "forwarded_headers"
        elif key == "forwardedQueryStrings":
            suggest = "forwarded_query_strings"
        elif key == "maximumTtl":
            suggest = "maximum_ttl"
        elif key == "minimumTtl":
            suggest = "minimum_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_http_methods: Optional[str] = None,
                 cached_http_methods: Optional[str] = None,
                 default_ttl: Optional[int] = None,
                 forwarded_cookies: Optional['outputs.DistributionCacheBehaviorSettingsForwardedCookies'] = None,
                 forwarded_headers: Optional['outputs.DistributionCacheBehaviorSettingsForwardedHeaders'] = None,
                 forwarded_query_strings: Optional['outputs.DistributionCacheBehaviorSettingsForwardedQueryStrings'] = None,
                 maximum_ttl: Optional[int] = None,
                 minimum_ttl: Optional[int] = None):
        """
        :param str allowed_http_methods: The HTTP methods that are processed and forwarded to the distribution's origin.
        :param str cached_http_methods: The HTTP method responses that are cached by your distribution.
        :param int default_ttl: The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
        :param 'DistributionCacheBehaviorSettingsForwardedCookiesArgs' forwarded_cookies: An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. Detailed below
        :param 'DistributionCacheBehaviorSettingsForwardedHeadersArgs' forwarded_headers: An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. Detailed below
        :param 'DistributionCacheBehaviorSettingsForwardedQueryStringsArgs' forwarded_query_strings: An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. Detailed below
        :param int maximum_ttl: The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        :param int minimum_ttl: The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        if allowed_http_methods is not None:
            pulumi.set(__self__, "allowed_http_methods", allowed_http_methods)
        if cached_http_methods is not None:
            pulumi.set(__self__, "cached_http_methods", cached_http_methods)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if forwarded_cookies is not None:
            pulumi.set(__self__, "forwarded_cookies", forwarded_cookies)
        if forwarded_headers is not None:
            pulumi.set(__self__, "forwarded_headers", forwarded_headers)
        if forwarded_query_strings is not None:
            pulumi.set(__self__, "forwarded_query_strings", forwarded_query_strings)
        if maximum_ttl is not None:
            pulumi.set(__self__, "maximum_ttl", maximum_ttl)
        if minimum_ttl is not None:
            pulumi.set(__self__, "minimum_ttl", minimum_ttl)

    @property
    @pulumi.getter(name="allowedHttpMethods")
    def allowed_http_methods(self) -> Optional[str]:
        """
        The HTTP methods that are processed and forwarded to the distribution's origin.
        """
        return pulumi.get(self, "allowed_http_methods")

    @property
    @pulumi.getter(name="cachedHttpMethods")
    def cached_http_methods(self) -> Optional[str]:
        """
        The HTTP method responses that are cached by your distribution.
        """
        return pulumi.get(self, "cached_http_methods")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[int]:
        """
        The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="forwardedCookies")
    def forwarded_cookies(self) -> Optional['outputs.DistributionCacheBehaviorSettingsForwardedCookies']:
        """
        An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded. Detailed below
        """
        return pulumi.get(self, "forwarded_cookies")

    @property
    @pulumi.getter(name="forwardedHeaders")
    def forwarded_headers(self) -> Optional['outputs.DistributionCacheBehaviorSettingsForwardedHeaders']:
        """
        An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded. Detailed below
        """
        return pulumi.get(self, "forwarded_headers")

    @property
    @pulumi.getter(name="forwardedQueryStrings")
    def forwarded_query_strings(self) -> Optional['outputs.DistributionCacheBehaviorSettingsForwardedQueryStrings']:
        """
        An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded. Detailed below
        """
        return pulumi.get(self, "forwarded_query_strings")

    @property
    @pulumi.getter(name="maximumTtl")
    def maximum_ttl(self) -> Optional[int]:
        """
        The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        return pulumi.get(self, "maximum_ttl")

    @property
    @pulumi.getter(name="minimumTtl")
    def minimum_ttl(self) -> Optional[int]:
        """
        The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        return pulumi.get(self, "minimum_ttl")


@pulumi.output_type
class DistributionCacheBehaviorSettingsForwardedCookies(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesAllowLists":
            suggest = "cookies_allow_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettingsForwardedCookies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettingsForwardedCookies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettingsForwardedCookies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_allow_lists: Optional[Sequence[str]] = None,
                 option: Optional[str] = None):
        """
        :param Sequence[str] cookies_allow_lists: The specific cookies to forward to your distribution's origin.
        :param str option: Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
        """
        if cookies_allow_lists is not None:
            pulumi.set(__self__, "cookies_allow_lists", cookies_allow_lists)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter(name="cookiesAllowLists")
    def cookies_allow_lists(self) -> Optional[Sequence[str]]:
        """
        The specific cookies to forward to your distribution's origin.
        """
        return pulumi.get(self, "cookies_allow_lists")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class DistributionCacheBehaviorSettingsForwardedHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headersAllowLists":
            suggest = "headers_allow_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettingsForwardedHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettingsForwardedHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettingsForwardedHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers_allow_lists: Optional[Sequence[str]] = None,
                 option: Optional[str] = None):
        """
        :param Sequence[str] headers_allow_lists: The specific headers to forward to your distribution's origin.
        :param str option: The headers that you want your distribution to forward to your origin and base caching on.
        """
        if headers_allow_lists is not None:
            pulumi.set(__self__, "headers_allow_lists", headers_allow_lists)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter(name="headersAllowLists")
    def headers_allow_lists(self) -> Optional[Sequence[str]]:
        """
        The specific headers to forward to your distribution's origin.
        """
        return pulumi.get(self, "headers_allow_lists")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        The headers that you want your distribution to forward to your origin and base caching on.
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class DistributionCacheBehaviorSettingsForwardedQueryStrings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringsAllowedLists":
            suggest = "query_strings_allowed_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheBehaviorSettingsForwardedQueryStrings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheBehaviorSettingsForwardedQueryStrings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheBehaviorSettingsForwardedQueryStrings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 option: Optional[bool] = None,
                 query_strings_allowed_lists: Optional[Sequence[str]] = None):
        """
        :param bool option: Indicates whether the distribution forwards and caches based on query strings.
        :param Sequence[str] query_strings_allowed_lists: The specific query strings that the distribution forwards to the origin.
        """
        if option is not None:
            pulumi.set(__self__, "option", option)
        if query_strings_allowed_lists is not None:
            pulumi.set(__self__, "query_strings_allowed_lists", query_strings_allowed_lists)

    @property
    @pulumi.getter
    def option(self) -> Optional[bool]:
        """
        Indicates whether the distribution forwards and caches based on query strings.
        """
        return pulumi.get(self, "option")

    @property
    @pulumi.getter(name="queryStringsAllowedLists")
    def query_strings_allowed_lists(self) -> Optional[Sequence[str]]:
        """
        The specific query strings that the distribution forwards to the origin.
        """
        return pulumi.get(self, "query_strings_allowed_lists")


@pulumi.output_type
class DistributionDefaultCacheBehavior(dict):
    def __init__(__self__, *,
                 behavior: str):
        """
        :param str behavior: The cache behavior of the distribution. Valid values: `cache` and `dont-cache`.
        """
        pulumi.set(__self__, "behavior", behavior)

    @property
    @pulumi.getter
    def behavior(self) -> str:
        """
        The cache behavior of the distribution. Valid values: `cache` and `dont-cache`.
        """
        return pulumi.get(self, "behavior")


@pulumi.output_type
class DistributionLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: str,
                 region_name: str):
        """
        :param str availability_zone: The Availability Zone. Follows the format us-east-2a (case-sensitive).
        :param str region_name: The AWS Region name.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The Availability Zone. Follows the format us-east-2a (case-sensitive).
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        The AWS Region name.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class DistributionOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionName":
            suggest = "region_name"
        elif key == "protocolPolicy":
            suggest = "protocol_policy"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 region_name: str,
                 protocol_policy: Optional[str] = None,
                 resource_type: Optional[str] = None):
        """
        :param str name: The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
        :param str region_name: The AWS Region name of the origin resource.
        :param str protocol_policy: The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
        :param str resource_type: The resource type of the origin resource (e.g., Instance).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region_name", region_name)
        if protocol_policy is not None:
            pulumi.set(__self__, "protocol_policy", protocol_policy)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the origin resource. Your origin can be an instance with an attached static IP, a bucket, or a load balancer that has at least one instance attached to it.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        The AWS Region name of the origin resource.
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="protocolPolicy")
    def protocol_policy(self) -> Optional[str]:
        """
        The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
        """
        return pulumi.get(self, "protocol_policy")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        The resource type of the origin resource (e.g., Instance).
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class InstanceAddOn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotTime":
            suggest = "snapshot_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_time: str,
                 status: str,
                 type: str):
        """
        :param str snapshot_time: The daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
        :param str status: The status of the add on. Valid Values: `Enabled`, `Disabled`.
        :param str type: The add-on type. There is currently only one valid type `AutoSnapshot`.
        """
        pulumi.set(__self__, "snapshot_time", snapshot_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> str:
        """
        The daily time when an automatic snapshot will be created. Must be in HH:00 format, and in an hourly increment and specified in Coordinated Universal Time (UTC). The snapshot will be automatically created between the time specified and up to 45 minutes after.
        """
        return pulumi.get(self, "snapshot_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the add on. Valid Values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The add-on type. There is currently only one valid type `AutoSnapshot`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstancePublicPortsPortInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"
        elif key == "cidrListAliases":
            suggest = "cidr_list_aliases"
        elif key == "ipv6Cidrs":
            suggest = "ipv6_cidrs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePublicPortsPortInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePublicPortsPortInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePublicPortsPortInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: int,
                 protocol: str,
                 to_port: int,
                 cidr_list_aliases: Optional[Sequence[str]] = None,
                 cidrs: Optional[Sequence[str]] = None,
                 ipv6_cidrs: Optional[Sequence[str]] = None):
        """
        :param int from_port: First port in a range of open ports on an instance.
        :param str protocol: IP protocol name. Valid values are `tcp`, `all`, `udp`, and `icmp`.
        :param int to_port: Last port in a range of open ports on an instance.
               
               The following arguments are optional:
        :param Sequence[str] cidr_list_aliases: Set of CIDR aliases that define access for a preconfigured range of IP addresses.
        :param Sequence[str] cidrs: Set of CIDR blocks.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)
        if cidr_list_aliases is not None:
            pulumi.set(__self__, "cidr_list_aliases", cidr_list_aliases)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if ipv6_cidrs is not None:
            pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> int:
        """
        First port in a range of open ports on an instance.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        IP protocol name. Valid values are `tcp`, `all`, `udp`, and `icmp`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> int:
        """
        Last port in a range of open ports on an instance.

        The following arguments are optional:
        """
        return pulumi.get(self, "to_port")

    @property
    @pulumi.getter(name="cidrListAliases")
    def cidr_list_aliases(self) -> Optional[Sequence[str]]:
        """
        Set of CIDR aliases that define access for a preconfigured range of IP addresses.
        """
        return pulumi.get(self, "cidr_list_aliases")

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[str]]:
        """
        Set of CIDR blocks.
        """
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ipv6_cidrs")


@pulumi.output_type
class LbCertificateDomainValidationRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "resourceRecordName":
            suggest = "resource_record_name"
        elif key == "resourceRecordType":
            suggest = "resource_record_type"
        elif key == "resourceRecordValue":
            suggest = "resource_record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LbCertificateDomainValidationRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LbCertificateDomainValidationRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LbCertificateDomainValidationRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[str] = None,
                 resource_record_name: Optional[str] = None,
                 resource_record_type: Optional[str] = None,
                 resource_record_value: Optional[str] = None):
        """
        :param str domain_name: The domain name (e.g., example.com) for your SSL/TLS certificate.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if resource_record_name is not None:
            pulumi.set(__self__, "resource_record_name", resource_record_name)
        if resource_record_type is not None:
            pulumi.set(__self__, "resource_record_type", resource_record_type)
        if resource_record_value is not None:
            pulumi.set(__self__, "resource_record_value", resource_record_value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        The domain name (e.g., example.com) for your SSL/TLS certificate.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="resourceRecordName")
    def resource_record_name(self) -> Optional[str]:
        return pulumi.get(self, "resource_record_name")

    @property
    @pulumi.getter(name="resourceRecordType")
    def resource_record_type(self) -> Optional[str]:
        return pulumi.get(self, "resource_record_type")

    @property
    @pulumi.getter(name="resourceRecordValue")
    def resource_record_value(self) -> Optional[str]:
        return pulumi.get(self, "resource_record_value")


