# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 engine_type: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 apply_changes_during_maintenance_window: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 high_availability_config: Optional[pulumi.Input['EnvironmentHighAvailabilityConfigArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_configuration: Optional[pulumi.Input['EnvironmentStorageConfigurationArgs']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['EnvironmentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[str] engine_type: Engine type must be `microfocus` or `bluage`.
        :param pulumi.Input[str] instance_type: M2 Instance Type.
               
               The following arguments are optional:
        :param pulumi.Input[str] engine_version: The specific version of the engine for the Environment.
        :param pulumi.Input[bool] force_update: Force update the environment even if applications are running.
        :param pulumi.Input[str] kms_key_id: ARN of the KMS key to use for the Environment.
        :param pulumi.Input[str] name: Name of the runtime environment. Must be unique within the account.
        :param pulumi.Input[str] preferred_maintenance_window: Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
        :param pulumi.Input[bool] publicly_accessible: Allow applications deployed to this environment to be publicly accessible.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group ids.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet ids to deploy environment to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "engine_type", engine_type)
        pulumi.set(__self__, "instance_type", instance_type)
        if apply_changes_during_maintenance_window is not None:
            pulumi.set(__self__, "apply_changes_during_maintenance_window", apply_changes_during_maintenance_window)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if high_availability_config is not None:
            pulumi.set(__self__, "high_availability_config", high_availability_config)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if storage_configuration is not None:
            pulumi.set(__self__, "storage_configuration", storage_configuration)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Input[str]:
        """
        Engine type must be `microfocus` or `bluage`.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        M2 Instance Type.

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="applyChangesDuringMaintenanceWindow")
    def apply_changes_during_maintenance_window(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "apply_changes_during_maintenance_window")

    @apply_changes_during_maintenance_window.setter
    def apply_changes_during_maintenance_window(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_changes_during_maintenance_window", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The specific version of the engine for the Environment.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Force update the environment even if applications are running.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter(name="highAvailabilityConfig")
    def high_availability_config(self) -> Optional[pulumi.Input['EnvironmentHighAvailabilityConfigArgs']]:
        return pulumi.get(self, "high_availability_config")

    @high_availability_config.setter
    def high_availability_config(self, value: Optional[pulumi.Input['EnvironmentHighAvailabilityConfigArgs']]):
        pulumi.set(self, "high_availability_config", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the KMS key to use for the Environment.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the runtime environment. Must be unique within the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow applications deployed to this environment to be publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of security group ids.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="storageConfiguration")
    def storage_configuration(self) -> Optional[pulumi.Input['EnvironmentStorageConfigurationArgs']]:
        return pulumi.get(self, "storage_configuration")

    @storage_configuration.setter
    def storage_configuration(self, value: Optional[pulumi.Input['EnvironmentStorageConfigurationArgs']]):
        pulumi.set(self, "storage_configuration", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subnet ids to deploy environment to.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EnvironmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EnvironmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 apply_changes_during_maintenance_window: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 high_availability_config: Optional[pulumi.Input['EnvironmentHighAvailabilityConfigArgs']] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_configuration: Optional[pulumi.Input['EnvironmentStorageConfigurationArgs']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['EnvironmentTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[str] arn: ARN of the Environment.
        :param pulumi.Input[str] engine_type: Engine type must be `microfocus` or `bluage`.
        :param pulumi.Input[str] engine_version: The specific version of the engine for the Environment.
        :param pulumi.Input[str] environment_id: The id of the Environment.
        :param pulumi.Input[bool] force_update: Force update the environment even if applications are running.
        :param pulumi.Input[str] instance_type: M2 Instance Type.
               
               The following arguments are optional:
        :param pulumi.Input[str] kms_key_id: ARN of the KMS key to use for the Environment.
        :param pulumi.Input[str] load_balancer_arn: ARN of the load balancer created by the Environment.
        :param pulumi.Input[str] name: Name of the runtime environment. Must be unique within the account.
        :param pulumi.Input[str] preferred_maintenance_window: Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
        :param pulumi.Input[bool] publicly_accessible: Allow applications deployed to this environment to be publicly accessible.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group ids.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet ids to deploy environment to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if apply_changes_during_maintenance_window is not None:
            pulumi.set(__self__, "apply_changes_during_maintenance_window", apply_changes_during_maintenance_window)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if high_availability_config is not None:
            pulumi.set(__self__, "high_availability_config", high_availability_config)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if load_balancer_arn is not None:
            pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if storage_configuration is not None:
            pulumi.set(__self__, "storage_configuration", storage_configuration)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="applyChangesDuringMaintenanceWindow")
    def apply_changes_during_maintenance_window(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "apply_changes_during_maintenance_window")

    @apply_changes_during_maintenance_window.setter
    def apply_changes_during_maintenance_window(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_changes_during_maintenance_window", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the Environment.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Engine type must be `microfocus` or `bluage`.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The specific version of the engine for the Environment.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[bool]]:
        """
        Force update the environment even if applications are running.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter(name="highAvailabilityConfig")
    def high_availability_config(self) -> Optional[pulumi.Input['EnvironmentHighAvailabilityConfigArgs']]:
        return pulumi.get(self, "high_availability_config")

    @high_availability_config.setter
    def high_availability_config(self, value: Optional[pulumi.Input['EnvironmentHighAvailabilityConfigArgs']]):
        pulumi.set(self, "high_availability_config", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        M2 Instance Type.

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the KMS key to use for the Environment.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the load balancer created by the Environment.
        """
        return pulumi.get(self, "load_balancer_arn")

    @load_balancer_arn.setter
    def load_balancer_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the runtime environment. Must be unique within the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow applications deployed to this environment to be publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of security group ids.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="storageConfiguration")
    def storage_configuration(self) -> Optional[pulumi.Input['EnvironmentStorageConfigurationArgs']]:
        return pulumi.get(self, "storage_configuration")

    @storage_configuration.setter
    def storage_configuration(self, value: Optional[pulumi.Input['EnvironmentStorageConfigurationArgs']]):
        pulumi.set(self, "storage_configuration", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subnet ids to deploy environment to.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['EnvironmentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['EnvironmentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_changes_during_maintenance_window: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 high_availability_config: Optional[pulumi.Input[Union['EnvironmentHighAvailabilityConfigArgs', 'EnvironmentHighAvailabilityConfigArgsDict']]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_configuration: Optional[pulumi.Input[Union['EnvironmentStorageConfigurationArgs', 'EnvironmentStorageConfigurationArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['EnvironmentTimeoutsArgs', 'EnvironmentTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an [AWS Mainframe Modernization Environment](https://docs.aws.amazon.com/m2/latest/userguide/environments-m2.html).

        ## Example Usage

        ## Import

        Using `pulumi import`, import Mainframe Modernization Environment using the `01234567890abcdef012345678`. For example:

        ```sh
        $ pulumi import aws:m2/environment:Environment example 01234567890abcdef012345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] engine_type: Engine type must be `microfocus` or `bluage`.
        :param pulumi.Input[str] engine_version: The specific version of the engine for the Environment.
        :param pulumi.Input[bool] force_update: Force update the environment even if applications are running.
        :param pulumi.Input[str] instance_type: M2 Instance Type.
               
               The following arguments are optional:
        :param pulumi.Input[str] kms_key_id: ARN of the KMS key to use for the Environment.
        :param pulumi.Input[str] name: Name of the runtime environment. Must be unique within the account.
        :param pulumi.Input[str] preferred_maintenance_window: Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
        :param pulumi.Input[bool] publicly_accessible: Allow applications deployed to this environment to be publicly accessible.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group ids.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet ids to deploy environment to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an [AWS Mainframe Modernization Environment](https://docs.aws.amazon.com/m2/latest/userguide/environments-m2.html).

        ## Example Usage

        ## Import

        Using `pulumi import`, import Mainframe Modernization Environment using the `01234567890abcdef012345678`. For example:

        ```sh
        $ pulumi import aws:m2/environment:Environment example 01234567890abcdef012345678
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_changes_during_maintenance_window: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 high_availability_config: Optional[pulumi.Input[Union['EnvironmentHighAvailabilityConfigArgs', 'EnvironmentHighAvailabilityConfigArgsDict']]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_configuration: Optional[pulumi.Input[Union['EnvironmentStorageConfigurationArgs', 'EnvironmentStorageConfigurationArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['EnvironmentTimeoutsArgs', 'EnvironmentTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            __props__.__dict__["apply_changes_during_maintenance_window"] = apply_changes_during_maintenance_window
            __props__.__dict__["description"] = description
            if engine_type is None and not opts.urn:
                raise TypeError("Missing required property 'engine_type'")
            __props__.__dict__["engine_type"] = engine_type
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["high_availability_config"] = high_availability_config
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["storage_configuration"] = storage_configuration
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["environment_id"] = None
            __props__.__dict__["load_balancer_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Environment, __self__).__init__(
            'aws:m2/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_changes_during_maintenance_window: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            engine_type: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            environment_id: Optional[pulumi.Input[str]] = None,
            force_update: Optional[pulumi.Input[bool]] = None,
            high_availability_config: Optional[pulumi.Input[Union['EnvironmentHighAvailabilityConfigArgs', 'EnvironmentHighAvailabilityConfigArgsDict']]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            load_balancer_arn: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
            publicly_accessible: Optional[pulumi.Input[bool]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            storage_configuration: Optional[pulumi.Input[Union['EnvironmentStorageConfigurationArgs', 'EnvironmentStorageConfigurationArgsDict']]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['EnvironmentTimeoutsArgs', 'EnvironmentTimeoutsArgsDict']]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN of the Environment.
        :param pulumi.Input[str] engine_type: Engine type must be `microfocus` or `bluage`.
        :param pulumi.Input[str] engine_version: The specific version of the engine for the Environment.
        :param pulumi.Input[str] environment_id: The id of the Environment.
        :param pulumi.Input[bool] force_update: Force update the environment even if applications are running.
        :param pulumi.Input[str] instance_type: M2 Instance Type.
               
               The following arguments are optional:
        :param pulumi.Input[str] kms_key_id: ARN of the KMS key to use for the Environment.
        :param pulumi.Input[str] load_balancer_arn: ARN of the load balancer created by the Environment.
        :param pulumi.Input[str] name: Name of the runtime environment. Must be unique within the account.
        :param pulumi.Input[str] preferred_maintenance_window: Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
        :param pulumi.Input[bool] publicly_accessible: Allow applications deployed to this environment to be publicly accessible.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List of security group ids.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet ids to deploy environment to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["apply_changes_during_maintenance_window"] = apply_changes_during_maintenance_window
        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["force_update"] = force_update
        __props__.__dict__["high_availability_config"] = high_availability_config
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["load_balancer_arn"] = load_balancer_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["storage_configuration"] = storage_configuration
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyChangesDuringMaintenanceWindow")
    def apply_changes_during_maintenance_window(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "apply_changes_during_maintenance_window")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the Environment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[str]:
        """
        Engine type must be `microfocus` or `bluage`.
        """
        return pulumi.get(self, "engine_type")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The specific version of the engine for the Environment.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        The id of the Environment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[bool]]:
        """
        Force update the environment even if applications are running.
        """
        return pulumi.get(self, "force_update")

    @property
    @pulumi.getter(name="highAvailabilityConfig")
    def high_availability_config(self) -> pulumi.Output[Optional['outputs.EnvironmentHighAvailabilityConfig']]:
        return pulumi.get(self, "high_availability_config")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        M2 Instance Type.

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of the KMS key to use for the Environment.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> pulumi.Output[str]:
        """
        ARN of the load balancer created by the Environment.
        """
        return pulumi.get(self, "load_balancer_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the runtime environment. Must be unique within the account.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[str]:
        """
        Configures the maintenance window that you want for the runtime environment. The maintenance window must have the format `ddd:hh24:mi-ddd:hh24:mi` and must be less than 24 hours. If not provided a random value will be used.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[bool]:
        """
        Allow applications deployed to this environment to be publicly accessible.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of security group ids.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="storageConfiguration")
    def storage_configuration(self) -> pulumi.Output[Optional['outputs.EnvironmentStorageConfiguration']]:
        return pulumi.get(self, "storage_configuration")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of subnet ids to deploy environment to.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value tags for the place index. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.EnvironmentTimeouts']]:
        return pulumi.get(self, "timeouts")

