# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CoreNetworkPolicyAttachmentArgs', 'CoreNetworkPolicyAttachment']

@pulumi.input_type
class CoreNetworkPolicyAttachmentArgs:
    def __init__(__self__, *,
                 core_network_id: pulumi.Input[str],
                 policy_document: pulumi.Input[str]):
        """
        The set of arguments for constructing a CoreNetworkPolicyAttachment resource.
        :param pulumi.Input[str] core_network_id: The ID of the core network that a policy will be attached to and made `LIVE`.
        :param pulumi.Input[str] policy_document: Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
        """
        pulumi.set(__self__, "core_network_id", core_network_id)
        pulumi.set(__self__, "policy_document", policy_document)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Input[str]:
        """
        The ID of the core network that a policy will be attached to and made `LIVE`.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "core_network_id", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Input[str]:
        """
        Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_document", value)


@pulumi.input_type
class _CoreNetworkPolicyAttachmentState:
    def __init__(__self__, *,
                 core_network_id: Optional[pulumi.Input[str]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CoreNetworkPolicyAttachment resources.
        :param pulumi.Input[str] core_network_id: The ID of the core network that a policy will be attached to and made `LIVE`.
        :param pulumi.Input[str] policy_document: Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
        :param pulumi.Input[str] state: Current state of a core network.
        """
        if core_network_id is not None:
            pulumi.set(__self__, "core_network_id", core_network_id)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the core network that a policy will be attached to and made `LIVE`.
        """
        return pulumi.get(self, "core_network_id")

    @core_network_id.setter
    def core_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "core_network_id", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[str]]:
        """
        Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Current state of a core network.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class CoreNetworkPolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[str]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Core Network Policy Attachment resource. This puts a Core Network Policy to an existing Core Network and executes the change set, which deploys changes globally based on the policy submitted (Sets the policy to `LIVE`).

        > **NOTE:** Deleting this resource will not delete the current policy defined in this resource. Deleting this resource will also not revert the current `LIVE` policy to the previous version.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example", global_network_id=example_aws_networkmanager_global_network["id"])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example.id,
            policy_document=example_aws_networkmanager_core_network_policy_document["json"])
        ```

        ### With VPC Attachment (Single Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument. There are 2 options to implement this:

        - Option 1: Use the `base_policy_document` argument in the `networkmanager.CoreNetwork` resource that allows the most customizations to a base policy. Use this to customize the `edge_locations` `asn`. In the example below, `us-west-2` and ASN `65500` are used in the base policy.
        - Option 2: Use the `create_base_policy` argument only. This creates a base policy in the region specified in the `provider` block.

        ### Option 1 - using base_policy_document

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        base = aws.networkmanager.get_core_network_policy_document(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [{
                    "location": "us-west-2",
                    "asn": "65500",
                }],
            }],
            segments=[{
                "name": "segment",
            }])
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            base_policy_document=base.json,
            create_base_policy=True)
        example_vpc_attachment = aws.networkmanager.VpcAttachment("example",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_aws_subnet],
            vpc_arn=example_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [{
                    "location": "us-west-2",
                    "asn": "65500",
                }],
            }],
            segments=[{
                "name": "segment",
            }],
            segment_actions=[{
                "action": "create-route",
                "segment": "segment",
                "destination_cidr_blocks": ["0.0.0.0/0"],
                "destinations": [example_vpc_attachment.id],
            }])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ### Option 2 - create_base_policy only

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            create_base_policy=True)
        example_vpc_attachment = aws.networkmanager.VpcAttachment("example",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_aws_subnet],
            vpc_arn=example_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [{
                    "location": "us-west-2",
                }],
            }],
            segments=[{
                "name": "segment",
            }],
            segment_actions=[{
                "action": "create-route",
                "segment": "segment",
                "destination_cidr_blocks": ["0.0.0.0/0"],
                "destinations": [example_vpc_attachment.id],
            }])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ### With VPC Attachment (Multi-Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument. For multi-region in a core network that does not yet have a `LIVE` policy, there are 2 options:

        - Option 1: Use the `base_policy_document` argument that allows the most customizations to a base policy. Use this to customize the `edge_locations` `asn`. In the example below, `us-west-2`, `us-east-1` and specific ASNs are used in the base policy.
        - Option 2: Pass a list of regions to the `networkmanager.CoreNetwork` resource `base_policy_regions` argument. In the example below, `us-west-2` and `us-east-1` are specified in the base policy.

        ### Option 1 - using base_policy_document

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        base = aws.networkmanager.get_core_network_policy_document(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [
                    {
                        "location": "us-west-2",
                        "asn": "65500",
                    },
                    {
                        "location": "us-east-1",
                        "asn": "65501",
                    },
                ],
            }],
            segments=[{
                "name": "segment",
            }])
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            base_policy_document=base.json,
            create_base_policy=True)
        example_us_west2 = aws.networkmanager.VpcAttachment("example_us_west_2",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_west2_aws_subnet],
            vpc_arn=example_us_west2_aws_vpc["arn"])
        example_us_east1 = aws.networkmanager.VpcAttachment("example_us_east_1",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_east1_aws_subnet],
            vpc_arn=example_us_east1_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [
                    {
                        "location": "us-west-2",
                        "asn": "65500",
                    },
                    {
                        "location": "us-east-1",
                        "asn": "65501",
                    },
                ],
            }],
            segments=[
                {
                    "name": "segment",
                },
                {
                    "name": "segment2",
                },
            ],
            segment_actions=[
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.0.0.0/16"],
                    "destinations": [example_us_west2.id],
                },
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.1.0.0/16"],
                    "destinations": [example_us_east1.id],
                },
            ])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ### Option 2 - using base_policy_regions

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            base_policy_regions=[
                "us-west-2",
                "us-east-1",
            ],
            create_base_policy=True)
        example_us_west2 = aws.networkmanager.VpcAttachment("example_us_west_2",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_west2_aws_subnet],
            vpc_arn=example_us_west2_aws_vpc["arn"])
        example_us_east1 = aws.networkmanager.VpcAttachment("example_us_east_1",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_east1_aws_subnet],
            vpc_arn=example_us_east1_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [
                    {
                        "location": "us-west-2",
                    },
                    {
                        "location": "us-east-1",
                    },
                ],
            }],
            segments=[
                {
                    "name": "segment",
                },
                {
                    "name": "segment2",
                },
            ],
            segment_actions=[
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.0.0.0/16"],
                    "destinations": [example_us_west2.id],
                },
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.1.0.0/16"],
                    "destinations": [example_us_east1.id],
                },
            ])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_core_network_policy_attachment` using the core network ID. For example:

        ```sh
        $ pulumi import aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment example core-network-0d47f6t230mz46dy4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] core_network_id: The ID of the core network that a policy will be attached to and made `LIVE`.
        :param pulumi.Input[str] policy_document: Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CoreNetworkPolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Core Network Policy Attachment resource. This puts a Core Network Policy to an existing Core Network and executes the change set, which deploys changes globally based on the policy submitted (Sets the policy to `LIVE`).

        > **NOTE:** Deleting this resource will not delete the current policy defined in this resource. Deleting this resource will also not revert the current `LIVE` policy to the previous version.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmanager.CoreNetwork("example", global_network_id=example_aws_networkmanager_global_network["id"])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example.id,
            policy_document=example_aws_networkmanager_core_network_policy_document["json"])
        ```

        ### With VPC Attachment (Single Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument. There are 2 options to implement this:

        - Option 1: Use the `base_policy_document` argument in the `networkmanager.CoreNetwork` resource that allows the most customizations to a base policy. Use this to customize the `edge_locations` `asn`. In the example below, `us-west-2` and ASN `65500` are used in the base policy.
        - Option 2: Use the `create_base_policy` argument only. This creates a base policy in the region specified in the `provider` block.

        ### Option 1 - using base_policy_document

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        base = aws.networkmanager.get_core_network_policy_document(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [{
                    "location": "us-west-2",
                    "asn": "65500",
                }],
            }],
            segments=[{
                "name": "segment",
            }])
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            base_policy_document=base.json,
            create_base_policy=True)
        example_vpc_attachment = aws.networkmanager.VpcAttachment("example",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_aws_subnet],
            vpc_arn=example_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [{
                    "location": "us-west-2",
                    "asn": "65500",
                }],
            }],
            segments=[{
                "name": "segment",
            }],
            segment_actions=[{
                "action": "create-route",
                "segment": "segment",
                "destination_cidr_blocks": ["0.0.0.0/0"],
                "destinations": [example_vpc_attachment.id],
            }])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ### Option 2 - create_base_policy only

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            create_base_policy=True)
        example_vpc_attachment = aws.networkmanager.VpcAttachment("example",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_aws_subnet],
            vpc_arn=example_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [{
                    "location": "us-west-2",
                }],
            }],
            segments=[{
                "name": "segment",
            }],
            segment_actions=[{
                "action": "create-route",
                "segment": "segment",
                "destination_cidr_blocks": ["0.0.0.0/0"],
                "destinations": [example_vpc_attachment.id],
            }])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ### With VPC Attachment (Multi-Region)

        The example below illustrates the scenario where your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Set the `create_base_policy` argument of the `networkmanager.CoreNetwork` resource to `true` if your core network does not currently have any `LIVE` policies (e.g. this is the first `pulumi up` with the core network resource), since a `LIVE` policy is required before VPCs can be attached to the core network. Otherwise, if your core network already has a `LIVE` policy, you may exclude the `create_base_policy` argument. For multi-region in a core network that does not yet have a `LIVE` policy, there are 2 options:

        - Option 1: Use the `base_policy_document` argument that allows the most customizations to a base policy. Use this to customize the `edge_locations` `asn`. In the example below, `us-west-2`, `us-east-1` and specific ASNs are used in the base policy.
        - Option 2: Pass a list of regions to the `networkmanager.CoreNetwork` resource `base_policy_regions` argument. In the example below, `us-west-2` and `us-east-1` are specified in the base policy.

        ### Option 1 - using base_policy_document

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        base = aws.networkmanager.get_core_network_policy_document(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [
                    {
                        "location": "us-west-2",
                        "asn": "65500",
                    },
                    {
                        "location": "us-east-1",
                        "asn": "65501",
                    },
                ],
            }],
            segments=[{
                "name": "segment",
            }])
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            base_policy_document=base.json,
            create_base_policy=True)
        example_us_west2 = aws.networkmanager.VpcAttachment("example_us_west_2",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_west2_aws_subnet],
            vpc_arn=example_us_west2_aws_vpc["arn"])
        example_us_east1 = aws.networkmanager.VpcAttachment("example_us_east_1",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_east1_aws_subnet],
            vpc_arn=example_us_east1_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [
                    {
                        "location": "us-west-2",
                        "asn": "65500",
                    },
                    {
                        "location": "us-east-1",
                        "asn": "65501",
                    },
                ],
            }],
            segments=[
                {
                    "name": "segment",
                },
                {
                    "name": "segment2",
                },
            ],
            segment_actions=[
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.0.0.0/16"],
                    "destinations": [example_us_west2.id],
                },
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.1.0.0/16"],
                    "destinations": [example_us_east1.id],
                },
            ])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ### Option 2 - using base_policy_regions

        ```python
        import pulumi
        import pulumi_aws as aws

        example_global_network = aws.networkmanager.GlobalNetwork("example")
        example_core_network = aws.networkmanager.CoreNetwork("example",
            global_network_id=example_global_network.id,
            base_policy_regions=[
                "us-west-2",
                "us-east-1",
            ],
            create_base_policy=True)
        example_us_west2 = aws.networkmanager.VpcAttachment("example_us_west_2",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_west2_aws_subnet],
            vpc_arn=example_us_west2_aws_vpc["arn"])
        example_us_east1 = aws.networkmanager.VpcAttachment("example_us_east_1",
            core_network_id=example_core_network.id,
            subnet_arns=[__item["arn"] for __item in example_us_east1_aws_subnet],
            vpc_arn=example_us_east1_aws_vpc["arn"])
        example = aws.networkmanager.get_core_network_policy_document_output(core_network_configurations=[{
                "asn_ranges": ["65022-65534"],
                "edge_locations": [
                    {
                        "location": "us-west-2",
                    },
                    {
                        "location": "us-east-1",
                    },
                ],
            }],
            segments=[
                {
                    "name": "segment",
                },
                {
                    "name": "segment2",
                },
            ],
            segment_actions=[
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.0.0.0/16"],
                    "destinations": [example_us_west2.id],
                },
                {
                    "action": "create-route",
                    "segment": "segment",
                    "destination_cidr_blocks": ["10.1.0.0/16"],
                    "destinations": [example_us_east1.id],
                },
            ])
        example_core_network_policy_attachment = aws.networkmanager.CoreNetworkPolicyAttachment("example",
            core_network_id=example_core_network.id,
            policy_document=example.json)
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmanager_core_network_policy_attachment` using the core network ID. For example:

        ```sh
        $ pulumi import aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment example core-network-0d47f6t230mz46dy4
        ```

        :param str resource_name: The name of the resource.
        :param CoreNetworkPolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CoreNetworkPolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 core_network_id: Optional[pulumi.Input[str]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CoreNetworkPolicyAttachmentArgs.__new__(CoreNetworkPolicyAttachmentArgs)

            if core_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'core_network_id'")
            __props__.__dict__["core_network_id"] = core_network_id
            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["state"] = None
        super(CoreNetworkPolicyAttachment, __self__).__init__(
            'aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            core_network_id: Optional[pulumi.Input[str]] = None,
            policy_document: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'CoreNetworkPolicyAttachment':
        """
        Get an existing CoreNetworkPolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] core_network_id: The ID of the core network that a policy will be attached to and made `LIVE`.
        :param pulumi.Input[str] policy_document: Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
        :param pulumi.Input[str] state: Current state of a core network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CoreNetworkPolicyAttachmentState.__new__(_CoreNetworkPolicyAttachmentState)

        __props__.__dict__["core_network_id"] = core_network_id
        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["state"] = state
        return CoreNetworkPolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="coreNetworkId")
    def core_network_id(self) -> pulumi.Output[str]:
        """
        The ID of the core network that a policy will be attached to and made `LIVE`.
        """
        return pulumi.get(self, "core_network_id")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[str]:
        """
        Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of a core network.
        """
        return pulumi.get(self, "state")

