# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProbeArgs', 'Probe']

@pulumi.input_type
class ProbeArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[str],
                 monitor_name: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 source_arn: pulumi.Input[str],
                 destination_port: Optional[pulumi.Input[int]] = None,
                 packet_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Probe resource.
        :param pulumi.Input[str] destination: The destination IP address. This must be either IPV4 or IPV6.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
        :param pulumi.Input[str] protocol: The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
        :param pulumi.Input[str] source_arn: The ARN of the subnet.
        :param pulumi.Input[int] destination_port: The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
        :param pulumi.Input[int] packet_size: The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "monitor_name", monitor_name)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_arn", source_arn)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if packet_size is not None:
            pulumi.set(__self__, "packet_size", packet_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        The destination IP address. This must be either IPV4 or IPV6.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="monitorName")
    def monitor_name(self) -> pulumi.Input[str]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "monitor_name")

    @monitor_name.setter
    def monitor_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "monitor_name", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the subnet.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="packetSize")
    def packet_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the packets sent between the source and destination. This must be a number between 56 and 8500.

        The following arguments are optional:
        """
        return pulumi.get(self, "packet_size")

    @packet_size.setter
    def packet_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "packet_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProbeState:
    def __init__(__self__, *,
                 address_family: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 monitor_name: Optional[pulumi.Input[str]] = None,
                 packet_size: Optional[pulumi.Input[int]] = None,
                 probe_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Probe resources.
        :param pulumi.Input[str] arn: The ARN of the attachment.
        :param pulumi.Input[str] destination: The destination IP address. This must be either IPV4 or IPV6.
        :param pulumi.Input[int] destination_port: The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
        :param pulumi.Input[int] packet_size: The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
               
               The following arguments are optional:
        :param pulumi.Input[str] protocol: The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
        :param pulumi.Input[str] source_arn: The ARN of the subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if address_family is not None:
            pulumi.set(__self__, "address_family", address_family)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if monitor_name is not None:
            pulumi.set(__self__, "monitor_name", monitor_name)
        if packet_size is not None:
            pulumi.set(__self__, "packet_size", packet_size)
        if probe_id is not None:
            pulumi.set(__self__, "probe_id", probe_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "address_family")

    @address_family.setter
    def address_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_family", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the attachment.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        The destination IP address. This must be either IPV4 or IPV6.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="monitorName")
    def monitor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "monitor_name")

    @monitor_name.setter
    def monitor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_name", value)

    @property
    @pulumi.getter(name="packetSize")
    def packet_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the packets sent between the source and destination. This must be a number between 56 and 8500.

        The following arguments are optional:
        """
        return pulumi.get(self, "packet_size")

    @packet_size.setter
    def packet_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "packet_size", value)

    @property
    @pulumi.getter(name="probeId")
    def probe_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "probe_id")

    @probe_id.setter
    def probe_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "probe_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the subnet.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Probe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 monitor_name: Optional[pulumi.Input[str]] = None,
                 packet_size: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Network Monitor Probe.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmonitor.Monitor("example",
            aggregation_period=30,
            monitor_name="example")
        example_probe = aws.networkmonitor.Probe("example",
            monitor_name=example.monitor_name,
            destination="127.0.0.1",
            destination_port=80,
            protocol="TCP",
            source_arn=example_aws_subnet["arn"],
            packet_size=200)
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmonitor_probe` using the monitor name and probe id. For example:

        ```sh
        $ pulumi import aws:networkmonitor/probe:Probe example monitor-7786087912324693644,probe-3qm8p693i4fi1h8lqylzkbp42e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination: The destination IP address. This must be either IPV4 or IPV6.
        :param pulumi.Input[int] destination_port: The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
        :param pulumi.Input[int] packet_size: The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
               
               The following arguments are optional:
        :param pulumi.Input[str] protocol: The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
        :param pulumi.Input[str] source_arn: The ARN of the subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProbeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Network Monitor Probe.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.networkmonitor.Monitor("example",
            aggregation_period=30,
            monitor_name="example")
        example_probe = aws.networkmonitor.Probe("example",
            monitor_name=example.monitor_name,
            destination="127.0.0.1",
            destination_port=80,
            protocol="TCP",
            source_arn=example_aws_subnet["arn"],
            packet_size=200)
        ```

        ## Import

        Using `pulumi import`, import `aws_networkmonitor_probe` using the monitor name and probe id. For example:

        ```sh
        $ pulumi import aws:networkmonitor/probe:Probe example monitor-7786087912324693644,probe-3qm8p693i4fi1h8lqylzkbp42e
        ```

        :param str resource_name: The name of the resource.
        :param ProbeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProbeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 monitor_name: Optional[pulumi.Input[str]] = None,
                 packet_size: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProbeArgs.__new__(ProbeArgs)

            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["destination_port"] = destination_port
            if monitor_name is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_name'")
            __props__.__dict__["monitor_name"] = monitor_name
            __props__.__dict__["packet_size"] = packet_size
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if source_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_arn'")
            __props__.__dict__["source_arn"] = source_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["address_family"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["probe_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vpc_id"] = None
        super(Probe, __self__).__init__(
            'aws:networkmonitor/probe:Probe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_family: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            destination: Optional[pulumi.Input[str]] = None,
            destination_port: Optional[pulumi.Input[int]] = None,
            monitor_name: Optional[pulumi.Input[str]] = None,
            packet_size: Optional[pulumi.Input[int]] = None,
            probe_id: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            source_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Probe':
        """
        Get an existing Probe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The ARN of the attachment.
        :param pulumi.Input[str] destination: The destination IP address. This must be either IPV4 or IPV6.
        :param pulumi.Input[int] destination_port: The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
        :param pulumi.Input[str] monitor_name: The name of the monitor.
        :param pulumi.Input[int] packet_size: The size of the packets sent between the source and destination. This must be a number between 56 and 8500.
               
               The following arguments are optional:
        :param pulumi.Input[str] protocol: The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
        :param pulumi.Input[str] source_arn: The ARN of the subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProbeState.__new__(_ProbeState)

        __props__.__dict__["address_family"] = address_family
        __props__.__dict__["arn"] = arn
        __props__.__dict__["destination"] = destination
        __props__.__dict__["destination_port"] = destination_port
        __props__.__dict__["monitor_name"] = monitor_name
        __props__.__dict__["packet_size"] = packet_size
        __props__.__dict__["probe_id"] = probe_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_id"] = vpc_id
        return Probe(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> pulumi.Output[str]:
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the attachment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[str]:
        """
        The destination IP address. This must be either IPV4 or IPV6.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port associated with the destination. This is required only if the protocol is TCP and must be a number between 1 and 65536.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter(name="monitorName")
    def monitor_name(self) -> pulumi.Output[str]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "monitor_name")

    @property
    @pulumi.getter(name="packetSize")
    def packet_size(self) -> pulumi.Output[int]:
        """
        The size of the packets sent between the source and destination. This must be a number between 56 and 8500.

        The following arguments are optional:
        """
        return pulumi.get(self, "packet_size")

    @property
    @pulumi.getter(name="probeId")
    def probe_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "probe_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol used for the network traffic between the source and destination. This must be either TCP or ICMP.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the subnet.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key-value tags for the monitor. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "vpc_id")

