# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorizeVpcEndpointAccessArgs', 'AuthorizeVpcEndpointAccess']

@pulumi.input_type
class AuthorizeVpcEndpointAccessArgs:
    def __init__(__self__, *,
                 account: pulumi.Input[str],
                 domain_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AuthorizeVpcEndpointAccess resource.
        :param pulumi.Input[str] account: AWS account ID to grant access to.
        :param pulumi.Input[str] domain_name: Name of OpenSearch Service domain to provide access to.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Input[str]:
        """
        AWS account ID to grant access to.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: pulumi.Input[str]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Name of OpenSearch Service domain to provide access to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)


@pulumi.input_type
class _AuthorizeVpcEndpointAccessState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[str]] = None,
                 authorized_principals: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs']]]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthorizeVpcEndpointAccess resources.
        :param pulumi.Input[str] account: AWS account ID to grant access to.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs']]] authorized_principals: Information about the Amazon Web Services account or service that was provided access to the domain. See authorized principal attribute for further details.
        :param pulumi.Input[str] domain_name: Name of OpenSearch Service domain to provide access to.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if authorized_principals is not None:
            pulumi.set(__self__, "authorized_principals", authorized_principals)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[str]]:
        """
        AWS account ID to grant access to.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="authorizedPrincipals")
    def authorized_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs']]]]:
        """
        Information about the Amazon Web Services account or service that was provided access to the domain. See authorized principal attribute for further details.
        """
        return pulumi.get(self, "authorized_principals")

    @authorized_principals.setter
    def authorized_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs']]]]):
        pulumi.set(self, "authorized_principals", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of OpenSearch Service domain to provide access to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)


class AuthorizeVpcEndpointAccess(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS OpenSearch Authorize Vpc Endpoint Access.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        test = aws.opensearch.AuthorizeVpcEndpointAccess("test",
            domain_name=test_aws_opensearch_domain["domainName"],
            account=current.account_id)
        ```

        ## Import

        Using `pulumi import`, import OpenSearch Authorize Vpc Endpoint Access using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:opensearch/authorizeVpcEndpointAccess:AuthorizeVpcEndpointAccess example authorize_vpc_endpoint_access-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: AWS account ID to grant access to.
        :param pulumi.Input[str] domain_name: Name of OpenSearch Service domain to provide access to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizeVpcEndpointAccessArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS OpenSearch Authorize Vpc Endpoint Access.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        test = aws.opensearch.AuthorizeVpcEndpointAccess("test",
            domain_name=test_aws_opensearch_domain["domainName"],
            account=current.account_id)
        ```

        ## Import

        Using `pulumi import`, import OpenSearch Authorize Vpc Endpoint Access using the `example_id_arg`. For example:

        ```sh
        $ pulumi import aws:opensearch/authorizeVpcEndpointAccess:AuthorizeVpcEndpointAccess example authorize_vpc_endpoint_access-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizeVpcEndpointAccessArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizeVpcEndpointAccessArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizeVpcEndpointAccessArgs.__new__(AuthorizeVpcEndpointAccessArgs)

            if account is None and not opts.urn:
                raise TypeError("Missing required property 'account'")
            __props__.__dict__["account"] = account
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["authorized_principals"] = None
        super(AuthorizeVpcEndpointAccess, __self__).__init__(
            'aws:opensearch/authorizeVpcEndpointAccess:AuthorizeVpcEndpointAccess',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[str]] = None,
            authorized_principals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs', 'AuthorizeVpcEndpointAccessAuthorizedPrincipalArgsDict']]]]] = None,
            domain_name: Optional[pulumi.Input[str]] = None) -> 'AuthorizeVpcEndpointAccess':
        """
        Get an existing AuthorizeVpcEndpointAccess resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: AWS account ID to grant access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizeVpcEndpointAccessAuthorizedPrincipalArgs', 'AuthorizeVpcEndpointAccessAuthorizedPrincipalArgsDict']]]] authorized_principals: Information about the Amazon Web Services account or service that was provided access to the domain. See authorized principal attribute for further details.
        :param pulumi.Input[str] domain_name: Name of OpenSearch Service domain to provide access to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizeVpcEndpointAccessState.__new__(_AuthorizeVpcEndpointAccessState)

        __props__.__dict__["account"] = account
        __props__.__dict__["authorized_principals"] = authorized_principals
        __props__.__dict__["domain_name"] = domain_name
        return AuthorizeVpcEndpointAccess(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Output[str]:
        """
        AWS account ID to grant access to.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="authorizedPrincipals")
    def authorized_principals(self) -> pulumi.Output[Sequence['outputs.AuthorizeVpcEndpointAccessAuthorizedPrincipal']]:
        """
        Information about the Amazon Web Services account or service that was provided access to the domain. See authorized principal attribute for further details.
        """
        return pulumi.get(self, "authorized_principals")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Name of OpenSearch Service domain to provide access to.
        """
        return pulumi.get(self, "domain_name")

