# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServerlessAccessPolicyResult',
    'AwaitableGetServerlessAccessPolicyResult',
    'get_serverless_access_policy',
    'get_serverless_access_policy_output',
]

@pulumi.output_type
class GetServerlessAccessPolicyResult:
    """
    A collection of values returned by getServerlessAccessPolicy.
    """
    def __init__(__self__, description=None, id=None, name=None, policy=None, policy_version=None, type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy and not isinstance(policy, str):
            raise TypeError("Expected argument 'policy' to be a str")
        pulumi.set(__self__, "policy", policy)
        if policy_version and not isinstance(policy_version, str):
            raise TypeError("Expected argument 'policy_version' to be a str")
        pulumi.set(__self__, "policy_version", policy_version)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the policy. Typically used to store information about the permissions defined in the policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        JSON policy document to use as the content for the new policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> str:
        """
        Version of the policy.
        """
        return pulumi.get(self, "policy_version")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetServerlessAccessPolicyResult(GetServerlessAccessPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessAccessPolicyResult(
            description=self.description,
            id=self.id,
            name=self.name,
            policy=self.policy,
            policy_version=self.policy_version,
            type=self.type)


def get_serverless_access_policy(name: Optional[str] = None,
                                 type: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessAccessPolicyResult:
    """
    Data source for managing an AWS OpenSearch Serverless Access Policy.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_access_policy(name=example_aws_opensearchserverless_access_policy["name"],
        type=example_aws_opensearchserverless_access_policy["type"])
    ```


    :param str name: Name of the policy.
    :param str type: Type of access policy. Must be `data`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:opensearch/getServerlessAccessPolicy:getServerlessAccessPolicy', __args__, opts=opts, typ=GetServerlessAccessPolicyResult).value

    return AwaitableGetServerlessAccessPolicyResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        policy=pulumi.get(__ret__, 'policy'),
        policy_version=pulumi.get(__ret__, 'policy_version'),
        type=pulumi.get(__ret__, 'type'))
def get_serverless_access_policy_output(name: Optional[pulumi.Input[str]] = None,
                                        type: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerlessAccessPolicyResult]:
    """
    Data source for managing an AWS OpenSearch Serverless Access Policy.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.opensearch.get_serverless_access_policy(name=example_aws_opensearchserverless_access_policy["name"],
        type=example_aws_opensearchserverless_access_policy["type"])
    ```


    :param str name: Name of the policy.
    :param str type: Type of access policy. Must be `data`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:opensearch/getServerlessAccessPolicy:getServerlessAccessPolicy', __args__, opts=opts, typ=GetServerlessAccessPolicyResult)
    return __ret__.apply(lambda __response__: GetServerlessAccessPolicyResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        policy=pulumi.get(__response__, 'policy'),
        policy_version=pulumi.get(__response__, 'policy_version'),
        type=pulumi.get(__response__, 'type')))
