# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 layer_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 stack_id: pulumi.Input[str],
                 agent_version: Optional[pulumi.Input[str]] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 auto_scaling_type: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_ebs: Optional[pulumi.Input[bool]] = None,
                 delete_eip: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 ecs_cluster_arn: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 infrastructure_class: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 root_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]]] = None,
                 root_device_type: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 virtualization_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layer_ids: List of the layers the instance will belong to.
        :param pulumi.Input[str] stack_id: Identifier of the stack the instance will belong to.
               
               The following arguments are optional:
        :param pulumi.Input[str] agent_version: OpsWorks agent to install. Default is `INHERIT`.
        :param pulumi.Input[str] ami_id: AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
        :param pulumi.Input[str] architecture: Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
        :param pulumi.Input[str] auto_scaling_type: Creates load-based or time-based instances.  Valid values are `load`, `timer`.
        :param pulumi.Input[str] availability_zone: Name of the availability zone where instances will be created by default.
        :param pulumi.Input[str] created_at: Time that the instance was created.
        :param pulumi.Input[bool] delete_ebs: Whether to delete EBS volume on deletion. Default is `true`.
        :param pulumi.Input[bool] delete_eip: Whether to delete the Elastic IP on deletion.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]] ebs_block_devices: Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
        :param pulumi.Input[bool] ebs_optimized: Whether the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input[str] ecs_cluster_arn: ECS cluster's ARN for container instances.
        :param pulumi.Input[str] elastic_ip: Instance Elastic IP address.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
        :param pulumi.Input[str] hostname: Instance's host name.
        :param pulumi.Input[str] infrastructure_class: For registered instances, infrastructure class: ec2 or on-premises.
        :param pulumi.Input[bool] install_updates_on_boot: Controls where to install OS and package updates when the instance boots.  Default is `true`.
        :param pulumi.Input[str] instance_profile_arn: ARN of the instance's IAM profile.
        :param pulumi.Input[str] instance_type: Type of instance to start.
        :param pulumi.Input[str] os: Name of operating system that will be installed.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]] root_block_devices: Configuration block for the root block device of the instance. See Block Devices below.
        :param pulumi.Input[str] root_device_type: Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Associated security groups.
        :param pulumi.Input[str] ssh_key_name: Name of the SSH keypair that instances will have by default.
        :param pulumi.Input[str] state: Desired state of the instance. Valid values are `running` or `stopped`.
        :param pulumi.Input[str] status: Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
        :param pulumi.Input[str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[str] tenancy: Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
        :param pulumi.Input[str] virtualization_type: Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
        """
        pulumi.set(__self__, "layer_ids", layer_ids)
        pulumi.set(__self__, "stack_id", stack_id)
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if auto_scaling_type is not None:
            pulumi.set(__self__, "auto_scaling_type", auto_scaling_type)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_ebs is not None:
            pulumi.set(__self__, "delete_ebs", delete_ebs)
        if delete_eip is not None:
            pulumi.set(__self__, "delete_eip", delete_eip)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if ecs_cluster_arn is not None:
            pulumi.set(__self__, "ecs_cluster_arn", ecs_cluster_arn)
        if elastic_ip is not None:
            pulumi.set(__self__, "elastic_ip", elastic_ip)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if infrastructure_class is not None:
            pulumi.set(__self__, "infrastructure_class", infrastructure_class)
        if install_updates_on_boot is not None:
            pulumi.set(__self__, "install_updates_on_boot", install_updates_on_boot)
        if instance_profile_arn is not None:
            pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if root_block_devices is not None:
            pulumi.set(__self__, "root_block_devices", root_block_devices)
        if root_device_type is not None:
            pulumi.set(__self__, "root_device_type", root_device_type)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if ssh_key_name is not None:
            pulumi.set(__self__, "ssh_key_name", ssh_key_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if virtualization_type is not None:
            pulumi.set(__self__, "virtualization_type", virtualization_type)

    @property
    @pulumi.getter(name="layerIds")
    def layer_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of the layers the instance will belong to.
        """
        return pulumi.get(self, "layer_ids")

    @layer_ids.setter
    def layer_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "layer_ids", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Input[str]:
        """
        Identifier of the stack the instance will belong to.

        The following arguments are optional:
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        OpsWorks agent to install. Default is `INHERIT`.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="autoScalingType")
    def auto_scaling_type(self) -> Optional[pulumi.Input[str]]:
        """
        Creates load-based or time-based instances.  Valid values are `load`, `timer`.
        """
        return pulumi.get(self, "auto_scaling_type")

    @auto_scaling_type.setter
    def auto_scaling_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_scaling_type", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the availability zone where instances will be created by default.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time that the instance was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteEbs")
    def delete_ebs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete EBS volume on deletion. Default is `true`.
        """
        return pulumi.get(self, "delete_ebs")

    @delete_ebs.setter
    def delete_ebs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_ebs", value)

    @property
    @pulumi.getter(name="deleteEip")
    def delete_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete the Elastic IP on deletion.
        """
        return pulumi.get(self, "delete_eip")

    @delete_eip.setter
    def delete_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_eip", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]:
        """
        Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the launched EC2 instance will be EBS-optimized.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="ecsClusterArn")
    def ecs_cluster_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ECS cluster's ARN for container instances.
        """
        return pulumi.get(self, "ecs_cluster_arn")

    @ecs_cluster_arn.setter
    def ecs_cluster_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_cluster_arn", value)

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Instance Elastic IP address.
        """
        return pulumi.get(self, "elastic_ip")

    @elastic_ip.setter
    def elastic_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_ip", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]:
        """
        Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Instance's host name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="infrastructureClass")
    def infrastructure_class(self) -> Optional[pulumi.Input[str]]:
        """
        For registered instances, infrastructure class: ec2 or on-premises.
        """
        return pulumi.get(self, "infrastructure_class")

    @infrastructure_class.setter
    def infrastructure_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infrastructure_class", value)

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Controls where to install OS and package updates when the instance boots.  Default is `true`.
        """
        return pulumi.get(self, "install_updates_on_boot")

    @install_updates_on_boot.setter
    def install_updates_on_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_updates_on_boot", value)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the instance's IAM profile.
        """
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of instance to start.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Name of operating system that will be installed.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="rootBlockDevices")
    def root_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]]]:
        """
        Configuration block for the root block device of the instance. See Block Devices below.
        """
        return pulumi.get(self, "root_block_devices")

    @root_block_devices.setter
    def root_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]]]):
        pulumi.set(self, "root_block_devices", value)

    @property
    @pulumi.getter(name="rootDeviceType")
    def root_device_type(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
        """
        return pulumi.get(self, "root_device_type")

    @root_device_type.setter
    def root_device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_device_type", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Associated security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SSH keypair that instances will have by default.
        """
        return pulumi.get(self, "ssh_key_name")

    @ssh_key_name.setter
    def ssh_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Desired state of the instance. Valid values are `running` or `stopped`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet ID to attach to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[str]]:
        """
        Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> Optional[pulumi.Input[str]]:
        """
        Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
        """
        return pulumi.get(self, "virtualization_type")

    @virtualization_type.setter
    def virtualization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtualization_type", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 auto_scaling_type: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_ebs: Optional[pulumi.Input[bool]] = None,
                 delete_eip: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 ec2_instance_id: Optional[pulumi.Input[str]] = None,
                 ecs_cluster_arn: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 infrastructure_class: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 last_service_error_id: Optional[pulumi.Input[str]] = None,
                 layer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 private_dns: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_dns: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 registered_by: Optional[pulumi.Input[str]] = None,
                 reported_agent_version: Optional[pulumi.Input[str]] = None,
                 reported_os_family: Optional[pulumi.Input[str]] = None,
                 reported_os_name: Optional[pulumi.Input[str]] = None,
                 reported_os_version: Optional[pulumi.Input[str]] = None,
                 root_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]]] = None,
                 root_device_type: Optional[pulumi.Input[str]] = None,
                 root_device_volume_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_host_dsa_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 ssh_host_rsa_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 virtualization_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] agent_version: OpsWorks agent to install. Default is `INHERIT`.
        :param pulumi.Input[str] ami_id: AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
        :param pulumi.Input[str] architecture: Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
        :param pulumi.Input[str] auto_scaling_type: Creates load-based or time-based instances.  Valid values are `load`, `timer`.
        :param pulumi.Input[str] availability_zone: Name of the availability zone where instances will be created by default.
        :param pulumi.Input[str] created_at: Time that the instance was created.
        :param pulumi.Input[bool] delete_ebs: Whether to delete EBS volume on deletion. Default is `true`.
        :param pulumi.Input[bool] delete_eip: Whether to delete the Elastic IP on deletion.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]] ebs_block_devices: Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
        :param pulumi.Input[bool] ebs_optimized: Whether the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input[str] ec2_instance_id: EC2 instance ID.
        :param pulumi.Input[str] ecs_cluster_arn: ECS cluster's ARN for container instances.
        :param pulumi.Input[str] elastic_ip: Instance Elastic IP address.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]] ephemeral_block_devices: Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
        :param pulumi.Input[str] hostname: Instance's host name.
        :param pulumi.Input[str] infrastructure_class: For registered instances, infrastructure class: ec2 or on-premises.
        :param pulumi.Input[bool] install_updates_on_boot: Controls where to install OS and package updates when the instance boots.  Default is `true`.
        :param pulumi.Input[str] instance_profile_arn: ARN of the instance's IAM profile.
        :param pulumi.Input[str] instance_type: Type of instance to start.
        :param pulumi.Input[str] last_service_error_id: ID of the last service error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layer_ids: List of the layers the instance will belong to.
        :param pulumi.Input[str] os: Name of operating system that will be installed.
        :param pulumi.Input[str] platform: Instance's platform.
        :param pulumi.Input[str] private_dns: Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] private_ip: Private IP address assigned to the instance.
        :param pulumi.Input[str] public_dns: Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] public_ip: Public IP address assigned to the instance, if applicable.
        :param pulumi.Input[str] registered_by: For registered instances, who performed the registration.
        :param pulumi.Input[str] reported_agent_version: Instance's reported AWS OpsWorks Stacks agent version.
        :param pulumi.Input[str] reported_os_family: For registered instances, the reported operating system family.
        :param pulumi.Input[str] reported_os_name: For registered instances, the reported operating system name.
        :param pulumi.Input[str] reported_os_version: For registered instances, the reported operating system version.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]] root_block_devices: Configuration block for the root block device of the instance. See Block Devices below.
        :param pulumi.Input[str] root_device_type: Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
        :param pulumi.Input[str] root_device_volume_id: Root device volume ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Associated security groups.
        :param pulumi.Input[str] ssh_host_dsa_key_fingerprint: SSH key's Deep Security Agent (DSA) fingerprint.
        :param pulumi.Input[str] ssh_host_rsa_key_fingerprint: SSH key's RSA fingerprint.
        :param pulumi.Input[str] ssh_key_name: Name of the SSH keypair that instances will have by default.
        :param pulumi.Input[str] stack_id: Identifier of the stack the instance will belong to.
               
               The following arguments are optional:
        :param pulumi.Input[str] state: Desired state of the instance. Valid values are `running` or `stopped`.
        :param pulumi.Input[str] status: Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
        :param pulumi.Input[str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[str] tenancy: Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
        :param pulumi.Input[str] virtualization_type: Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
        """
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if auto_scaling_type is not None:
            pulumi.set(__self__, "auto_scaling_type", auto_scaling_type)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_ebs is not None:
            pulumi.set(__self__, "delete_ebs", delete_ebs)
        if delete_eip is not None:
            pulumi.set(__self__, "delete_eip", delete_eip)
        if ebs_block_devices is not None:
            pulumi.set(__self__, "ebs_block_devices", ebs_block_devices)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if ec2_instance_id is not None:
            pulumi.set(__self__, "ec2_instance_id", ec2_instance_id)
        if ecs_cluster_arn is not None:
            pulumi.set(__self__, "ecs_cluster_arn", ecs_cluster_arn)
        if elastic_ip is not None:
            pulumi.set(__self__, "elastic_ip", elastic_ip)
        if ephemeral_block_devices is not None:
            pulumi.set(__self__, "ephemeral_block_devices", ephemeral_block_devices)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if infrastructure_class is not None:
            pulumi.set(__self__, "infrastructure_class", infrastructure_class)
        if install_updates_on_boot is not None:
            pulumi.set(__self__, "install_updates_on_boot", install_updates_on_boot)
        if instance_profile_arn is not None:
            pulumi.set(__self__, "instance_profile_arn", instance_profile_arn)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if last_service_error_id is not None:
            pulumi.set(__self__, "last_service_error_id", last_service_error_id)
        if layer_ids is not None:
            pulumi.set(__self__, "layer_ids", layer_ids)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if private_dns is not None:
            pulumi.set(__self__, "private_dns", private_dns)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_dns is not None:
            pulumi.set(__self__, "public_dns", public_dns)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if registered_by is not None:
            pulumi.set(__self__, "registered_by", registered_by)
        if reported_agent_version is not None:
            pulumi.set(__self__, "reported_agent_version", reported_agent_version)
        if reported_os_family is not None:
            pulumi.set(__self__, "reported_os_family", reported_os_family)
        if reported_os_name is not None:
            pulumi.set(__self__, "reported_os_name", reported_os_name)
        if reported_os_version is not None:
            pulumi.set(__self__, "reported_os_version", reported_os_version)
        if root_block_devices is not None:
            pulumi.set(__self__, "root_block_devices", root_block_devices)
        if root_device_type is not None:
            pulumi.set(__self__, "root_device_type", root_device_type)
        if root_device_volume_id is not None:
            pulumi.set(__self__, "root_device_volume_id", root_device_volume_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if ssh_host_dsa_key_fingerprint is not None:
            pulumi.set(__self__, "ssh_host_dsa_key_fingerprint", ssh_host_dsa_key_fingerprint)
        if ssh_host_rsa_key_fingerprint is not None:
            pulumi.set(__self__, "ssh_host_rsa_key_fingerprint", ssh_host_rsa_key_fingerprint)
        if ssh_key_name is not None:
            pulumi.set(__self__, "ssh_key_name", ssh_key_name)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if virtualization_type is not None:
            pulumi.set(__self__, "virtualization_type", virtualization_type)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        OpsWorks agent to install. Default is `INHERIT`.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter(name="autoScalingType")
    def auto_scaling_type(self) -> Optional[pulumi.Input[str]]:
        """
        Creates load-based or time-based instances.  Valid values are `load`, `timer`.
        """
        return pulumi.get(self, "auto_scaling_type")

    @auto_scaling_type.setter
    def auto_scaling_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_scaling_type", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the availability zone where instances will be created by default.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time that the instance was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteEbs")
    def delete_ebs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete EBS volume on deletion. Default is `true`.
        """
        return pulumi.get(self, "delete_ebs")

    @delete_ebs.setter
    def delete_ebs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_ebs", value)

    @property
    @pulumi.getter(name="deleteEip")
    def delete_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete the Elastic IP on deletion.
        """
        return pulumi.get(self, "delete_eip")

    @delete_eip.setter
    def delete_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_eip", value)

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]:
        """
        Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @ebs_block_devices.setter
    def ebs_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEbsBlockDeviceArgs']]]]):
        pulumi.set(self, "ebs_block_devices", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the launched EC2 instance will be EBS-optimized.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="ec2InstanceId")
    def ec2_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        EC2 instance ID.
        """
        return pulumi.get(self, "ec2_instance_id")

    @ec2_instance_id.setter
    def ec2_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ec2_instance_id", value)

    @property
    @pulumi.getter(name="ecsClusterArn")
    def ecs_cluster_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ECS cluster's ARN for container instances.
        """
        return pulumi.get(self, "ecs_cluster_arn")

    @ecs_cluster_arn.setter
    def ecs_cluster_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs_cluster_arn", value)

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Instance Elastic IP address.
        """
        return pulumi.get(self, "elastic_ip")

    @elastic_ip.setter
    def elastic_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastic_ip", value)

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]:
        """
        Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @ephemeral_block_devices.setter
    def ephemeral_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEphemeralBlockDeviceArgs']]]]):
        pulumi.set(self, "ephemeral_block_devices", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Instance's host name.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="infrastructureClass")
    def infrastructure_class(self) -> Optional[pulumi.Input[str]]:
        """
        For registered instances, infrastructure class: ec2 or on-premises.
        """
        return pulumi.get(self, "infrastructure_class")

    @infrastructure_class.setter
    def infrastructure_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infrastructure_class", value)

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Controls where to install OS and package updates when the instance boots.  Default is `true`.
        """
        return pulumi.get(self, "install_updates_on_boot")

    @install_updates_on_boot.setter
    def install_updates_on_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_updates_on_boot", value)

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the instance's IAM profile.
        """
        return pulumi.get(self, "instance_profile_arn")

    @instance_profile_arn.setter
    def instance_profile_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_arn", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of instance to start.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="lastServiceErrorId")
    def last_service_error_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the last service error.
        """
        return pulumi.get(self, "last_service_error_id")

    @last_service_error_id.setter
    def last_service_error_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_service_error_id", value)

    @property
    @pulumi.getter(name="layerIds")
    def layer_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the layers the instance will belong to.
        """
        return pulumi.get(self, "layer_ids")

    @layer_ids.setter
    def layer_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layer_ids", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Name of operating system that will be installed.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        Instance's platform.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> Optional[pulumi.Input[str]]:
        """
        Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "private_dns")

    @private_dns.setter
    def private_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Private IP address assigned to the instance.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> Optional[pulumi.Input[str]]:
        """
        Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "public_dns")

    @public_dns.setter
    def public_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_dns", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address assigned to the instance, if applicable.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="registeredBy")
    def registered_by(self) -> Optional[pulumi.Input[str]]:
        """
        For registered instances, who performed the registration.
        """
        return pulumi.get(self, "registered_by")

    @registered_by.setter
    def registered_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registered_by", value)

    @property
    @pulumi.getter(name="reportedAgentVersion")
    def reported_agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Instance's reported AWS OpsWorks Stacks agent version.
        """
        return pulumi.get(self, "reported_agent_version")

    @reported_agent_version.setter
    def reported_agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reported_agent_version", value)

    @property
    @pulumi.getter(name="reportedOsFamily")
    def reported_os_family(self) -> Optional[pulumi.Input[str]]:
        """
        For registered instances, the reported operating system family.
        """
        return pulumi.get(self, "reported_os_family")

    @reported_os_family.setter
    def reported_os_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reported_os_family", value)

    @property
    @pulumi.getter(name="reportedOsName")
    def reported_os_name(self) -> Optional[pulumi.Input[str]]:
        """
        For registered instances, the reported operating system name.
        """
        return pulumi.get(self, "reported_os_name")

    @reported_os_name.setter
    def reported_os_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reported_os_name", value)

    @property
    @pulumi.getter(name="reportedOsVersion")
    def reported_os_version(self) -> Optional[pulumi.Input[str]]:
        """
        For registered instances, the reported operating system version.
        """
        return pulumi.get(self, "reported_os_version")

    @reported_os_version.setter
    def reported_os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reported_os_version", value)

    @property
    @pulumi.getter(name="rootBlockDevices")
    def root_block_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]]]:
        """
        Configuration block for the root block device of the instance. See Block Devices below.
        """
        return pulumi.get(self, "root_block_devices")

    @root_block_devices.setter
    def root_block_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceRootBlockDeviceArgs']]]]):
        pulumi.set(self, "root_block_devices", value)

    @property
    @pulumi.getter(name="rootDeviceType")
    def root_device_type(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
        """
        return pulumi.get(self, "root_device_type")

    @root_device_type.setter
    def root_device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_device_type", value)

    @property
    @pulumi.getter(name="rootDeviceVolumeId")
    def root_device_volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        Root device volume ID.
        """
        return pulumi.get(self, "root_device_volume_id")

    @root_device_volume_id.setter
    def root_device_volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_device_volume_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Associated security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="sshHostDsaKeyFingerprint")
    def ssh_host_dsa_key_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        SSH key's Deep Security Agent (DSA) fingerprint.
        """
        return pulumi.get(self, "ssh_host_dsa_key_fingerprint")

    @ssh_host_dsa_key_fingerprint.setter
    def ssh_host_dsa_key_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_host_dsa_key_fingerprint", value)

    @property
    @pulumi.getter(name="sshHostRsaKeyFingerprint")
    def ssh_host_rsa_key_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        SSH key's RSA fingerprint.
        """
        return pulumi.get(self, "ssh_host_rsa_key_fingerprint")

    @ssh_host_rsa_key_fingerprint.setter
    def ssh_host_rsa_key_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_host_rsa_key_fingerprint", value)

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the SSH keypair that instances will have by default.
        """
        return pulumi.get(self, "ssh_key_name")

    @ssh_key_name.setter
    def ssh_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_key_name", value)

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the stack the instance will belong to.

        The following arguments are optional:
        """
        return pulumi.get(self, "stack_id")

    @stack_id.setter
    def stack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Desired state of the instance. Valid values are `running` or `stopped`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet ID to attach to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[str]]:
        """
        Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> Optional[pulumi.Input[str]]:
        """
        Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
        """
        return pulumi.get(self, "virtualization_type")

    @virtualization_type.setter
    def virtualization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtualization_type", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 auto_scaling_type: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_ebs: Optional[pulumi.Input[bool]] = None,
                 delete_eip: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 ecs_cluster_arn: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 infrastructure_class: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 layer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 root_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]]]] = None,
                 root_device_type: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 virtualization_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an OpsWorks instance resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_instance = aws.opsworks.Instance("my-instance",
            stack_id=main["id"],
            layer_ids=[my_layer["id"]],
            instance_type="t2.micro",
            os="Amazon Linux 2015.09",
            state="stopped")
        ```

        ## Block devices

        Each of the `*_block_device` attributes controls a portion of the AWS
        Instance's "Block Device Mapping". It's a good idea to familiarize yourself with [AWS's Block Device
        Mapping docs](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
        to understand the implications of using these attributes.

        ### `ebs_block_device`

        * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
        * `device_name` - (Required) Name of the device to mount.
        * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
        * `snapshot_id` - (Optional) Snapshot ID to mount.
        * `volume_size` - (Optional) Size of the volume in gigabytes.
        * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.

        Modifying any `ebs_block_device` currently requires resource replacement.

        ### `ephemeral_block_device`

        * `device_name` - Name of the block device to mount on the instance.
        * `virtual_name` - The [Instance Store Device Name](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).

        Each AWS Instance type has a different set of Instance Store block devices
        available for attachment. AWS [publishes a
        list](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes)
        of which ephemeral devices are available on each type. The devices are always
        identified by the `virtual_name` in the format `ephemeral{0..N}`.

        ### `root_block_device`

        * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
        * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
        * `volume_size` - (Optional) Size of the volume in gigabytes.
        * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.

        Modifying any of the `root_block_device` settings requires resource
        replacement.

        > **NOTE:** Currently, changes to `*_block_device` configuration of _existing_
        resources cannot be automatically detected by this provider. After making updates
        to block device configuration, resource recreation can be manually triggered by
        using the [`up` command with the --replace argument](https://www.pulumi.com/docs/reference/cli/pulumi_up/).

        ## Import

        Using `pulumi import`, import Opsworks Instances using the instance `id`. For example:

        ```sh
        $ pulumi import aws:opsworks/instance:Instance my_instance 4d6d1710-ded9-42a1-b08e-b043ad7af1e2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] agent_version: OpsWorks agent to install. Default is `INHERIT`.
        :param pulumi.Input[str] ami_id: AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
        :param pulumi.Input[str] architecture: Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
        :param pulumi.Input[str] auto_scaling_type: Creates load-based or time-based instances.  Valid values are `load`, `timer`.
        :param pulumi.Input[str] availability_zone: Name of the availability zone where instances will be created by default.
        :param pulumi.Input[str] created_at: Time that the instance was created.
        :param pulumi.Input[bool] delete_ebs: Whether to delete EBS volume on deletion. Default is `true`.
        :param pulumi.Input[bool] delete_eip: Whether to delete the Elastic IP on deletion.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]] ebs_block_devices: Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
        :param pulumi.Input[bool] ebs_optimized: Whether the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input[str] ecs_cluster_arn: ECS cluster's ARN for container instances.
        :param pulumi.Input[str] elastic_ip: Instance Elastic IP address.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
        :param pulumi.Input[str] hostname: Instance's host name.
        :param pulumi.Input[str] infrastructure_class: For registered instances, infrastructure class: ec2 or on-premises.
        :param pulumi.Input[bool] install_updates_on_boot: Controls where to install OS and package updates when the instance boots.  Default is `true`.
        :param pulumi.Input[str] instance_profile_arn: ARN of the instance's IAM profile.
        :param pulumi.Input[str] instance_type: Type of instance to start.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layer_ids: List of the layers the instance will belong to.
        :param pulumi.Input[str] os: Name of operating system that will be installed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]]] root_block_devices: Configuration block for the root block device of the instance. See Block Devices below.
        :param pulumi.Input[str] root_device_type: Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Associated security groups.
        :param pulumi.Input[str] ssh_key_name: Name of the SSH keypair that instances will have by default.
        :param pulumi.Input[str] stack_id: Identifier of the stack the instance will belong to.
               
               The following arguments are optional:
        :param pulumi.Input[str] state: Desired state of the instance. Valid values are `running` or `stopped`.
        :param pulumi.Input[str] status: Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
        :param pulumi.Input[str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[str] tenancy: Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
        :param pulumi.Input[str] virtualization_type: Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OpsWorks instance resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_instance = aws.opsworks.Instance("my-instance",
            stack_id=main["id"],
            layer_ids=[my_layer["id"]],
            instance_type="t2.micro",
            os="Amazon Linux 2015.09",
            state="stopped")
        ```

        ## Block devices

        Each of the `*_block_device` attributes controls a portion of the AWS
        Instance's "Block Device Mapping". It's a good idea to familiarize yourself with [AWS's Block Device
        Mapping docs](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
        to understand the implications of using these attributes.

        ### `ebs_block_device`

        * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
        * `device_name` - (Required) Name of the device to mount.
        * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
        * `snapshot_id` - (Optional) Snapshot ID to mount.
        * `volume_size` - (Optional) Size of the volume in gigabytes.
        * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.

        Modifying any `ebs_block_device` currently requires resource replacement.

        ### `ephemeral_block_device`

        * `device_name` - Name of the block device to mount on the instance.
        * `virtual_name` - The [Instance Store Device Name](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames) (e.g., `ephemeral0`).

        Each AWS Instance type has a different set of Instance Store block devices
        available for attachment. AWS [publishes a
        list](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#StorageOnInstanceTypes)
        of which ephemeral devices are available on each type. The devices are always
        identified by the `virtual_name` in the format `ephemeral{0..N}`.

        ### `root_block_device`

        * `delete_on_termination` - (Optional) Whether the volume should be destroyed on instance termination. Default is `true`.
        * `iops` - (Optional) Amount of provisioned [IOPS](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). This must be set with a `volume_type` of `io1`.
        * `volume_size` - (Optional) Size of the volume in gigabytes.
        * `volume_type` - (Optional) Type of volume. Valid values are `standard`, `gp2`, or `io1`. Default is `standard`.

        Modifying any of the `root_block_device` settings requires resource
        replacement.

        > **NOTE:** Currently, changes to `*_block_device` configuration of _existing_
        resources cannot be automatically detected by this provider. After making updates
        to block device configuration, resource recreation can be manually triggered by
        using the [`up` command with the --replace argument](https://www.pulumi.com/docs/reference/cli/pulumi_up/).

        ## Import

        Using `pulumi import`, import Opsworks Instances using the instance `id`. For example:

        ```sh
        $ pulumi import aws:opsworks/instance:Instance my_instance 4d6d1710-ded9-42a1-b08e-b043ad7af1e2
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 auto_scaling_type: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_ebs: Optional[pulumi.Input[bool]] = None,
                 delete_eip: Optional[pulumi.Input[bool]] = None,
                 ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 ecs_cluster_arn: Optional[pulumi.Input[str]] = None,
                 elastic_ip: Optional[pulumi.Input[str]] = None,
                 ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 infrastructure_class: Optional[pulumi.Input[str]] = None,
                 install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
                 instance_profile_arn: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 layer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 root_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]]]] = None,
                 root_device_type: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssh_key_name: Optional[pulumi.Input[str]] = None,
                 stack_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 virtualization_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["agent_version"] = agent_version
            __props__.__dict__["ami_id"] = ami_id
            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["auto_scaling_type"] = auto_scaling_type
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["delete_ebs"] = delete_ebs
            __props__.__dict__["delete_eip"] = delete_eip
            __props__.__dict__["ebs_block_devices"] = ebs_block_devices
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["ecs_cluster_arn"] = ecs_cluster_arn
            __props__.__dict__["elastic_ip"] = elastic_ip
            __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["infrastructure_class"] = infrastructure_class
            __props__.__dict__["install_updates_on_boot"] = install_updates_on_boot
            __props__.__dict__["instance_profile_arn"] = instance_profile_arn
            __props__.__dict__["instance_type"] = instance_type
            if layer_ids is None and not opts.urn:
                raise TypeError("Missing required property 'layer_ids'")
            __props__.__dict__["layer_ids"] = layer_ids
            __props__.__dict__["os"] = os
            __props__.__dict__["root_block_devices"] = root_block_devices
            __props__.__dict__["root_device_type"] = root_device_type
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["ssh_key_name"] = ssh_key_name
            if stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_id'")
            __props__.__dict__["stack_id"] = stack_id
            __props__.__dict__["state"] = state
            __props__.__dict__["status"] = status
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tenancy"] = tenancy
            __props__.__dict__["virtualization_type"] = virtualization_type
            __props__.__dict__["ec2_instance_id"] = None
            __props__.__dict__["last_service_error_id"] = None
            __props__.__dict__["platform"] = None
            __props__.__dict__["private_dns"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_dns"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["registered_by"] = None
            __props__.__dict__["reported_agent_version"] = None
            __props__.__dict__["reported_os_family"] = None
            __props__.__dict__["reported_os_name"] = None
            __props__.__dict__["reported_os_version"] = None
            __props__.__dict__["root_device_volume_id"] = None
            __props__.__dict__["ssh_host_dsa_key_fingerprint"] = None
            __props__.__dict__["ssh_host_rsa_key_fingerprint"] = None
        super(Instance, __self__).__init__(
            'aws:opsworks/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_version: Optional[pulumi.Input[str]] = None,
            ami_id: Optional[pulumi.Input[str]] = None,
            architecture: Optional[pulumi.Input[str]] = None,
            auto_scaling_type: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            delete_ebs: Optional[pulumi.Input[bool]] = None,
            delete_eip: Optional[pulumi.Input[bool]] = None,
            ebs_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]]] = None,
            ebs_optimized: Optional[pulumi.Input[bool]] = None,
            ec2_instance_id: Optional[pulumi.Input[str]] = None,
            ecs_cluster_arn: Optional[pulumi.Input[str]] = None,
            elastic_ip: Optional[pulumi.Input[str]] = None,
            ephemeral_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            infrastructure_class: Optional[pulumi.Input[str]] = None,
            install_updates_on_boot: Optional[pulumi.Input[bool]] = None,
            instance_profile_arn: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            last_service_error_id: Optional[pulumi.Input[str]] = None,
            layer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            os: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            private_dns: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            public_dns: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            registered_by: Optional[pulumi.Input[str]] = None,
            reported_agent_version: Optional[pulumi.Input[str]] = None,
            reported_os_family: Optional[pulumi.Input[str]] = None,
            reported_os_name: Optional[pulumi.Input[str]] = None,
            reported_os_version: Optional[pulumi.Input[str]] = None,
            root_block_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]]]] = None,
            root_device_type: Optional[pulumi.Input[str]] = None,
            root_device_volume_id: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ssh_host_dsa_key_fingerprint: Optional[pulumi.Input[str]] = None,
            ssh_host_rsa_key_fingerprint: Optional[pulumi.Input[str]] = None,
            ssh_key_name: Optional[pulumi.Input[str]] = None,
            stack_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tenancy: Optional[pulumi.Input[str]] = None,
            virtualization_type: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] agent_version: OpsWorks agent to install. Default is `INHERIT`.
        :param pulumi.Input[str] ami_id: AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
        :param pulumi.Input[str] architecture: Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
        :param pulumi.Input[str] auto_scaling_type: Creates load-based or time-based instances.  Valid values are `load`, `timer`.
        :param pulumi.Input[str] availability_zone: Name of the availability zone where instances will be created by default.
        :param pulumi.Input[str] created_at: Time that the instance was created.
        :param pulumi.Input[bool] delete_ebs: Whether to delete EBS volume on deletion. Default is `true`.
        :param pulumi.Input[bool] delete_eip: Whether to delete the Elastic IP on deletion.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEbsBlockDeviceArgs', 'InstanceEbsBlockDeviceArgsDict']]]] ebs_block_devices: Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
        :param pulumi.Input[bool] ebs_optimized: Whether the launched EC2 instance will be EBS-optimized.
        :param pulumi.Input[str] ec2_instance_id: EC2 instance ID.
        :param pulumi.Input[str] ecs_cluster_arn: ECS cluster's ARN for container instances.
        :param pulumi.Input[str] elastic_ip: Instance Elastic IP address.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceEphemeralBlockDeviceArgs', 'InstanceEphemeralBlockDeviceArgsDict']]]] ephemeral_block_devices: Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
        :param pulumi.Input[str] hostname: Instance's host name.
        :param pulumi.Input[str] infrastructure_class: For registered instances, infrastructure class: ec2 or on-premises.
        :param pulumi.Input[bool] install_updates_on_boot: Controls where to install OS and package updates when the instance boots.  Default is `true`.
        :param pulumi.Input[str] instance_profile_arn: ARN of the instance's IAM profile.
        :param pulumi.Input[str] instance_type: Type of instance to start.
        :param pulumi.Input[str] last_service_error_id: ID of the last service error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layer_ids: List of the layers the instance will belong to.
        :param pulumi.Input[str] os: Name of operating system that will be installed.
        :param pulumi.Input[str] platform: Instance's platform.
        :param pulumi.Input[str] private_dns: Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] private_ip: Private IP address assigned to the instance.
        :param pulumi.Input[str] public_dns: Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        :param pulumi.Input[str] public_ip: Public IP address assigned to the instance, if applicable.
        :param pulumi.Input[str] registered_by: For registered instances, who performed the registration.
        :param pulumi.Input[str] reported_agent_version: Instance's reported AWS OpsWorks Stacks agent version.
        :param pulumi.Input[str] reported_os_family: For registered instances, the reported operating system family.
        :param pulumi.Input[str] reported_os_name: For registered instances, the reported operating system name.
        :param pulumi.Input[str] reported_os_version: For registered instances, the reported operating system version.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceRootBlockDeviceArgs', 'InstanceRootBlockDeviceArgsDict']]]] root_block_devices: Configuration block for the root block device of the instance. See Block Devices below.
        :param pulumi.Input[str] root_device_type: Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
        :param pulumi.Input[str] root_device_volume_id: Root device volume ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Associated security groups.
        :param pulumi.Input[str] ssh_host_dsa_key_fingerprint: SSH key's Deep Security Agent (DSA) fingerprint.
        :param pulumi.Input[str] ssh_host_rsa_key_fingerprint: SSH key's RSA fingerprint.
        :param pulumi.Input[str] ssh_key_name: Name of the SSH keypair that instances will have by default.
        :param pulumi.Input[str] stack_id: Identifier of the stack the instance will belong to.
               
               The following arguments are optional:
        :param pulumi.Input[str] state: Desired state of the instance. Valid values are `running` or `stopped`.
        :param pulumi.Input[str] status: Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
        :param pulumi.Input[str] subnet_id: Subnet ID to attach to.
        :param pulumi.Input[str] tenancy: Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
        :param pulumi.Input[str] virtualization_type: Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["ami_id"] = ami_id
        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["auto_scaling_type"] = auto_scaling_type
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delete_ebs"] = delete_ebs
        __props__.__dict__["delete_eip"] = delete_eip
        __props__.__dict__["ebs_block_devices"] = ebs_block_devices
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["ec2_instance_id"] = ec2_instance_id
        __props__.__dict__["ecs_cluster_arn"] = ecs_cluster_arn
        __props__.__dict__["elastic_ip"] = elastic_ip
        __props__.__dict__["ephemeral_block_devices"] = ephemeral_block_devices
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["infrastructure_class"] = infrastructure_class
        __props__.__dict__["install_updates_on_boot"] = install_updates_on_boot
        __props__.__dict__["instance_profile_arn"] = instance_profile_arn
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["last_service_error_id"] = last_service_error_id
        __props__.__dict__["layer_ids"] = layer_ids
        __props__.__dict__["os"] = os
        __props__.__dict__["platform"] = platform
        __props__.__dict__["private_dns"] = private_dns
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_dns"] = public_dns
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["registered_by"] = registered_by
        __props__.__dict__["reported_agent_version"] = reported_agent_version
        __props__.__dict__["reported_os_family"] = reported_os_family
        __props__.__dict__["reported_os_name"] = reported_os_name
        __props__.__dict__["reported_os_version"] = reported_os_version
        __props__.__dict__["root_block_devices"] = root_block_devices
        __props__.__dict__["root_device_type"] = root_device_type
        __props__.__dict__["root_device_volume_id"] = root_device_volume_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["ssh_host_dsa_key_fingerprint"] = ssh_host_dsa_key_fingerprint
        __props__.__dict__["ssh_host_rsa_key_fingerprint"] = ssh_host_rsa_key_fingerprint
        __props__.__dict__["ssh_key_name"] = ssh_key_name
        __props__.__dict__["stack_id"] = stack_id
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tenancy"] = tenancy
        __props__.__dict__["virtualization_type"] = virtualization_type
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[Optional[str]]:
        """
        OpsWorks agent to install. Default is `INHERIT`.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> pulumi.Output[str]:
        """
        AMI to use for the instance.  If an AMI is specified, `os` must be `Custom`.
        """
        return pulumi.get(self, "ami_id")

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[str]]:
        """
        Machine architecture for created instances.  Valid values are `x86_64` or `i386`. The default is `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="autoScalingType")
    def auto_scaling_type(self) -> pulumi.Output[Optional[str]]:
        """
        Creates load-based or time-based instances.  Valid values are `load`, `timer`.
        """
        return pulumi.get(self, "auto_scaling_type")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Name of the availability zone where instances will be created by default.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time that the instance was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deleteEbs")
    def delete_ebs(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to delete EBS volume on deletion. Default is `true`.
        """
        return pulumi.get(self, "delete_ebs")

    @property
    @pulumi.getter(name="deleteEip")
    def delete_eip(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to delete the Elastic IP on deletion.
        """
        return pulumi.get(self, "delete_eip")

    @property
    @pulumi.getter(name="ebsBlockDevices")
    def ebs_block_devices(self) -> pulumi.Output[Sequence['outputs.InstanceEbsBlockDevice']]:
        """
        Configuration block for additional EBS block devices to attach to the instance. See Block Devices below.
        """
        return pulumi.get(self, "ebs_block_devices")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the launched EC2 instance will be EBS-optimized.
        """
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="ec2InstanceId")
    def ec2_instance_id(self) -> pulumi.Output[str]:
        """
        EC2 instance ID.
        """
        return pulumi.get(self, "ec2_instance_id")

    @property
    @pulumi.getter(name="ecsClusterArn")
    def ecs_cluster_arn(self) -> pulumi.Output[str]:
        """
        ECS cluster's ARN for container instances.
        """
        return pulumi.get(self, "ecs_cluster_arn")

    @property
    @pulumi.getter(name="elasticIp")
    def elastic_ip(self) -> pulumi.Output[str]:
        """
        Instance Elastic IP address.
        """
        return pulumi.get(self, "elastic_ip")

    @property
    @pulumi.getter(name="ephemeralBlockDevices")
    def ephemeral_block_devices(self) -> pulumi.Output[Sequence['outputs.InstanceEphemeralBlockDevice']]:
        """
        Configuration block for ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below.
        """
        return pulumi.get(self, "ephemeral_block_devices")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        Instance's host name.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="infrastructureClass")
    def infrastructure_class(self) -> pulumi.Output[str]:
        """
        For registered instances, infrastructure class: ec2 or on-premises.
        """
        return pulumi.get(self, "infrastructure_class")

    @property
    @pulumi.getter(name="installUpdatesOnBoot")
    def install_updates_on_boot(self) -> pulumi.Output[Optional[bool]]:
        """
        Controls where to install OS and package updates when the instance boots.  Default is `true`.
        """
        return pulumi.get(self, "install_updates_on_boot")

    @property
    @pulumi.getter(name="instanceProfileArn")
    def instance_profile_arn(self) -> pulumi.Output[str]:
        """
        ARN of the instance's IAM profile.
        """
        return pulumi.get(self, "instance_profile_arn")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of instance to start.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lastServiceErrorId")
    def last_service_error_id(self) -> pulumi.Output[str]:
        """
        ID of the last service error.
        """
        return pulumi.get(self, "last_service_error_id")

    @property
    @pulumi.getter(name="layerIds")
    def layer_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of the layers the instance will belong to.
        """
        return pulumi.get(self, "layer_ids")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[str]:
        """
        Name of operating system that will be installed.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        Instance's platform.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="privateDns")
    def private_dns(self) -> pulumi.Output[str]:
        """
        Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "private_dns")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        Private IP address assigned to the instance.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicDns")
    def public_dns(self) -> pulumi.Output[str]:
        """
        Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
        """
        return pulumi.get(self, "public_dns")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Public IP address assigned to the instance, if applicable.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="registeredBy")
    def registered_by(self) -> pulumi.Output[str]:
        """
        For registered instances, who performed the registration.
        """
        return pulumi.get(self, "registered_by")

    @property
    @pulumi.getter(name="reportedAgentVersion")
    def reported_agent_version(self) -> pulumi.Output[str]:
        """
        Instance's reported AWS OpsWorks Stacks agent version.
        """
        return pulumi.get(self, "reported_agent_version")

    @property
    @pulumi.getter(name="reportedOsFamily")
    def reported_os_family(self) -> pulumi.Output[str]:
        """
        For registered instances, the reported operating system family.
        """
        return pulumi.get(self, "reported_os_family")

    @property
    @pulumi.getter(name="reportedOsName")
    def reported_os_name(self) -> pulumi.Output[str]:
        """
        For registered instances, the reported operating system name.
        """
        return pulumi.get(self, "reported_os_name")

    @property
    @pulumi.getter(name="reportedOsVersion")
    def reported_os_version(self) -> pulumi.Output[str]:
        """
        For registered instances, the reported operating system version.
        """
        return pulumi.get(self, "reported_os_version")

    @property
    @pulumi.getter(name="rootBlockDevices")
    def root_block_devices(self) -> pulumi.Output[Sequence['outputs.InstanceRootBlockDevice']]:
        """
        Configuration block for the root block device of the instance. See Block Devices below.
        """
        return pulumi.get(self, "root_block_devices")

    @property
    @pulumi.getter(name="rootDeviceType")
    def root_device_type(self) -> pulumi.Output[str]:
        """
        Name of the type of root device instances will have by default. Valid values are `ebs` or `instance-store`.
        """
        return pulumi.get(self, "root_device_type")

    @property
    @pulumi.getter(name="rootDeviceVolumeId")
    def root_device_volume_id(self) -> pulumi.Output[str]:
        """
        Root device volume ID.
        """
        return pulumi.get(self, "root_device_volume_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Associated security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="sshHostDsaKeyFingerprint")
    def ssh_host_dsa_key_fingerprint(self) -> pulumi.Output[str]:
        """
        SSH key's Deep Security Agent (DSA) fingerprint.
        """
        return pulumi.get(self, "ssh_host_dsa_key_fingerprint")

    @property
    @pulumi.getter(name="sshHostRsaKeyFingerprint")
    def ssh_host_rsa_key_fingerprint(self) -> pulumi.Output[str]:
        """
        SSH key's RSA fingerprint.
        """
        return pulumi.get(self, "ssh_host_rsa_key_fingerprint")

    @property
    @pulumi.getter(name="sshKeyName")
    def ssh_key_name(self) -> pulumi.Output[str]:
        """
        Name of the SSH keypair that instances will have by default.
        """
        return pulumi.get(self, "ssh_key_name")

    @property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> pulumi.Output[str]:
        """
        Identifier of the stack the instance will belong to.

        The following arguments are optional:
        """
        return pulumi.get(self, "stack_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        Desired state of the instance. Valid values are `running` or `stopped`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Instance status. Will be one of `booting`, `connection_lost`, `online`, `pending`, `rebooting`, `requested`, `running_setup`, `setup_failed`, `shutting_down`, `start_failed`, `stop_failed`, `stopped`, `stopping`, `terminated`, or `terminating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Subnet ID to attach to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tenancy(self) -> pulumi.Output[str]:
        """
        Instance tenancy to use. Valid values are `default`, `dedicated` or `host`.
        """
        return pulumi.get(self, "tenancy")

    @property
    @pulumi.getter(name="virtualizationType")
    def virtualization_type(self) -> pulumi.Output[str]:
        """
        Keyword to choose what virtualization mode created instances will use. Valid values are `paravirtual` or `hvm`.
        """
        return pulumi.get(self, "virtualization_type")

