# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyAliasArgs', 'KeyAlias']

@pulumi.input_type
class KeyAliasArgs:
    def __init__(__self__, *,
                 alias_name: pulumi.Input[str],
                 key_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KeyAlias resource.
        :param pulumi.Input[str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[str] key_arn: ARN of the key.
        """
        pulumi.set(__self__, "alias_name", alias_name)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> pulumi.Input[str]:
        """
        Name of the Key Alias.

        The following arguments are optional:
        """
        return pulumi.get(self, "alias_name")

    @alias_name.setter
    def alias_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "alias_name", value)

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "key_arn")

    @key_arn.setter
    def key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_arn", value)


@pulumi.input_type
class _KeyAliasState:
    def __init__(__self__, *,
                 alias_name: Optional[pulumi.Input[str]] = None,
                 key_arn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KeyAlias resources.
        :param pulumi.Input[str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[str] key_arn: ARN of the key.
        """
        if alias_name is not None:
            pulumi.set(__self__, "alias_name", alias_name)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Key Alias.

        The following arguments are optional:
        """
        return pulumi.get(self, "alias_name")

    @alias_name.setter
    def alias_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias_name", value)

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "key_arn")

    @key_arn.setter
    def key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_arn", value)


class KeyAlias(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_name: Optional[pulumi.Input[str]] = None,
                 key_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Payment Cryptography Control Plane Key Alias.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Payment Cryptography Control Plane Key Alias using the `alias/4681482429376900170`. For example:

        ```sh
        $ pulumi import aws:paymentcryptography/keyAlias:KeyAlias example alias/4681482429376900170
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[str] key_arn: ARN of the key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyAliasArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Payment Cryptography Control Plane Key Alias.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Payment Cryptography Control Plane Key Alias using the `alias/4681482429376900170`. For example:

        ```sh
        $ pulumi import aws:paymentcryptography/keyAlias:KeyAlias example alias/4681482429376900170
        ```

        :param str resource_name: The name of the resource.
        :param KeyAliasArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyAliasArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_name: Optional[pulumi.Input[str]] = None,
                 key_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyAliasArgs.__new__(KeyAliasArgs)

            if alias_name is None and not opts.urn:
                raise TypeError("Missing required property 'alias_name'")
            __props__.__dict__["alias_name"] = alias_name
            __props__.__dict__["key_arn"] = key_arn
        super(KeyAlias, __self__).__init__(
            'aws:paymentcryptography/keyAlias:KeyAlias',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias_name: Optional[pulumi.Input[str]] = None,
            key_arn: Optional[pulumi.Input[str]] = None) -> 'KeyAlias':
        """
        Get an existing KeyAlias resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[str] key_arn: ARN of the key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyAliasState.__new__(_KeyAliasState)

        __props__.__dict__["alias_name"] = alias_name
        __props__.__dict__["key_arn"] = key_arn
        return KeyAlias(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> pulumi.Output[str]:
        """
        Name of the Key Alias.

        The following arguments are optional:
        """
        return pulumi.get(self, "alias_name")

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "key_arn")

