# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppCampaignHook',
    'AppLimits',
    'AppQuietTime',
    'EmailTemplateEmailTemplate',
    'EmailTemplateEmailTemplateHeader',
    'Smsvoicev2PhoneNumberTimeouts',
]

@pulumi.output_type
class AppCampaignHook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaFunctionName":
            suggest = "lambda_function_name"
        elif key == "webUrl":
            suggest = "web_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppCampaignHook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppCampaignHook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppCampaignHook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_function_name: Optional[str] = None,
                 mode: Optional[str] = None,
                 web_url: Optional[str] = None):
        """
        :param str lambda_function_name: Lambda function name or ARN to be called for delivery. Conflicts with `web_url`
        :param str mode: What mode Lambda should be invoked in. Valid values for this parameter are `DELIVERY`, `FILTER`.
        :param str web_url: Web URL to call for hook. If the URL has authentication specified it will be added as authentication to the request. Conflicts with `lambda_function_name`
        """
        if lambda_function_name is not None:
            pulumi.set(__self__, "lambda_function_name", lambda_function_name)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if web_url is not None:
            pulumi.set(__self__, "web_url", web_url)

    @property
    @pulumi.getter(name="lambdaFunctionName")
    def lambda_function_name(self) -> Optional[str]:
        """
        Lambda function name or ARN to be called for delivery. Conflicts with `web_url`
        """
        return pulumi.get(self, "lambda_function_name")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        What mode Lambda should be invoked in. Valid values for this parameter are `DELIVERY`, `FILTER`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> Optional[str]:
        """
        Web URL to call for hook. If the URL has authentication specified it will be added as authentication to the request. Conflicts with `lambda_function_name`
        """
        return pulumi.get(self, "web_url")


@pulumi.output_type
class AppLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumDuration":
            suggest = "maximum_duration"
        elif key == "messagesPerSecond":
            suggest = "messages_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily: Optional[int] = None,
                 maximum_duration: Optional[int] = None,
                 messages_per_second: Optional[int] = None,
                 total: Optional[int] = None):
        """
        :param int daily: The maximum number of messages that the campaign can send daily.
        :param int maximum_duration: The length of time (in seconds) that the campaign can run before it ends and message deliveries stop. This duration begins at the scheduled start time for the campaign. The minimum value is 60.
        :param int messages_per_second: The number of messages that the campaign can send per second. The minimum value is 50, and the maximum is 20000.
        :param int total: The maximum total number of messages that the campaign can send.
        """
        if daily is not None:
            pulumi.set(__self__, "daily", daily)
        if maximum_duration is not None:
            pulumi.set(__self__, "maximum_duration", maximum_duration)
        if messages_per_second is not None:
            pulumi.set(__self__, "messages_per_second", messages_per_second)
        if total is not None:
            pulumi.set(__self__, "total", total)

    @property
    @pulumi.getter
    def daily(self) -> Optional[int]:
        """
        The maximum number of messages that the campaign can send daily.
        """
        return pulumi.get(self, "daily")

    @property
    @pulumi.getter(name="maximumDuration")
    def maximum_duration(self) -> Optional[int]:
        """
        The length of time (in seconds) that the campaign can run before it ends and message deliveries stop. This duration begins at the scheduled start time for the campaign. The minimum value is 60.
        """
        return pulumi.get(self, "maximum_duration")

    @property
    @pulumi.getter(name="messagesPerSecond")
    def messages_per_second(self) -> Optional[int]:
        """
        The number of messages that the campaign can send per second. The minimum value is 50, and the maximum is 20000.
        """
        return pulumi.get(self, "messages_per_second")

    @property
    @pulumi.getter
    def total(self) -> Optional[int]:
        """
        The maximum total number of messages that the campaign can send.
        """
        return pulumi.get(self, "total")


@pulumi.output_type
class AppQuietTime(dict):
    def __init__(__self__, *,
                 end: Optional[str] = None,
                 start: Optional[str] = None):
        """
        :param str end: The default end time for quiet time in ISO 8601 format. Required if `start` is set
        :param str start: The default start time for quiet time in ISO 8601 format. Required if `end` is set
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        The default end time for quiet time in ISO 8601 format. Required if `start` is set
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        The default start time for quiet time in ISO 8601 format. Required if `end` is set
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class EmailTemplateEmailTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultSubstitutions":
            suggest = "default_substitutions"
        elif key == "htmlPart":
            suggest = "html_part"
        elif key == "recommenderId":
            suggest = "recommender_id"
        elif key == "textPart":
            suggest = "text_part"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailTemplateEmailTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailTemplateEmailTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailTemplateEmailTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_substitutions: Optional[str] = None,
                 description: Optional[str] = None,
                 headers: Optional[Sequence['outputs.EmailTemplateEmailTemplateHeader']] = None,
                 html_part: Optional[str] = None,
                 recommender_id: Optional[str] = None,
                 subject: Optional[str] = None,
                 text_part: Optional[str] = None):
        """
        :param str default_substitutions: JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
        :param str html_part: The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
        :param str recommender_id: The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
        :param str subject: Subject line, or title, to use in email messages that are based on the message template.
        :param str text_part: Message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
        """
        if default_substitutions is not None:
            pulumi.set(__self__, "default_substitutions", default_substitutions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if html_part is not None:
            pulumi.set(__self__, "html_part", html_part)
        if recommender_id is not None:
            pulumi.set(__self__, "recommender_id", recommender_id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if text_part is not None:
            pulumi.set(__self__, "text_part", text_part)

    @property
    @pulumi.getter(name="defaultSubstitutions")
    def default_substitutions(self) -> Optional[str]:
        """
        JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that's based on the template, you can override these defaults with message-specific and address-specific variables and values.
        """
        return pulumi.get(self, "default_substitutions")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.EmailTemplateEmailTemplateHeader']]:
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="htmlPart")
    def html_part(self) -> Optional[str]:
        """
        The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
        """
        return pulumi.get(self, "html_part")

    @property
    @pulumi.getter(name="recommenderId")
    def recommender_id(self) -> Optional[str]:
        """
        The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.
        """
        return pulumi.get(self, "recommender_id")

    @property
    @pulumi.getter
    def subject(self) -> Optional[str]:
        """
        Subject line, or title, to use in email messages that are based on the message template.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="textPart")
    def text_part(self) -> Optional[str]:
        """
        Message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
        """
        return pulumi.get(self, "text_part")


@pulumi.output_type
class EmailTemplateEmailTemplateHeader(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: Name of the message header. The header name can contain up to 126 characters.
        :param str value: Value of the message header. The header value can contain up to 870 characters, including the length of any rendered attributes. For example if you add the {CreationDate} attribute, it renders as YYYY-MM-DDTHH:MM:SS.SSSZ and is 24 characters in length.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the message header. The header name can contain up to 126 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of the message header. The header value can contain up to 870 characters, including the length of any rendered attributes. For example if you add the {CreationDate} attribute, it renders as YYYY-MM-DDTHH:MM:SS.SSSZ and is 24 characters in length.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class Smsvoicev2PhoneNumberTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


