# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['ClusterInstanceArgs', 'ClusterInstance']

@pulumi.input_type
class ClusterInstanceArgs:
    def __init__(__self__, *,
                 cluster_identifier: pulumi.Input[str],
                 engine: pulumi.Input[str],
                 instance_class: pulumi.Input[Union[str, 'InstanceType']],
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 promotion_tier: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ClusterInstance resource.
        :param pulumi.Input[str] cluster_identifier: Identifier of the `rds.Cluster` in which to launch this instance.
        :param pulumi.Input[str] engine: Name of the database engine to be used for the RDS cluster instance.
               Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.(Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details. For Aurora Serverless v2 use `db.serverless`.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
        :param pulumi.Input[str] availability_zone: EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[str] ca_cert_identifier: Identifier of the CA certificate for the DB instance.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[str] db_parameter_group_name: Name of the DB parameter group to associate with this instance.
        :param pulumi.Input[str] db_subnet_group_name: Specifies the DB subnet group to associate with this DB instance. The default behavior varies depending on whether `db_subnet_group_name` is specified. Please refer to official [AWS documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-db-instance.html) to understand how `db_subnet_group_name` and `publicly_accessible` parameters affect DB instance behaviour. **NOTE:** This must match the `db_subnet_group_name` of the attached `rds.Cluster`.
        :param pulumi.Input[str] engine_version: Database engine version. Please note that to upgrade the `engine_version` of the instance, it must be done on the `rds.Cluster` `engine_version`. Trying to upgrade in `aws_cluster_instance` will not update the `engine_version`.
        :param pulumi.Input[bool] force_destroy: Forces an instance to be destroyed when a part of a read replica cluster. **Note:** will promote the read replica to a standalone cluster before instance deletion.
        :param pulumi.Input[str] identifier: Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[int] monitoring_interval: Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights is enabled or not.
        :param pulumi.Input[str] performance_insights_kms_key_id: ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[str] preferred_backup_window: Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
        :param pulumi.Input[str] preferred_maintenance_window: Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "instance_class", instance_class)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if ca_cert_identifier is not None:
            pulumi.set(__self__, "ca_cert_identifier", ca_cert_identifier)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if custom_iam_instance_profile is not None:
            pulumi.set(__self__, "custom_iam_instance_profile", custom_iam_instance_profile)
        if db_parameter_group_name is not None:
            pulumi.set(__self__, "db_parameter_group_name", db_parameter_group_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn is not None:
            pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if performance_insights_enabled is not None:
            pulumi.set(__self__, "performance_insights_enabled", performance_insights_enabled)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period is not None:
            pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if promotion_tier is not None:
            pulumi.set(__self__, "promotion_tier", promotion_tier)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Input[str]:
        """
        Identifier of the `rds.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        Name of the database engine to be used for the RDS cluster instance.
        Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.(Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[Union[str, 'InstanceType']]:
        """
        Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details. For Aurora Serverless v2 use `db.serverless`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[Union[str, 'InstanceType']]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the CA certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @ca_cert_identifier.setter
    def ca_cert_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_identifier", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @custom_iam_instance_profile.setter
    def custom_iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_iam_instance_profile", value)

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the DB parameter group to associate with this instance.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @db_parameter_group_name.setter
    def db_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB subnet group to associate with this DB instance. The default behavior varies depending on whether `db_subnet_group_name` is specified. Please refer to official [AWS documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-db-instance.html) to understand how `db_subnet_group_name` and `publicly_accessible` parameters affect DB instance behaviour. **NOTE:** This must match the `db_subnet_group_name` of the attached `rds.Cluster`.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Database engine version. Please note that to upgrade the `engine_version` of the instance, it must be done on the `rds.Cluster` `engine_version`. Trying to upgrade in `aws_cluster_instance` will not update the `engine_version`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces an instance to be destroyed when a part of a read replica cluster. **Note:** will promote the read replica to a standalone cluster before instance deletion.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier_prefix", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
        """
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @monitoring_role_arn.setter
    def monitoring_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitoring_role_arn", value)

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Performance Insights is enabled or not.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @performance_insights_enabled.setter
    def performance_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "performance_insights_enabled", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @performance_insights_retention_period.setter
    def performance_insights_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "performance_insights_retention_period", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[pulumi.Input[int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @promotion_tier.setter
    def promotion_tier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "promotion_tier", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterInstanceState:
    def __init__(__self__, *,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 dbi_resource_id: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 engine_version_actual: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 promotion_tier: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 storage_encrypted: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 writer: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ClusterInstance resources.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of cluster instance
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
        :param pulumi.Input[str] availability_zone: EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[str] ca_cert_identifier: Identifier of the CA certificate for the DB instance.
        :param pulumi.Input[str] cluster_identifier: Identifier of the `rds.Cluster` in which to launch this instance.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[str] db_parameter_group_name: Name of the DB parameter group to associate with this instance.
        :param pulumi.Input[str] db_subnet_group_name: Specifies the DB subnet group to associate with this DB instance. The default behavior varies depending on whether `db_subnet_group_name` is specified. Please refer to official [AWS documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-db-instance.html) to understand how `db_subnet_group_name` and `publicly_accessible` parameters affect DB instance behaviour. **NOTE:** This must match the `db_subnet_group_name` of the attached `rds.Cluster`.
        :param pulumi.Input[str] dbi_resource_id: Region-unique, immutable identifier for the DB instance.
        :param pulumi.Input[str] endpoint: DNS address for this instance. May not be writable
        :param pulumi.Input[str] engine: Name of the database engine to be used for the RDS cluster instance.
               Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.(Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
        :param pulumi.Input[str] engine_version: Database engine version. Please note that to upgrade the `engine_version` of the instance, it must be done on the `rds.Cluster` `engine_version`. Trying to upgrade in `aws_cluster_instance` will not update the `engine_version`.
        :param pulumi.Input[str] engine_version_actual: Database engine version
        :param pulumi.Input[bool] force_destroy: Forces an instance to be destroyed when a part of a read replica cluster. **Note:** will promote the read replica to a standalone cluster before instance deletion.
        :param pulumi.Input[str] identifier: Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details. For Aurora Serverless v2 use `db.serverless`.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS encryption key if one is set to the cluster.
        :param pulumi.Input[int] monitoring_interval: Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[str] network_type: Network type of the DB instance.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights is enabled or not.
        :param pulumi.Input[str] performance_insights_kms_key_id: ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[int] port: Database port
        :param pulumi.Input[str] preferred_backup_window: Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
        :param pulumi.Input[str] preferred_maintenance_window: Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB cluster is encrypted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[bool] writer: Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if ca_cert_identifier is not None:
            pulumi.set(__self__, "ca_cert_identifier", ca_cert_identifier)
        if cluster_identifier is not None:
            pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        if copy_tags_to_snapshot is not None:
            pulumi.set(__self__, "copy_tags_to_snapshot", copy_tags_to_snapshot)
        if custom_iam_instance_profile is not None:
            pulumi.set(__self__, "custom_iam_instance_profile", custom_iam_instance_profile)
        if db_parameter_group_name is not None:
            pulumi.set(__self__, "db_parameter_group_name", db_parameter_group_name)
        if db_subnet_group_name is not None:
            pulumi.set(__self__, "db_subnet_group_name", db_subnet_group_name)
        if dbi_resource_id is not None:
            pulumi.set(__self__, "dbi_resource_id", dbi_resource_id)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if engine_version_actual is not None:
            pulumi.set(__self__, "engine_version_actual", engine_version_actual)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if identifier_prefix is not None:
            pulumi.set(__self__, "identifier_prefix", identifier_prefix)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_role_arn is not None:
            pulumi.set(__self__, "monitoring_role_arn", monitoring_role_arn)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if performance_insights_enabled is not None:
            pulumi.set(__self__, "performance_insights_enabled", performance_insights_enabled)
        if performance_insights_kms_key_id is not None:
            pulumi.set(__self__, "performance_insights_kms_key_id", performance_insights_kms_key_id)
        if performance_insights_retention_period is not None:
            pulumi.set(__self__, "performance_insights_retention_period", performance_insights_retention_period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_backup_window is not None:
            pulumi.set(__self__, "preferred_backup_window", preferred_backup_window)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if promotion_tier is not None:
            pulumi.set(__self__, "promotion_tier", promotion_tier)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if storage_encrypted is not None:
            pulumi.set(__self__, "storage_encrypted", storage_encrypted)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if writer is not None:
            pulumi.set(__self__, "writer", writer)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of cluster instance
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the CA certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @ca_cert_identifier.setter
    def ca_cert_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_identifier", value)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the `rds.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @cluster_identifier.setter
    def cluster_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_identifier", value)

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @copy_tags_to_snapshot.setter
    def copy_tags_to_snapshot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "copy_tags_to_snapshot", value)

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @custom_iam_instance_profile.setter
    def custom_iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_iam_instance_profile", value)

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the DB parameter group to associate with this instance.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @db_parameter_group_name.setter
    def db_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_parameter_group_name", value)

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB subnet group to associate with this DB instance. The default behavior varies depending on whether `db_subnet_group_name` is specified. Please refer to official [AWS documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-db-instance.html) to understand how `db_subnet_group_name` and `publicly_accessible` parameters affect DB instance behaviour. **NOTE:** This must match the `db_subnet_group_name` of the attached `rds.Cluster`.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @db_subnet_group_name.setter
    def db_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_subnet_group_name", value)

    @property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Region-unique, immutable identifier for the DB instance.
        """
        return pulumi.get(self, "dbi_resource_id")

    @dbi_resource_id.setter
    def dbi_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dbi_resource_id", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        DNS address for this instance. May not be writable
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database engine to be used for the RDS cluster instance.
        Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.(Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Database engine version. Please note that to upgrade the `engine_version` of the instance, it must be done on the `rds.Cluster` `engine_version`. Trying to upgrade in `aws_cluster_instance` will not update the `engine_version`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> Optional[pulumi.Input[str]]:
        """
        Database engine version
        """
        return pulumi.get(self, "engine_version_actual")

    @engine_version_actual.setter
    def engine_version_actual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version_actual", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces an instance to be destroyed when a part of a read replica cluster. **Note:** will promote the read replica to a standalone cluster before instance deletion.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @identifier_prefix.setter
    def identifier_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier_prefix", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[Union[str, 'InstanceType']]]:
        """
        Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details. For Aurora Serverless v2 use `db.serverless`.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[Union[str, 'InstanceType']]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS encryption key if one is set to the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
        """
        return pulumi.get(self, "monitoring_interval")

    @monitoring_interval.setter
    def monitoring_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "monitoring_interval", value)

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @monitoring_role_arn.setter
    def monitoring_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitoring_role_arn", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        Network type of the DB instance.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether Performance Insights is enabled or not.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @performance_insights_enabled.setter
    def performance_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "performance_insights_enabled", value)

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @performance_insights_kms_key_id.setter
    def performance_insights_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_insights_kms_key_id", value)

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @performance_insights_retention_period.setter
    def performance_insights_retention_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "performance_insights_retention_period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Database port
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> Optional[pulumi.Input[str]]:
        """
        Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
        """
        return pulumi.get(self, "preferred_backup_window")

    @preferred_backup_window.setter
    def preferred_backup_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_backup_window", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> Optional[pulumi.Input[int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @promotion_tier.setter
    def promotion_tier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "promotion_tier", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the DB cluster is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @storage_encrypted.setter
    def storage_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_encrypted", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def writer(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        return pulumi.get(self, "writer")

    @writer.setter
    def writer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "writer", value)


class ClusterInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 promotion_tier: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an RDS Cluster Instance Resource. A Cluster Instance Resource defines
        attributes that are specific to a single instance in a RDS Cluster,
        specifically running Amazon Aurora.

        Unlike other RDS resources that support replication, with Amazon Aurora you do
        not designate a primary and subsequent replicas. Instead, you simply add RDS
        Instances and Aurora manages the replication. You can use the [count][5]
        meta-parameter to make multiple instances and join them all to the same RDS
        Cluster, or you may specify different Cluster Instance resources with various
        `instance_class` sizes.

        For more information on Amazon Aurora, see [Aurora on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html) in the Amazon RDS User Guide.

        > **NOTE:** Deletion Protection from the RDS service can only be enabled at the cluster level, not for individual cluster instances. You can still add the [`protect` CustomResourceOption](https://www.pulumi.com/docs/intro/concepts/programming-model/#protect) to this resource configuration if you desire protection from accidental deletion.

        > **NOTE:** `aurora` is no longer a valid `engine` because of [Amazon Aurora's MySQL-Compatible Edition version 1 end of life](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.MySQL56.EOL.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.rds.Cluster("default",
            cluster_identifier="aurora-cluster-demo",
            availability_zones=[
                "us-west-2a",
                "us-west-2b",
                "us-west-2c",
            ],
            database_name="mydb",
            master_username="foo",
            master_password="barbut8chars")
        cluster_instances = []
        for range in [{"value": i} for i in range(0, 2)]:
            cluster_instances.append(aws.rds.ClusterInstance(f"cluster_instances-{range['value']}",
                identifier=f"aurora-cluster-demo-{range['value']}",
                cluster_identifier=default.id,
                instance_class=aws.rds.InstanceType.R4_LARGE,
                engine=default.engine,
                engine_version=default.engine_version))
        ```

        ## Import

        Using `pulumi import`, import RDS Cluster Instances using the `identifier`. For example:

        ```sh
        $ pulumi import aws:rds/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
        :param pulumi.Input[str] availability_zone: EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[str] ca_cert_identifier: Identifier of the CA certificate for the DB instance.
        :param pulumi.Input[str] cluster_identifier: Identifier of the `rds.Cluster` in which to launch this instance.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[str] db_parameter_group_name: Name of the DB parameter group to associate with this instance.
        :param pulumi.Input[str] db_subnet_group_name: Specifies the DB subnet group to associate with this DB instance. The default behavior varies depending on whether `db_subnet_group_name` is specified. Please refer to official [AWS documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-db-instance.html) to understand how `db_subnet_group_name` and `publicly_accessible` parameters affect DB instance behaviour. **NOTE:** This must match the `db_subnet_group_name` of the attached `rds.Cluster`.
        :param pulumi.Input[str] engine: Name of the database engine to be used for the RDS cluster instance.
               Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.(Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
        :param pulumi.Input[str] engine_version: Database engine version. Please note that to upgrade the `engine_version` of the instance, it must be done on the `rds.Cluster` `engine_version`. Trying to upgrade in `aws_cluster_instance` will not update the `engine_version`.
        :param pulumi.Input[bool] force_destroy: Forces an instance to be destroyed when a part of a read replica cluster. **Note:** will promote the read replica to a standalone cluster before instance deletion.
        :param pulumi.Input[str] identifier: Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details. For Aurora Serverless v2 use `db.serverless`.
        :param pulumi.Input[int] monitoring_interval: Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights is enabled or not.
        :param pulumi.Input[str] performance_insights_kms_key_id: ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[str] preferred_backup_window: Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
        :param pulumi.Input[str] preferred_maintenance_window: Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an RDS Cluster Instance Resource. A Cluster Instance Resource defines
        attributes that are specific to a single instance in a RDS Cluster,
        specifically running Amazon Aurora.

        Unlike other RDS resources that support replication, with Amazon Aurora you do
        not designate a primary and subsequent replicas. Instead, you simply add RDS
        Instances and Aurora manages the replication. You can use the [count][5]
        meta-parameter to make multiple instances and join them all to the same RDS
        Cluster, or you may specify different Cluster Instance resources with various
        `instance_class` sizes.

        For more information on Amazon Aurora, see [Aurora on Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html) in the Amazon RDS User Guide.

        > **NOTE:** Deletion Protection from the RDS service can only be enabled at the cluster level, not for individual cluster instances. You can still add the [`protect` CustomResourceOption](https://www.pulumi.com/docs/intro/concepts/programming-model/#protect) to this resource configuration if you desire protection from accidental deletion.

        > **NOTE:** `aurora` is no longer a valid `engine` because of [Amazon Aurora's MySQL-Compatible Edition version 1 end of life](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.MySQL56.EOL.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        default = aws.rds.Cluster("default",
            cluster_identifier="aurora-cluster-demo",
            availability_zones=[
                "us-west-2a",
                "us-west-2b",
                "us-west-2c",
            ],
            database_name="mydb",
            master_username="foo",
            master_password="barbut8chars")
        cluster_instances = []
        for range in [{"value": i} for i in range(0, 2)]:
            cluster_instances.append(aws.rds.ClusterInstance(f"cluster_instances-{range['value']}",
                identifier=f"aurora-cluster-demo-{range['value']}",
                cluster_identifier=default.id,
                instance_class=aws.rds.InstanceType.R4_LARGE,
                engine=default.engine,
                engine_version=default.engine_version))
        ```

        ## Import

        Using `pulumi import`, import RDS Cluster Instances using the `identifier`. For example:

        ```sh
        $ pulumi import aws:rds/clusterInstance:ClusterInstance prod_instance_1 aurora-cluster-instance-1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 ca_cert_identifier: Optional[pulumi.Input[str]] = None,
                 cluster_identifier: Optional[pulumi.Input[str]] = None,
                 copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
                 custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 db_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 identifier_prefix: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
                 monitoring_interval: Optional[pulumi.Input[int]] = None,
                 monitoring_role_arn: Optional[pulumi.Input[str]] = None,
                 performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
                 performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
                 preferred_backup_window: Optional[pulumi.Input[str]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 promotion_tier: Optional[pulumi.Input[int]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterInstanceArgs.__new__(ClusterInstanceArgs)

            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["ca_cert_identifier"] = ca_cert_identifier
            if cluster_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_identifier'")
            __props__.__dict__["cluster_identifier"] = cluster_identifier
            __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
            __props__.__dict__["custom_iam_instance_profile"] = custom_iam_instance_profile
            __props__.__dict__["db_parameter_group_name"] = db_parameter_group_name
            __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["identifier_prefix"] = identifier_prefix
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            __props__.__dict__["monitoring_interval"] = monitoring_interval
            __props__.__dict__["monitoring_role_arn"] = monitoring_role_arn
            __props__.__dict__["performance_insights_enabled"] = performance_insights_enabled
            __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
            __props__.__dict__["performance_insights_retention_period"] = performance_insights_retention_period
            __props__.__dict__["preferred_backup_window"] = preferred_backup_window
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["promotion_tier"] = promotion_tier
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["dbi_resource_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["engine_version_actual"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["network_type"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["storage_encrypted"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["writer"] = None
        super(ClusterInstance, __self__).__init__(
            'aws:rds/clusterInstance:ClusterInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_immediately: Optional[pulumi.Input[bool]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            ca_cert_identifier: Optional[pulumi.Input[str]] = None,
            cluster_identifier: Optional[pulumi.Input[str]] = None,
            copy_tags_to_snapshot: Optional[pulumi.Input[bool]] = None,
            custom_iam_instance_profile: Optional[pulumi.Input[str]] = None,
            db_parameter_group_name: Optional[pulumi.Input[str]] = None,
            db_subnet_group_name: Optional[pulumi.Input[str]] = None,
            dbi_resource_id: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            engine_version_actual: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            identifier_prefix: Optional[pulumi.Input[str]] = None,
            instance_class: Optional[pulumi.Input[Union[str, 'InstanceType']]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            monitoring_interval: Optional[pulumi.Input[int]] = None,
            monitoring_role_arn: Optional[pulumi.Input[str]] = None,
            network_type: Optional[pulumi.Input[str]] = None,
            performance_insights_enabled: Optional[pulumi.Input[bool]] = None,
            performance_insights_kms_key_id: Optional[pulumi.Input[str]] = None,
            performance_insights_retention_period: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[int]] = None,
            preferred_backup_window: Optional[pulumi.Input[str]] = None,
            preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
            promotion_tier: Optional[pulumi.Input[int]] = None,
            publicly_accessible: Optional[pulumi.Input[bool]] = None,
            storage_encrypted: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            writer: Optional[pulumi.Input[bool]] = None) -> 'ClusterInstance':
        """
        Get an existing ClusterInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_immediately: Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
        :param pulumi.Input[str] arn: Amazon Resource Name (ARN) of cluster instance
        :param pulumi.Input[bool] auto_minor_version_upgrade: Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
        :param pulumi.Input[str] availability_zone: EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
        :param pulumi.Input[str] ca_cert_identifier: Identifier of the CA certificate for the DB instance.
        :param pulumi.Input[str] cluster_identifier: Identifier of the `rds.Cluster` in which to launch this instance.
        :param pulumi.Input[bool] copy_tags_to_snapshot: Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
        :param pulumi.Input[str] custom_iam_instance_profile: Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        :param pulumi.Input[str] db_parameter_group_name: Name of the DB parameter group to associate with this instance.
        :param pulumi.Input[str] db_subnet_group_name: Specifies the DB subnet group to associate with this DB instance. The default behavior varies depending on whether `db_subnet_group_name` is specified. Please refer to official [AWS documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-db-instance.html) to understand how `db_subnet_group_name` and `publicly_accessible` parameters affect DB instance behaviour. **NOTE:** This must match the `db_subnet_group_name` of the attached `rds.Cluster`.
        :param pulumi.Input[str] dbi_resource_id: Region-unique, immutable identifier for the DB instance.
        :param pulumi.Input[str] endpoint: DNS address for this instance. May not be writable
        :param pulumi.Input[str] engine: Name of the database engine to be used for the RDS cluster instance.
               Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.(Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
        :param pulumi.Input[str] engine_version: Database engine version. Please note that to upgrade the `engine_version` of the instance, it must be done on the `rds.Cluster` `engine_version`. Trying to upgrade in `aws_cluster_instance` will not update the `engine_version`.
        :param pulumi.Input[str] engine_version_actual: Database engine version
        :param pulumi.Input[bool] force_destroy: Forces an instance to be destroyed when a part of a read replica cluster. **Note:** will promote the read replica to a standalone cluster before instance deletion.
        :param pulumi.Input[str] identifier: Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
        :param pulumi.Input[str] identifier_prefix: Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        :param pulumi.Input[Union[str, 'InstanceType']] instance_class: Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details. For Aurora Serverless v2 use `db.serverless`.
        :param pulumi.Input[str] kms_key_id: ARN for the KMS encryption key if one is set to the cluster.
        :param pulumi.Input[int] monitoring_interval: Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
        :param pulumi.Input[str] monitoring_role_arn: ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        :param pulumi.Input[str] network_type: Network type of the DB instance.
        :param pulumi.Input[bool] performance_insights_enabled: Specifies whether Performance Insights is enabled or not.
        :param pulumi.Input[str] performance_insights_kms_key_id: ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
        :param pulumi.Input[int] performance_insights_retention_period: Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        :param pulumi.Input[int] port: Database port
        :param pulumi.Input[str] preferred_backup_window: Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
        :param pulumi.Input[str] preferred_maintenance_window: Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        :param pulumi.Input[int] promotion_tier: Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
        :param pulumi.Input[bool] publicly_accessible: Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
        :param pulumi.Input[bool] storage_encrypted: Specifies whether the DB cluster is encrypted.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[bool] writer: Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterInstanceState.__new__(_ClusterInstanceState)

        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["ca_cert_identifier"] = ca_cert_identifier
        __props__.__dict__["cluster_identifier"] = cluster_identifier
        __props__.__dict__["copy_tags_to_snapshot"] = copy_tags_to_snapshot
        __props__.__dict__["custom_iam_instance_profile"] = custom_iam_instance_profile
        __props__.__dict__["db_parameter_group_name"] = db_parameter_group_name
        __props__.__dict__["db_subnet_group_name"] = db_subnet_group_name
        __props__.__dict__["dbi_resource_id"] = dbi_resource_id
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["engine_version_actual"] = engine_version_actual
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["identifier_prefix"] = identifier_prefix
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["monitoring_interval"] = monitoring_interval
        __props__.__dict__["monitoring_role_arn"] = monitoring_role_arn
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["performance_insights_enabled"] = performance_insights_enabled
        __props__.__dict__["performance_insights_kms_key_id"] = performance_insights_kms_key_id
        __props__.__dict__["performance_insights_retention_period"] = performance_insights_retention_period
        __props__.__dict__["port"] = port
        __props__.__dict__["preferred_backup_window"] = preferred_backup_window
        __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
        __props__.__dict__["promotion_tier"] = promotion_tier
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["storage_encrypted"] = storage_encrypted
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["writer"] = writer
        return ClusterInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[bool]:
        """
        Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
        """
        return pulumi.get(self, "apply_immediately")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (ARN) of cluster instance
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="caCertIdentifier")
    def ca_cert_identifier(self) -> pulumi.Output[str]:
        """
        Identifier of the CA certificate for the DB instance.
        """
        return pulumi.get(self, "ca_cert_identifier")

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> pulumi.Output[str]:
        """
        Identifier of the `rds.Cluster` in which to launch this instance.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="copyTagsToSnapshot")
    def copy_tags_to_snapshot(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
        """
        return pulumi.get(self, "copy_tags_to_snapshot")

    @property
    @pulumi.getter(name="customIamInstanceProfile")
    def custom_iam_instance_profile(self) -> pulumi.Output[Optional[str]]:
        """
        Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
        """
        return pulumi.get(self, "custom_iam_instance_profile")

    @property
    @pulumi.getter(name="dbParameterGroupName")
    def db_parameter_group_name(self) -> pulumi.Output[str]:
        """
        Name of the DB parameter group to associate with this instance.
        """
        return pulumi.get(self, "db_parameter_group_name")

    @property
    @pulumi.getter(name="dbSubnetGroupName")
    def db_subnet_group_name(self) -> pulumi.Output[str]:
        """
        Specifies the DB subnet group to associate with this DB instance. The default behavior varies depending on whether `db_subnet_group_name` is specified. Please refer to official [AWS documentation](https://docs.aws.amazon.com/cli/latest/reference/rds/create-db-instance.html) to understand how `db_subnet_group_name` and `publicly_accessible` parameters affect DB instance behaviour. **NOTE:** This must match the `db_subnet_group_name` of the attached `rds.Cluster`.
        """
        return pulumi.get(self, "db_subnet_group_name")

    @property
    @pulumi.getter(name="dbiResourceId")
    def dbi_resource_id(self) -> pulumi.Output[str]:
        """
        Region-unique, immutable identifier for the DB instance.
        """
        return pulumi.get(self, "dbi_resource_id")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        DNS address for this instance. May not be writable
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        Name of the database engine to be used for the RDS cluster instance.
        Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.(Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Database engine version. Please note that to upgrade the `engine_version` of the instance, it must be done on the `rds.Cluster` `engine_version`. Trying to upgrade in `aws_cluster_instance` will not update the `engine_version`.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="engineVersionActual")
    def engine_version_actual(self) -> pulumi.Output[str]:
        """
        Database engine version
        """
        return pulumi.get(self, "engine_version_actual")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Forces an instance to be destroyed when a part of a read replica cluster. **Note:** will promote the read replica to a standalone cluster before instance deletion.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="identifierPrefix")
    def identifier_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
        """
        return pulumi.get(self, "identifier_prefix")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[str]:
        """
        Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details. For Aurora Serverless v2 use `db.serverless`.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        ARN for the KMS encryption key if one is set to the cluster.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
        """
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringRoleArn")
    def monitoring_role_arn(self) -> pulumi.Output[str]:
        """
        ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
        """
        return pulumi.get(self, "monitoring_role_arn")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[str]:
        """
        Network type of the DB instance.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="performanceInsightsEnabled")
    def performance_insights_enabled(self) -> pulumi.Output[bool]:
        """
        Specifies whether Performance Insights is enabled or not.
        """
        return pulumi.get(self, "performance_insights_enabled")

    @property
    @pulumi.getter(name="performanceInsightsKmsKeyId")
    def performance_insights_kms_key_id(self) -> pulumi.Output[str]:
        """
        ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
        """
        return pulumi.get(self, "performance_insights_kms_key_id")

    @property
    @pulumi.getter(name="performanceInsightsRetentionPeriod")
    def performance_insights_retention_period(self) -> pulumi.Output[int]:
        """
        Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to '7'.
        """
        return pulumi.get(self, "performance_insights_retention_period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Database port
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredBackupWindow")
    def preferred_backup_window(self) -> pulumi.Output[str]:
        """
        Daily time range during which automated backups are created if automated backups are enabled. Eg: "04:00-09:00". **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
        """
        return pulumi.get(self, "preferred_backup_window")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[str]:
        """
        Window to perform maintenance in. Syntax: "ddd:hh24:mi-ddd:hh24:mi". Eg: "Mon:00:00-Mon:03:00".
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="promotionTier")
    def promotion_tier(self) -> pulumi.Output[Optional[int]]:
        """
        Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
        """
        return pulumi.get(self, "promotion_tier")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[bool]:
        """
        Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="storageEncrypted")
    def storage_encrypted(self) -> pulumi.Output[bool]:
        """
        Specifies whether the DB cluster is encrypted.
        """
        return pulumi.get(self, "storage_encrypted")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def writer(self) -> pulumi.Output[bool]:
        """
        Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
        """
        return pulumi.get(self, "writer")

