# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CustomDbEngineVersionArgs', 'CustomDbEngineVersion']

@pulumi.input_type
class CustomDbEngineVersionArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[str],
                 engine_version: pulumi.Input[str],
                 database_installation_files_s3_bucket_name: Optional[pulumi.Input[str]] = None,
                 database_installation_files_s3_prefix: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 manifest: Optional[pulumi.Input[str]] = None,
                 manifest_hash: Optional[pulumi.Input[str]] = None,
                 source_image_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CustomDbEngineVersion resource.
        :param pulumi.Input[str] engine: The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
        :param pulumi.Input[str] engine_version: The version of the database engine.
        :param pulumi.Input[str] database_installation_files_s3_bucket_name: The name of the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] database_installation_files_s3_prefix: The prefix for the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] description: The description of the CEV.
        :param pulumi.Input[str] filename: The name of the manifest file within the local filesystem. Conflicts with `manifest`.
        :param pulumi.Input[str] kms_key_id: The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
        :param pulumi.Input[str] manifest: The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
        :param pulumi.Input[str] manifest_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
        :param pulumi.Input[str] source_image_id: The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
        :param pulumi.Input[str] status: The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        if database_installation_files_s3_bucket_name is not None:
            pulumi.set(__self__, "database_installation_files_s3_bucket_name", database_installation_files_s3_bucket_name)
        if database_installation_files_s3_prefix is not None:
            pulumi.set(__self__, "database_installation_files_s3_prefix", database_installation_files_s3_prefix)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if manifest_hash is not None:
            pulumi.set(__self__, "manifest_hash", manifest_hash)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Input[str]:
        """
        The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[str]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="databaseInstallationFilesS3BucketName")
    def database_installation_files_s3_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Amazon S3 bucket that contains the database installation files.
        """
        return pulumi.get(self, "database_installation_files_s3_bucket_name")

    @database_installation_files_s3_bucket_name.setter
    def database_installation_files_s3_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_installation_files_s3_bucket_name", value)

    @property
    @pulumi.getter(name="databaseInstallationFilesS3Prefix")
    def database_installation_files_s3_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix for the Amazon S3 bucket that contains the database installation files.
        """
        return pulumi.get(self, "database_installation_files_s3_prefix")

    @database_installation_files_s3_prefix.setter
    def database_installation_files_s3_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_installation_files_s3_prefix", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the CEV.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the manifest file within the local filesystem. Conflicts with `manifest`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input[str]]:
        """
        The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest", value)

    @property
    @pulumi.getter(name="manifestHash")
    def manifest_hash(self) -> Optional[pulumi.Input[str]]:
        """
        Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
        """
        return pulumi.get(self, "manifest_hash")

    @manifest_hash.setter
    def manifest_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_hash", value)

    @property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_image_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CustomDbEngineVersionState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 database_installation_files_s3_bucket_name: Optional[pulumi.Input[str]] = None,
                 database_installation_files_s3_prefix: Optional[pulumi.Input[str]] = None,
                 db_parameter_group_family: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 major_engine_version: Optional[pulumi.Input[str]] = None,
                 manifest: Optional[pulumi.Input[str]] = None,
                 manifest_computed: Optional[pulumi.Input[str]] = None,
                 manifest_hash: Optional[pulumi.Input[str]] = None,
                 source_image_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CustomDbEngineVersion resources.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) for the custom engine version.
        :param pulumi.Input[str] create_time: The date and time that the CEV was created.
        :param pulumi.Input[str] database_installation_files_s3_bucket_name: The name of the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] database_installation_files_s3_prefix: The prefix for the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] db_parameter_group_family: The name of the DB parameter group family for the CEV.
        :param pulumi.Input[str] description: The description of the CEV.
        :param pulumi.Input[str] engine: The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
        :param pulumi.Input[str] engine_version: The version of the database engine.
        :param pulumi.Input[str] filename: The name of the manifest file within the local filesystem. Conflicts with `manifest`.
        :param pulumi.Input[str] image_id: The ID of the AMI that was created with the CEV.
        :param pulumi.Input[str] kms_key_id: The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
        :param pulumi.Input[str] major_engine_version: The major version of the database engine.
        :param pulumi.Input[str] manifest: The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
        :param pulumi.Input[str] manifest_computed: The returned manifest file, in JSON format, service generated and often different from input `manifest`.
        :param pulumi.Input[str] manifest_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
        :param pulumi.Input[str] source_image_id: The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
        :param pulumi.Input[str] status: The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if database_installation_files_s3_bucket_name is not None:
            pulumi.set(__self__, "database_installation_files_s3_bucket_name", database_installation_files_s3_bucket_name)
        if database_installation_files_s3_prefix is not None:
            pulumi.set(__self__, "database_installation_files_s3_prefix", database_installation_files_s3_prefix)
        if db_parameter_group_family is not None:
            pulumi.set(__self__, "db_parameter_group_family", db_parameter_group_family)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if major_engine_version is not None:
            pulumi.set(__self__, "major_engine_version", major_engine_version)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if manifest_computed is not None:
            pulumi.set(__self__, "manifest_computed", manifest_computed)
        if manifest_hash is not None:
            pulumi.set(__self__, "manifest_hash", manifest_hash)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the custom engine version.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the CEV was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="databaseInstallationFilesS3BucketName")
    def database_installation_files_s3_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Amazon S3 bucket that contains the database installation files.
        """
        return pulumi.get(self, "database_installation_files_s3_bucket_name")

    @database_installation_files_s3_bucket_name.setter
    def database_installation_files_s3_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_installation_files_s3_bucket_name", value)

    @property
    @pulumi.getter(name="databaseInstallationFilesS3Prefix")
    def database_installation_files_s3_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix for the Amazon S3 bucket that contains the database installation files.
        """
        return pulumi.get(self, "database_installation_files_s3_prefix")

    @database_installation_files_s3_prefix.setter
    def database_installation_files_s3_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_installation_files_s3_prefix", value)

    @property
    @pulumi.getter(name="dbParameterGroupFamily")
    def db_parameter_group_family(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DB parameter group family for the CEV.
        """
        return pulumi.get(self, "db_parameter_group_family")

    @db_parameter_group_family.setter
    def db_parameter_group_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_parameter_group_family", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the CEV.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the manifest file within the local filesystem. Conflicts with `manifest`.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AMI that was created with the CEV.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The major version of the database engine.
        """
        return pulumi.get(self, "major_engine_version")

    @major_engine_version.setter
    def major_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "major_engine_version", value)

    @property
    @pulumi.getter
    def manifest(self) -> Optional[pulumi.Input[str]]:
        """
        The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
        """
        return pulumi.get(self, "manifest")

    @manifest.setter
    def manifest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest", value)

    @property
    @pulumi.getter(name="manifestComputed")
    def manifest_computed(self) -> Optional[pulumi.Input[str]]:
        """
        The returned manifest file, in JSON format, service generated and often different from input `manifest`.
        """
        return pulumi.get(self, "manifest_computed")

    @manifest_computed.setter
    def manifest_computed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_computed", value)

    @property
    @pulumi.getter(name="manifestHash")
    def manifest_hash(self) -> Optional[pulumi.Input[str]]:
        """
        Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
        """
        return pulumi.get(self, "manifest_hash")

    @manifest_hash.setter
    def manifest_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manifest_hash", value)

    @property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_image_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class CustomDbEngineVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_installation_files_s3_bucket_name: Optional[pulumi.Input[str]] = None,
                 database_installation_files_s3_prefix: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 manifest: Optional[pulumi.Input[str]] = None,
                 manifest_hash: Optional[pulumi.Input[str]] = None,
                 source_image_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides an custom engine version (CEV) resource for Amazon RDS Custom. For additional information, see [Working with CEVs for RDS Custom for Oracle](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html) and [Working with CEVs for RDS Custom for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev-sqlserver.html) in the the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html).

        ## Example Usage

        ### RDS Custom for Oracle Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example", description="KMS symmetric key for RDS Custom for Oracle")
        example_custom_db_engine_version = aws.rds.CustomDbEngineVersion("example",
            database_installation_files_s3_bucket_name="DOC-EXAMPLE-BUCKET",
            database_installation_files_s3_prefix="1915_GI/",
            engine="custom-oracle-ee-cdb",
            engine_version="19.cdb_cev1",
            kms_key_id=example.arn,
            manifest=\"\"\"  {
        \\x09"databaseInstallationFileNames":["V982063-01.zip"]
          }
        \"\"\",
            tags={
                "Name": "example",
                "Key": "value",
            })
        ```

        ### RDS Custom for Oracle External Manifest Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.kms.Key("example", description="KMS symmetric key for RDS Custom for Oracle")
        example_custom_db_engine_version = aws.rds.CustomDbEngineVersion("example",
            database_installation_files_s3_bucket_name="DOC-EXAMPLE-BUCKET",
            database_installation_files_s3_prefix="1915_GI/",
            engine="custom-oracle-ee-cdb",
            engine_version="19.cdb_cev1",
            kms_key_id=example.arn,
            filename="manifest_1915_GI.json",
            manifest_hash=std.filebase64sha256(input=json).result,
            tags={
                "Name": "example",
                "Key": "value",
            })
        ```

        ### RDS Custom for SQL Server Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # CEV creation requires an AMI owned by the operator
        test = aws.rds.CustomDbEngineVersion("test",
            engine="custom-sqlserver-se",
            engine_version="15.00.4249.2.cev-1",
            source_image_id="ami-0aa12345678a12ab1")
        ```

        ### RDS Custom for SQL Server Usage with AMI from another region

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiCopy("example",
            name="sqlserver-se-2019-15.00.4249.2",
            description="A copy of ami-xxxxxxxx",
            source_ami_id="ami-xxxxxxxx",
            source_ami_region="us-east-1")
        # CEV creation requires an AMI owned by the operator
        test = aws.rds.CustomDbEngineVersion("test",
            engine="custom-sqlserver-se",
            engine_version="15.00.4249.2.cev-1",
            source_image_id=example.id)
        ```

        ## Import

        Using `pulumi import`, import custom engine versions for Amazon RDS custom using the `engine` and `engine_version` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:rds/customDbEngineVersion:CustomDbEngineVersion example custom-oracle-ee-cdb:19.cdb_cev1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_installation_files_s3_bucket_name: The name of the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] database_installation_files_s3_prefix: The prefix for the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] description: The description of the CEV.
        :param pulumi.Input[str] engine: The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
        :param pulumi.Input[str] engine_version: The version of the database engine.
        :param pulumi.Input[str] filename: The name of the manifest file within the local filesystem. Conflicts with `manifest`.
        :param pulumi.Input[str] kms_key_id: The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
        :param pulumi.Input[str] manifest: The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
        :param pulumi.Input[str] manifest_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
        :param pulumi.Input[str] source_image_id: The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
        :param pulumi.Input[str] status: The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDbEngineVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an custom engine version (CEV) resource for Amazon RDS Custom. For additional information, see [Working with CEVs for RDS Custom for Oracle](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html) and [Working with CEVs for RDS Custom for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev-sqlserver.html) in the the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html).

        ## Example Usage

        ### RDS Custom for Oracle Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.kms.Key("example", description="KMS symmetric key for RDS Custom for Oracle")
        example_custom_db_engine_version = aws.rds.CustomDbEngineVersion("example",
            database_installation_files_s3_bucket_name="DOC-EXAMPLE-BUCKET",
            database_installation_files_s3_prefix="1915_GI/",
            engine="custom-oracle-ee-cdb",
            engine_version="19.cdb_cev1",
            kms_key_id=example.arn,
            manifest=\"\"\"  {
        \\x09"databaseInstallationFileNames":["V982063-01.zip"]
          }
        \"\"\",
            tags={
                "Name": "example",
                "Key": "value",
            })
        ```

        ### RDS Custom for Oracle External Manifest Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.kms.Key("example", description="KMS symmetric key for RDS Custom for Oracle")
        example_custom_db_engine_version = aws.rds.CustomDbEngineVersion("example",
            database_installation_files_s3_bucket_name="DOC-EXAMPLE-BUCKET",
            database_installation_files_s3_prefix="1915_GI/",
            engine="custom-oracle-ee-cdb",
            engine_version="19.cdb_cev1",
            kms_key_id=example.arn,
            filename="manifest_1915_GI.json",
            manifest_hash=std.filebase64sha256(input=json).result,
            tags={
                "Name": "example",
                "Key": "value",
            })
        ```

        ### RDS Custom for SQL Server Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # CEV creation requires an AMI owned by the operator
        test = aws.rds.CustomDbEngineVersion("test",
            engine="custom-sqlserver-se",
            engine_version="15.00.4249.2.cev-1",
            source_image_id="ami-0aa12345678a12ab1")
        ```

        ### RDS Custom for SQL Server Usage with AMI from another region

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.AmiCopy("example",
            name="sqlserver-se-2019-15.00.4249.2",
            description="A copy of ami-xxxxxxxx",
            source_ami_id="ami-xxxxxxxx",
            source_ami_region="us-east-1")
        # CEV creation requires an AMI owned by the operator
        test = aws.rds.CustomDbEngineVersion("test",
            engine="custom-sqlserver-se",
            engine_version="15.00.4249.2.cev-1",
            source_image_id=example.id)
        ```

        ## Import

        Using `pulumi import`, import custom engine versions for Amazon RDS custom using the `engine` and `engine_version` separated by a colon (`:`). For example:

        ```sh
        $ pulumi import aws:rds/customDbEngineVersion:CustomDbEngineVersion example custom-oracle-ee-cdb:19.cdb_cev1
        ```

        :param str resource_name: The name of the resource.
        :param CustomDbEngineVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDbEngineVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_installation_files_s3_bucket_name: Optional[pulumi.Input[str]] = None,
                 database_installation_files_s3_prefix: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 manifest: Optional[pulumi.Input[str]] = None,
                 manifest_hash: Optional[pulumi.Input[str]] = None,
                 source_image_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDbEngineVersionArgs.__new__(CustomDbEngineVersionArgs)

            __props__.__dict__["database_installation_files_s3_bucket_name"] = database_installation_files_s3_bucket_name
            __props__.__dict__["database_installation_files_s3_prefix"] = database_installation_files_s3_prefix
            __props__.__dict__["description"] = description
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["filename"] = filename
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["manifest"] = manifest
            __props__.__dict__["manifest_hash"] = manifest_hash
            __props__.__dict__["source_image_id"] = source_image_id
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["db_parameter_group_family"] = None
            __props__.__dict__["image_id"] = None
            __props__.__dict__["major_engine_version"] = None
            __props__.__dict__["manifest_computed"] = None
            __props__.__dict__["tags_all"] = None
        super(CustomDbEngineVersion, __self__).__init__(
            'aws:rds/customDbEngineVersion:CustomDbEngineVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            database_installation_files_s3_bucket_name: Optional[pulumi.Input[str]] = None,
            database_installation_files_s3_prefix: Optional[pulumi.Input[str]] = None,
            db_parameter_group_family: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            engine: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            filename: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            major_engine_version: Optional[pulumi.Input[str]] = None,
            manifest: Optional[pulumi.Input[str]] = None,
            manifest_computed: Optional[pulumi.Input[str]] = None,
            manifest_hash: Optional[pulumi.Input[str]] = None,
            source_image_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'CustomDbEngineVersion':
        """
        Get an existing CustomDbEngineVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) for the custom engine version.
        :param pulumi.Input[str] create_time: The date and time that the CEV was created.
        :param pulumi.Input[str] database_installation_files_s3_bucket_name: The name of the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] database_installation_files_s3_prefix: The prefix for the Amazon S3 bucket that contains the database installation files.
        :param pulumi.Input[str] db_parameter_group_family: The name of the DB parameter group family for the CEV.
        :param pulumi.Input[str] description: The description of the CEV.
        :param pulumi.Input[str] engine: The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
        :param pulumi.Input[str] engine_version: The version of the database engine.
        :param pulumi.Input[str] filename: The name of the manifest file within the local filesystem. Conflicts with `manifest`.
        :param pulumi.Input[str] image_id: The ID of the AMI that was created with the CEV.
        :param pulumi.Input[str] kms_key_id: The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
        :param pulumi.Input[str] major_engine_version: The major version of the database engine.
        :param pulumi.Input[str] manifest: The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
        :param pulumi.Input[str] manifest_computed: The returned manifest file, in JSON format, service generated and often different from input `manifest`.
        :param pulumi.Input[str] manifest_hash: Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
        :param pulumi.Input[str] source_image_id: The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
        :param pulumi.Input[str] status: The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDbEngineVersionState.__new__(_CustomDbEngineVersionState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["database_installation_files_s3_bucket_name"] = database_installation_files_s3_bucket_name
        __props__.__dict__["database_installation_files_s3_prefix"] = database_installation_files_s3_prefix
        __props__.__dict__["db_parameter_group_family"] = db_parameter_group_family
        __props__.__dict__["description"] = description
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["filename"] = filename
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["major_engine_version"] = major_engine_version
        __props__.__dict__["manifest"] = manifest
        __props__.__dict__["manifest_computed"] = manifest_computed
        __props__.__dict__["manifest_hash"] = manifest_hash
        __props__.__dict__["source_image_id"] = source_image_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return CustomDbEngineVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the custom engine version.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The date and time that the CEV was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="databaseInstallationFilesS3BucketName")
    def database_installation_files_s3_bucket_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Amazon S3 bucket that contains the database installation files.
        """
        return pulumi.get(self, "database_installation_files_s3_bucket_name")

    @property
    @pulumi.getter(name="databaseInstallationFilesS3Prefix")
    def database_installation_files_s3_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        The prefix for the Amazon S3 bucket that contains the database installation files.
        """
        return pulumi.get(self, "database_installation_files_s3_prefix")

    @property
    @pulumi.getter(name="dbParameterGroupFamily")
    def db_parameter_group_family(self) -> pulumi.Output[str]:
        """
        The name of the DB parameter group family for the CEV.
        """
        return pulumi.get(self, "db_parameter_group_family")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the CEV.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[str]:
        """
        The name of the database engine. Valid values are `custom-oracle*`, `custom-sqlserver*`.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the manifest file within the local filesystem. Conflicts with `manifest`.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The ID of the AMI that was created with the CEV.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The ARN of the AWS KMS key that is used to encrypt the database installation files. Required for RDS Custom for Oracle.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="majorEngineVersion")
    def major_engine_version(self) -> pulumi.Output[str]:
        """
        The major version of the database engine.
        """
        return pulumi.get(self, "major_engine_version")

    @property
    @pulumi.getter
    def manifest(self) -> pulumi.Output[Optional[str]]:
        """
        The manifest file, in JSON format, that contains the list of database installation files. Conflicts with `filename`.
        """
        return pulumi.get(self, "manifest")

    @property
    @pulumi.getter(name="manifestComputed")
    def manifest_computed(self) -> pulumi.Output[str]:
        """
        The returned manifest file, in JSON format, service generated and often different from input `manifest`.
        """
        return pulumi.get(self, "manifest_computed")

    @property
    @pulumi.getter(name="manifestHash")
    def manifest_hash(self) -> pulumi.Output[Optional[str]]:
        """
        Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the manifest source specified with `filename`. The usual way to set this is filebase64sha256("manifest.json") where "manifest.json" is the local filename of the manifest source.
        """
        return pulumi.get(self, "manifest_hash")

    @property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the AMI to create the CEV from. Required for RDS Custom for SQL Server. For RDS Custom for Oracle, you can specify an AMI ID that was used in a different Oracle CEV.
        """
        return pulumi.get(self, "source_image_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the CEV. Valid values are `available`, `inactive`, `inactive-except-restore`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

